/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.EventQueue;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;

public class GVTTreeRenderer
extends Thread {
    protected ImageRenderer renderer;
    protected Shape areaOfInterest;
    protected int width;
    protected int height;
    protected AffineTransform user2DeviceTransform;
    protected boolean doubleBuffering;
    protected List listeners = Collections.synchronizedList(new LinkedList());

    public GVTTreeRenderer(ImageRenderer imageRenderer, AffineTransform affineTransform, boolean bl, Shape shape, int n, int n2) {
        this.renderer = imageRenderer;
        this.areaOfInterest = shape;
        this.user2DeviceTransform = affineTransform;
        this.doubleBuffering = bl;
        this.width = n;
        this.height = n2;
    }

    public void run() {
        try {
            this.firePrepareEvent();
            this.renderer.setTransform(this.user2DeviceTransform);
            this.renderer.setDoubleBuffered(this.doubleBuffering);
            this.renderer.updateOffScreen(this.width, this.height);
            this.renderer.clearOffScreen();
            if (this.checkInterrupted()) {
                return;
            }
            this.fireStartedEvent(this.renderer.getOffScreen());
            this.renderer.repaint(this.areaOfInterest);
            if (this.checkInterrupted()) {
                return;
            }
            this.fireCompletedEvent(this.renderer.getOffScreen());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (InterruptedBridgeException interruptedBridgeException) {
            this.fireFailedEvent();
        }
        catch (InterruptedException interruptedException) {
            this.fireFailedEvent();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.fireFailedEvent();
        }
    }

    public void addGVTTreeRendererListener(GVTTreeRendererListener gVTTreeRendererListener) {
        this.listeners.add(gVTTreeRendererListener);
    }

    public void removeGVTTreeRendererListener(GVTTreeRendererListener gVTTreeRendererListener) {
        this.listeners.remove(gVTTreeRendererListener);
    }

    protected boolean checkInterrupted() {
        if (!Thread.interrupted()) {
            return false;
        }
        this.fireCancelledEvent(this.renderer.getOffScreen());
        return true;
    }

    protected void firePrepareEvent() throws InterruptedException {
        block5: {
            final Object[] objectArray = this.listeners.toArray();
            if (objectArray.length <= 0) break block5;
            final GVTTreeRendererEvent gVTTreeRendererEvent = new GVTTreeRendererEvent(this, null);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    ((GVTTreeRendererListener)objectArray[n]).gvtRenderingPrepare(gVTTreeRendererEvent);
                    ++n;
                }
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            int n = 0;
                            while (n < objectArray.length) {
                                ((GVTTreeRendererListener)objectArray[n]).gvtRenderingPrepare(gVTTreeRendererEvent);
                                ++n;
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    protected void fireStartedEvent(BufferedImage bufferedImage) throws InterruptedException {
        block5: {
            final Object[] objectArray = this.listeners.toArray();
            if (objectArray.length <= 0) break block5;
            final GVTTreeRendererEvent gVTTreeRendererEvent = new GVTTreeRendererEvent(this, bufferedImage);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    ((GVTTreeRendererListener)objectArray[n]).gvtRenderingStarted(gVTTreeRendererEvent);
                    ++n;
                }
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            int n = 0;
                            while (n < objectArray.length) {
                                ((GVTTreeRendererListener)objectArray[n]).gvtRenderingStarted(gVTTreeRendererEvent);
                                ++n;
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    protected void fireCancelledEvent(BufferedImage bufferedImage) {
        final Object[] objectArray = this.listeners.toArray();
        if (objectArray.length > 0) {
            final GVTTreeRendererEvent gVTTreeRendererEvent = new GVTTreeRendererEvent(this, bufferedImage);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    ((GVTTreeRendererListener)objectArray[n]).gvtRenderingCancelled(gVTTreeRendererEvent);
                    ++n;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n = 0;
                        while (n < objectArray.length) {
                            ((GVTTreeRendererListener)objectArray[n]).gvtRenderingCancelled(gVTTreeRendererEvent);
                            ++n;
                        }
                    }
                });
            }
        }
    }

    protected void fireCompletedEvent(BufferedImage bufferedImage) {
        final Object[] objectArray = this.listeners.toArray();
        if (objectArray.length > 0) {
            final GVTTreeRendererEvent gVTTreeRendererEvent = new GVTTreeRendererEvent(this, bufferedImage);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    ((GVTTreeRendererListener)objectArray[n]).gvtRenderingCompleted(gVTTreeRendererEvent);
                    ++n;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n = 0;
                        while (n < objectArray.length) {
                            ((GVTTreeRendererListener)objectArray[n]).gvtRenderingCompleted(gVTTreeRendererEvent);
                            ++n;
                        }
                    }
                });
            }
        }
    }

    protected void fireFailedEvent() {
        final Object[] objectArray = this.listeners.toArray();
        if (objectArray.length > 0) {
            final GVTTreeRendererEvent gVTTreeRendererEvent = new GVTTreeRendererEvent(this, null);
            if (EventQueue.isDispatchThread()) {
                int n = 0;
                while (n < objectArray.length) {
                    ((GVTTreeRendererListener)objectArray[n]).gvtRenderingFailed(gVTTreeRendererEvent);
                    ++n;
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int n = 0;
                        while (n < objectArray.length) {
                            ((GVTTreeRendererListener)objectArray[n]).gvtRenderingFailed(gVTTreeRendererEvent);
                            ++n;
                        }
                    }
                });
            }
        }
    }
}

