/********************************************************************************
*                                                                               *
*                         T a b   B o o k   W i d g e t s                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997,2001 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: FXTab.h,v 1.18 2001/05/03 19:17:09 jeroen Exp $                          *
********************************************************************************/
#ifndef FXTAB_H
#define FXTAB_H



// Tab Item orientations which affect border
enum {
  TAB_TOP          = 0,           // Top side tabs
  TAB_LEFT         = 0x00800000,  // Left side tabs
  TAB_RIGHT        = 0x01000000,  // Right side tabs
  TAB_BOTTOM       = 0x01800000,  // Bottom side tabs
  TAB_TOP_NORMAL   = JUSTIFY_NORMAL|ICON_BEFORE_TEXT|TAB_TOP|FRAME_RAISED|FRAME_THICK,
  TAB_BOTTOM_NORMAL= JUSTIFY_NORMAL|ICON_BEFORE_TEXT|TAB_BOTTOM|FRAME_RAISED|FRAME_THICK,
  TAB_LEFT_NORMAL  = JUSTIFY_LEFT|JUSTIFY_CENTER_Y|ICON_BEFORE_TEXT|TAB_LEFT|FRAME_RAISED|FRAME_THICK,
  TAB_RIGHT_NORMAL = JUSTIFY_LEFT|JUSTIFY_CENTER_Y|ICON_BEFORE_TEXT|TAB_RIGHT|FRAME_RAISED|FRAME_THICK
  };


// Tab Book options
enum {
  TABBOOK_TOPTABS    = 0,                                   // Tabs on top (default)
  TABBOOK_BOTTOMTABS = 0x00020000,                          // Tabs on bottom
  TABBOOK_SIDEWAYS   = 0x00040000,                          // Tabs on left
  TABBOOK_LEFTTABS   = TABBOOK_SIDEWAYS|TABBOOK_TOPTABS,    // Tabs on left
  TABBOOK_RIGHTTABS  = TABBOOK_SIDEWAYS|TABBOOK_BOTTOMTABS, // Tabs on right
  TABBOOK_NORMAL     = TABBOOK_TOPTABS
  };


// Forward
class FXTabBar;


/**
* A tab item is placed in a tab bar or tab book.
* When selected, the tab item sends a message to its
* parent, and causes itself to become the active tab,
* and raised slightly above the other tabs.
* In the tab book, activating a tab item also causes
* the corresponding panel to be raised to the top.
*/
class FXAPI FXTabItem : public FXLabel {
  FXDECLARE(FXTabItem)
protected:
  FXTabItem(){}
private:
  FXTabItem(const FXTabItem&);
  FXTabItem& operator=(const FXTabItem&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onUngrabbed(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onHotKeyPress(FXObject*,FXSelector,void*);
  long onHotKeyRelease(FXObject*,FXSelector,void*);
public:

  /// Construct a tab item
  FXTabItem(FXTabBar* p,const FXString& text,FXIcon* ic=0,FXuint opts=TAB_TOP_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

  /// Returns true because a tab item can receive focus
  virtual FXbool canFocus() const;

  /// Return current tab item orientation
  FXuint getTabOrientation() const;

  /// Change tab item orientation
  void setTabOrientation(FXuint style);
  };


/**
* The tab bar layout manager arranges tab items side by side,
* and raises the active tab item above the neighboring tab items.
* The tab bar can be have the tab items on the top or
* bottom for horizontal arrangement, or on the left or right
* for vertical arrangement.
*/
class FXAPI FXTabBar : public FXPacker {
  FXDECLARE(FXTabBar)
protected:
  FXint current;
protected:
  FXTabBar(){}
  virtual void layout();
private:
  FXTabBar(const FXTabBar&);
  FXTabBar& operator=(const FXTabBar&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onFocusNext(FXObject*,FXSelector,void*);
  long onFocusPrev(FXObject*,FXSelector,void*);
  long onFocusUp(FXObject*,FXSelector,void*);
  long onFocusDown(FXObject*,FXSelector,void*);
  long onFocusLeft(FXObject*,FXSelector,void*);
  long onFocusRight(FXObject*,FXSelector,void*);
  long onCmdOpenItem(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdSetIntValue(FXObject*,FXSelector,void*);
  long onCmdGetIntValue(FXObject*,FXSelector,void*);
  long onCmdOpen(FXObject*,FXSelector,void*);
  long onUpdOpen(FXObject*,FXSelector,void*);
public:
  enum {
    ID_OPEN_ITEM=FXPacker::ID_LAST,   /// Sent from one of the FXTabItems
    ID_OPEN_FIRST,                    /// Switch to panel ID_OPEN_FIRST+i
    ID_OPEN_SECOND,
    ID_OPEN_THIRD,
    ID_OPEN_FOURTH,
    ID_OPEN_FIFTH,
    ID_OPEN_SIXTH,
    ID_OPEN_SEVENTH,
    ID_OPEN_EIGHTH,
    ID_OPEN_NINETH,
    ID_OPEN_TENTH,
    ID_OPEN_LAST=ID_OPEN_FIRST+100,
    ID_LAST
    };
public:

  /// Construct a tab bar
  FXTabBar(FXComposite* p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=TABBOOK_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_SPACING,FXint pr=DEFAULT_SPACING,FXint pt=DEFAULT_SPACING,FXint pb=DEFAULT_SPACING);

  /// Return default width
  virtual FXint getDefaultWidth();

  /// Return default height
  virtual FXint getDefaultHeight();

  /**
  * Change currently active tab item;
  * this raises the active tab item slightly above the neighboring
  * tab items.
  */
  virtual void setCurrent(FXint panel,FXbool notify=FALSE);

  /// Return the currently active tab item
  FXint getCurrent() const { return current; }

  /// Return tab bar style
  FXuint getTabStyle() const;

  /// Change tab tab style
  void setTabStyle(FXuint style);

  /// Save to stream
  virtual void save(FXStream& store) const;

  /// Load from stream
  virtual void load(FXStream& store);
  };


/**
* The tab book layout manager arranges pairs of children;
* the even numbered children (0,2,4,...) are usually tab items,
* and are placed on the top.  The odd numbered children are
* usually layout managers, and are placed below; all the odd
* numbered children are placed on top of each other, similar
* to the switcher widget.  When the user presses one of the
* tab items, the tab item is raised above the neighboring tabs,
* and the corresponding panel is raised to the top.
* Thus, a tab book can be used to present many GUI controls
* in a small space by placing several panels on top of each
* other and using tab items to select the desired panel.
*/
class FXAPI FXTabBook : public FXTabBar {
  FXDECLARE(FXTabBook)
protected:
  FXTabBook(){}
  virtual void layout();
private:
  FXTabBook(const FXTabBook&);
  FXTabBook& operator=(const FXTabBook&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onFocusNext(FXObject*,FXSelector,void*);
  long onFocusPrev(FXObject*,FXSelector,void*);
  long onFocusUp(FXObject*,FXSelector,void*);
  long onFocusDown(FXObject*,FXSelector,void*);
  long onFocusLeft(FXObject*,FXSelector,void*);
  long onFocusRight(FXObject*,FXSelector,void*);
  long onCmdOpenItem(FXObject*,FXSelector,void*);
public:

  /// Construct tab book
  FXTabBook(FXComposite* p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=TABBOOK_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_SPACING,FXint pr=DEFAULT_SPACING,FXint pt=DEFAULT_SPACING,FXint pb=DEFAULT_SPACING);

  /// Return default width
  virtual FXint getDefaultWidth();

  /// Return default height
  virtual FXint getDefaultHeight();
  };



#endif
