/********************************************************************************
*                                                                               *
*        F O X   K e y b o a r d   S y m b o l   D e f i n i t i o n s          *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997,2001 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: fxkeys.h,v 1.2 2001/01/25 19:48:27 jeroen Exp $                          *
********************************************************************************/
#ifndef FXKEYS_H
#define FXKEYS_H

// Void symbol
#define KEY_VoidSymbol		            0xFFFFFF

// Miscellaneous
#define KEY_BackSpace		            0xFF08
#define KEY_Tab			            0xFF09
#define KEY_Linefeed		            0xFF0A
#define KEY_Clear		            0xFF0B
#define KEY_Return		            0xFF0D
#define KEY_Pause		            0xFF13
#define KEY_Scroll_Lock		            0xFF14
#define KEY_Sys_Req		            0xFF15
#define KEY_Escape		            0xFF1B
#define KEY_Delete		            0xFFFF
#define KEY_Multi_key		            0xFF20

// Japanese
#define KEY_Kanji		            0xFF21
#define KEY_Muhenkan		            0xFF22
#define KEY_Henkan_Mode		            0xFF23
#define KEY_Henkan		            0xFF23
#define KEY_Romaji		            0xFF24
#define KEY_Hiragana		            0xFF25
#define KEY_Katakana		            0xFF26
#define KEY_Hiragana_Katakana	            0xFF27
#define KEY_Zenkaku		            0xFF28
#define KEY_Hankaku		            0xFF29
#define KEY_Zenkaku_Hankaku	            0xFF2A
#define KEY_Touroku		            0xFF2B
#define KEY_Massyo		            0xFF2C
#define KEY_Kana_Lock		            0xFF2D
#define KEY_Kana_Shift		            0xFF2E
#define KEY_Eisu_Shift		            0xFF2F
#define KEY_Eisu_toggle		            0xFF30

// Cursor
#define KEY_Home			    0xFF50
#define KEY_Left			    0xFF51
#define KEY_Up			            0xFF52
#define KEY_Right		            0xFF53
#define KEY_Down			    0xFF54
#define KEY_Prior		            0xFF55
#define KEY_Page_Up		            0xFF55
#define KEY_Next			    0xFF56
#define KEY_Page_Down		            0xFF56
#define KEY_End			            0xFF57
#define KEY_Begin		            0xFF58

// Functions
#define KEY_Select		            0xFF60
#define KEY_Print		            0xFF61
#define KEY_Execute		            0xFF62
#define KEY_Insert		            0xFF63
#define KEY_Undo			    0xFF65
#define KEY_Redo			    0xFF66
#define KEY_Menu			    0xFF67
#define KEY_Find			    0xFF68
#define KEY_Cancel		            0xFF69
#define KEY_Help			    0xFF6A
#define KEY_Break		            0xFF6B
#define KEY_Mode_switch		            0xFF7E
#define KEY_script_switch                   0xFF7E
#define KEY_Num_Lock		            0xFF7F

// Keypad
#define KEY_KP_Space		            0xFF80
#define KEY_KP_Tab		            0xFF89
#define KEY_KP_Enter		            0xFF8D
#define KEY_KP_F1		            0xFF91
#define KEY_KP_F2		            0xFF92
#define KEY_KP_F3		            0xFF93
#define KEY_KP_F4		            0xFF94
#define KEY_KP_Home		            0xFF95
#define KEY_KP_Left		            0xFF96
#define KEY_KP_Up		            0xFF97
#define KEY_KP_Right		            0xFF98
#define KEY_KP_Down		            0xFF99
#define KEY_KP_Prior		            0xFF9A
#define KEY_KP_Page_Up		            0xFF9A
#define KEY_KP_Next		            0xFF9B
#define KEY_KP_Page_Down		    0xFF9B
#define KEY_KP_End		            0xFF9C
#define KEY_KP_Begin		            0xFF9D
#define KEY_KP_Insert		            0xFF9E
#define KEY_KP_Delete		            0xFF9F
#define KEY_KP_Equal		            0xFFBD
#define KEY_KP_Multiply		            0xFFAA
#define KEY_KP_Add		            0xFFAB
#define KEY_KP_Separator		    0xFFAC
#define KEY_KP_Subtract		            0xFFAD
#define KEY_KP_Decimal		            0xFFAE
#define KEY_KP_Divide		            0xFFAF

// Keypad numbers
#define KEY_KP_0			    0xFFB0
#define KEY_KP_1			    0xFFB1
#define KEY_KP_2			    0xFFB2
#define KEY_KP_3			    0xFFB3
#define KEY_KP_4			    0xFFB4
#define KEY_KP_5			    0xFFB5
#define KEY_KP_6			    0xFFB6
#define KEY_KP_7			    0xFFB7
#define KEY_KP_8			    0xFFB8
#define KEY_KP_9			    0xFFB9

// Function keys
#define KEY_F1			            0xFFBE
#define KEY_F2			            0xFFBF
#define KEY_F3			            0xFFC0
#define KEY_F4			            0xFFC1
#define KEY_F5			            0xFFC2
#define KEY_F6			            0xFFC3
#define KEY_F7			            0xFFC4
#define KEY_F8			            0xFFC5
#define KEY_F9			            0xFFC6
#define KEY_F10			            0xFFC7
#define KEY_F11			            0xFFC8
#define KEY_L1			            0xFFC8
#define KEY_F12			            0xFFC9
#define KEY_L2			            0xFFC9
#define KEY_F13			            0xFFCA
#define KEY_L3			            0xFFCA
#define KEY_F14			            0xFFCB
#define KEY_L4			            0xFFCB
#define KEY_F15			            0xFFCC
#define KEY_L5			            0xFFCC
#define KEY_F16			            0xFFCD
#define KEY_L6			            0xFFCD
#define KEY_F17			            0xFFCE
#define KEY_L7			            0xFFCE
#define KEY_F18			            0xFFCF
#define KEY_L8			            0xFFCF
#define KEY_F19			            0xFFD0
#define KEY_L9			            0xFFD0
#define KEY_F20			            0xFFD1
#define KEY_L10			            0xFFD1
#define KEY_F21			            0xFFD2
#define KEY_R1			            0xFFD2
#define KEY_F22			            0xFFD3
#define KEY_R2			            0xFFD3
#define KEY_F23			            0xFFD4
#define KEY_R3			            0xFFD4
#define KEY_F24			            0xFFD5
#define KEY_R4			            0xFFD5
#define KEY_F25			            0xFFD6
#define KEY_R5			            0xFFD6
#define KEY_F26			            0xFFD7
#define KEY_R6			            0xFFD7
#define KEY_F27			            0xFFD8
#define KEY_R7			            0xFFD8
#define KEY_F28			            0xFFD9
#define KEY_R8			            0xFFD9
#define KEY_F29			            0xFFDA
#define KEY_R9			            0xFFDA
#define KEY_F30			            0xFFDB
#define KEY_R10			            0xFFDB
#define KEY_F31			            0xFFDC
#define KEY_R11			            0xFFDC
#define KEY_F32			            0xFFDD
#define KEY_R12			            0xFFDD
#define KEY_F33			            0xFFDE
#define KEY_R13			            0xFFDE
#define KEY_F34			            0xFFDF
#define KEY_R14			            0xFFDF
#define KEY_F35			            0xFFE0
#define KEY_R15			            0xFFE0

// Modifiers
#define KEY_Shift_L		            0xFFE1
#define KEY_Shift_R		            0xFFE2
#define KEY_Control_L		            0xFFE3
#define KEY_Control_R		            0xFFE4
#define KEY_Caps_Lock		            0xFFE5
#define KEY_Shift_Lock		            0xFFE6

#define KEY_Meta_L		            0xFFE7
#define KEY_Meta_R		            0xFFE8
#define KEY_Alt_L		            0xFFE9
#define KEY_Alt_R		            0xFFEA
#define KEY_Super_L		            0xFFEB
#define KEY_Super_R		            0xFFEC
#define KEY_Hyper_L		            0xFFED
#define KEY_Hyper_R		            0xFFEE


// ISO 9995
#define	KEY_ISO_Lock			    0xFE01
#define	KEY_ISO_Level2_Latch		    0xFE02
#define	KEY_ISO_Level3_Shift		    0xFE03
#define	KEY_ISO_Level3_Latch		    0xFE04
#define	KEY_ISO_Level3_Lock		    0xFE05
#define	KEY_ISO_Group_Shift		    0xFF7E
#define	KEY_ISO_Group_Latch		    0xFE06
#define	KEY_ISO_Group_Lock		    0xFE07
#define	KEY_ISO_Next_Group		    0xFE08
#define	KEY_ISO_Next_Group_Lock		    0xFE09
#define	KEY_ISO_Prev_Group		    0xFE0A
#define	KEY_ISO_Prev_Group_Lock		    0xFE0B
#define	KEY_ISO_First_Group		    0xFE0C
#define	KEY_ISO_First_Group_Lock	    0xFE0D
#define	KEY_ISO_Last_Group		    0xFE0E
#define	KEY_ISO_Last_Group_Lock		    0xFE0F
#define	KEY_ISO_Left_Tab		    0xFE20
#define	KEY_ISO_Move_Line_Up		    0xFE21
#define	KEY_ISO_Move_Line_Down		    0xFE22
#define	KEY_ISO_Partial_Line_Up		    0xFE23
#define	KEY_ISO_Partial_Line_Down	    0xFE24
#define	KEY_ISO_Partial_Space_Left	    0xFE25
#define	KEY_ISO_Partial_Space_Right	    0xFE26
#define	KEY_ISO_Set_Margin_Left		    0xFE27
#define	KEY_ISO_Set_Margin_Right	    0xFE28
#define	KEY_ISO_Release_Margin_Left	    0xFE29
#define	KEY_ISO_Release_Margin_Right	    0xFE2A
#define	KEY_ISO_Release_Both_Margins	    0xFE2B
#define	KEY_ISO_Fast_Cursor_Left	    0xFE2C
#define	KEY_ISO_Fast_Cursor_Right	    0xFE2D
#define	KEY_ISO_Fast_Cursor_Up		    0xFE2E
#define	KEY_ISO_Fast_Cursor_Down	    0xFE2F
#define	KEY_ISO_Continuous_Underline	    0xFE30
#define	KEY_ISO_Discontinuous_Underline	    0xFE31
#define	KEY_ISO_Emphasize		    0xFE32
#define	KEY_ISO_Center_Object		    0xFE33
#define	KEY_ISO_Enter			    0xFE34

#define	KEY_dead_grave			    0xFE50
#define	KEY_dead_acute			    0xFE51
#define	KEY_dead_circumflex		    0xFE52
#define	KEY_dead_tilde			    0xFE53
#define	KEY_dead_macron			    0xFE54
#define	KEY_dead_breve			    0xFE55
#define	KEY_dead_abovedot		    0xFE56
#define	KEY_dead_diaeresis		    0xFE57
#define	KEY_dead_abovering		    0xFE58
#define	KEY_dead_doubleacute		    0xFE59
#define	KEY_dead_caron			    0xFE5A
#define	KEY_dead_cedilla		    0xFE5B
#define	KEY_dead_ogonek			    0xFE5C
#define	KEY_dead_iota			    0xFE5D
#define	KEY_dead_voiced_sound		    0xFE5E
#define	KEY_dead_semivoiced_sound	    0xFE5F
#define	KEY_dead_belowdot		    0xFE60

#define	KEY_First_Virtual_Screen	    0xFED0
#define	KEY_Prev_Virtual_Screen		    0xFED1
#define	KEY_Next_Virtual_Screen		    0xFED2
#define	KEY_Last_Virtual_Screen		    0xFED4
#define	KEY_Terminate_Server		    0xFED5

#define	KEY_AccessX_Enable		    0xFE70
#define	KEY_AccessX_Feedback_Enable	    0xFE71
#define	KEY_RepeatKeys_Enable		    0xFE72
#define	KEY_SlowKeys_Enable		    0xFE73
#define	KEY_BounceKeys_Enable		    0xFE74
#define	KEY_StickyKeys_Enable		    0xFE75
#define	KEY_MouseKeys_Enable		    0xFE76
#define	KEY_MouseKeys_Accel_Enable	    0xFE77
#define	KEY_Overlay1_Enable		    0xFE78
#define	KEY_Overlay2_Enable		    0xFE79
#define	KEY_AudibleBell_Enable		    0xFE7A

#define	KEY_Pointer_Left		    0xFEE0
#define	KEY_Pointer_Right		    0xFEE1
#define	KEY_Pointer_Up			    0xFEE2
#define	KEY_Pointer_Down		    0xFEE3
#define	KEY_Pointer_UpLeft		    0xFEE4
#define	KEY_Pointer_UpRight		    0xFEE5
#define	KEY_Pointer_DownLeft		    0xFEE6
#define	KEY_Pointer_DownRight		    0xFEE7
#define	KEY_Pointer_Button_Dflt		    0xFEE8
#define	KEY_Pointer_Button1		    0xFEE9
#define	KEY_Pointer_Button2		    0xFEEA
#define	KEY_Pointer_Button3		    0xFEEB
#define	KEY_Pointer_Button4		    0xFEEC
#define	KEY_Pointer_Button5		    0xFEED
#define	KEY_Pointer_DblClick_Dflt	    0xFEEE
#define	KEY_Pointer_DblClick1		    0xFEEF
#define	KEY_Pointer_DblClick2		    0xFEF0
#define	KEY_Pointer_DblClick3		    0xFEF1
#define	KEY_Pointer_DblClick4		    0xFEF2
#define	KEY_Pointer_DblClick5		    0xFEF3
#define	KEY_Pointer_Drag_Dflt		    0xFEF4
#define	KEY_Pointer_Drag1		    0xFEF5
#define	KEY_Pointer_Drag2		    0xFEF6
#define	KEY_Pointer_Drag3		    0xFEF7
#define	KEY_Pointer_Drag4		    0xFEF8
#define	KEY_Pointer_Drag5		    0xFEFD

#define	KEY_Pointer_EnableKeys		    0xFEF9
#define	KEY_Pointer_Accelerate		    0xFEFA
#define	KEY_Pointer_DfltBtnNext		    0xFEFB
#define	KEY_Pointer_DfltBtnPrev		    0xFEFC

// 3270 Terminal
#define KEY_3270_Duplicate                  0xFD01
#define KEY_3270_FieldMark                  0xFD02
#define KEY_3270_Right2                     0xFD03
#define KEY_3270_Left2                      0xFD04
#define KEY_3270_BackTab                    0xFD05
#define KEY_3270_EraseEOF                   0xFD06
#define KEY_3270_EraseInput                 0xFD07
#define KEY_3270_Reset                      0xFD08
#define KEY_3270_Quit                       0xFD09
#define KEY_3270_PA1                        0xFD0A
#define KEY_3270_PA2                        0xFD0B
#define KEY_3270_PA3                        0xFD0C
#define KEY_3270_Test                       0xFD0D
#define KEY_3270_Attn                       0xFD0E
#define KEY_3270_CursorBlink                0xFD0F
#define KEY_3270_AltCursor                  0xFD10
#define KEY_3270_KeyClick                   0xFD11
#define KEY_3270_Jump                       0xFD12
#define KEY_3270_Ident                      0xFD13
#define KEY_3270_Rule                       0xFD14
#define KEY_3270_Copy                       0xFD15
#define KEY_3270_Play                       0xFD16
#define KEY_3270_Setup                      0xFD17
#define KEY_3270_Record                     0xFD18
#define KEY_3270_ChangeScreen               0xFD19
#define KEY_3270_DeleteWord                 0xFD1A
#define KEY_3270_ExSelect                   0xFD1B
#define KEY_3270_CursorSelect               0xFD1C
#define KEY_3270_PrintScreen                0xFD1D
#define KEY_3270_Enter                      0xFD1E

// Latin 1
#define KEY_space                           0x0020
#define KEY_exclam                          0x0021
#define KEY_quotedbl                        0x0022
#define KEY_numbersign                      0x0023
#define KEY_dollar                          0x0024
#define KEY_percent                         0x0025
#define KEY_ampersand                       0x0026
#define KEY_apostrophe                      0x0027
#define KEY_quoteright                      0x0027
#define KEY_parenleft                       0x0028
#define KEY_parenright                      0x0029
#define KEY_asterisk                        0x002A
#define KEY_plus                            0x002B
#define KEY_comma                           0x002C
#define KEY_minus                           0x002D
#define KEY_period                          0x002E
#define KEY_slash                           0x002F
#define KEY_0                               0x0030
#define KEY_1                               0x0031
#define KEY_2                               0x0032
#define KEY_3                               0x0033
#define KEY_4                               0x0034
#define KEY_5                               0x0035
#define KEY_6                               0x0036
#define KEY_7                               0x0037
#define KEY_8                               0x0038
#define KEY_9                               0x0039
#define KEY_colon                           0x003A
#define KEY_semicolon                       0x003B
#define KEY_less                            0x003C
#define KEY_equal                           0x003D
#define KEY_greater                         0x003E
#define KEY_question                        0x003F
#define KEY_at                              0x0040
#define KEY_A                               0x0041
#define KEY_B                               0x0042
#define KEY_C                               0x0043
#define KEY_D                               0x0044
#define KEY_E                               0x0045
#define KEY_F                               0x0046
#define KEY_G                               0x0047
#define KEY_H                               0x0048
#define KEY_I                               0x0049
#define KEY_J                               0x004A
#define KEY_K                               0x004B
#define KEY_L                               0x004C
#define KEY_M                               0x004D
#define KEY_N                               0x004E
#define KEY_O                               0x004F
#define KEY_P                               0x0050
#define KEY_Q                               0x0051
#define KEY_R                               0x0052
#define KEY_S                               0x0053
#define KEY_T                               0x0054
#define KEY_U                               0x0055
#define KEY_V                               0x0056
#define KEY_W                               0x0057
#define KEY_X                               0x0058
#define KEY_Y                               0x0059
#define KEY_Z                               0x005A
#define KEY_bracketleft                     0x005B
#define KEY_backslash                       0x005C
#define KEY_bracketright                    0x005D
#define KEY_asciicircum                     0x005E
#define KEY_underscore                      0x005F
#define KEY_grave                           0x0060
#define KEY_quoteleft                       0x0060
#define KEY_a                               0x0061
#define KEY_b                               0x0062
#define KEY_c                               0x0063
#define KEY_d                               0x0064
#define KEY_e                               0x0065
#define KEY_f                               0x0066
#define KEY_g                               0x0067
#define KEY_h                               0x0068
#define KEY_i                               0x0069
#define KEY_j                               0x006A
#define KEY_k                               0x006B
#define KEY_l                               0x006C
#define KEY_m                               0x006D
#define KEY_n                               0x006E
#define KEY_o                               0x006F
#define KEY_p                               0x0070
#define KEY_q                               0x0071
#define KEY_r                               0x0072
#define KEY_s                               0x0073
#define KEY_t                               0x0074
#define KEY_u                               0x0075
#define KEY_v                               0x0076
#define KEY_w                               0x0077
#define KEY_x                               0x0078
#define KEY_y                               0x0079
#define KEY_z                               0x007A
#define KEY_braceleft                       0x007B
#define KEY_bar                             0x007C
#define KEY_braceright                      0x007D
#define KEY_asciitilde                      0x007E

#define KEY_nobreakspace                    0x00A0
#define KEY_exclamdown                      0x00A1
#define KEY_cent        	            0x00A2
#define KEY_sterling                        0x00A3
#define KEY_currency                        0x00A4
#define KEY_yen                             0x00A5
#define KEY_brokenbar                       0x00A6
#define KEY_section                         0x00A7
#define KEY_diaeresis                       0x00A8
#define KEY_copyright                       0x00A9
#define KEY_ordfeminine                     0x00AA
#define KEY_guillemotleft                   0x00AB
#define KEY_notsign                         0x00AC
#define KEY_hyphen                          0x00AD
#define KEY_registered                      0x00AE
#define KEY_macron                          0x00AF
#define KEY_degree                          0x00B0
#define KEY_plusminus                       0x00B1
#define KEY_twosuperior                     0x00B2
#define KEY_threesuperior                   0x00B3
#define KEY_acute                           0x00B4
#define KEY_mu                              0x00B5
#define KEY_paragraph                       0x00B6
#define KEY_periodcentered                  0x00B7
#define KEY_cedilla                         0x00B8
#define KEY_onesuperior                     0x00B9
#define KEY_masculine                       0x00BA
#define KEY_guillemotright                  0x00BB
#define KEY_onequarter                      0x00BC
#define KEY_onehalf                         0x00BD
#define KEY_threequarters                   0x00BE
#define KEY_questiondown                    0x00BF
#define KEY_Agrave                          0x00C0
#define KEY_Aacute                          0x00C1
#define KEY_Acircumflex                     0x00C2
#define KEY_Atilde                          0x00C3
#define KEY_Adiaeresis                      0x00C4
#define KEY_Aring                           0x00C5
#define KEY_AE                              0x00C6
#define KEY_Ccedilla                        0x00C7
#define KEY_Egrave                          0x00C8
#define KEY_Eacute                          0x00C9
#define KEY_Ecircumflex                     0x00CA
#define KEY_Ediaeresis                      0x00CB
#define KEY_Igrave                          0x00CC
#define KEY_Iacute                          0x00CD
#define KEY_Icircumflex                     0x00CE
#define KEY_Idiaeresis                      0x00CF
#define KEY_ETH                             0x00D0
#define KEY_Eth                             0x00D0
#define KEY_Ntilde                          0x00D1
#define KEY_Ograve                          0x00D2
#define KEY_Oacute                          0x00D3
#define KEY_Ocircumflex                     0x00D4
#define KEY_Otilde                          0x00D5
#define KEY_Odiaeresis                      0x00D6
#define KEY_multiply                        0x00D7
#define KEY_Ooblique                        0x00D8
#define KEY_Ugrave                          0x00D9
#define KEY_Uacute                          0x00DA
#define KEY_Ucircumflex                     0x00DB
#define KEY_Udiaeresis                      0x00DC
#define KEY_Yacute                          0x00DD
#define KEY_THORN                           0x00DE
#define KEY_Thorn                           0x00DE
#define KEY_ssharp                          0x00DF
#define KEY_agrave                          0x00E0
#define KEY_aacute                          0x00E1
#define KEY_acircumflex                     0x00E2
#define KEY_atilde                          0x00E3
#define KEY_adiaeresis                      0x00E4
#define KEY_aring                           0x00E5
#define KEY_ae                              0x00E6
#define KEY_ccedilla                        0x00E7
#define KEY_egrave                          0x00E8
#define KEY_eacute                          0x00E9
#define KEY_ecircumflex                     0x00EA
#define KEY_ediaeresis                      0x00EB
#define KEY_igrave                          0x00EC
#define KEY_iacute                          0x00ED
#define KEY_icircumflex                     0x00EE
#define KEY_idiaeresis                      0x00EF
#define KEY_eth                             0x00F0
#define KEY_ntilde                          0x00F1
#define KEY_ograve                          0x00F2
#define KEY_oacute                          0x00F3
#define KEY_ocircumflex                     0x00F4
#define KEY_otilde                          0x00F5
#define KEY_odiaeresis                      0x00F6
#define KEY_division                        0x00F7
#define KEY_oslash                          0x00F8
#define KEY_ugrave                          0x00F9
#define KEY_uacute                          0x00FA
#define KEY_ucircumflex                     0x00FB
#define KEY_udiaeresis                      0x00FC
#define KEY_yacute                          0x00FD
#define KEY_thorn                           0x00FE
#define KEY_ydiaeresis                      0x00FF

// Latin 2
#define KEY_Aogonek                         0x01A1
#define KEY_breve                           0x01A2
#define KEY_Lstroke                         0x01A3
#define KEY_Lcaron                          0x01A5
#define KEY_Sacute                          0x01A6
#define KEY_Scaron                          0x01A9
#define KEY_Scedilla                        0x01AA
#define KEY_Tcaron                          0x01AB
#define KEY_Zacute                          0x01AC
#define KEY_Zcaron                          0x01AE
#define KEY_Zabovedot                       0x01AF
#define KEY_aogonek                         0x01B1
#define KEY_ogonek                          0x01B2
#define KEY_lstroke                         0x01B3
#define KEY_lcaron                          0x01B5
#define KEY_sacute                          0x01B6
#define KEY_caron                           0x01B7
#define KEY_scaron                          0x01B9
#define KEY_scedilla                        0x01BA
#define KEY_tcaron                          0x01BB
#define KEY_zacute                          0x01BC
#define KEY_doubleacute                     0x01BD
#define KEY_zcaron                          0x01BE
#define KEY_zabovedot                       0x01BF
#define KEY_Racute                          0x01C0
#define KEY_Abreve                          0x01C3
#define KEY_Lacute                          0x01C5
#define KEY_Cacute                          0x01C6
#define KEY_Ccaron                          0x01C8
#define KEY_Eogonek                         0x01CA
#define KEY_Ecaron                          0x01CC
#define KEY_Dcaron                          0x01CF
#define KEY_Dstroke                         0x01D0
#define KEY_Nacute                          0x01D1
#define KEY_Ncaron                          0x01D2
#define KEY_Odoubleacute                    0x01D5
#define KEY_Rcaron                          0x01D8
#define KEY_Uring                           0x01D9
#define KEY_Udoubleacute                    0x01DB
#define KEY_Tcedilla                        0x01DE
#define KEY_racute                          0x01E0
#define KEY_abreve                          0x01E3
#define KEY_lacute                          0x01E5
#define KEY_cacute                          0x01E6
#define KEY_ccaron                          0x01E8
#define KEY_eogonek                         0x01EA
#define KEY_ecaron                          0x01EC
#define KEY_dcaron                          0x01EF
#define KEY_dstroke                         0x01F0
#define KEY_nacute                          0x01F1
#define KEY_ncaron                          0x01F2
#define KEY_odoubleacute                    0x01F5
#define KEY_udoubleacute                    0x01FB
#define KEY_rcaron                          0x01F8
#define KEY_uring                           0x01F9
#define KEY_tcedilla                        0x01FE
#define KEY_abovedot                        0x01FF

// Latin 3
#define KEY_Hstroke                         0x02A1
#define KEY_Hcircumflex                     0x02A6
#define KEY_Iabovedot                       0x02A9
#define KEY_Gbreve                          0x02AB
#define KEY_Jcircumflex                     0x02AC
#define KEY_hstroke                         0x02B1
#define KEY_hcircumflex                     0x02B6
#define KEY_idotless                        0x02B9
#define KEY_gbreve                          0x02BB
#define KEY_jcircumflex                     0x02BC
#define KEY_Cabovedot                       0x02C5
#define KEY_Ccircumflex                     0x02C6
#define KEY_Gabovedot                       0x02D5
#define KEY_Gcircumflex                     0x02D8
#define KEY_Ubreve                          0x02DD
#define KEY_Scircumflex                     0x02DE
#define KEY_cabovedot                       0x02E5
#define KEY_ccircumflex                     0x02E6
#define KEY_gabovedot                       0x02F5
#define KEY_gcircumflex                     0x02F8
#define KEY_ubreve                          0x02FD
#define KEY_scircumflex                     0x02FE


// Latin 4
#define KEY_kra                             0x03A2
#define KEY_kappa                           0x03A2
#define KEY_Rcedilla                        0x03A3
#define KEY_Itilde                          0x03A5
#define KEY_Lcedilla                        0x03A6
#define KEY_Emacron                         0x03AA
#define KEY_Gcedilla                        0x03AB
#define KEY_Tslash                          0x03AC
#define KEY_rcedilla                        0x03B3
#define KEY_itilde                          0x03B5
#define KEY_lcedilla                        0x03B6
#define KEY_emacron                         0x03BA
#define KEY_gcedilla                        0x03BB
#define KEY_tslash                          0x03BC
#define KEY_ENG                             0x03BD
#define KEY_eng                             0x03BF
#define KEY_Amacron                         0x03C0
#define KEY_Iogonek                         0x03C7
#define KEY_Eabovedot                       0x03CC
#define KEY_Imacron                         0x03CF
#define KEY_Ncedilla                        0x03D1
#define KEY_Omacron                         0x03D2
#define KEY_Kcedilla                        0x03D3
#define KEY_Uogonek                         0x03D9
#define KEY_Utilde                          0x03DD
#define KEY_Umacron                         0x03DE
#define KEY_amacron                         0x03E0
#define KEY_iogonek                         0x03E7
#define KEY_eabovedot                       0x03EC
#define KEY_imacron                         0x03EF
#define KEY_ncedilla                        0x03F1
#define KEY_omacron                         0x03F2
#define KEY_kcedilla                        0x03F3
#define KEY_uogonek                         0x03F9
#define KEY_utilde                          0x03FD
#define KEY_umacron                         0x03FE

// Katakana
#define KEY_overline			    0x047E
#define KEY_kana_fullstop                   0x04A1
#define KEY_kana_openingbracket             0x04A2
#define KEY_kana_closingbracket             0x04A3
#define KEY_kana_comma                      0x04A4
#define KEY_kana_conjunctive                0x04A5
#define KEY_kana_middledot                  0x04A5
#define KEY_kana_WO                         0x04A6
#define KEY_kana_a                          0x04A7
#define KEY_kana_i                          0x04A8
#define KEY_kana_u                          0x04A9
#define KEY_kana_e                          0x04AA
#define KEY_kana_o                          0x04AB
#define KEY_kana_ya                         0x04AC
#define KEY_kana_yu                         0x04AD
#define KEY_kana_yo                         0x04AE
#define KEY_kana_tsu                        0x04AF
#define KEY_kana_tu                         0x04AF
#define KEY_prolongedsound                  0x04B0
#define KEY_kana_A                          0x04B1
#define KEY_kana_I                          0x04B2
#define KEY_kana_U                          0x04B3
#define KEY_kana_E                          0x04B4
#define KEY_kana_O                          0x04B5
#define KEY_kana_KA                         0x04B6
#define KEY_kana_KI                         0x04B7
#define KEY_kana_KU                         0x04B8
#define KEY_kana_KE                         0x04B9
#define KEY_kana_KO                         0x04BA
#define KEY_kana_SA                         0x04BB
#define KEY_kana_SHI                        0x04BC
#define KEY_kana_SU                         0x04BD
#define KEY_kana_SE                         0x04BE
#define KEY_kana_SO                         0x04BF
#define KEY_kana_TA                         0x04C0
#define KEY_kana_CHI                        0x04C1
#define KEY_kana_TI                         0x04C1
#define KEY_kana_TSU                        0x04C2
#define KEY_kana_TU                         0x04C2
#define KEY_kana_TE                         0x04C3
#define KEY_kana_TO                         0x04C4
#define KEY_kana_NA                         0x04C5
#define KEY_kana_NI                         0x04C6
#define KEY_kana_NU                         0x04C7
#define KEY_kana_NE                         0x04C8
#define KEY_kana_NO                         0x04C9
#define KEY_kana_HA                         0x04CA
#define KEY_kana_HI                         0x04CB
#define KEY_kana_FU                         0x04CC
#define KEY_kana_HU                         0x04CC
#define KEY_kana_HE                         0x04CD
#define KEY_kana_HO                         0x04CE
#define KEY_kana_MA                         0x04CF
#define KEY_kana_MI                         0x04D0
#define KEY_kana_MU                         0x04D1
#define KEY_kana_ME                         0x04D2
#define KEY_kana_MO                         0x04D3
#define KEY_kana_YA                         0x04D4
#define KEY_kana_YU                         0x04D5
#define KEY_kana_YO                         0x04D6
#define KEY_kana_RA                         0x04D7
#define KEY_kana_RI                         0x04D8
#define KEY_kana_RU                         0x04D9
#define KEY_kana_RE                         0x04DA
#define KEY_kana_RO                         0x04DB
#define KEY_kana_WA                         0x04DC
#define KEY_kana_N                          0x04DD
#define KEY_voicedsound                     0x04DE
#define KEY_semivoicedsound                 0x04DF
#define KEY_kana_switch                     0x0FF7

// Arabic
#define KEY_Arabic_comma                    0x05AC
#define KEY_Arabic_semicolon                0x05BB
#define KEY_Arabic_question_mark            0x05BF
#define KEY_Arabic_hamza                    0x05C1
#define KEY_Arabic_maddaonalef              0x05C2
#define KEY_Arabic_hamzaonalef              0x05C3
#define KEY_Arabic_hamzaonwaw               0x05C4
#define KEY_Arabic_hamzaunderalef           0x05C5
#define KEY_Arabic_hamzaonyeh               0x05C6
#define KEY_Arabic_alef                     0x05C7
#define KEY_Arabic_beh                      0x05C8
#define KEY_Arabic_tehmarbuta               0x05C9
#define KEY_Arabic_teh                      0x05CA
#define KEY_Arabic_theh                     0x05CB
#define KEY_Arabic_jeem                     0x05CC
#define KEY_Arabic_hah                      0x05CD
#define KEY_Arabic_khah                     0x05CE
#define KEY_Arabic_dal                      0x05CF
#define KEY_Arabic_thal                     0x05D0
#define KEY_Arabic_ra                       0x05D1
#define KEY_Arabic_zain                     0x05D2
#define KEY_Arabic_seen                     0x05D3
#define KEY_Arabic_sheen                    0x05D4
#define KEY_Arabic_sad                      0x05D5
#define KEY_Arabic_dad                      0x05D6
#define KEY_Arabic_tah                      0x05D7
#define KEY_Arabic_zah                      0x05D8
#define KEY_Arabic_ain                      0x05D9
#define KEY_Arabic_ghain                    0x05DA
#define KEY_Arabic_tatweel                  0x05E0
#define KEY_Arabic_feh                      0x05E1
#define KEY_Arabic_qaf                      0x05E2
#define KEY_Arabic_kaf                      0x05E3
#define KEY_Arabic_lam                      0x05E4
#define KEY_Arabic_meem                     0x05E5
#define KEY_Arabic_noon                     0x05E6
#define KEY_Arabic_ha                       0x05E7
#define KEY_Arabic_heh                      0x05E7
#define KEY_Arabic_waw                      0x05E8
#define KEY_Arabic_alefmaksura              0x05E9
#define KEY_Arabic_yeh                      0x05EA
#define KEY_Arabic_fathatan                 0x05EB
#define KEY_Arabic_dammatan                 0x05EC
#define KEY_Arabic_kasratan                 0x05ED
#define KEY_Arabic_fatha                    0x05EE
#define KEY_Arabic_damma                    0x05EF
#define KEY_Arabic_kasra                    0x05F0
#define KEY_Arabic_shadda                   0x05F1
#define KEY_Arabic_sukun                    0x05F2
#define KEY_Arabic_switch                   0xFF7E

// Cyrillic
#define KEY_Serbian_dje                     0x06A1
#define KEY_Macedonia_gje                   0x06A2
#define KEY_Cyrillic_io                     0x06A3
#define KEY_Ukrainian_ie                    0x06A4
#define KEY_Ukranian_je                     0x06A4
#define KEY_Macedonia_dse                   0x06A5
#define KEY_Ukrainian_i                     0x06A6
#define KEY_Ukranian_i                      0x06A6
#define KEY_Ukrainian_yi                    0x06A7
#define KEY_Ukranian_yi                     0x06A7
#define KEY_Cyrillic_je                     0x06A8
#define KEY_Serbian_je                      0x06A8
#define KEY_Cyrillic_lje                    0x06A9
#define KEY_Serbian_lje                     0x06A9
#define KEY_Cyrillic_nje                    0x06AA
#define KEY_Serbian_nje                     0x06AA
#define KEY_Serbian_tshe                    0x06AB
#define KEY_Macedonia_kje                   0x06AC
#define KEY_Byelorussian_shortu             0x06AE
#define KEY_Cyrillic_dzhe                   0x06AF
#define KEY_Serbian_dze                     0x06AF
#define KEY_numerosign                      0x06B0
#define KEY_Serbian_DJE                     0x06B1
#define KEY_Macedonia_GJE                   0x06B2
#define KEY_Cyrillic_IO                     0x06B3
#define KEY_Ukrainian_IE                    0x06B4
#define KEY_Ukranian_JE                     0x06B4
#define KEY_Macedonia_DSE                   0x06B5
#define KEY_Ukrainian_I                     0x06B6
#define KEY_Ukranian_I                      0x06B6
#define KEY_Ukrainian_YI                    0x06B7
#define KEY_Ukranian_YI                     0x06B7
#define KEY_Cyrillic_JE                     0x06B8
#define KEY_Serbian_JE                      0x06B8
#define KEY_Cyrillic_LJE                    0x06B9
#define KEY_Serbian_LJE                     0x06B9
#define KEY_Cyrillic_NJE                    0x06BA
#define KEY_Serbian_NJE                     0x06BA
#define KEY_Serbian_TSHE                    0x06BB
#define KEY_Macedonia_KJE                   0x06BC
#define KEY_Byelorussian_SHORTU             0x06BE
#define KEY_Cyrillic_DZHE                   0x06BF
#define KEY_Serbian_DZE                     0x06BF
#define KEY_Cyrillic_yu                     0x06C0
#define KEY_Cyrillic_a                      0x06C1
#define KEY_Cyrillic_be                     0x06C2
#define KEY_Cyrillic_tse                    0x06C3
#define KEY_Cyrillic_de                     0x06C4
#define KEY_Cyrillic_ie                     0x06C5
#define KEY_Cyrillic_ef                     0x06C6
#define KEY_Cyrillic_ghe                    0x06C7
#define KEY_Cyrillic_ha                     0x06C8
#define KEY_Cyrillic_i                      0x06C9
#define KEY_Cyrillic_shorti                 0x06CA
#define KEY_Cyrillic_ka                     0x06CB
#define KEY_Cyrillic_el                     0x06CC
#define KEY_Cyrillic_em                     0x06CD
#define KEY_Cyrillic_en                     0x06CE
#define KEY_Cyrillic_o                      0x06CF
#define KEY_Cyrillic_pe                     0x06D0
#define KEY_Cyrillic_ya                     0x06D1
#define KEY_Cyrillic_er                     0x06D2
#define KEY_Cyrillic_es                     0x06D3
#define KEY_Cyrillic_te                     0x06D4
#define KEY_Cyrillic_u                      0x06D5
#define KEY_Cyrillic_zhe                    0x06D6
#define KEY_Cyrillic_ve                     0x06D7
#define KEY_Cyrillic_softsign               0x06D8
#define KEY_Cyrillic_yeru                   0x06D9
#define KEY_Cyrillic_ze                     0x06DA
#define KEY_Cyrillic_sha                    0x06DB
#define KEY_Cyrillic_e                      0x06DC
#define KEY_Cyrillic_shcha                  0x06DD
#define KEY_Cyrillic_che                    0x06DE
#define KEY_Cyrillic_hardsign               0x06DF
#define KEY_Cyrillic_YU                     0x06E0
#define KEY_Cyrillic_A                      0x06E1
#define KEY_Cyrillic_BE                     0x06E2
#define KEY_Cyrillic_TSE                    0x06E3
#define KEY_Cyrillic_DE                     0x06E4
#define KEY_Cyrillic_IE                     0x06E5
#define KEY_Cyrillic_EF                     0x06E6
#define KEY_Cyrillic_GHE                    0x06E7
#define KEY_Cyrillic_HA                     0x06E8
#define KEY_Cyrillic_I                      0x06E9
#define KEY_Cyrillic_SHORTI                 0x06EA
#define KEY_Cyrillic_KA                     0x06EB
#define KEY_Cyrillic_EL                     0x06EC
#define KEY_Cyrillic_EM                     0x06ED
#define KEY_Cyrillic_EN                     0x06EE
#define KEY_Cyrillic_O                      0x06EF
#define KEY_Cyrillic_PE                     0x06F0
#define KEY_Cyrillic_YA                     0x06F1
#define KEY_Cyrillic_ER                     0x06F2
#define KEY_Cyrillic_ES                     0x06F3
#define KEY_Cyrillic_TE                     0x06F4
#define KEY_Cyrillic_U                      0x06F5
#define KEY_Cyrillic_ZHE                    0x06F6
#define KEY_Cyrillic_VE                     0x06F7
#define KEY_Cyrillic_SOFTSIGN               0x06F8
#define KEY_Cyrillic_YERU                   0x06F9
#define KEY_Cyrillic_ZE                     0x06FA
#define KEY_Cyrillic_SHA                    0x06FB
#define KEY_Cyrillic_E                      0x06FC
#define KEY_Cyrillic_SHCHA                  0x06FD
#define KEY_Cyrillic_CHE                    0x06FE
#define KEY_Cyrillic_HARDSIGN               0x06FF

// Greek
#define KEY_Greek_ALPHAaccent               0x07A1
#define KEY_Greek_EPSILONaccent             0x07A2
#define KEY_Greek_ETAaccent                 0x07A3
#define KEY_Greek_IOTAaccent                0x07A4
#define KEY_Greek_IOTAdiaeresis             0x07A5
#define KEY_Greek_OMICRONaccent             0x07A7
#define KEY_Greek_UPSILONaccent             0x07A8
#define KEY_Greek_UPSILONdieresis           0x07A9
#define KEY_Greek_OMEGAaccent               0x07AB
#define KEY_Greek_accentdieresis            0x07AE
#define KEY_Greek_horizbar                  0x07AF
#define KEY_Greek_alphaaccent               0x07B1
#define KEY_Greek_epsilonaccent             0x07B2
#define KEY_Greek_etaaccent                 0x07B3
#define KEY_Greek_iotaaccent                0x07B4
#define KEY_Greek_iotadieresis              0x07B5
#define KEY_Greek_iotaaccentdieresis        0x07B6
#define KEY_Greek_omicronaccent             0x07B7
#define KEY_Greek_upsilonaccent             0x07B8
#define KEY_Greek_upsilondieresis           0x07B9
#define KEY_Greek_upsilonaccentdieresis     0x07BA
#define KEY_Greek_omegaaccent               0x07BB
#define KEY_Greek_ALPHA                     0x07C1
#define KEY_Greek_BETA                      0x07C2
#define KEY_Greek_GAMMA                     0x07C3
#define KEY_Greek_DELTA                     0x07C4
#define KEY_Greek_EPSILON                   0x07C5
#define KEY_Greek_ZETA                      0x07C6
#define KEY_Greek_ETA                       0x07C7
#define KEY_Greek_THETA                     0x07C8
#define KEY_Greek_IOTA                      0x07C9
#define KEY_Greek_KAPPA                     0x07CA
#define KEY_Greek_LAMDA                     0x07CB
#define KEY_Greek_LAMBDA                    0x07CB
#define KEY_Greek_MU                        0x07CC
#define KEY_Greek_NU                        0x07CD
#define KEY_Greek_XI                        0x07CE
#define KEY_Greek_OMICRON                   0x07CF
#define KEY_Greek_PI                        0x07D0
#define KEY_Greek_RHO                       0x07D1
#define KEY_Greek_SIGMA                     0x07D2
#define KEY_Greek_TAU                       0x07D4
#define KEY_Greek_UPSILON                   0x07D5
#define KEY_Greek_PHI                       0x07D6
#define KEY_Greek_CHI                       0x07D7
#define KEY_Greek_PSI                       0x07D8
#define KEY_Greek_OMEGA                     0x07D9
#define KEY_Greek_alpha                     0x07E1
#define KEY_Greek_beta                      0x07E2
#define KEY_Greek_gamma                     0x07E3
#define KEY_Greek_delta                     0x07E4
#define KEY_Greek_epsilon                   0x07E5
#define KEY_Greek_zeta                      0x07E6
#define KEY_Greek_eta                       0x07E7
#define KEY_Greek_theta                     0x07E8
#define KEY_Greek_iota                      0x07E9
#define KEY_Greek_kappa                     0x07EA
#define KEY_Greek_lamda                     0x07EB
#define KEY_Greek_lambda                    0x07EB
#define KEY_Greek_mu                        0x07EC
#define KEY_Greek_nu                        0x07ED
#define KEY_Greek_xi                        0x07EE
#define KEY_Greek_omicron                   0x07EF
#define KEY_Greek_pi                        0x07F0
#define KEY_Greek_rho                       0x07F1
#define KEY_Greek_sigma                     0x07F2
#define KEY_Greek_finalsmallsigma           0x07F3
#define KEY_Greek_tau                       0x07F4
#define KEY_Greek_upsilon                   0x07F5
#define KEY_Greek_phi                       0x07F6
#define KEY_Greek_chi                       0x07F7
#define KEY_Greek_psi                       0x07F8
#define KEY_Greek_omega                     0x07F9
#define KEY_Greek_switch                    0xFF7E

// Technical
#define KEY_leftradical                     0x08A1
#define KEY_topleftradical                  0x08A2
#define KEY_horizconnector                  0x08A3
#define KEY_topintegral                     0x08A4
#define KEY_botintegral                     0x08A5
#define KEY_vertconnector                   0x08A6
#define KEY_topleftsqbracket                0x08A7
#define KEY_botleftsqbracket                0x08A8
#define KEY_toprightsqbracket               0x08A9
#define KEY_botrightsqbracket               0x08AA
#define KEY_topleftparens                   0x08AB
#define KEY_botleftparens                   0x08AC
#define KEY_toprightparens                  0x08AD
#define KEY_botrightparens                  0x08AE
#define KEY_leftmiddlecurlybrace            0x08AF
#define KEY_rightmiddlecurlybrace           0x08B0
#define KEY_topleftsummation                0x08B1
#define KEY_botleftsummation                0x08B2
#define KEY_topvertsummationconnector       0x08B3
#define KEY_botvertsummationconnector       0x08B4
#define KEY_toprightsummation               0x08B5
#define KEY_botrightsummation               0x08B6
#define KEY_rightmiddlesummation            0x08B7
#define KEY_lessthanequal                   0x08BC
#define KEY_notequal                        0x08BD
#define KEY_greaterthanequal                0x08BE
#define KEY_integral                        0x08BF
#define KEY_therefore                       0x08C0
#define KEY_variation                       0x08C1
#define KEY_infinity                        0x08C2
#define KEY_nabla                           0x08C5
#define KEY_approximate                     0x08C8
#define KEY_similarequal                    0x08C9
#define KEY_ifonlyif                        0x08CD
#define KEY_implies                         0x08CE
#define KEY_identical                       0x08CF
#define KEY_radical                         0x08D6
#define KEY_includedin                      0x08DA
#define KEY_includes                        0x08DB
#define KEY_intersection                    0x08DC
#define KEY_union                           0x08DD
#define KEY_logicaland                      0x08DE
#define KEY_logicalor                       0x08DF
#define KEY_partialderivative               0x08EF
#define KEY_function                        0x08F6
#define KEY_leftarrow                       0x08FB
#define KEY_uparrow                         0x08FC
#define KEY_rightarrow                      0x08FD
#define KEY_downarrow                       0x08FE

// Special
#define KEY_blank                           0x09DF
#define KEY_soliddiamond                    0x09E0
#define KEY_checkerboard                    0x09E1
#define KEY_ht                              0x09E2
#define KEY_ff                              0x09E3
#define KEY_cr                              0x09E4
#define KEY_lf                              0x09E5
#define KEY_nl                              0x09E8
#define KEY_vt                              0x09E9
#define KEY_lowrightcorner                  0x09EA
#define KEY_uprightcorner                   0x09EB
#define KEY_upleftcorner                    0x09EC
#define KEY_lowleftcorner                   0x09ED
#define KEY_crossinglines                   0x09EE
#define KEY_horizlinescan1                  0x09EF
#define KEY_horizlinescan3                  0x09F0
#define KEY_horizlinescan5                  0x09F1
#define KEY_horizlinescan7                  0x09F2
#define KEY_horizlinescan9                  0x09F3
#define KEY_leftt                           0x09F4
#define KEY_rightt                          0x09F5
#define KEY_bott                            0x09F6
#define KEY_topt                            0x09F7
#define KEY_vertbar                         0x09F8

// Publishing
#define KEY_emspace                         0x0AA1
#define KEY_enspace                         0x0AA2
#define KEY_em3space                        0x0AA3
#define KEY_em4space                        0x0AA4
#define KEY_digitspace                      0x0AA5
#define KEY_punctspace                      0x0AA6
#define KEY_thinspace                       0x0AA7
#define KEY_hairspace                       0x0AA8
#define KEY_emdash                          0x0AA9
#define KEY_endash                          0x0AAA
#define KEY_signifblank                     0x0AAC
#define KEY_ellipsis                        0x0AAE
#define KEY_doubbaselinedot                 0x0AAF
#define KEY_onethird                        0x0AB0
#define KEY_twothirds                       0x0AB1
#define KEY_onefifth                        0x0AB2
#define KEY_twofifths                       0x0AB3
#define KEY_threefifths                     0x0AB4
#define KEY_fourfifths                      0x0AB5
#define KEY_onesixth                        0x0AB6
#define KEY_fivesixths                      0x0AB7
#define KEY_careof                          0x0AB8
#define KEY_figdash                         0x0ABB
#define KEY_leftanglebracket                0x0ABC
#define KEY_decimalpoint                    0x0ABD
#define KEY_rightanglebracket               0x0ABE
#define KEY_marker                          0x0ABF
#define KEY_oneeighth                       0x0AC3
#define KEY_threeeighths                    0x0AC4
#define KEY_fiveeighths                     0x0AC5
#define KEY_seveneighths                    0x0AC6
#define KEY_trademark                       0x0AC9
#define KEY_signaturemark                   0x0ACA
#define KEY_trademarkincircle               0x0ACB
#define KEY_leftopentriangle                0x0ACC
#define KEY_rightopentriangle               0x0ACD
#define KEY_emopencircle                    0x0ACE
#define KEY_emopenrectangle                 0x0ACF
#define KEY_leftsinglequotemark             0x0AD0
#define KEY_rightsinglequotemark            0x0AD1
#define KEY_leftdoublequotemark             0x0AD2
#define KEY_rightdoublequotemark            0x0AD3
#define KEY_prescription                    0x0AD4
#define KEY_minutes                         0x0AD6
#define KEY_seconds                         0x0AD7
#define KEY_latincross                      0x0AD9
#define KEY_hexagram                        0x0ADA
#define KEY_filledrectbullet                0x0ADB
#define KEY_filledlefttribullet             0x0ADC
#define KEY_filledrighttribullet            0x0ADD
#define KEY_emfilledcircle                  0x0ADE
#define KEY_emfilledrect                    0x0ADF
#define KEY_enopencircbullet                0x0AE0
#define KEY_enopensquarebullet              0x0AE1
#define KEY_openrectbullet                  0x0AE2
#define KEY_opentribulletup                 0x0AE3
#define KEY_opentribulletdown               0x0AE4
#define KEY_openstar                        0x0AE5
#define KEY_enfilledcircbullet              0x0AE6
#define KEY_enfilledsqbullet                0x0AE7
#define KEY_filledtribulletup               0x0AE8
#define KEY_filledtribulletdown             0x0AE9
#define KEY_leftpointer                     0x0AEA
#define KEY_rightpointer                    0x0AEB
#define KEY_club                            0x0AEC
#define KEY_diamond                         0x0AED
#define KEY_heart                           0x0AEE
#define KEY_maltesecross                    0x0AF0
#define KEY_dagger                          0x0AF1
#define KEY_doubledagger                    0x0AF2
#define KEY_checkmark                       0x0AF3
#define KEY_ballotcross                     0x0AF4
#define KEY_musicalsharp                    0x0AF5
#define KEY_musicalflat                     0x0AF6
#define KEY_malesymbol                      0x0AF7
#define KEY_femalesymbol                    0x0AF8
#define KEY_telephone                       0x0AF9
#define KEY_telephonerecorder               0x0AFA
#define KEY_phonographcopyright             0x0AFB
#define KEY_caret                           0x0AFC
#define KEY_singlelowquotemark              0x0AFD
#define KEY_doublelowquotemark              0x0AFE
#define KEY_cursor                          0x0AFF

// APL
#define KEY_leftcaret                       0x0BA3
#define KEY_rightcaret                      0x0BA6
#define KEY_downcaret                       0x0BA8
#define KEY_upcaret                         0x0BA9
#define KEY_overbar                         0x0BC0
#define KEY_downtack                        0x0BC2
#define KEY_upshoe                          0x0BC3
#define KEY_downstile                       0x0BC4
#define KEY_underbar                        0x0BC6
#define KEY_jot                             0x0BCA
#define KEY_quad                            0x0BCC
#define KEY_uptack                          0x0BCE
#define KEY_circle                          0x0BCF
#define KEY_upstile                         0x0BD3
#define KEY_downshoe                        0x0BD6
#define KEY_rightshoe                       0x0BD8
#define KEY_leftshoe                        0x0BDA
#define KEY_lefttack                        0x0BDC
#define KEY_righttack                       0x0BFC

// Hebrew
#define KEY_hebrew_doublelowline            0x0CDF
#define KEY_hebrew_aleph                    0x0CE0
#define KEY_hebrew_bet                      0x0CE1
#define KEY_hebrew_beth                     0x0CE1
#define KEY_hebrew_gimel                    0x0CE2
#define KEY_hebrew_gimmel                   0x0CE2
#define KEY_hebrew_dalet                    0x0CE3
#define KEY_hebrew_daleth                   0x0CE3
#define KEY_hebrew_he                       0x0CE4
#define KEY_hebrew_waw                      0x0CE5
#define KEY_hebrew_zain                     0x0CE6
#define KEY_hebrew_zayin                    0x0CE6
#define KEY_hebrew_chet                     0x0CE7
#define KEY_hebrew_het                      0x0CE7
#define KEY_hebrew_tet                      0x0CE8
#define KEY_hebrew_teth                     0x0CE8
#define KEY_hebrew_yod                      0x0CE9
#define KEY_hebrew_finalkaph                0x0CEA
#define KEY_hebrew_kaph                     0x0CEB
#define KEY_hebrew_lamed                    0x0CEC
#define KEY_hebrew_finalmem                 0x0CED
#define KEY_hebrew_mem                      0x0CEE
#define KEY_hebrew_finalnun                 0x0CEF
#define KEY_hebrew_nun                      0x0CF0
#define KEY_hebrew_samech                   0x0CF1
#define KEY_hebrew_samekh                   0x0CF1
#define KEY_hebrew_ayin                     0x0CF2
#define KEY_hebrew_finalpe                  0x0CF3
#define KEY_hebrew_pe                       0x0CF4
#define KEY_hebrew_finalzade                0x0CF5
#define KEY_hebrew_finalzadi                0x0CF5
#define KEY_hebrew_zade                     0x0CF6
#define KEY_hebrew_zadi                     0x0CF6
#define KEY_hebrew_qoph                     0x0CF7
#define KEY_hebrew_kuf                      0x0CF7
#define KEY_hebrew_resh                     0x0CF8
#define KEY_hebrew_shin                     0x0CF9
#define KEY_hebrew_taw                      0x0CFA
#define KEY_hebrew_taf                      0x0CFA
#define KEY_Hebrew_switch                   0xFF7E

// Thai
#define KEY_Thai_kokai			    0x0DA1
#define KEY_Thai_khokhai		    0x0DA2
#define KEY_Thai_khokhuat		    0x0DA3
#define KEY_Thai_khokhwai		    0x0DA4
#define KEY_Thai_khokhon		    0x0DA5
#define KEY_Thai_khorakhang		    0x0DA6
#define KEY_Thai_ngongu			    0x0DA7
#define KEY_Thai_chochan		    0x0DA8
#define KEY_Thai_choching		    0x0DA9
#define KEY_Thai_chochang		    0x0DAA
#define KEY_Thai_soso			    0x0DAB
#define KEY_Thai_chochoe		    0x0DAC
#define KEY_Thai_yoying			    0x0DAD
#define KEY_Thai_dochada		    0x0DAE
#define KEY_Thai_topatak		    0x0DAF
#define KEY_Thai_thothan		    0x0DB0
#define KEY_Thai_thonangmontho		    0x0DB1
#define KEY_Thai_thophuthao		    0x0DB2
#define KEY_Thai_nonen			    0x0DB3
#define KEY_Thai_dodek			    0x0DB4
#define KEY_Thai_totao			    0x0DB5
#define KEY_Thai_thothung		    0x0DB6
#define KEY_Thai_thothahan		    0x0DB7
#define KEY_Thai_thothong	 	    0x0DB8
#define KEY_Thai_nonu			    0x0DB9
#define KEY_Thai_bobaimai		    0x0DBA
#define KEY_Thai_popla			    0x0DBB
#define KEY_Thai_phophung		    0x0DBC
#define KEY_Thai_fofa			    0x0DBD
#define KEY_Thai_phophan		    0x0DBE
#define KEY_Thai_fofan			    0x0DBF
#define KEY_Thai_phosamphao		    0x0DC0
#define KEY_Thai_moma			    0x0DC1
#define KEY_Thai_yoyak			    0x0DC2
#define KEY_Thai_rorua			    0x0DC3
#define KEY_Thai_ru			    0x0DC4
#define KEY_Thai_loling			    0x0DC5
#define KEY_Thai_lu			    0x0DC6
#define KEY_Thai_wowaen			    0x0DC7
#define KEY_Thai_sosala			    0x0DC8
#define KEY_Thai_sorusi			    0x0DC9
#define KEY_Thai_sosua			    0x0DCA
#define KEY_Thai_hohip			    0x0DCB
#define KEY_Thai_lochula		    0x0DCC
#define KEY_Thai_oang			    0x0DCD
#define KEY_Thai_honokhuk		    0x0DCE
#define KEY_Thai_paiyannoi		    0x0DCF
#define KEY_Thai_saraa			    0x0DD0
#define KEY_Thai_maihanakat		    0x0DD1
#define KEY_Thai_saraaa			    0x0DD2
#define KEY_Thai_saraam			    0x0DD3
#define KEY_Thai_sarai			    0x0DD4
#define KEY_Thai_saraii			    0x0DD5
#define KEY_Thai_saraue			    0x0DD6
#define KEY_Thai_sarauee		    0x0DD7
#define KEY_Thai_sarau			    0x0DD8
#define KEY_Thai_sarauu			    0x0DD9
#define KEY_Thai_phinthu		    0x0DDA
#define KEY_Thai_maihanakat_maitho   	    0x0DDE
#define KEY_Thai_baht			    0x0DDF
#define KEY_Thai_sarae			    0x0DE0
#define KEY_Thai_saraae			    0x0DE1
#define KEY_Thai_sarao			    0x0DE2
#define KEY_Thai_saraaimaimuan		    0x0DE3
#define KEY_Thai_saraaimaimalai		    0x0DE4
#define KEY_Thai_lakkhangyao		    0x0DE5
#define KEY_Thai_maiyamok		    0x0DE6
#define KEY_Thai_maitaikhu		    0x0DE7
#define KEY_Thai_maiek			    0x0DE8
#define KEY_Thai_maitho			    0x0DE9
#define KEY_Thai_maitri			    0x0DEA
#define KEY_Thai_maichattawa		    0x0DEB
#define KEY_Thai_thanthakhat		    0x0DEC
#define KEY_Thai_nikhahit		    0x0DED
#define KEY_Thai_leksun			    0x0DF0
#define KEY_Thai_leknung		    0x0DF1
#define KEY_Thai_leksong		    0x0DF2
#define KEY_Thai_leksam			    0x0DF3
#define KEY_Thai_leksi			    0x0DF4
#define KEY_Thai_lekha			    0x0DF5
#define KEY_Thai_lekhok			    0x0DF6
#define KEY_Thai_lekchet		    0x0DF7
#define KEY_Thai_lekpaet		    0x0DF8
#define KEY_Thai_lekkao			    0x0DF9

// Korean
#define KEY_Hangul		            0xFF31
#define KEY_Hangul_Start		    0xFF32
#define KEY_Hangul_End		            0xFF33
#define KEY_Hangul_Hanja		    0xFF34
#define KEY_Hangul_Jamo		            0xFF35
#define KEY_Hangul_Romaja	            0xFF36
#define KEY_Hangul_Codeinput	            0xFF37
#define KEY_Hangul_Jeonja	            0xFF38
#define KEY_Hangul_Banja		    0xFF39
#define KEY_Hangul_PreHanja	            0xFF3A
#define KEY_Hangul_PostHanja	            0xFF3B
#define KEY_Hangul_SingleCandidate	    0xFF3C
#define KEY_Hangul_MultipleCandidate	    0xFF3D
#define KEY_Hangul_PreviousCandidate	    0xFF3E
#define KEY_Hangul_Special	            0xFF3F
#define KEY_Hangul_switch	            0xFF7E
#define KEY_Hangul_Kiyeog		    0x0EA1
#define KEY_Hangul_SsangKiyeog		    0x0EA2
#define KEY_Hangul_KiyeogSios		    0x0EA3
#define KEY_Hangul_Nieun		    0x0EA4
#define KEY_Hangul_NieunJieuj		    0x0EA5
#define KEY_Hangul_NieunHieuh		    0x0EA6
#define KEY_Hangul_Dikeud		    0x0EA7
#define KEY_Hangul_SsangDikeud		    0x0EA8
#define KEY_Hangul_Rieul		    0x0EA9
#define KEY_Hangul_RieulKiyeog		    0x0EAA
#define KEY_Hangul_RieulMieum		    0x0EAB
#define KEY_Hangul_RieulPieub		    0x0EAC
#define KEY_Hangul_RieulSios		    0x0EAD
#define KEY_Hangul_RieulTieut		    0x0EAE
#define KEY_Hangul_RieulPhieuf		    0x0EAF
#define KEY_Hangul_RieulHieuh		    0x0EB0
#define KEY_Hangul_Mieum		    0x0EB1
#define KEY_Hangul_Pieub		    0x0EB2
#define KEY_Hangul_SsangPieub		    0x0EB3
#define KEY_Hangul_PieubSios		    0x0EB4
#define KEY_Hangul_Sios			    0x0EB5
#define KEY_Hangul_SsangSios		    0x0EB6
#define KEY_Hangul_Ieung		    0x0EB7
#define KEY_Hangul_Jieuj		    0x0EB8
#define KEY_Hangul_SsangJieuj		    0x0EB9
#define KEY_Hangul_Cieuc		    0x0EBA
#define KEY_Hangul_Khieuq		    0x0EBB
#define KEY_Hangul_Tieut		    0x0EBC
#define KEY_Hangul_Phieuf		    0x0EBD
#define KEY_Hangul_Hieuh		    0x0EBE
#define KEY_Hangul_A			    0x0EBF
#define KEY_Hangul_AE			    0x0EC0
#define KEY_Hangul_YA			    0x0EC1
#define KEY_Hangul_YAE			    0x0EC2
#define KEY_Hangul_EO			    0x0EC3
#define KEY_Hangul_E			    0x0EC4
#define KEY_Hangul_YEO			    0x0EC5
#define KEY_Hangul_YE			    0x0EC6
#define KEY_Hangul_O			    0x0EC7
#define KEY_Hangul_WA			    0x0EC8
#define KEY_Hangul_WAE			    0x0EC9
#define KEY_Hangul_OE			    0x0ECA
#define KEY_Hangul_YO			    0x0ECB
#define KEY_Hangul_U			    0x0ECC
#define KEY_Hangul_WEO			    0x0ECD
#define KEY_Hangul_WE			    0x0ECE
#define KEY_Hangul_WI			    0x0ECF
#define KEY_Hangul_YU			    0x0ED0
#define KEY_Hangul_EU			    0x0ED1
#define KEY_Hangul_YI			    0x0ED2
#define KEY_Hangul_I			    0x0ED3
#define KEY_Hangul_J_Kiyeog		    0x0ED4
#define KEY_Hangul_J_SsangKiyeog	    0x0ED5
#define KEY_Hangul_J_KiyeogSios		    0x0ED6
#define KEY_Hangul_J_Nieun		    0x0ED7
#define KEY_Hangul_J_NieunJieuj		    0x0ED8
#define KEY_Hangul_J_NieunHieuh		    0x0ED9
#define KEY_Hangul_J_Dikeud		    0x0EDA
#define KEY_Hangul_J_Rieul		    0x0EDB
#define KEY_Hangul_J_RieulKiyeog	    0x0EDC
#define KEY_Hangul_J_RieulMieum		    0x0EDD
#define KEY_Hangul_J_RieulPieub		    0x0EDE
#define KEY_Hangul_J_RieulSios		    0x0EDF
#define KEY_Hangul_J_RieulTieut		    0x0EE0
#define KEY_Hangul_J_RieulPhieuf	    0x0EE1
#define KEY_Hangul_J_RieulHieuh		    0x0EE2
#define KEY_Hangul_J_Mieum		    0x0EE3
#define KEY_Hangul_J_Pieub		    0x0EE4
#define KEY_Hangul_J_PieubSios		    0x0EE5
#define KEY_Hangul_J_Sios		    0x0EE6
#define KEY_Hangul_J_SsangSios		    0x0EE7
#define KEY_Hangul_J_Ieung		    0x0EE8
#define KEY_Hangul_J_Jieuj		    0x0EE9
#define KEY_Hangul_J_Cieuc		    0x0EEA
#define KEY_Hangul_J_Khieuq		    0x0EEB
#define KEY_Hangul_J_Tieut		    0x0EEC
#define KEY_Hangul_J_Phieuf		    0x0EED
#define KEY_Hangul_J_Hieuh		    0x0EEE
#define KEY_Hangul_RieulYeorinHieuh	    0x0EEF
#define KEY_Hangul_SunkyeongeumMieum	    0x0EF0
#define KEY_Hangul_SunkyeongeumPieub	    0x0EF1
#define KEY_Hangul_PanSios		    0x0EF2
#define KEY_Hangul_KkogjiDalrinIeung	    0x0EF3
#define KEY_Hangul_SunkyeongeumPhieuf	    0x0EF4
#define KEY_Hangul_YeorinHieuh		    0x0EF5
#define KEY_Hangul_AraeA		    0x0EF6
#define KEY_Hangul_AraeAE		    0x0EF7
#define KEY_Hangul_J_PanSios		    0x0EF8
#define KEY_Hangul_J_KkogjiDalrinIeung	    0x0EF9
#define KEY_Hangul_J_YeorinHieuh	    0x0EFA
#define KEY_Korean_Won			    0x0EFF

#endif
