/********************************************************************************
*                                                                               *
*                       T e x t   S e a r c h   D i a l o g                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 2000,2001 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: FXSearchDialog.h,v 1.9 2001/01/31 16:30:34 jeroen Exp $                  *
********************************************************************************/
#ifndef FXSEARCHDIALOG_H
#define FXSEARCHDIALOG_H


class FXTextField;



/// Text search dialog
class FXAPI FXSearchDialog : public FXDialogBox {
  FXDECLARE(FXSearchDialog)
protected:
  FXTextField   *searchtext;
  FXuint         searchmode;
protected:
  FXSearchDialog(){}
private:
  FXSearchDialog(const FXSearchDialog&);
  FXSearchDialog &operator=(const FXSearchDialog&);
public:
  long onCmdSearchNext(FXObject*,FXSelector,void*);
  long onUpdSearchDir(FXObject*,FXSelector,void*);
  long onCmdSearchDir(FXObject*,FXSelector,void*);
  long onUpdSearchMode(FXObject*,FXSelector,void*);
  long onCmdSearchMode(FXObject*,FXSelector,void*);
public:
  enum{
    ID_SEARCH_NEXT=FXDialogBox::ID_LAST,
    ID_SEARCH_LAST,
    ID_SEARCH_DIR,
    ID_SEARCH_MODE,
    ID_LAST=ID_SEARCH_MODE+32
    };
public:
  enum {  
    DONE        = 0,     /// Cancel search
    SEARCH      = 1,     /// Search first occurrence
    SEARCH_NEXT = 2      /// Search next occurrence
    };
public:
  
  /// Construct search dialog box
  FXSearchDialog(FXWindow* owner,const FXString& caption,FXIcon* ic=NULL,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);

  /// Set text or pattern to search for
  void setSearchText(const FXString& text);

  /// Return text or pattern the user has entered
  FXString getSearchText() const;

  /// Set search match mode
  void setSearchMode(FXuint mode){ searchmode=mode; }

  /// Return search mode the user has selected
  FXuint getSearchMode() const { return searchmode; }
  
  /// Save to stream
  virtual void save(FXStream& store) const;

  /// Load from stream
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXSearchDialog();
  };


#endif
