/********************************************************************************
*                                                                               *
*                        D r i v e   B o x   W i d g e t                        *
*                                                                               *
*********************************************************************************
* Copyright (C) 1999,2001 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXDRIVEBOX_H
#define FXDRIVEBOX_H


/// DRIVE Box styles
enum {
  DRIVEBOX_REPORT_ERRORS         = 0x00020000          // Display an error dialog if a drive is inaccessible
  };


class FXIcon;


/// Directory Box
class FXAPI FXDriveBox : public FXListBox {
  FXDECLARE(FXDriveBox)
protected:
  FXString    currentdrive;
  FXIcon     *foldericon;             // Folder icons
  FXIcon     *cdromicon;
  FXIcon     *desktopicon;
  FXIcon     *harddiskicon;
  FXIcon     *networkicon;
  FXIcon     *floppyicon;
  FXIcon     *computericon;
  FXIcon     *nethoodicon;
  FXIcon     *zipdiskicon;
protected:
  FXDriveBox(){}
  void loaddrives();
private:
  FXDriveBox(const FXDriveBox&);
  FXDriveBox &operator=(const FXDriveBox&);
public:
  long onChanged(FXObject*,FXSelector,void*);
  long onCommand(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdSetStringValue(FXObject*,FXSelector,void*);
  long onCmdGetStringValue(FXObject*,FXSelector,void*);
public:

  /// Constructor
  FXDriveBox(FXComposite *p,FXint nvis,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=FRAME_SUNKEN|FRAME_THICK|LISTBOX_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

  /// Create server-side resources
  virtual void create();

  /// Detach server-side resources
  virtual void detach();

  /// Destroy server-side resources
  virtual void destroy();

  /// Save to stream
  virtual void save(FXStream& store) const;

  /// Load from stream
  virtual void load(FXStream& store);

  /// Set current drive
  FXbool setDrive(const FXString& drive);

  /// Return current drive
  FXString getDrive() const { return currentdrive; }

  void reportErrors(FXbool errors=TRUE);

  /// Destructor
  virtual ~FXDriveBox();
  };


#endif
