/********************************************************************************
*                                                                               *
*                      T e x t   R e p l a c e   D i a l o g                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 2000,2001 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: FXReplaceDialog.h,v 1.8 2001/01/31 16:30:34 jeroen Exp $                 *
********************************************************************************/
#ifndef FXREPLACEDIALOG_H
#define FXREPLACEDIALOG_H


class FXTextField;
 

/// Text replace dialog
class FXAPI FXReplaceDialog : public FXDialogBox {
  FXDECLARE(FXReplaceDialog)
protected:
  FXTextField   *searchtext;
  FXTextField   *replacetext;
  FXuint         searchmode;
protected:
  FXReplaceDialog(){}
private:
  FXReplaceDialog(const FXReplaceDialog&);
  FXReplaceDialog &operator=(const FXReplaceDialog&);
public:
  long onCmdReplaceAll(FXObject*,FXSelector,void*);
  long onCmdReplaceNext(FXObject*,FXSelector,void*);
  long onUpdReplaceDir(FXObject*,FXSelector,void*);
  long onCmdReplaceDir(FXObject*,FXSelector,void*);
  long onUpdReplaceMode(FXObject*,FXSelector,void*);
  long onCmdReplaceMode(FXObject*,FXSelector,void*);
public:
  enum{
    ID_REPLACE_ALL=FXDialogBox::ID_LAST,
    ID_REPLACE_NEXT,
    ID_REPLACE_LAST,
    ID_REPLACE_DIR,
    ID_REPLACE_MODE,
    ID_LAST=ID_REPLACE_MODE+32
    };
public:
  enum {
    DONE          = 0,    /// Cancel replace
    REPLACE       = 1,    /// Replace first occurrence
    REPLACE_ALL   = 2,    /// Replace all occurrences
    REPLACE_NEXT  = 3     /// Replace next occurrence
    };
public:

  /// Construct search and replace dialog box
  FXReplaceDialog(FXWindow* owner,const FXString& caption,FXIcon* ic=NULL,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);

  /// Set text or pattern to search for
  void setSearchText(const FXString& text);

  /// Return text or pattern the user has entered
  FXString getSearchText() const;

  /// Set replace text
  void setReplaceText(const FXString& text);

  /// Return replace text the user has entered
  FXString getReplaceText() const;

  /// Set search match mode
  void setSearchMode(FXuint mode){ searchmode=mode; }

  /// Return search mode the user has selected
  FXuint getSearchMode() const { return searchmode; }

  /// Save to stream
  virtual void save(FXStream& store) const;

  /// Load from stream
  virtual void load(FXStream& store);

  /// Destructor
  virtual ~FXReplaceDialog();
  };


#endif
