<?php
/* daCode http://www.dacode.org/
 * src/phplib/admin.php3
 * $Id: admin.php3,v 1.146 2001/07/12 20:09:45 penso Exp $
 *
 * Class to handle all the admin functions.
 *
 * Depends: Config Db User Utils Html Poll News Redirect Webcam
 */

Class Admin {
	var $db,$session,$utils,$html,$poll,$news,$redirect,$webcam,$tips;

	Function Admin() {
		//echo '<br>Admin';
		$this->db = LoadClass('Db');
		$this->session = LoadClass('Session');
		$this->cache = LoadClass('Cache');
		$this->html  = LoadClass('Html');
		$this->poll  = LoadClass('Poll');
		$this->news  = LoadClass('News');
		$this->webcam = LoadClass('Webcam');
		$this->redirect = LoadClass('Redirect');
		$this->tar   = LoadClass('Tar');
		$this->tips  = LoadClass('Tips');
	}

	/*
	 * This print the admin box on the homepage is user as admin or
	 * moderator rights
	 */
	Function adminbox() {
		global $config;

		// Just to return fast in case the user doesn't interest us.
		if (!$this->session->is_moderator) {
			return '<!-- ADMIN --><!-- /ADMIN -->';
		}

		$tmp = '';

		if ($this->session->is_admin) {
			$tmp .= "<center><font color=\"#ff0000\">".lecho("You are a super user!").
				"</font></center><br>\n";

			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=clear_cache\">".lecho("Clear Cache")."</a><br>\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=edit_users\">".lecho("Edit Users")."</a><br>\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=edit_topics\">".lecho("Edit Topics")."</a><br>\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=add_topics\">".lecho("Add Topics")."</a><br>\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=edit_section\">".lecho("Edit Sections")."</a><br>\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=add_section\">".lecho("Add Sections")."</a><br>\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=edit_theme\">".lecho("Themes")."</a><br>\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=list_polls\">".lecho("Edit Polls")."</a><br>\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=add_tip_section\">".lecho("Add Tip Sections")."</a><br>\n";
		}

		/* 
		 * We build the SELECT command to fetch news 
		 */ 
		$sqlc_q = "SELECT ".
			$config->tables['news'].".id," .
			$config->tables['news'].".timestamp,".
			$config->tables['news'].".title,".
			$config->tables['news'].".departement,".
			$config->tables['news_body'].".body,".
			$config->tables['topics'].".topic,".
			$config->tables['sections']. ".section,".
			$config->tables['author'].".name,".
			$config->tables['author'].".contact,".
			$config->tables['news'].".state FROM ".
			$config->tables['news'].",".
			$config->tables['news_body'].",".
			$config->tables['topics'].",".
			$config->tables['sections'].",".
			$config->tables['author']." "."WHERE ".
			$config->tables['news'].".id=".
			$config->tables['news_body'].".id AND ".
			$config->tables['news'].".author_id=".
			$config->tables['author'].".id AND ".
			$config->tables['news'].".topic_id=".
			$config->tables['topics'].".id AND ".
			$config->tables['news'].".section_id=".
			$config->tables['sections'].".id AND (".
			$config->tables['news'].".state='0' OR ".
			$config->tables['news'].".state='2' OR ".
			$config->tables['news'].".state='3' ) ORDER BY ".
			$config->tables['news'].".timestamp DESC LIMIT 100";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			return -1;
		}

		$i=0;

		while ($row = $this->db->fetch_array()) {
			if (empty($row[2])) {
				$row[2] = $config->newstitledefault;
			}

			if ($row[9] == "0") {
				$tmp .= "&nbsp;-&nbsp;";
				$tmp .= "[".lecho("to moderate")."] ";
				$tmp .= "<A HREF=\"". $config->basehref.
					$config->adminfile.
					"?action=edit_news&amp;news_id=$row[0]\">$row[2]</A><BR>\n";
			} elseif ($row[9] == "2") {
				$tmp .= "&nbsp;-&nbsp;";
				$tmp .= "[".lecho("wait state")."] ";
				$tmp .= "<A HREF=\"". $config->basehref.
					$config->adminfile.
					"?action=edit_news&amp;news_id=$row[0]\">$row[2]</A><BR>\n";
			} elseif($row[9] == "3" && $i <= 5) {
				$tmp .= "&nbsp;-&nbsp;";
				$tmp .= "[".lecho("deleted")."] ";
				$tmp .= "<A HREF=\"". $config->basehref.
					$config->adminfile.
					"?action=edit_news&amp;news_id=$row[0]\">$row[2]</A><BR>\n";
				$i++;
			}
		}

		$this->db->free();

		// Show poll to be moderated !
		$tmp .= $this->poll->poll_to_moderate();

		// Show webcam to be moderated
		$tmp .= $this->webcam->webcam_to_moderate();

		// Show tips to be moderated
		$tmp .= $this->tips->tips_to_moderate();
		
		return '<!-- ADMIN -->'.
			$this->html->sidebox("Administration",$tmp."<br>").
			'<!-- /ADMIN -->';
	}

	/*
	 * We print the news which is beeing moderated
	 */
	Function show_news($id) {
		global $config;

		// Just to return fast in case the user doesn't interest us.
		if (!$this->session->is_moderator) {
			return;
		}

		/* We build the SELECT command - Damned long ! :-) */
		$sqlc_q = "SELECT ".
			$config->tables['news'].".id," .
			$config->tables['news'].".timestamp,".
			$config->tables['news'].".title,".
			$config->tables['news'].".departement,".
			$config->tables['news_body'].".body,".
			$config->tables['topics'].".topic,".
			$config->tables['sections']. ".section,".
			$config->tables['author'].".name,".
			$config->tables['author'].".contact,".
			$config->tables['news'].".ip,".
			$config->tables['news'].".main_page,".
			$config->tables['author'].".id,".
			$config->tables['news_body'].".content_type,".
			$config->tables['news'].".state FROM ".
			$config->tables['news'].",".
			$config->tables['news_body'].",".
			$config->tables['topics'].",".
			$config->tables['sections'].",".
			$config->tables['author']." "."WHERE ".
			$config->tables['news'].".id=".
			$config->tables['news_body'].".id AND ".
			$config->tables['news'].".author_id=".
			$config->tables['author'].".id AND ".
			$config->tables['news'].".topic_id=".
			$config->tables['topics'].".id AND ".
			$config->tables['news'].".section_id=".
			$config->tables['sections'].".id AND ".
			$config->tables['news'].".id=".addslashes($id).
			" ORDER BY ".
			$config->tables['news'].".timestamp DESC LIMIT 1";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			return -1;
		}

		$row = $this->db->fetch_array();
		$this->db->free();

		$out .= "<form method=\"post\" action=\"".$config->basehref.
		  "admin/mod.".$config->php."\">\n";

		$out .= "<input type=\"hidden\" name=\"table[id]\" value=\"".
		  htmlentities($row[0])."\">\n";

		$out .= "<input type=\"text\" name=\"table[author]\" value=\"".
		  htmlentities($row[7])."\" size=\"50\" maxlength=\"100\">".
		  "<br>\n";
		$out .= "<input type=\"hidden\" name=\"table[author_id]\" value=\"".
		  htmlentities($row[11])."\">\n";

		$out .= "<input type=\"text\" name=\"table[contact]\" value=\"".
		  htmlentities($row[8])."\" size=\"50\" maxlength=\"100\">".
		  "<br>\n";
		$out .= "<input type=\"text\" name=\"table[title]\" value=\"".
		  htmlentities($row[2])."\" size=\"50\" maxlength=\"150\">".
		  "<br>\n";

		$out .= "<select name=\"table[topic_id]\">\n";

		$sqlc_q = "SELECT id,topic FROM ".$config->tables['topics'] .
		  " ORDER BY topic";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			return -1;
		}
		while($topics_tmp = $this->db->fetch_array()) {
			if ($row[5] == $topics_tmp[1]) {
				$out .= "<option value=\"$topics_tmp[0]\" selected>".
				  "$topics_tmp[1]\n";
			} else {
				$out .= "<option value=\"$topics_tmp[0]\">$topics_tmp[1]\n";
			}
		}
		$this->db->free();

		$out .= "</select>\n";

		$out .= "<select name=\"table[section_id]\">\n";

		$sqlc_q = "SELECT id,section FROM ".$config->tables['sections'] .
			" ORDER BY section";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			return -1;
		}
		while($sections_tmp = $this->db->fetch_array()) {
			if ($row[6] == $sections_tmp[1]) {
				$out .= "<option value=\"$sections_tmp[0]\" selected>".
					"$sections_tmp[1]\n";
			} else {
				$out .= "<option value=\"$sections_tmp[0]\">$sections_tmp[1]\n";
			}
		}
		$this->db->free();

		$out .= "</select>\n";

		$out .= "<input type=\"text\" name=\"table[departement]\" value=\"".
			htmlentities($row[3])."\" size=\"30\" maxlength=\"100\"><br>\n";

		$out .= "<input type=\"text\" name=\"table[timestamp]\" value=\"".
			htmlentities($row[1])."\" size=\"14\">\n&nbsp;";
		// We keep the old timestamp and old state just in case ...
		$out .= "<input type=\"hidden\" name=\"table[old_timestamp]\" value=\"".
			htmlentities($row[1])."\">\n";
		$out .= "<input type=\"hidden\" name=\"table[old_state]\" value=\"".
			htmlentities($row[13])."\">\n";
		
		$out .= "Change for now: <input type=\"checkbox\" name=\"table[timeon]\" ";

		if ($row[13] == 1) {
			$out .= ">&nbsp; ";
		} else {
			$out .= "CHECKED>&nbsp; ";
		}
		
		

		$out .= ($row[12]=="text/plain") ?
			"<select name=\"table[content_type]\">".
			"<option value=\"text/plain\" selected>texte".
			"<option value=\"text/html\">html".
			"</select><br>\n" :
			"<select name=\"table[content_type]\">".
			"<option value=\"text/html\" selected>html".
			"<option value=\"text/plain\">texte".
			"</select><br>\n";

		$out .= '<textarea name="table[body]" wrap="virtual" rows="10" cols="70">'.
		  htmlentities($row[4])."</textarea><br>\n";

		/*
		 * For Links
		 */
		$sqlc_q = "SELECT id,lang FROM ".$config->tables['lang'] ." ORDER BY lang";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			return -1;
		}
		while($lang_tmp = $this->db->fetch_array()) {
			$lang_id = $lang_tmp[0];
			$lang_lan   = $lang_tmp[1];
			$lan[$lang_id] = $lang_lan;
		}
		$this->db->free();

		$links = array();

		$links = $this->news->get_urls($row[0]);
		$row['links'] = $links;

		$out .= "<table>\n";
		for ($k=0;$k<$config->numberoflinks;$k++) {

			$out .= "<tr><td><input type=\"text\" name=\"table[nom$k]\" size=\"20\" ";
			if (!empty($links[($k+1)]['name'])) {
				$out .= "value=\"".$links[($k+1)]['name']."\"";
			}
			$out .= "></td>";
			$out .= "<td><input type=\"text\" name=\"table[url$k]\" size=\"50\"";
			if (!empty($links[($k+1)]['url'])) {
				$out .= "value=\"".$links[($k+1)]['url']."\"";
			}
			$out .= "></td><td>";

			$out .= "<select name=\"table[lang$k]\">";
			$out .= '<option value="no">'.lecho("Language")."\n";
			reset($lan);
			while (current($lan)) {
				if (!empty($links[($k+1)]['lang']) && $links[($k+1)]['lang'] == current($lan)) {
					$out .= '<option value="'. key($lan) .'" selected>'.
						current($lan)."\n";
				} else {
					$out .= '<option value="'. key($lan) .'">'.
						current($lan)."\n";
				}
				next($lan);
			}

			$out .= "</select>";

			$out .= "<input type=\"hidden\" name=\"table[newsurlid$k]\" ".
				"value=\"".$links[($k+1)]['id']."\">\n";
			$out .= "<input type=\"hidden\" name=\"table[urlsid$k]\" ".
				"value=\"".$links[($k+1)]['urls_id']."\">\n";

			$out .= "</td></tr>\n";
		}
		$out .= "</table>\n";
		/*
		 * Finished links !
		 */

		$out .= lecho("action") . ": <select name=\"table[action]\">\n";
		$out .= '<option value="1">'. lecho("ok")."\n";
		$out .= '<option value="2">'. lecho("wait")."\n";
		$out .= '<option value="3">'. lecho("del")."\n";
		$out .= "</select>\n";

		$out .= lecho("Put on homepage:")." <input type=\"checkbox\" name=\"table[main_page]\" value=\"1\"";
		if ($row[10] == 1 || $row[13] == 0) {
			$out .= "checked>&nbsp;";
		} else {
			$out .= ">&nbsp;";
		}

		$out .= "<input type=\"submit\" value=\"". lecho("send") ."\">\n";

		$out .= "</form>\n";

		$out .= "<br><br>\n";

		$out .= $this->html->newsbox($row);

		return $out;
	}

	/*
	 * We do moderate the news
	 */
	Function mod_news($row) {
		global $config;

		if (!$this->session->is_moderator) {
			return lecho("Trying to play with your life? ").
				lecho("If not contact webmaster!")."<br>\n";
		}

		//  Erase main index file
		if (!empty($config->htmldir)) {
			$this->cache->delete_htmlfiles('section',0,0,0,'.');
			$this->cache->delete_htmlfiles('topic',0,0,0,'.');
			$this->cache->delete_htmlfiles('.',0,0,0,'^index');
		}
		//  ... and archive boxes
		if (!empty($config->cachedir)) {
			$this->cache->delete_boxfiles('news_show_archive',0,0,0, '^#');
		}

		// We ignore STOP from user ...
		ignore_user_abort(true);

		/*
		 * We check if the news has been modified by someone else
		 */
		$sqlc_q = "SELECT title FROM ".$config->tables['news']." WHERE ".
		  "timestamp='".addslashes($row['old_timestamp'])."'".
		  " AND state='".addslashes($row['old_state'])."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}
		if ($this->db->num_rows() == 0) {
			$tmp .= "<span class=\"newstext\">".
			  lecho("News has been modified by someone else while you were editing it!<br>").
			  lecho("Please go back, reload, and try again.<br>")."</span>\n";
			return $tmp;
		}
		/**************** OK ******************/

		// We do get the main_page function
		$row['main_page']     = $row['main_page'] || 0;


		$tmp = "<span class=\"newstext\">".lecho("Modifying:")."<br>\n-&nbsp;".
		  lecho("news table...");

		$sqlc_q = "UPDATE ".$config->tables['news']." SET ".
			"topic_id='".addslashes($row['topic_id'])."',".
			"section_id='".addslashes($row['section_id'])."',";
		if  ($row['timeon'] != "on") {
			$sqlc_q .= "timestamp='".addslashes($row['timestamp'])."',";
		}
		$sqlc_q .= "title='".addslashes($row['title'])."',".
			"departement='".addslashes($row['departement'])."',".
			"state='".addslashes($row['action'])."',".
			"main_page='".addslashes($row['main_page'])."'".
			" WHERE id='".addslashes($row['id'])."'";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}
		$tmp .= lecho(" done!")."<br>\n";

		$tmp .= "-&nbsp;".lecho("body table...");

		$sqlc_q = "UPDATE ".$config->tables['news_body'].
			" SET body='".addslashes($row['body'])."',".
			"content_type='".addslashes($row['content_type'])."'".
			" WHERE id='".addslashes($row['id'])."'";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}
		$tmp .= lecho(" done!")."<br>\n";

		$tmp .= "-&nbsp;".lecho("Author table...");

		$sqlc_q = "UPDATE ".$config->tables['author']." SET ".
			"name='".addslashes($row['author'])."',".
			"contact='".addslashes($row['contact'])."'".
			" WHERE id='".addslashes($row['author_id'])."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}
		$tmp .= lecho(" done!")."<br>\n";

		$tmp .= "-&nbsp;".lecho("URL table...");
		for ($k=0;$k<$config->numberoflinks;$k++) {
			$nomk = "nom$k";
			$urlk = "url$k";
			$urlsidk = "urlsid$k";
			$newsurlidk = "newsurlid$k";
			$lank = "lang$k";

			if ($row[$lank] == 'no') continue;
			if (empty($row[$nomk]) && !empty($row[$newsurlidk])) {
				$sqlc_q = "DELETE FROM ".$config->tables['news_urls'].
					" WHERE id='".addslashes($row[$newsurlidk])."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					$tmp .= lecho("SQL Failed: ").$this->db->error();
					return $tmp;
				}
				continue;
			} elseif(!empty($row[$nomk]) && empty($row[$newsurlidk])) {
				$sqlc_q = "SELECT id FROM ".$config->tables['urls'].
					" WHERE url='".addslashes($row[$urlk])."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					$tmp .= lecho("SQL Failed: ").$this->db->error();
					return $tmp;
				}
				$tempo = $this->db->fetch_array();
				if (empty($tempo[0])) {
					$sqlc_q = "INSERT INTO ".$config->tables['urls'].
						" (url) VALUES ('".addslashes($row[$urlk])."')";
					$ret = $this->db->query($sqlc_q);
					if (!$ret) {
						$tmp .= lecho("SQL Failed: ").$this->db->error();
						return $tmp;
					}
					$tempourlid = $this->db->last_insert_id();
				} else {
					$tempourlid = $tempo[0];
				}

				$sqlc_q = "INSERT INTO ".$config->tables['news_urls'].
					" (news_id,lang_id,urls_id,name) VALUES ('".
					addslashes($row['id'])."','".
					addslashes($row[$lank])."','".
					addslashes($tempourlid)."','".
					addslashes($row[$nomk])."')";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					$tmp .= lecho("SQL Failed: ").$this->db->error();
					return $tmp;
				}
				$tempourlid = $this->db->last_insert_id();

				$sqlc_q = "INSERT INTO ".$config->tables['urls_hits'].
					" (news_urls_id,hits) VALUES ('".
					addslashes($tempourlid)."','0')";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					$tmp .= lecho("SQL Failed: ").$this->db->error();
					return $tmp;
				}
				continue;
			}

			//   urls must be unique, as defined in SQL tables
			$sqlc_q = "SELECT id FROM ".$config->tables['urls'].
				" WHERE url='".addslashes($row[$urlk])."' AND ".
				"id<>'".addslashes($urlsidk)."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$tmp .= lecho("SQL Failed: ").$this->db->error();
				return $tmp;
			}

			$tempourlid = $row[$urlsidk];
			if ($this->db->num_rows() > 0) {
				$dup = $this->db->fetch_array();
				if ($dup[0] != $row[$urlsidk]) {
					//   Duplicate entry
					$row[$urlsidk] = $dup[0];
					$sqlc_q = "DELETE FROM ".$config->tables['urls'].
						" WHERE id='".addslashes($tempourlid)."'";
					$ret = $this->db->query($sqlc_q);
					if (!$ret) {
						$tmp .= lecho("SQL Failed: ").$this->db->error();
						return $tmp;
					}
					$sqlc_q = "UPDATE ".$config->tables['news_urls'].
						" SET urls_id='".addslashes($row[$urlsidk])."'".
						" WHERE urls_id='".addslashes($tempourlid)."'";
					$ret = $this->db->query($sqlc_q);
					if (!$ret) {
						$tmp .= lecho("SQL Failed: ").$this->db->error();
						return $tmp;
					}
				}
			}
			if ($tempourlid == $row[$urlsidk]) {
				$sqlc_q = "UPDATE ".$config->tables['urls']." SET url='".
					addslashes($row[$urlk])."' WHERE id='".
					addslashes($row[$urlsidk])."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					$tmp .= lecho("SQL Failed: ").$this->db->error();
					return $tmp;
				}
			}
			$sqlc_q = "UPDATE ".$config->tables['news_urls']." SET ".
				"lang_id='".addslashes($row[$lank])."',".
				"name='".addslashes($row[$nomk])."' WHERE ".
				"id='".addslashes($row[$newsurlidk])."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$tmp .= lecho("SQL Failed: ").$this->db->error();
				return $tmp;
			}
		}
		$tmp .= lecho(" done!")."<br><br>\n";

		$tmp .= "-&nbsp;".lecho("Adding entry in moderated table...");

		$sqlc_q = "SELECT state FROM ".$config->tables['news_moderated'].
			" WHERE news_id='".addslashes($row['id'])."' AND ".
			"user_id='".addslashes($this->session->user_id)."'";
		$ret = $this->db->query($sqlc_q);
		if ($this->db->num_rows() == 0) {
			$sqlc_q = "INSERT INTO ".$config->tables['news_moderated'].
				" (news_id,user_id,state) VALUES ('".
				addslashes($row['id'])."','".
				addslashes($this->session->user_id)."','".
				addslashes($row['action'])."')";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$tmp .= lecho("SQL Failed: ").$this->db->error();
				return $tmp;
			}
		} else {
			$sqlc_q = "UPDATE ".$config->tables['news_moderated'].
				" SET state='".addslashes($row['action'])."' WHERE ".
				"news_id='".addslashes($row['id'])."' AND ".
				"user_id='".addslashes($this->session->user_id)."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$tmp .= lecho("SQL Failed: ").$this->db->error();
				return $tmp;
			}
		}

		$tmp .= lecho(" done!")."<br></span>\n";

		return $tmp;
	}

	/*
	 * Function for sysadmin to show list of present users
	 */
	Function show_users() {
		global $config;

		if (!$this->session->is_admin) {
			return lecho("Trying to play with your life? ").
				lecho("If not contact webmaster!")."<br>\n";
		}

		$tmp = "";
		$sqlc_q = "SELECT id,lname,fname,login,email,level FROM ".
			$config->tables['users']." ORDER BY created DESC";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}

		$tmp .= "<table width=\"100%\" border=\"1\">";

		$tmp .= "<tr><td class=\"newstext\">m</td><td class=\"newstext\">s</td>".
			"<td class=\"newstext\">score</td>".
			"<td class=\"newstext\">id</td>".
			"<td class=\"newstext\">".lecho("Last Name")."</td>".
			"<td class=\"newstext\">".lecho("First Name")."</td>".
			"<td class=\"newstext\">".lecho("Login")."</td>".
			"<td class=\"newstext\">".lecho("E-Mail")."</td>".
			"</tr>";

		while($row=$this->db->fetch_array()) {

			$tmp .= "<tr>";

			if ($row[5] & pow(2,21)) {
				$tmp .= "<td><b>x</b></td>";
			} else {
				$tmp .= "<td>&nbsp;</td>";
			}

			if ($row[5] & pow(2,22)) {
				$tmp .= "<td><b>x</b></td>";
			} else {
				$tmp .= "<td>&nbsp;</td>";
			}

			if ($row[5] & pow(2,23)) {
				$tmp .= "<td><b>x</b></td>";
			} else {
				$tmp .= "<td>&nbsp;</td>";
			}

			$tmp .= "<td class=\"newstext\">&nbsp;<a href=\"".
				$config->basehref.$config->adminfile.
				"?action=edit_users&amp;user_id=$row[0]\">".
				htmlentities($row[0])."</a></td>".
				"<td class=\"newstext\">".htmlentities($row[1])."</td>".
				"<td class=\"newstext\">&nbsp;".htmlentities($row[2])."</td>".
				"<td class=\"newstext\">&nbsp;".htmlentities($row[3])."</td>".
				"<td class=\"newstext\">&nbsp;".htmlentities($row[4])."</td></tr>\n";
		}
		$tmp .= "</table>";

		return $this->html->simplebox($tmp);
	}

	/*
	 * Function for sysadmin to show form to modify a user
	 */
	Function show_edit_user($id) {
		global $config;

		if (!$this->session->is_admin) {
			return lecho("Trying to play with your life? ").
				lecho("If not contact webmaster!")."<br>\n";
		}

		$tmp = "";
		$sqlc_q = "SELECT id,lname,fname,login,email,fake_email,homesite,theme,level,score,param FROM ".
			$config->tables['users']." WHERE id='".addslashes($id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}
		$row=$this->db->fetch_array();

		$tmp .= "<form method=\"post\" action=\"".$config->basehref."admin/modusers.".$config->php."\">\n";
		$tmp .= "<table width=\"100%\" border=\"0\">";

		$tmp .= "<tr><td class=\"sboxtext\">id</td><td>".htmlentities($row[0])."".
			"</td></tr>\n";
		$tmp .= "<tr><td class=\"sboxtext\">".lecho("Login")."</td><td><input type=\"text\" size=\"30\" ".
			"name=\"table[login]\" value=\"".htmlentities($row[3])."\">".
			"</td></tr>\n";
		$tmp .= "<tr><td class=\"sboxtext\">".lecho("Last Name")."</td><td><input type=\"text\" size=\"30\" ".
			"name=\"table[lname]\" value=\"".htmlentities($row[1])."\">".
			"</td></tr>\n";
		$tmp .= "<tr><td class=\"sboxtext\">".lecho("First Name")."</td><td><input type=\"text\" size=\"30\" ".
			"name=\"table[fname]\" value=\"".htmlentities($row[2])."\">".
			"</td></tr>\n";
		$tmp .= "<tr><td class=\"sboxtext\">".lecho("E-Mail")."</td><td><input type=\"text\" size=\"30\" ".
			"name=\"table[email]\" value=\"".htmlentities($row[4])."\">".
			"</td></tr>\n";
		$tmp .= "<tr><td class=\"sboxtext\">".lecho("Fake E-Mail")."</td><td><input type=\"text\" size=\"30\" ".
			"name=\"table[fake_email]\" value=\"".htmlentities($row[5])."\">".
			"</td></tr>\n";
		$tmp .= "<tr><td class=\"sboxtext\">".lecho("Homesite")."</td><td><input type=\"text\" size=\"30\" ".
			"name=\"table[homesite]\" value=\"".htmlentities($row[6])."\">".
			"</td></tr>\n";
		$tmp .= "<tr><td class=\"sboxtext\">theme</td><td><select name=\"table[theme]\">\n";
		reset ($config->listofthemes);
		while (list($i, $theme) = each ($config->listofthemes)) {
			$tmp .= '<option value="'.$i.'"';
			if ($i == $row[7]) {
				$tmp .= " selected";
			}
			$tmp .= ">".$theme."</option>\n";
		}
		$tmp .= "</select></td></tr>\n";

		$tmp .= "<tr><td class=\"sboxtext\">".lecho("score")."</td><td><select name=\"table[score]\">\n";
		for ($i=-1;$i<=5;$i++) {
			$tmp .= '<option value="'.$i.'"'.
				($i == $row[9] ? ' selected' : '').
				">".$i."</option>\n";
		}
		$tmp .= "</select></td></tr>\n";

		$hide_sig = ($row[10] & pow(2,2) ? 1 : 0);
		$tmp .= "<tr><td class=\"newstext\">".lecho("Hide signatures")."</td><td><select name=\"table[hide_sig]\">\n".
			"<option value=\"0\"".($hide_sig==0 ? ' selected' : '').
			">".lecho("No")."</option>\n".
			"<option value=\"1\"".($hide_sig==1 ? ' selected' : '').
			">".lecho("Yes")."</option>\n".
			"</select></td></tr>\n";

		$identity = ($row[10] & pow(2,0) ? 1 : 0);
		$tmp .= "<tr><td class=\"newstext\">".lecho("Display")."</td><td><select name=\"table[identity]\">\n".
			"<option value=\"1\"".($identity ? ' selected' : '').
			">".lecho("First Name")." ".lecho("Last Name")."</option>\n".
			"<option value=\"0\"".($identity ? '' : ' selected').
			">".lecho("Login")."</option>\n".
			"</select></td></tr>\n";

		$skip_referer = ($row[10] & pow(2,3) ? 1 : 0);
		$tmp .= "<tr><td class=\"newstext\">".lecho("Skip referer")."</td><td><select name=\"table[skip_referer]\">\n".
			"<option value=\"0\"".($skip_referer==0 ? ' selected' : '').
			">".lecho("No")."</option>\n".
			"<option value=\"1\"".($skip_referer==1 ? ' selected' : '').
			">".lecho("Yes")."</option>\n".
			"</select></td></tr>\n";

		$tmp .= "<tr><td class=\"newstext\">".lecho("moderator")."</td><td><input type=\"checkbox\" ".
			"name=\"table[moderator]\"";
		if ($row[8] & pow(2,21)) {
			$tmp .= "checked>";
		} else {
			$tmp .= ">";
		}
		$tmp .= "</td></tr>\n";

		$tmp .= "<tr><td class=\"newstext\">".lecho("sysadmin")."</td><td><input type=\"checkbox\" ".
			"name=\"table[sysadmin]\"";
		if ($row[8] & pow(2,22)) {
			$tmp .= "checked>";
		} else {
			$tmp .= ">";
		}
		$tmp .= "</td></tr>\n";

		$tmp .= "<tr><td class=\"newstext\">".lecho("scoror")."</td><td><input type=\"checkbox\" ".
			"name=\"table[scoror]\"";
		if ($row[8] & pow(2,23)) {
			$tmp .= "checked>";
		} else {
			$tmp .= ">";
		}
		$tmp .= "</td></tr>\n";

		$tmp .= "<tr><td colspan=\"2\" align=\"center\"><input type=\"submit\" value=\"". lecho("send") ."\"></td></tr>\n";
		$tmp .= "<input type=\"hidden\" name=\"table[id]\" value=\"".htmlspecialchars($row[0])."\">\n";
		$tmp .= "<input type=\"hidden\" name=\"table[level]\" value=\"".htmlspecialchars($row[8])."\">\n";
		$tmp .= "<input type=\"hidden\" name=\"table[param]\" value=\"".htmlspecialchars($row[10])."\">\n";

		$tmp .= "</table></form>";

		return $this->html->simplebox($tmp);
	}

	/*
	 * Function to modify user parameters by sysadmin
	 */
	Function mod_user($row) {
		global $config;

		if (!$this->session->is_admin) {
			return lecho("Trying to play with your life? ").
				lecho("If not contact webmaster!")."<br>\n";
		}

		$hide_sig = $row['hide_sig'];
		$identity = $row['identity'];
		$skip_referer = $row['skip_referer'];
		$newlevel = $row['level'];
		if ($row['sysadmin'] == "on") {
			$newlevel = $newlevel | pow(2,22);
		} else {
			$newlevel = $newlevel & ~ pow(2,22);
		}
		if ($row['moderator'] == "on") {
			$newlevel = $newlevel | pow(2,21);
		} else {
			$newlevel = $newlevel & ~ pow(2,21);
		}
		if ($row['scoror'] == "on") {
			$newlevel = $newlevel | pow(2,23);
		} else {
			$newlevel = $newlevel & ~ pow(2,23);
		}
		$row['param'] = $param | ($identity ? pow(2,0) : 0);
		$row['param'] = $param | ($hide_sig ? pow(2,2) : 0);
		$row['param'] = $param | ($skip_referer ? pow(2,3) : 0);

		$sqlc_q = "UPDATE ".$config->tables['users']." SET ".
			"lname='".addslashes($row['lname'])."',".
			"fname='".addslashes($row['fname'])."',".
			"login='".addslashes($row['login'])."',".
			"email='".addslashes($row['email'])."',".
			"fake_email='".addslashes($row['fake_email'])."',".
			"theme='".addslashes($row['theme'])."',".
			"param='".addslashes($row['param'])."',".
			"score='".addslashes($row['score'])."',".
			"level='".addslashes($newlevel)."'".
			" WHERE id='".addslashes($row['id'])."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$sqlc_q.$this->db->error();
			echo $tmp;
		}
	}

	/*
	 * Function to show topics for admin
	 */
	Function show_topics() {
		global $config;

		if (!$this->session->is_admin) {
			return lecho("Trying to play with your life? ").
				lecho("If not contact webmaster!")."<br>\n";
		}

		$tmp = "";
		$sqlc_q = "SELECT id,topic,state FROM ".$config->tables['topics'].
			" ORDER BY topic,id";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}
		$tmp .= "<table><tr>";
		$i= (int) 0;
		while($row=$this->db->fetch_array()) {
			if ($i>=5) {
				$tmp .= "</tr><tr>";
			}
			$tmp .= "<td class=\"newstext\">";

			$tempo_link = "<img src=\"".$this->session->imgurl("section/".$row[1])."\" alt=\"\">";

			$tmp .= "<table><tr><td class=\"newstext\"><center>".
				$this->redirect->make($tempo_link,
									$config->basehref.$config->newsfile,"topic=".
									urlencode($row[1])).
				"</center></td></tr><tr><td class=\"newstext\"><center>";

			if ($row[2] == 0) {
				$tempo_link = "<font color=\"red\">".htmlentities($row[1])."</font>\n";
			} else {
				$tempo_link = htmlentities($row[1]);
			}

			$tmp .= "<a href=\"".$config->basehref.$config->adminfile."?action=edit_topics&amp;topic_id=".
				urlencode($row[0])."\">$tempo_link</a>";

			$tmp .= "</center></td></tr>".
				"</table>";
			$tmp .= "</td>\n";

			if ($i>=5) {
				$i=0;
			}
			$i++;
		}
		$tmp .= "</tr></table>\n";
		$this->db->free();

		return $this->html->simplebox($tmp);
	}

	/* 
	 * Show modify topic
	 */
	Function show_edit_topic($id) {
		global $config;

		if (!$this->session->is_admin) {
			return lecho("Trying to play with your life? ").
				lecho("If not contact webmaster!")."<br>\n";
		}

		$tmp = "";
		$sqlc_q = "SELECT id,topic,state,longname FROM ".$config->tables['topics'].
			" WHERE id='".addslashes($id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}
		$row=$this->db->fetch_array();
		$tmp .= "<form method=\"post\" action=\"".$config->basehref.
			"admin/topics_edit.".$config->php."\">\n";
		$tmp .= "<table cellpadding=\"3\" cellspacing=\"3\">\n";
		$tmp .= "<tr><td class=\"newstext\">".lecho("Short name (of picture)")."</td>".
			"<td class=\"newstext\">\n";
		$tmp .= "<input type=\"text\" name=\"table[topic]\" value=\"".
			$row[1]."\"></td></tr>\n";
		$tmp .= "<tr><td class=\"newstext\">".lecho("Long name")."</td><td ".
			"class=\"newstext\">\n";
		$tmp .= "<input type=\"text\" name=\"table[longname]\" value=\"".
			$row[3]."\"></td></tr>\n";
		$tmp .= "<tr><td class=\"newstext\">".lecho("State")."</td><td class=\"newstext\">\n";
		$tmp .= "<input type=\"checkbox\" name=\"table[state]\" ";
		$tmp .= ($row[2] == 1) ?
			"checked></td></tr>\n":
			"></td></tr>\n";
		$tmp .= "<tr><td>&nbsp;</td></tr>\n";
		$tmp .= "<tr><td colspan=\"2\" class=\"newstext\"><center><input ".
			"type=\"submit\" name=\"table[submit]\" value=\"".
			lecho("Submit")."\"></center></td></tr></table>\n";
		$tmp .= "<input type=\"hidden\" name=\"table[id]\" value=\"$row[0]\">\n";

		$tmp .= "</form>\n";

		return $this->html->simplebox($tmp);
	}

	/*
	 * Do edit topic
	 */
	Function do_edit_topic($row) {
		global $config;

		if (!$this->session->is_admin) {
			return lecho("Trying to play with your life? ").
				lecho("If not contact webmaster!")."<br>\n";
		}

		$row['state'] = ($row['state'] == "on") ?  1 : 0 ;
		$sqlc_q = "UPDATE ".$config->tables['topics']." SET ".
			"topic='".addslashes($row['topic'])."',".
			"longname='".addslashes($row['longname'])."',".
			"state='".addslashes($row['state'])."'".
			" WHERE id='".addslashes($row['id'])."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			return 0;
		}
		return 1;
	}

	/*
	 * Show form to add topic
	 */
	Function show_add_topic() {
		global $config;

		$tmp = "<table><tr><td><form method=\"post\" action=\"".
			$config->basehref."admin/topics_add.".$config->php."\">\n".
			"<table cellpadding=\"3\" cellspacing=\"3\">\n".
			"<tr><td class=\"newstext\">".lecho("Short name (of picture)")."</td>".
			"<td class=\"newstext\">\n".
			"<input type=\"text\" name=\"table[topic]\"></td></tr>\n".
			"<tr><td class=\"newstext\">".lecho("Long name")."</td><td ".
			"class=\"newstext\">\n".
			"<input type=\"text\" name=\"table[longname]\"></td></tr>\n".
			"<tr><td class=\"newstext\">".lecho("State")."</td><td class=\"newstext\">\n".
			"<input type=\"checkbox\" name=\"table[state]\" checked></td>".
			"</tr><tr><td>&nbsp;</td></tr>\n".
			"<tr><td colspan=\"2\" class=\"newstext\"><center><input ".
			"type=\"submit\" name=\"table[submit]\" value=\"".
			"submit!\"></center></td></tr></table>\n".
			"</form></td>\n";
		$tmp .= "<td valign=\"top\" class=\"newstext\">".
			lecho("Add your png file in images/section/ then ").
			lecho("put the same name as short name and activate or not the topic.").
			"</td></tr></table>\n";

		return $this->html->simplebox($tmp);
	}

	/*
	 * Do add topic
	 */
	Function do_add_topic($row) {
		global $config;

		if (!$this->session->is_admin) {
			return lecho("Trying to play with your life? ").
				lecho("If not contact webmaster!")."<br>\n";
		}

		$row['state'] = ($row['state'] == "on") ?  1 : 0 ;
		$sqlc_q = "INSERT INTO ".$config->tables['topics'].
			" (topic,longname,state) VALUES ('".
			addslashes($row['topic'])."','".
			addslashes($row['longname'])."','".
			addslashes($row['state'])."')";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			return 0;
		}
		return 1;
	}

	Function show_add_section() {
		global $config;
		$tmp = "<table><tr><td><form method=\"post\" action=\"".
			$config->basehref."admin/section_add.".$config->php."\">\n".
			"<table cellpadding=\"3\" cellspacing=\"3\">\n".
			"<td class=\"newstext\">".lecho("Name")."</td>\n".
			"<td class=\"newstext\">\n".
			"<input type=\"text\" name=\"table[section]\"></td></tr>\n".
			"<tr><td colspan=\"2\" class=\"newstext\"><center><input ".
			"type=\"submit\" name=\"table[submit]\" value=\"".
			lecho("Submit")."\"></center></td></tr></table>\n".
			"</form></td></table>\n";
		return $this->html->simplebox($tmp);
	}

	Function do_add_section($row) {
		global $config;
		if (!$this->session->is_admin) {
			return lecho("Trying to play with your life? ").
				lecho("If not contact webmaster!")."<br>\n";
		}

		$sqlc_q = "INSERT INTO ".$config->tables['sections'].
			" (section,state) VALUES ('".
			addslashes($row['section'])."', '1')";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			return 0;
		}
		return 1;
	}

	Function show_sections() {
		global $config;

		if (!$this->session->is_admin) {
			return lecho("Trying to play with your life? ").
				lecho("If not contact webmaster!")."<br>\n";
		}

		$tmp = "";
		$sqlc_q = "SELECT id,section,state FROM ".$config->tables['sections'].
			" ORDER BY section,id";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}
		$tmp .= "<table><tr>";
		$i= (int) 0;
		while($row=$this->db->fetch_array()) {
			if ($i>=5) {
				$tmp .= "</tr><tr>";
			}
			$tmp .= "<td class=\"newstext\">";

			$tempo_link = "<img src=\"".$this->session->imgurl("section/".$row[1])."\" alt=\"\">";

			$tmp .= "<table><tr><td class=\"newstext\"><center>";

			if ($row[2] == 0) {
				$tempo_link = "<font color=\"red\">".htmlentities($row[1])."</font>\n";
			} else {
				$tempo_link = htmlentities($row[1]);
			}

			$tmp .= "<a href=\"".$config->basehref.$config->adminfile."?action=edit_section&amp;section_id=".
				urlencode($row[0])."\">$tempo_link</a>";

			$tmp .= "</center></td></tr>".
				"</table>";
			$tmp .= "</td>\n";

			if ($i>=5) {
				$i=0;
			}
			$i++;
		}
		$tmp .= "</tr></table>\n";
		$this->db->free();

		return $this->html->simplebox($tmp);
	}

	Function show_edit_section($id) {
		global $config;

		if (!$this->session->is_admin) {
			return lecho("Trying to play with your life? ").
				lecho("If not contact webmaster!")."<br>\n";
		}

		$tmp = "";
		$sqlc_q = "SELECT id,section,state FROM ".$config->tables['sections'].
			" WHERE id='".addslashes($id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}
		$row=$this->db->fetch_array();
		$tmp .= "<form method=\"post\" action=\"".$config->basehref.
			"admin/section_edit.".$config->php."\">\n";
		$tmp .= "<table cellpadding=\"3\" cellspacing=\"3\">\n";
		$tmp .= "<tr><td class=\"newstext\">".lecho("Name")."</td><td ".
			"class=\"newstext\">\n";
		$tmp .= "<input type=\"text\" name=\"table[section]\" value=\"".
			$row[1]."\"></td></tr>\n";
		$tmp .= "<tr><td class=\"newstext\">".lecho("State")."</td><td class=\"newstext\">\n";
		$tmp .= "<input type=\"checkbox\" name=\"table[state]\" ";
		$tmp .= ($row[2] == 1) ?
			"checked></td></tr>\n":
			"></td></tr>\n";
		$tmp .= "<tr><td>&nbsp;</td></tr>\n";
		$tmp .= "<tr><td colspan=\"2\" class=\"newstext\"><center><input ".
			"type=\"submit\" name=\"table[submit]\" value=\"".
			lecho("Submit")."\"></center></td></tr></table>\n";
		$tmp .= "<input type=\"hidden\" name=\"table[id]\" value=\"$row[0]\">\n";

		$tmp .= "</form>\n";

		return $this->html->simplebox($tmp);
	}

	/*
	 * Do edit section
	 */
	Function do_edit_section($row) {
		global $config;

		if (!$this->session->is_admin) {
			return lecho("Trying to play with your life? ").
				lecho("If not contact webmaster!")."<br>\n";
		}

		$row['state']   = ($row['state'] == "on") ?  1 : 0 ;
		$sqlc_q = "UPDATE ".$config->tables['sections']." SET ".
			"section='".addslashes($row['section'])."',".
			"state='".addslashes($row['state'])."' WHERE ".
			"id='".addslashes($row['id'])."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			return 0;
		}
		return 1;
	}

	Function show_add_tip_section() {
		global $config;
		if (!$this->session->is_admin) {
			return lecho("Trying to play with your life? ").
			  lecho("If not contact webmaster!")."<br>\n";
		}

		$out = "<select name=\"table[tip_section_id]\">\n";
		$sqlc_q = "SELECT id,tip_section FROM ".$config->tables['tips_sections'] .
		  " ORDER BY tip_section";
		
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "Error...";
			return $this->db->error();
		}
		
		$out .= "<option value=\"0\" selected>\n";
		while ($sections_tmp=$this->db->fetch_array()) {
			$out .= "<option value=\"$sections_tmp[0]\">$sections_tmp[1]\n";
		}
		$this->db->free();
		
		$out .= "</select>\n";

		$tmp = "<table><tr><td><form method=\"post\" action=\"".
		  $config->basehref."admin/tip_section_add.".$config->php."\">\n".
		  "<table cellpadding=\"3\" cellspacing=\"3\">\n".
		  "<td class=\"newstext\">".lecho("Section")."</td>\n".
		  "<td class=\"newstext\">".$out."</td>\n".
		  "</tr><tr>\n".
		  "<td class=\"newstext\">".lecho("Name")."</td>\n".
		  "<td class=\"newstext\">\n".
		  "<input type=\"text\" name=\"table[tip_section]\"></td></tr>\n".
		  "<tr><td colspan=\"2\" class=\"newstext\"><center><input ".
		  "type=\"submit\" name=\"table[submit]\" value=\"".
		  lecho("Submit")."\"></center></td></tr></table>\n".
		  "</form></td></table>\n";

		return $this->html->simplebox($tmp);
	}

	Function do_add_tip_section($row) {
		global $config;
		if (!$this->session->checked || !$this->session->level&pow(2,22)) {
			return lecho("Trying to play with your life? ").
			  lecho("If not contact webmaster!")."<br>\n";
		}

		$sqlc_q = "INSERT INTO ".$config->tables['tips_sections'].
		  " (tip_section_referer_id,tip_section,state) VALUES ('".
		  addslashes($row['tip_section_id'])."','".
		  addslashes($row['tip_section'])."', '1')";
		
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error().$sqlc_q;
			return 0;
		}
		return 1;
	}

	Function clear_cache () {
		if (!$this->session->is_admin) {
			return lecho("Trying to play with your life? ").
				lecho("If not contact webmaster!")."<br>\n";
		}

		$this->cache->delete_files('.',1,1,0,1,'^[0-9]|index,','.');
		$this->cache->delete_files('section',1,1,1,1,'.','.');
		$this->cache->delete_files('topic',1,1,1,1,'.','.');
		$this->cache->delete_files('.',0,1,1,1,'^#','.');
	}

	Function perform_action ($action,$table) {
		global $HTTP_GET_VARS;

		if ($action == 'edit_news') {
			if (!$this->session->is_moderator) {
				echo lecho("you bad boy...");
				exit;
			}

			if (empty($HTTP_GET_VARS['news_id'])) {
				echo lecho("Error");
				exit;
			} else {
				return $this->show_news($HTTP_GET_VARS['news_id']);
			}
		} else if ($action == 'mod_news') {
			if (!$this->session->is_moderator) {
				echo lecho("you bad boy...");
				exit;
			}
			return $this->mod_news($table);
		} else if ($action == 'edit_users') {
			if (!$this->session->is_admin) {
				echo lecho("you bad boy...");
				exit;
			}
			if (empty($HTTP_GET_VARS['user_id'])) {
				return $this->show_users();
			} else {
				return $this->show_edit_user($HTTP_GET_VARS['user_id']);
			}
		} else if ($action == 'edit_topics') {
			if (!$this->session->is_admin) {
				echo lecho("you bad boy...");
				exit;
			}
			if (empty($HTTP_GET_VARS['topic_id'])) {
				return $this->show_topics();
			} else {
				return $this->show_edit_topic($HTTP_GET_VARS['topic_id']);
			}
		} else if ($action == 'add_topics') {
			if (!$this->session->is_admin) {
				echo lecho("you bad boy...");
				exit;
			}
			return $this->show_add_topic();
		} else if ($action == 'mod_poll') {
			if (!$this->session->is_admin) {
				echo lecho("you bad boy...");
				exit;
			}
			return $this->poll->edit_poll($table['id']);
		} else if ($action == 'edit_section') {
			if (!$this->session->is_admin) {
				echo lecho("you bad boy...");
				exit;
			}
			if (empty($HTTP_GET_VARS['section_id'])) {
				return $this->show_sections();
			} else {
				return $this->show_edit_section($HTTP_GET_VARS['section_id']);
			}
		} else if ($action == 'add_section') {
			if (!$this->session->is_admin) {
				echo lecho("you bad boy...");
				exit;
			}
			return $this->show_add_section();
		} else if ($action == 'add_tip_section') {
			if (!$this->session->is_moderator) {
				echo lecho("you bad boy...");
				exit;
			}
			return $this->show_add_tip_section();
		} else if ($action == 'list_polls') {
			if (!$this->session->is_admin) {
				echo lecho("you bad boy...");
				exit;
			}
			return $this->poll->list_polls();
		} else if ($action == 'clear_cache') {
			if (!$this->session->is_admin) {
				echo lecho("you bad boy...");
				exit;
			}
			return $this->clear_cache();
		} else if ($action == 'edit_theme') {
			if (!$this->session->is_admin) {
				echo lecho("you bad boy...");
				exit;
			}
			if (empty($HTTP_GET_VARS['theme'])) {
				return $this->show_themes();
			} else {
				return $this->create_theme_tar($HTTP_GET_VARS['theme']);
			}
		} else if ($action == 'view_theme') {
			if (!$this->session->is_admin) {
				echo lecho("you bad boy...");
				exit;
			}
			if (empty($HTTP_GET_VARS['theme'])) {
				return $this->show_themes();
			} else {
				return $this->extract_theme_tar($HTTP_GET_VARS['theme'],0);
			}
		} else if ($action == 'extract_theme') {
			if (!$this->session->is_admin) {
				echo lecho("you bad boy...");
				exit;
			}
			if (empty($HTTP_GET_VARS['theme'])) {
				return $this->show_themes();
			} else {
				return $this->extract_theme_tar($HTTP_GET_VARS['theme'],1);
			}
		} else if ($action == 'delete_theme') {
			if (!$this->session->is_admin) {
				echo lecho("you bad boy...");
				exit;
			}
			return $this->delete_theme_tar($HTTP_GET_VARS['theme']);
		} else {
			return lecho("Error");
			exit;
		}
	}

	Function comments_showscore($user_id_tmp,$comments_id_tmp) {
		global $config;

		if (!$this->session->is_scoror || 
			$this->session->user_id == $user_id_tmp) {
			return;
		}

		$tmp = "&nbsp; <B>[</B> ";

		for ($i=-1;$i<=5;$i++) {
			$tmp .= '<a href="'.$config->basehref.
				"comments/score.".$config->php."?news_id=$news_id&amp;id=$comments_id_tmp&amp;score=$i".
				"\" OnClick=\"window.open('".$config->basehref.
				"comments/score.".$config->php."?news_id=$news_id&amp;id=$comments_id_tmp&amp;score=$i','M',".
				"'toolbar=no,location=no,directories=no,status=no,".
				"alwaysRaised=yes,dependant=no,menubar=no,scrollbars=no,".
				"resizable=no,width=100,height=50'); return false\" ".
				"onMouseOut=\"window.status=''; return true;\" ".
				"onMouseOver=\"window.status='Scorer $i'; ".
				"return true;\">$i</A> ";
		}
		$tmp .= "<b>]</b>\n";

		return $tmp;
	}

	Function news_showedit($news_id) {
		global $config;
		$tmp = "";
		if ($this->session->is_moderator) {
			$tmp .= " - <b><a href=\"".$config->basehref.$config->adminfile.
				"?action=edit_news&amp;news_id=$news_id\">edit!</a></b>";
		}
		return $tmp;
	}

	Function webcam_showtitle($webcam_id) {
		global $config;
		$tmp = "";
		if ($this->session->is_moderator || $this->session->is_admin) {
			$tmp .= "Webcam ... - <a href=\"".$config->basehref.
				"webcam/".$config->webcamadminfile.
				"?webcam_id=".$webcam_id."\">".lecho("Edit!")."</a>\n";
		} else {
			$tmp .= lecho("Webcam...");
		}

		return $tmp;
	}

	Function tips_showtitle($tip_id) {
		global $config;
		$tmp = "";
		if ($this->session->checked &&
			($this->session->is_moderator || $this->session->is_admin)) {

			$tmp .= "<a href=\"".$config->basehref."tips/\">".lecho("Tip").
			  "</a> - <a href=\"".$config->basehref.
			  "tips/".$config->tipsadminfile.
			  "?tip_id=".$tip_id."\">".lecho("Edit!")."</a>\n";
		} else {
			$tmp .= "<a href=\"".$config->basehref."tips/\">".lecho("Tip")."</a>";
		}

		return $tmp;
	}

	Function list_installed_themes() {
		global $config;

		$themes = '';
		$handle=opendir($config->libdir.'themes');
		if (!$handle) {
			return $themes;
		}
		while ($file = readdir($handle)) {
			if ($file == '.' || $file == '..' || $file == 'CVS' ||
					$file.'/' == $config->theme_subdir) {
				continue;
			}
			if (is_dir($config->libdir.'themes/'.$file)) {
				$themes[] = $file;
			}
		}
		closedir($handle);
		if ($config->theme_subdir) {
			$handle=opendir($config->libdir.'themes/'.ereg_replace('/$', '', $config->theme_subdir));
			if (!$handle) {
				return $themes;
			}
			while ($file = readdir($handle)) {
				if ($file == '.' || $file == '..' || $file == 'CVS') {
					continue;
				}
				if (is_dir($config->libdir.'themes/'.$config->theme_subdir.$file)) {
					$themes[] = $file;
				}
			}
		}
		closedir($handle);
		return $themes;
	}

	Function list_uploaded_themes() {
		global $config;

		if (!$config->upload_tar_dir) {
			return;
		}
		$handle=opendir($config->upload_tar_dir);
		if (!$handle) {
			return;
		}
		$themes = '';
		while ($file = readdir($handle)) {
			if (ereg('(.*)-([0-9.]+)\.tar(\.gz)?$', $file, $regs)) {
				$themes[] = $regs[0];
			}
		}
		closedir($handle);
		return $themes;
	}

	Function show_themes() {
		global $config;

		$tmp = '';
		$themes = $this->list_installed_themes();
		if (is_array($themes)) {
			$tmp .= "<div class=\"bgtext\"><h2>".lecho("Create archive of existing theme")."</h2>\n";
			$tmp .= "<ul>\n";
			while ($theme = each($themes)) {
				$tmp .= "  <li><a href=\"".
					$config->basehref.$config->adminfile.
					"?action=edit_theme&amp;theme=".
					$theme[1]."\">".$theme[1]."</a></li>\n";
			}
			$tmp .= "</ul>";
		}

		$themes = $this->list_uploaded_themes();
		if (is_array($themes)) {
			$tmp .= "<h2>".lecho("Install new theme")."</h2>\n";
			$tmp .= "<ul>\n";
			while ($theme = each($themes)) {
				$tmp .= "  <li><a href=\"".
					$config->basehref.$config->adminfile.
					"?action=view_theme&amp;theme=".
					$theme[1]."\">".$theme[1]."</a></li>\n";
			}
			$tmp .= "</ul></div>";
		}
		return $tmp;
	}

	Function create_theme_tar($theme,$version="0.1") {
		global $config,$topdir,$libdir;

		//   Must be run by admin only for security reason
		if (!$this->session->is_admin) {
			echo lecho("you bad boy...");
			exit;
		}
		if (!$config->create_tar_dir) {
			return lecho('Variable $config->create_tar_dir is empty, function disabled');
		}
		if (is_dir($libdir."themes/".$theme)) {
			$theme_dir = "themes/".$theme;
		} elseif (is_dir($libdir."themes/".$config->theme_subdir.$theme)) {
			$theme_dir = "themes/".$config->theme_subdir.$theme;
		} else {
			return lecho("Theme not found -&gt; ").$theme;
		}

		if (!file_exists($libdir.$theme_dir."/VERSION")) {
			return lecho("Error: file not found -&gt; ").$libdir.$theme_dir."/VERSION <br>\n";
		}

		$text = file ($libdir.$theme_dir."/VERSION");
		//   Check for theme format.
		//   This is currently useless, but may be used later
		if (ereg('^[0-9]+$',$text[0])) {
			$theme_name = trim($text[1]);
			$version = trim($text[2]);
		} else {
			$theme_name = trim($text[0]);
			$version = trim($text[1]);
		}
		if ($theme != $theme_name) {
			return lecho("Error : incorrect theme name in ").$libdir.$theme_dir."/VERSION <br>\n";
		}

		//   We will chdir to $config->topdir when creating tarfile,
		//   so we must set $libdir according to this fact.
		$save_topdir = $config->topdir;
		$topdir = './';
		include $config->topdir.'dacode.'.$config->php;

		$contents = array($libdir.$theme_dir);
		if (file_exists($save_topdir.$theme_dir)) {
			$contents[] = $topdir.$theme_dir;
		}
		$excl = array(
			'(.*/)?CVS', '(.*/)?.cvsignore',
			//   For security reasons, we forbid inclusion of
			//   config.* files
			'config\.'
		);
		$id = 'daCode-'.$theme.'-'.$version;
		$subs = array(
			'^', $id.'/',
			"^$id/".$libdir.$theme_dir, "$id/templates",
			"^$id/".$topdir.$theme_dir, "$id/html"
		);
		if (function_exists('gzopen')) {
			$tarfile = $config->create_tar_dir.$id.'.tar.gz';
			$gz = 1;
		} else {
			$tarfile = $config->create_tar_dir.$id.'.tar';
			$gz = 0;
		}
		if ($this->tar->create($tarfile, $contents, $gz, $excl, $subs, $save_topdir)) {
			return  lecho("Archive file created -&gt; ")."$tarfile<br>\n";
		} else {
			return lecho("Unable to create archive")."<br>\n";
		}
	}

	Function extract_theme_tar($tarfile,$action,$file="") {
		global $config;

		//   Must be run by admin only for security reason
		if (!$this->session->is_admin) {
			echo lecho("you bad boy...");
			exit;
		}

		if (!$config->upload_tar_dir) {
			return lecho('Variable $config->create_tar_dir is empty, function disabled');
		}
		$tarpath = $config->upload_tar_dir.$tarfile;

		//   Retrieve informations from the VERSION file
		ereg('(.*-[0-9.]+)\.tar(\.gz)?$', $tarfile, $regs);
		$id = $regs[1];
		$gz = (isset($regs[2]) && $regs[2] ? 1 : 0);
		$infos = split("\n",
			$this->tar->file_content($tarpath,$gz,$id."/templates/VERSION"));
		if (!is_array($infos)) {
			return lecho("Error : This doesn't look to be a valid theme's archive.");
		}

		$out = '';
		//   Check for theme format.
		//   This is currently useless, but may be used later
		if (ereg('^[0-9]+$',$infos[0])) {
			if ($infos[0] > 1) {
				$out .= "<p>".
					lecho("<b>Warning</b>: theme created with a previous version of daCode. It may generate errors").
					"</p>";
			}
			$theme = trim($infos[1]);
			$version = trim($infos[2]);
		} else {
			$theme = trim($infos[0]);
			$version = trim($infos[1]);
		}
		$id = 'daCode-'.$theme.'-'.$version;

		$subs = array(
			"^$id/html", "$id/".$config->topdir."themes/".$config->theme_subdir.$theme,
			"^$id/templates", "$id/".$config->libdir."themes/".$config->theme_subdir.$theme,
			"^$id/", ''
		);
		if ($action == 1) {
			if ($this->tar->extract($tarpath, $gz, $subs)) {
				$out .= lecho("Theme correctly installed -&gt; ")."<br>\n";
			}
		} elseif ($action == 2) {
			$out .= $this->tar->file_content($tarpath,$gz,$file,$subs);
		} else {
			$list = $this->tar->files($tarpath, $gz, $subs);
			$out .= "<h2>".lecho("Content of archive")." $tarpath</h2>\n";
			$out .= "<ul>\n";
			while ($f = each($list)) {
				$out .= "  <li><a href=\"".
					$config->basehref.'admin/viewfile.'.$config->php.
					'?theme='.$tarfile.'&amp;file='.
					urlencode($f[1]).
					"\">".$f[1]."</a>\n";
			}
			$out .= "</ul>\n";
			$out .= "<br><a href=\"".
				$config->basehref.$config->adminfile.'?action=extract_theme'.
				'&amp;theme='.$tarfile.
				"\">".lecho("Install")."</a>\n";
			$out .= "<br><a href=\"".
				$config->basehref.$config->adminfile.'?action=delete_theme'.
				'&amp;theme='.$tarfile.
				"\">".lecho("Delete")."</a>\n";
		}
		return $out;
	}

	Function delete_theme_tar($theme) {
		global $config;

		//   Must be run by admin only for security reason
		if (!$this->session->is_admin) {
			echo lecho("you bad boy...");
			exit;
		}

		if (!$config->upload_tar_dir) {
			return;
		}

		if (unlink($config->upload_tar_dir.$theme)) {
			return $this->show_themes();
		} else {
			return lecho("Error: unable to remove ").$config->upload_tar_dir.$theme."<br>\n";
		}
	}

}

?>
