<?php
/* daCode http://www.dacode.org/
 * src/phplib/cal.php3
 * Pascal Terjan <pascal_terjan@bigfoot.com>
 *
 * $Id: cal.php3,v 1.13 2001/07/21 21:24:44 penso Exp $
 *
 * This is to display a small calendar allowing a simple
 * access to the news archives.
 *
 * Depends: Config Utils Html Session
*/

class Cal {
	var $cache,$html,$session;

	Function Cal() {
		$this->html  = LoadClass('Html');
		$this->cache = LoadClass('Cache');
		$this->session = LoadClass('Session');
	}


	/* Display the calendar */
	Function calbox($day, $month, $year) {
	  global $config, $LANG;

		$cachetmp = array ($day, $month, $year,
						$config->score,$config->hide_sig,$config->ext);

		$fcontents = $this->cache->check_box("7200","cal", $cachetmp);

		if (!empty($fcontents)) {
			return $fcontents;
		}

		/* Current day to know when to stop putting links */
		$thisday = date("j");

		/* Two digits month */
		$m2 = ((strlen($month)-1)?"":"0").$month;

		/* Number of days in the week */
		$n = date("t", mktime(0, 0, 0, $month, 1, $year));

		/* Number of the empty cells before first day of the week + 1 */
		$s = date("w", mktime(0, 0, 0, $month, 1, $year));
		if ($LANG=="fr") {
			if(!$s) { 
				$s = 7;
			}
		} else {
		  $s++;
		}

		/* Is the month displayed already finished ? */
		$passed = ($year<date("Y"))||((int)$month<(int)date("n")) && 
		  ($year==date("Y"));

		/* Is the month displayed the current one ? */
		$current = ($year==date("Y"))&&((int)$month==(int)date("n"));

		$d = 1;

		/* Display links for previous/next month + name of current one */
		$prev = mktime(0,0,0,$month-1,1,$year);
		$cur = mktime(0,0,0,$month,$day,$year);
		$next = mktime(0,0,0,$month+1,1,$year);
		$prevy = date("Y",$prev);
		$nexty = date("Y",$next);
		$prevm = date("m",$prev);
		$nextm = date("m",$next);
		$prevname = ucfirst(lecho(strtolower(date("F",$prev))));
		$curname = ucfirst(lecho(strtolower(date("F",$cur))));
		$nextname = ucfirst(lecho(strtolower(date("F",$next))));

		$out = "<table width=\"100%\"><tr>".
			"<td class=\"calmonth\" width=\"25%\"><a href=\"".
		  	$this->session->newsurls("","","",$prevy,$prevm,"01").
		  	"\">$prevname</a></td>".
			"<td class=\"calcurmonth\" width=\"50%\">$curname $year</td>";

		if ($passed) {
		  $out .= "<td class=\"calmonth\" width=\"25%\"><a href=\"".
			$this->session->newsurls("","","",$nexty,$nextm,"01").
			"\">$nextname</a></td>";
		} else {
		  $out .= "<td class=\"calmonth\" width=\"25%\">&nbsp;</td>";
		}
		$out .= "</tr></table>";

	 	$day_array = array(lecho("sunday"),lecho("monday"),
			lecho("tuesday"), lecho("wednesday"),lecho("thursday"),
			lecho("friday"), lecho("saturday"));

		/* Display the days names */
		$out .= "<center><table width=\"91%\"><tr>";
		if ($LANG=="fr") {
			for ($i=1; $i<7; $i++) {
				$out .= "<td class='cal' width=\"7%\">".
				  ucfirst(substr($day_array[$i],0,2))."</td>";
			}
			$out .= "<td class='cal' width=\"7%\">".
				ucfirst(substr($day_array[0],0,2))."</td>";
		} else {
			/* if not in french first day is sunday */
			for($i=0; $i<7; $i++){
				$out .= "<td class='cal' width=\"7%\">".
				  ucfirst(substr($day_array[$i],0,2))."</td>";
			}
		}

		$out .= "</tr>\n";

		/* Display the real calendar */
		while ($d<=$n) {
			$out .= "<tr>";
			for ($i=1; $i<=7; $i++) {
				/* Are we before the first day or after the last one ? */
				if ((($d==1)&&($i<$s)) || ($d>$n)) {
					$out .= "<td>&nbsp;</td>\n";
				} else {
				/* Do we need a link ? */
					if (($passed)|| ($current&&($thisday>=$d))) {
						$d2 = ((strlen($d)-1)?"":"0").$d;
						$out .= "<td class='cal'>\n<a href='".
						$this->session->newsurls("", "", "", $year, $m2, $d2).
						"'>";
						
						if ($day == $d) {
							$out .= "<b><u>$d</u></b>";
						} else {
							$out .= $d;
						}

						$out .= "</a></td>\n";
					} else {
						$out .= "<td class='cal'>$d</td>\n";
					}
					
					$d++;
				}
			}
			
			$out .= "</tr>\n";
		}
		$out .= "</table></center>\n";

		$out = '<!-- CAL -->'.$this->html->sidebox("Cal",$out."<br>").'<!-- /CAL -->';

		$this->cache->write_box("cal",$cachetmp,$out);

		return $out;
	}

}

?>
