<?php
/* Fabien Seisen <seisen@linuxfr.org>
 * Rolland Dudemaine <karllim@apologia.cx>
 * Db.php3
 * $Id: dbpgsql.php3,v 1.12 2001/07/16 23:19:47 barbier Exp $
 *
 * Classe Db
 *
 * booleen Db(host, login, passwd, database, persistant (0 ou 1));
 * booleen query($query_str);
 * free();
 * $array fetch_array();
 * int num_rows();
 * void error(); // affiche l erreur
 *
 * Depends: Config
 */

class Db {
	var $db;
	var $results;
	var $currentrow;

	Function Db() {
		global $config;

		//echo '<br>Db';
		$this->currentrow = 0;
		if ($config->sql_persistant == 1) {
			$db = $this->pconnect(
				$config->sql_host, $config->sql_user,
				$config->sql_passwd, $config->sql_db);
		} else {
			$db = $this->connect(
				$config->sql_host, $config->sql_user,
				$config->sql_passwd, $config->sql_db);
		}

		if (! $db) {
			// echo "Db->Db() rat<br>\n";
			$config->nodb=1;
			return 0;
		}

		return $db;
	}

	Function clone() {
		$db2 = new Db("", "", "", "", "");
		$db2->db = $this->db;
		return $db2;
	}
	Function connect($host, $login, $passwd, $database) {
		$this->db  = pg_connect("host=".$host." dbname=".$database." user=".$login." password=".$passwd);
		return $this->db;
	}
	Function pconnect($host, $login, $passwd,$database) {
		$this->db  = pg_pconnect("host=".$host." dbname=".$database." user=".$login." password=".$passwd);
		return $this->db;
	}
	Function close() {
		$this->ret = pg_close($this->db);
		return $this->ret;
	}
	Function select_db($database) {
		return $this->db;
	}
	Function query($query) {
		global $config;

		$this->currentrow = 0;
		if (!empty($config->sql_logfile)) {
			if(!($fp = fopen($config->sql_logfile,"a"))) {
				echo "problem...";
			}
			//   We do not check this writing because
			//   of the one just below which will catch any
			//   error
			fputs($fp,$query."\n");
		}
		$this->lasttable = '';
		if (eregi(' *insert +into +([^ ,]+) ', $query, $args)) {
			$this->lasttable = $args[1];
		}
		$this->results = @pg_exec($this->db,$query);
		if (!empty($config->sql_logfile)) {
			$text = "Affected : ".$this->affected_rows()."\n";
			$bytes_written = fputs($fp, $text);
			fclose($fp);
			if ($bytes_written != strlen($text)) {
				@unlink($config->sql_logfile);
				$config->nosave = 1;
			}
		}
		return $this->results;
	}
	Function result($nb, $fieldname) {
		return @pg_result($this->results, $nb, $fieldname);
	}
	Function free() {
		return pg_freeresult($this->results);
	}
	Function fetch_array() {
		if ($this->currentrow < pg_numrows($this->results)) {
			$ret = @pg_fetch_array($this->results, $this->currentrow );
			if (is_array($ret)) {
				if (isset($ret["timestamp"])) {
					$ret["timestamp"] = substr(ereg_replace("[- :]","", $ret["timestamp"]), 0, 14);
				}
			}
			$this->currentrow += 1;
			return $ret;
		} else {
			$this->currentrow = 0;
			return false;
		}
	}
	Function fetch_field() {
		$ret = pg_fetch_array($this->results);
		if (is_array($ret)) {
			if (isset($ret["timestamp"])) {
				$ret["timestamp"] = substr(ereg_replace("[- :]","", $ret["timestamp"]), 0, 14);
			}
		}
		return $ret;
	}
	Function num_rows() {
		return pg_numrows($this->results);
	}
	Function num_fields() {
		return pg_numfields($this->results);
	}
	Function error() {
		return pg_errormessage($this->db);
	}
	Function last_insert_id() {
		if ($this->lasttable) {
			$result = pg_exec($this->db,"SELECT max(id) FROM $this->lasttable");
			$row = pg_fetch_array($result, 0);
			return $row[0];
		} else {
			return FALSE;
		}
	}
	Function affected_rows() {
		return pg_cmdtuples($this->results);
	}

	//   The compat_* functions are to handle with incompatibilities
	//   between SQL backends
	Function compat_limit($nb,$offset="0") {
		return "LIMIT $nb OFFSET $offset";
	}
	Function compat_date_add($sec) {
		return "CURRENT_TIMESTAMP + $sec";
	}
}

?>
