<?php
/* daCode http://www.dacode.org/
 * src/phplib/html.php3
 * $Id: html.php3,v 1.123 2001/07/22 21:55:33 barbier Exp $
 *
 * This class is derived by themes
 *
*/

class Html {
	//   Read a template file, replace all <!-- daCode: ... -->
	//   expressions by PHP expressions, displays output text and
	//   returns this text
	Function parsetemplate($template) {
		global $config,$HTTP_GET_VARS,$HTTP_POST_VARS;
		//   All global variables used in template files must
		//   be declared below
		global $admin,$backends,$board,$cache,$comments,$db,$fortune,
		  $hits,$html,$message,$news,$nospider,$poll,$redirects,
		  $search,$session,$sidebox,$user,$utils,$webcam,$tips,$cal;
		global $section,$topic,$news_id,$date,$com_id,$title,$a,$table,
		  $pageday,$pagemonth,$pageyear;
		global $HTTP_REFERER,$text,$nobanner;

		$file = $config->libdir.'themes/'.
			$config->theme_name.'/'.$template;
		if (! file_exists($file)) {
			//   Look into third-party themes
			$file = $config->libdir.'themes/'.$config->theme_subdir.
				$config->theme_name.'/'.$template;
		}
		if (! file_exists($file)) {
			//  Load default templates
			$theme = $config->dft_prefs['theme'];
			$file = $config->libdir.'themes/'.
				$config->listofthemes[$theme].'/'.$template;
			if (! file_exists($file)) {
				return;
			}
		}

		$output = "";
		$input_lines = file($file);

		while ($t=each($input_lines)) {
			if (ereg('^[ 	]*#', $t[1])) {
				continue;
			}
			if (ereg('^(.*)<!-- daCode:(.*) -->(.*)$', $t[1], $res)) {
				eval("\$eval = $res[2];");
				$out = $res[1].$eval.$res[3];
				echo $out;
				$output .= $out;
			} else {
				echo $t[1];
				$output .= $t[1];
			}
		}

		return $output;
	}

	Function newsbox_posted_by($row,$preview) {
		global $config;

		$name = $row['name'];
		$contact = $row['contact'];

		$out = lecho("Posted by")." ";

		if (eregi("^http://", $contact) || eregi("^ftp://", $contact)) {
			$out .= $this->redirect->make($name,$contact,"");
		} elseif (preg_match("/^[\w_\-\.]+@[\w_\-\.]+$/",$contact)) {
			$out .= $this->redirect->make($name,"mailto:$contact","");
		} else {
			$out .= $name;
		}

		if ($preview=='1') {
			$out .= ". " . lecho("Proposed on") . " " .
			$this->utils->stamp2date($row['timestamp'],"long",2);
		} else {
			$out .= ". " . lecho("Approved on") . " " .
			$this->utils->stamp2date($row['timestamp'],"long");
		}

		$out .= ' <a href="'.$config->basehref.
			"news/view_modero.".$config->php."?news_id=".$row['id'].
			"\" onclick=\"window.open('".$config->basehref.
			"news/view_modero.".$config->php."?news_id=".$row['id']."','M',".
			"'toolbar=no,location=no,directories=no,status=no,".
			"alwaysRaised=yes,dependant=no,menubar=no,scrollbars=no,".
			"resizable=no,width=100,height=50'); return false\" ".
			"onmouseout=\"window.status=''; return true;\" ".
			"onmouseover=\"window.status='Voir moderateurs'; return true;\">[M]</a> ";

		return $out;
	}

	Function newsbox_show_links($row,$preview) {
		global $config;

		$out = '';
		if ($preview) {
			$out .= "<ul>\n";
			for ($k=0;$k<$config->numberoflinks;$k++) {
				if (empty($row['url'.$k])) {
					break;
				}
				$lank = ereg_replace('^[0-9]+:', '', $row['lan'.$k]);
				$out .= "<li><img src=\"".
					$this->session->imgurl($lank).
					"\" alt=\"[$lank] \"> - ";
				$out .= '<a href="'.$row['url'.$k].'">'.$row['nom'.$k]."</a></li>";
			}
			$out .= "</ul>\n";
		} elseif (gettype($row['links']) == "array" && count($row['links']) > 0) {
			$out .= "<ul>\n";
			reset($row['links']);
			while($urls = current($row['links'])) {
				$out .= "<li><img src=\"".
					$this->session->imgurl($urls['lang']).
					"\" alt=\"[".$urls['lang']."] \"> - ";
				$out .= $this->hits->make($urls) . "</li>";
				next($row['links']);
			}
			$out .= "</ul>\n";
		} else {
			$out .= "&nbsp;";
		}
		return $out;
	}
	
	Function size_unit($file_size) {
		if ($file_size >= 1048576) {
			$file_size = round($file_size / 1048576 * 100) / 100 . "Mega-";
		} elseif ($file_size >= 1024) {
			$file_size = round($file_size / 1024 * 100) / 100 . "Kilo-";
		}
		return $file_size;
	}
	
	Function newsbox_show_attachments($row) {
		global $config;

		$out = '';
		if (gettype($row['attach']) == "array") {
			reset($row['attach']);
			while ($attach = current($row['attach'])) {
				// Test to check if content-type.png exists
				// if so use it, else use default icon
				$img = str_replace("/", "-",
					$attach['content_type']);
				$imgsrc = $this->session->imgurl($img);
				$tmp = str_replace($config->basehref,
					$config->topdir, $imgsrc);
				if (!file_exists($tmp)) {
					$imgsrc = $this->session->imgurl("default_attach");
				}

				if ($attach['size'] <= 1) {
					$out .= "<a name=\"attach\" href=\"".$config->basehref."\">";
					$out .= "<img src=\"".$imgsrc.
						"\" alt=\"".$attach['size'] ." ". lecho("byte") ." ".
						lecho("in body") .
						"\" border=\"0\" hspace=\"0\" vspace=\"0\">\n";
					$out .= "</a>";
				} else {
					$out .= "&nbsp;<a name=\"attach\" href=\"".
						$config->basehref.
						"view_attach.".$config->php."?id=".$attach['id']."\">";
					$out .= "<img src=\"".$imgsrc.
						"\" alt=\"".$this->size_unit($attach['size']).lecho("bytes") ." ".
						lecho("in body") .
						"\" border=\"0\" hspace=\"0\" vspace=\"0\">\n";
					$out .= "</a>\n";
				}

				next($row['attach']);
			}
		}
		return $out;
	}

	Function newsbox_count_comments($row,$section,$topic,$year,$month,$day) {
		if (isset($row['comment'])) {
			$comment = $row['comment'];
		} else {
			$comment = 0;
		}
		if (isset($row['score_comment'])) {
			$score_comment = $row['score_comment'];
		} else {
			$score_comment = 0;
		}

		$out = "<a href=\"".
			$this->session->newsurls($row['id'],$section,$topic,$year,$month,$day).
			"\">";
		if ($score_comment <= 1) {
			$out .= "$score_comment " . lecho("comment");
		} else {
			$out .= "$score_comment " . lecho("comments");
		}
		$out .= "</a>";
		if ($score_comment < $comment) {
			$out .= " parmi <a href=\"".
				$this->session->newsurls($row['id'],$section,$topic,$year,$month,$day,0).
				"\">".$comment."</a>";
		}
		return $out;
	}

	Function linkto_topic($topic) {
		global $config;

		$name_tmp = "<img src=\"".$this->session->imgurl("section/".$topic).
			"\" hspace=\"10\" border=\"0\" ".
			"alt=\"$topic\" align=\"right\">";
		$url_tmp = $config->basehref.($config->visiblenewsfile ? $config->newsfile ."/" : "");
		if ($topic == 'notopic') {
			$out = $this->redirect->make($name_tmp);
		} else {
			$out = $this->redirect->make($name_tmp,
				$url_tmp."topic/".urlencode($topic).$config->extraopts.$config->ext);
		}
		return $out;
	}
}

	//   Derived classes are loaded by libdacode.php3
?>
