<?php
/* daCode http://www.dacode.org/
 * src/phplib/news.php3
 * $Id: news.php3,v 1.162 2001/07/22 21:55:33 barbier Exp $
 *
 * Class to handle all the news system.
 *
 * Depends: Config Db Utils Html Redirect Cache
 */

Class News {
	var $db,$session,$utils,$html,$redirect,$cache;
	var $news;

	Function News() {
//echo '<br>News';
		$this->db = LoadClass('Db');
		$this->session = LoadClass('Session');
		$this->utils = LoadClass('Utils');
		$this->html  = LoadClass('Html');
		$this->redirect = LoadClass('Redirect');
		$this->cache = LoadClass('Cache');

		$this->news = array ();
	}

	/*
		Add an entry to the news table.
		Need an array as input which needs to be like the following.
		$row[topic_id]    is the id of the topic.
		$row[section_id]  is the id the section.
		$row[author_id]   is the id of the author.
		$row[title]       is the title of the news.
		$row[departement] is the departement.
		$row[body]        is the body of the news.
		$row[links]       is an array (see the following)
		$row[files]       is an array which is an array itself (see the following)
	*/
	Function add($row) {
		global $config;

		$texte = "";
		$sqlc_q = "INSERT INTO ".$config->tables['news']." ".
			"(topic,section,author_id,title,departement,body) VALUES ('".
			addslashes($row['topic'])."','".
			addslashes($row['section'])."','".
			addslashes($row['author_id'])."','".
			addslashes($row['title'])."','".
			addslashes($row['departement'])."','".
			addslashes($row['body'])."')";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) return $texte.lecho("query failed")." :".$this->db->error();

		$last_insert_id = $this->db->last_insert_id();

		/*
			We INSERT all the submitted urls
			$row[links] must be an array which looks like the following.

			$row['links'] = array(
				"name of url"   => "http://www.url.com",
				"name of url2"  => "http://www.url2.com"
			);
		*/
		$links = $row['links'];
		reset($links);

		while (current($links)) {
			$c_links = current($links);
			$k_links = key($links);
			$sqlc_q = "INSERT INTO ".$config->tables['url']." ".
				"(news_id, name, url) VALUES ('".
				addslashes($last_insert_id)."','".
				addslashes($c_links)."','".
				addslashes($k_links)."')";

			$ret = $this->db->query($sqlc_q);
			if (!$ret) return $texte.lecho("query failed")." :".$this->db->error();

			next($links);
		}

		/*
			We INSERT all the submitted attachements
			$row[files] must be an array of array which looks like the following.

			$tmp[1] = array(
				"size"  =>  "1000",
				"name"  =>  "file1",
				"content_type"  =>  "text/plain",
				"content" =>  "This is the text from the file"
			);

			$tmp[2] = array(
				"size"  =>  "1200",
				"name"  =>  "file2",
				"content_type"  =>  "text/plain",
				"content" =>  "This is the text from the file"
			);

			$row['files'] = $tmp;

		*/
		$files = $row['files'];
		reset ($files);

		while(current($files)) {
			$files_tmp = current($files);
			$files_tmp['content'] =
				(empty($files_tmp['content']) || $files_tmp['content'] == 'unknown' ?
				'text/plain' : $files_tmp['content']);

			$sqlc_q = "INSERT INTO ".$config->tables['attach']." ".
				"(news_id, content_type, size, name, attachement) VALUES ('".
				addslashes($last_insert_id)."','".
				addslashes($files_tmp['content_type'])."','".
				addslashes($files_tmp['size'])."','".
				addslashes($files_tmp['name'])."','".
				addslashes($files_tmp['content'])."')";

			$ret = $this->db->query($sqlc_q);
			if (!$ret) return $texte."query rat".$this->db->error();

			next($files);
		}
	}

	/*
		Get a number of news. Return an array of array.
	*/
	Function get_news($nb=10,$section="",$topic="",$state=1,$view=1,$news_id=0,$body=1,$start_date=0,$date=0,$start_nb=0) {
		global $config;

		/* We build the SELECT command - Damned long ! :-) */
		$sqlc_q = "SELECT ".$config->tables['news'].".id,".$config->tables['news'].
			".timestamp,".$config->tables['news'].".title,".$config->tables['news'].
			".departement,".$config->tables['news'].".author_id, ";

		if ($body) {
			$sqlc_q .= $config->tables['news_body'].".body,".
				$config->tables['news_body'].".content_type,";
		}

		$sqlc_q .=$config->tables['topics'].".topic,".$config->tables['sections'].
			".section,".$config->tables['author'].".name,".$config->tables['author'].
			".contact FROM ".
			$config->tables['news'].",";
		if ($body) {
			$sqlc_q .= $config->tables['news_body'].",";
		}

		$sqlc_q .= $config->tables['topics'].",".$config->tables['sections'].",".
			$config->tables['author']." ".
			"WHERE ";

		if ($body) {
			$sqlc_q .=$config->tables['news'].".id=".$config->tables['news_body'].
			".id AND ";
		}

		$sqlc_q .= $config->tables['news'].".author_id=".
			$config->tables['author'].".id AND ".$config->tables['news'].
			".topic_id=".$config->tables['topics'].".id AND ".
			$config->tables['news'].".section_id=".$config->tables['sections'].
			".id AND ".$config->tables['news'].".state='".addslashes($state)."' ";

		/* 
		 * Removed to fix bug when url is called by normal url
		 * but doesn't have main_page at 1
		 */
		if ($view && $news_id==0) { //  || ($section==0 && $topic==0))
			$sqlc_q .= "AND ".$config->tables['news'].".main_page='1' ";
		}

		if ($section) {
			$sqlc_q .= "AND ".$config->tables['sections'].".section='".addslashes($section)."' ";
		}
		if ($topic) {
			$sqlc_q .= "AND ".$config->tables['topics'].".topic='".addslashes($topic)."' ";
		}
		if ($news_id) {
			$sqlc_q .= "AND ".$config->tables['news'].".id='".addslashes($news_id)."' ";
		}
		if ($start_date && $start_nb==0) {
			$sqlc_q .= "AND ".$config->tables['news'].".timestamp<'".addslashes($start_date)."' ";
		}
		if ($date) {
			$sqlc_q .= "AND ".$config->tables['news'].".timestamp LIKE '".addslashes($date)."%' ";
		}

		$sqlc_q .= "ORDER BY ".$config->tables['news'].
			".timestamp DESC ";

		if ((!$news_id && !$nb) || $start_nb != 0) {
			$sqlc_q .= $this->db->compat_limit($nb,$start_nb);
		} elseif (!$date) {
			$sqlc_q .= $this->db->compat_limit($nb);
		}
		/* built ! */

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL Failed:".$this->db->error()."\nSQL: $sqlc_q -->";
			return;
		}

		$i = 1;
		$out = array();
		/* fetch_array is probably faster than query */
		while ($row = $this->db->fetch_array()) {
			$out[$i] = $row;
			$i++;
		}
		$this->db->free();
		if (count($out) == 0) {
			//   There are no news matching the request.
			//   In order to prevent flooding disk with
			//   non-existing news, no files will be written
			//   to cache
			$config->nosave = 1;
		}

		return $out;
	}

	/*
		Get all the urls of the given news_id.
		Returns an array.
	*/
	Function get_urls($id) {
		global $config;

		$out = array();
		/* Let's make the SQL command */
		$sqlc_q = "SELECT ".$config->tables['lang'].".lang,".$config->tables['news_urls'].
			".name,".$config->tables['urls'].".url,".$config->tables['news_urls'].".id,".
			$config->tables['urls_hits'].".hits,".$config->tables['news_urls'].".news_id,".
			$config->tables['urls'].".id AS urls_id FROM ".
			$config->tables['lang'].",".$config->tables['news_urls'].",".
			$config->tables['urls'].",".$config->tables['urls_hits'].
			" WHERE ".$config->tables['news_urls'].".lang_id=".$config->tables['lang'].
			".id AND ".
			$config->tables['news_urls'].".urls_id=".
			$config->tables['urls'].".id AND ".
			$config->tables['urls_hits'].".news_urls_id=".
			$config->tables['news_urls'].".id AND ";

		if (gettype($id) == "array" && sizeof($id) > 0) {
			reset($id);
			$sqlc_q .= "(";
			while($tmpo=current($id)) {
				$sqlc_q .= $config->tables['news_urls'].".news_id='".addslashes($tmpo)."'";
				if (next($id)) {
					$sqlc_q .= " OR ";
				}
			}
			$sqlc_q .= ")";
		} else {
			$sqlc_q .= $config->tables['news_urls'].".news_id='".addslashes($id)."'";
		}

		$sqlc_q .= " ORDER BY ".$config->tables['news_urls'].".id";

		$ret = $this->db->query($sqlc_q);

		if (!$ret) return "SQL Failed:".$this->db->error();
		$i = 1;
		while ($row = $this->db->fetch_array()) {
			$out[$i] = $row;
			$i++;
		}
		$this->db->free();
		return $out;
	}

	/*
		Get all the attachements of the given news_id.
		Takes 2 arguments, the news id, and a integer (0 or 1) which says to
		returns the body or not.
		Returns an array.
	*/
	Function get_attach($id,$w=0) {
		global $config;

		$out = array();
		$sqlc_q = "SELECT id,news_id,content_type,size,name";

		if ($w) {
			$sqlc_q .= ",attachement";
		}

		$sqlc_q .= " FROM ". $config->tables['attach'] ." WHERE ";

		if (gettype($id) == "array" && sizeof($id) > 0) {
			reset($id);
			$sqlc_q .= "(";
			while($tmpo=current($id)) {
				$sqlc_q .= "news_id='".addslashes($tmpo)."'";
				if (next($id)) {
					$sqlc_q .= " OR ";
				}
			}
			$sqlc_q .= ")";
		} else {
			$sqlc_q .= "news_id='".addslashes($id)."'";
		}

		$ret = $this->db->query($sqlc_q);
		if (!$ret) return "SQL Failed ".$this->db->error();
		$i = 1;
		while ($row = $this->db->fetch_array()) {
			$out[$i] = $row;
			$i++;
		}
		$this->db->free();
		return $out;
	}

	/* Get attachement for save as command under netscape */
	Function view_attach($id) {
		global $config;

		$sqlc_q = "SELECT id,content_type,size,name,attachement FROM ".
			$config->tables['attach'] ." WHERE id='".addslashes($id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "SQL Failed ".$this->db->error();
			echo "SQL Command was: $sqlc_q<br>\n";
			return -1;
		}

		if ($row = $this->db->fetch_array()) {
			header('Content-type: '.$row['content_type']);
			header('Content-Length: '.$row['size']);
			header('Content-disposition: inline; filename='.$row['name']);
			echo $row['attachement'];
			exit;
		} else {
			echo lecho("No attachment");
		}

		$this->db->free();
	}

	/* This returns the number of comments */
	Function count_comments($news_id,$score="-2") {
		global $config;

		$out = array();
		$sqlc_q = "SELECT COUNT(*),".$config->tables['comments'].
			".news_id FROM ".$config->tables['comments'].
			", ".$config->tables['comments_scored'].
			" WHERE ";
		if (gettype($news_id) == "array" && sizeof($news_id) >= 0) {
			reset($news_id);
			$sqlc_q .= "(";
			while($tmpo=current($news_id)) {
				$sqlc_q .= $config->tables['comments'].
					".news_id='".addslashes($tmpo['id'])."'";
				if (next($news_id)) {
					$sqlc_q .= " OR ";
				}
			}
			$sqlc_q .= ") AND ";
		} else if (gettype($news_id) != "array") {
			$sqlc_q .= $config->tables['comments'].".news_id='".addslashes($news_id)."' AND ";
		} else {
			return $out;
		}

		if ($score != "-2") {
			$sqlc_q .= $config->tables['comments_scored'].
					".score >= '".addslashes($score)."' AND ";
		}

		$sqlc_q .= $config->tables['comments_scored'].".comments_id=".
				$config->tables['comments'].".id ";

		$sqlc_q .= " GROUP BY ".$config->tables['comments'].".news_id";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: $sqlc_q".$this->db->error() . " -->";
			return -1;
		}
		$i = 1;
		while ($row = $this->db->fetch_array()) {
			$out[$i] = $row;
			$i++;
		}
		$this->db->free();

		if (gettype($news_id) == "array") {
			return $out;
		} elseif (isset($out[1])) {
			return $out[1][0];
		} else {
			return 0;
		}
	}

	/* Returns the number of comments in an hash array
	 *     => array [$news_id]["s".$score]
	 */
	Function count_comments_array($news_id) {
		global $config;

		$out = array();
		$sqlc_q = "SELECT ".$config->tables['comments'].".news_id,".
			$config->tables['comments_scored'].".score,COUNT(*)".
			" FROM ".$config->tables['comments'].
			",".$config->tables['comments_scored'].
			" WHERE ";
		if (gettype($news_id) == "array" && sizeof($news_id) > 0) {
			reset($news_id);
			$array_news = $news_id;
			$sqlc_q .= "(";
			while($tmpo=current($news_id)) {
				$sqlc_q .= $config->tables['comments'].
					".news_id='".addslashes($tmpo['id'])."'";
				if (next($news_id)) {
					$sqlc_q .= " OR ";
				}
			}
			$sqlc_q .= ") AND ";
		} else if (gettype($news_id) != "array") {
			$sqlc_q .= $config->tables['comments'].".news_id='".addslashes($news_id)."' AND ";
			$array_news = array();
			$array_news[0] = array('id' => $news_id);
		} else {
			return $out;
		}

		$sqlc_q .= $config->tables['comments_scored'].".comments_id=".
				$config->tables['comments'].".id ";

		$sqlc_q .= " GROUP BY ".
			$config->tables['comments'].".news_id,".
			$config->tables['comments_scored'].".score";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: $sqlc_q".$this->db->error() . " -->";
			return -1;
		}
		reset($array_news);
		while ($n = current($array_news)) {
			$out['n'.$n['id']] = array(
				"s-1" => 0,
				"s0" => 0,
				"s1" => 0,
				"s2" => 0,
				"s3" => 0,
				"s4" => 0,
				"s5" => 0,
				"s6" => 0
			);
			next($array_news);
		}
		while ($row = $this->db->fetch_array()) {
			$n = $row['news_id'];
			$s = $row['score'];
			$out['n'.$n]['s'.$s] = $row[2];
		}
		$this->db->free();

		reset($array_news);
		while ($n = current($array_news)) {
			$nid = $n['id'];
			for ($i=5;$i>=-1;$i--) {
				$prev = $i+1;
				$out['n'.$nid]['s'.$i] += $out['n'.$nid]['s'.$prev];
			}
			next($array_news);
		}
		return $out;
	}

	/*
	 * Return the number of news in the last week for the given section
	 *
	 */
	Function count_section($section) {
		global $config;

		$sqlc_q = "SELECT COUNT(*),".$config->tables['sections'].
			".section FROM ".$config->tables['news'].",".
			$config->tables['sections'] . " WHERE ".
			$config->tables['news'] . ".section_id=".
			$config->tables['sections']. ".id AND ".
			$config->tables['news'].".state='1' AND ";

		if (gettype($section) == "array" && sizeof($section) > 0) {
			reset($section);
			$sqlc_q .= "(";
			while($tmpo=current($section)) {
				$sqlc_q .= $config->tables['sections'].".section='".
					addslashes($tmpo['section'])."'";
				if (next($section)) {
					$sqlc_q .= " OR ";
				}
			}
			$sqlc_q .= ") ";
		} else {
			$sqlc_q .= $config->tables['sections'].".section='".addslashes($tmpo)."' ";
		}

		$sqlc_q .= "GROUP BY ".$config->tables['sections'].".section";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: $sqlc_q".$this->db->error() . " -->";
			return -1;
		}

		$out = array();
		$i=1;
		while ($row = $this->db->fetch_array()) {
			$out[$i] = $row;
			$i++;
		}
		$this->db->free();

		if (gettype($section) == "array") {
			return $out;
		} elseif (isset($out[1])) {
			return $out[1];
		} else {
			return 0;
		}
	}

	/* Get title */
	Function show_title($news_id="") {
		global $config;

		if (empty($news_id)) {
			return $config->titledefault;
		}
		if (gettype($this->news) == "array") {
			reset($this->news);
			while ($cur=current($this->news)) {
				if ($cur['id'] == $news_id) {
					return $cur['title'];
				}
				next($this->news);
			}
		}
		$sqlc_q = "SELECT title FROM ".$config->tables['news'].
			" WHERE id='".addslashes($news_id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "SQL Failed ".$this->db->error();
			return -1;
		}
		$row = $this->db->fetch_array();
		if ($row[0] == " ") {
			$row[0] = $config->newstitledefault;
		}
		$this->db->free();
		$this->news[0]['title'] = $row[0];
		$this->news[0]['id'] = $news_id;
		return $row[0];
	}

	/* Show news */
	Function show_news($nb=10,$section="",$topic="",$state=1,$view=1,$news_id=0,$date=0) {
		global $config;

		if ($news_id) {
			$boxname = 'news_show';
			$cachetmp = array ($news_id,$section,$topic,$config->ext,
							$config->score,$config->hide_sig,$this->session->level,
							$state,$view,$date);
		} else {
			$boxname = 'news_index';
			$cachetmp = array ($section,$topic,$config->ext,$config->score,
							$config->hide_sig,$this->session->level,$state,$view,$date);
		}

		$fcontents = $this->cache->check_box("300",$boxname,$cachetmp);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		$out = '';
		$this->news = $this->get_news($nb,$section,$topic,$state,$view,$news_id,1,0,$date);
		if (gettype($this->news) == "array") {

			reset($this->news);

			$i=0;
			$tempo = array();
			while ($cur=current($this->news)) {
				$tempo[$i] = $cur['id'];
				$i++;
				next($this->news);
			}
			reset($this->news);

			/* We get the urls for all the news */
			$tempo_urls = (array) $this->get_urls($tempo);

			if ($news_id) {
				$tempo_attach = (array) $this->get_attach($tempo,1);
			} else {
				$tempo_attach = (array) $this->get_attach($tempo);
			}

			$i=1;
			while ($cur=current($this->news)) {
				$tempo2 = array();
				reset($tempo_urls);
				$j=1;
				while($cur2=current($tempo_urls)) {
					if ($cur2['news_id'] == $cur['id']) {
						$tempo2[$j] = $cur2;
					}
					$j++;
					next($tempo_urls);
				}
				$this->news[$i]['links'] = $tempo2;
				$i++;
				next($this->news);
			}
			reset($this->news);

			$i=1;
			while ($cur=current($this->news)) {
				$tempo = array();
				reset($tempo_attach);
				$j=1;
				while($cur2=current($tempo_attach)) {
					if ($cur2['news_id'] == $cur['id']) {
						$tempo[$j] = $cur2;
					}
					$j++;
					next($tempo_attach);
				}
				$this->news[$i]['attach'] = $tempo;
				$i++;
				next($this->news);
			}
			reset($this->news);

			$score_comment = (array) $this->count_comments_array($this->news);
			reset($this->news);
			while ($cur=current($this->news)) {

				/*
				 * We get the number of comments for this news
				 */
				$n = $cur[0];
				$cur['comment'] = $score_comment['n'.$n]['s0'];
				$cur['score_comment'] = $score_comment['n'.$n]['s'.$config->score];

				$out .= $this->html->newsbox($cur);

				/*
				 * We archive the last news id for archive 
				 */
				$config->last_news_timestamp = $cur['timestamp'];

				if ($news_id) {
					if (gettype($cur['attach']) == "array") {
						reset($cur['attach']);
						$accepted_view = array ("text/plain", "text/html");
						while ($attach = current($cur['attach'])) {
							$ok=0;
							reset($accepted_view);
							while($accepted_view_a = current($accepted_view)) {
								if ($attach['content_type'] == $accepted_view_a) {
									$ok =1;
								}
								next($accepted_view);
							}

							if ($ok==1) {
								// Important!
								// $attach['attachement'] = htmlentities($attach['attachement']);
								$attach['attachement'] = str_replace("<?","&lt;?",$attach['attachement']);
								$attach['attachement'] = str_replace("?>","?&gt;",$attach['attachement']);
								$out_tmp = "<b>".$attach['name']." - ";
								$out_tmp .= $attach['size']<=1?
								  $attach['size']." ".lecho("byte"):
								  $this->html->size_unit($attach['size']).lecho("bytes");
								$out_tmp .= "</b><br><br>\n";

								if ($attach['content_type'] == "text/plain") {
									$out_tmp = $out_tmp . 
									  nl2br(htmlspecialchars($attach['attachement']));
								} else {
									$out_tmp = $out_tmp . $attach['attachement'];
								}
								$out .= $this->html->simplebox($out_tmp);
								$out .= "<br>";
							}
							next($cur['attach']);
						}
					}
				}

				next($this->news);
			}
			$this->cache->write_box($boxname,$cachetmp,$out);
			return $out;
		}
	}

	/*
	 * This is to show archives of the news in an archive box
	 */
	Function show_archive($nb=10,$section="",$topic="",$state=1,$view=1) {
		global $config,$date;

		$cachetmp = array ($nb,$section,$topic,$config->ext,$config->score,
						   $config->hide_sig,$state,$view,
						   $config->last_news_timestamp);

		$fcontents = $this->cache->check_box("600","news_show_archive",$cachetmp);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		if (!isset($config->last_news_timestamp) ||
			$config->last_news_timestamp == 0) {
			$fcontents = $this->cache->check_box("60000","news_show_archive",$cachetmp);
			if (!empty($fcontents)) {
				return $fcontents;
			}
		}

		$out = '';
		// If the archive isn't asked from a date page, we start at 10.
		if (empty($date)) {
			$start_nb=10;
		} else {
			$start_nb=0;
		}
		$tmp = $this->get_news($nb,$section,$topic,$state,$view,0,0,
							   $config->last_news_timestamp,0,$start_nb);
		if (gettype($tmp) == "array") {
			$yr_old = $m_old = $j_old = '';
			$score_comment = (array) $this->count_comments_array($tmp);
			while(current($tmp)) {
				$cur = current($tmp);

				$cur['title'] = $cur['title']
						?$cur['title']
						:$config->newstitledefault;

				ereg("^([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})$",
							$cur['timestamp'], $regs);
				if ($yr_old != $regs[1] || $m_old != $regs[2] || $j_old != $regs[3]) {
					if ($yr_old != "") $out .= "<br>";
					$mregs = (int)$regs[2] - 1 ;
					$out .= "<b><a href=\"".
					  $this->session->newsurls("", "", "", $regs[1], $regs[2], $regs[3]).
					  "\"><span class=\"boxtext\">".
					  $this->utils->stamp2date($cur['timestamp'],"short")
					  ."</span></a></b><br>\n";
				}
				$yr_old = $regs[1];
				$m_old = $regs[2];
				$j_old = $regs[3];


				$title_tmp = $cur['title'];
				ereg("^([0-9]{4})([0-9]{2})([0-9]{2})", $cur['timestamp'], $regs);
				$url_tmp = $this->session->newsurls($cur['id'], "", "", $regs[1], $regs[2], $regs[3]);
				$out .= "&nbsp;<b>-</b>&nbsp;[".
				  $score_comment['n'.$cur['id']]['s'.$config->score]."/".
				  $score_comment['n'.$cur['id']]['s0'].
				  "]&nbsp;".$this->redirect->make($title_tmp,$url_tmp,"zop=").
				  "<br>";

				next($tmp);
			}

			if (!$section && !$topic) {
				$title = lecho("Archives");
			} else {
				if ($section) {
					$title = "$section";
					if ($topic)
						$title .= "::$topic";
				} else {
					$title = "$topic";
				}
			}
			$out = $this->html->sidebox($title,$out);

			$this->cache->write_box("news_show_archive",$cachetmp,$out);
			return $out;
		}
	}

	/*
	 * Takes an ID as argument and show the previous and next news
	 * If $prevnext=1, previous news is returned, otherwise next.
	 */
	Function get_prev_next_news($news_id,$prevnext,$section="",$topic="",$view=1) {
		global $config;

		$out = '';

		$sqlc_q = "SELECT timestamp FROM ".$config->tables['news']." WHERE id='".addslashes($news_id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "SQL Failed : ".$this->db->error();
			echo "SQL: $sqlc_q";
			return;
		}
		$row = $this->db->fetch_array();
		$timestamp = $row[0];
		$this->db->free();

		$sqlc_q = "SELECT ".$config->tables['news'].".id,".
			$config->tables['news'].".title,".
			$config->tables['news'].".timestamp FROM ".$config->tables['news'];

		if ($section) {
			$sqlc_q .= ",".$config->tables['sections'];
		}

		if ($topic) {
			$sqlc_q .= ",".$config->tables['topics'];
		}

		$sqlc_q .= " WHERE ";

		if ($view) {
			$sqlc_q .= $config->tables['news'].".main_page='".addslashes($view)."' AND ";
		}

		$sqlc_q .= $config->tables['news'].".state='1' ";

		if ($section) {
			$sqlc_q .= "AND ".$config->tables['sections'].".section='".addslashes($section)."' AND ".
				$config->tables['sections'].".id=".
				$config->tables['news'].".section_id ";
		}

		if ($topic) {
			$sqlc_q .= "AND ".$config->tables['topics'].".topic='".addslashes($topic)."' AND ".
				$config->tables['topics'].".id=".$config->tables['news'].
				".topic_id ";
		}

		$sqlc_q .= "AND ".$config->tables['news'].".timestamp ";
		$date = ereg_replace('([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})', '\1-\2-\3 \4:\5:\6', $timestamp);
		if ($prevnext) {
			$sqlc_q .= "< '".addslashes($date)."' ORDER BY timestamp DESC LIMIT 1";
		} else {
			$sqlc_q .= "> '".addslashes($date)."' ORDER BY timestamp LIMIT 1";
		}

		$ret = $this->db->query($sqlc_q);

		if (!$ret) {
			echo "SQL Failed : ".$this->db->error();
			echo "SQL: $sqlc_q";
			return;
		}

		if ($row = $this->db->fetch_array()) {
			$row[1] = $row[1]?$row[1]:$config->newstitledefault;
			ereg("^([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})([0-9]{2})$",
					$row[2], $regs);
			$out .= "<a href=\"".
				$this->session->newsurls($row[0], $section, $topic, $regs[1], $regs[2], $regs[3])."\">";
			if ($prevnext) {
				$out .= " << $row[1]</a>";
			} else {
				$out .= "$row[1] >> </a>";
			}
		}
		$this->db->free();

		return $out;
	}

	Function show_prev_next_news($news_id,$section="",$topic="",$view=1) {
		global $config;
		$cachetmp = array ($news_id,$section,$topic,$config->ext,$config->score,$view);

		$fcontents = $this->cache->check_box("180","news_prev_next",$cachetmp);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		$out = "<table width=\"100%\">".
			"<tr><td class=\"newstext\">".
			$this->get_prev_next_news($news_id,1,$section,$topic,$view).
			"</td><td class=\"rightnewstext\">".
			$this->get_prev_next_news($news_id,0,$section,$topic,$view).
			"</td></tr></table>\n";

		$out = $this->html->simplebox($out);
		$this->cache->write_box("news_prev_next",$cachetmp,$out);
		return $out;
	}

	/* Verify that the author has been created. If not then it creates it,
	 * and returns the id in any case
	 */
	Function verify_author($name,$contact) {
		global $config;

		$sqlc_q = "SELECT id FROM ". $config->tables['author'] ." WHERE name like '".addslashes($name)."' ";
		$sqlc_q .= "AND contact='".addslashes($contact)."'";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) return "query rat".$this->db->error();

		if ($this->db->num_rows()) {
			$id_tempo = $this->db->fetch_array();
			return $id_tempo[0];
		} else {
			$sqlc_q = "INSERT INTO ". $config->tables['author'].
				" (name,contact) VALUES ('".
				addslashes($name)."','".
				addslashes($contact)."')";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) return "query rat".$this->db->error();
			return $this->db->last_insert_id();
		}
	}

	Function datefr($t,$mode="short") {
		global $config;

		$timestamp = mktime(substr($t,8,2),substr($t,10,2),substr($t,12,2),substr($t,4,2),substr($t,6,2),substr($t,0,4));
		$dval   = date( "w",$timestamp);
		$mval   = (int) date( "m",$timestamp);
		$nval   = date( "d",$timestamp);

		$day    = array( "dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi");
		$sday   = array( "dim", "lun", "mar", "mer", "jeu", "ven", "sam");
		$month  = array( "", "janvier", "fvrier", "mars", "avril", "mai", "juin", "juillet", "aout", "septembre", "octobre", "novembre", "dcembre");
		$smonth = array( "", "jan", "fv", "mars", "avr", "mai", "juin", "juil", "aout", "sept", "oct", "nov", "dc");
		$suffix = array( "er", "nd", "");

		switch ($mode) {
			case "heure":
				$result  =  substr($t,8,2) . ":" . substr($t,10,2);
				break;
			case  "Long":
				$result  = ucfirst($day[$dval]). " $nval ".ucfirst($month[$mval]) . "  " . substr($t,8,2) . ":" . substr($t,10,2);
				break;
		}
		return $result;
	}

	Function view_modero($news_id) {
		global $config;

		$out = "";

		$sqlc_q = "SELECT ".$config->tables['users'].".fname,".
			$config->tables['users'].".lname,".
			$config->tables['users'].".login,".
			$config->tables['news_moderated'].".timestamp,".
			$config->tables['news_moderated'].".state ".
			" FROM ".$config->tables['users'].",".
			$config->tables['news_moderated']." WHERE ".
			$config->tables['users'].".id=".
			$config->tables['news_moderated'].".user_id AND ".
			$config->tables['news_moderated'].".news_id='".addslashes($news_id)."'".
			" ORDER BY ".$config->tables['news_moderated'].".timestamp";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			return "<!-- Query Failed ".$this->db->error()." -->\n";
		}
		if ($this->db->num_rows()) {
			while($row=$this->db->fetch_array()) {
				if (!empty($row[0]) || !empty($row[1])) {
					$out .= "$row[0] $row[1]<BR>\n";
				} else {
					$out .= "$row[2]<BR>\n";
				}

			}
		}
		$this->db->free();

		return $out;
	}

	Function warn_referer() {
		global $config; 
		return lecho("<b>Warning</b> : your webbrowser didn't sent").
			lecho(" informations about HTTP_REFERER.").
			lecho("<br>Consult ").
			"<a href=\"http://lwn.net/2000/features/Redirect.phtml\">".
			"http://lwn.net/2000/features/Redirect.phtml</a>".
			lecho(" to understand why it's a problem.").
			lecho("<p>If you are behind a proxy, which deletes").
			lecho(" this information, you can post").
			lecho(" by choosing in your ").
			"<a href=\"".$config->basehref.
			"users/?a=mu\">".lecho("preferences")."</a>".
			lecho(" to disable this verification.</p>");
	}

	Function preview($table) {
		global $config;

		$sqlc_q = "SELECT topic FROM ".$config->tables['topics'].
			" WHERE id='".addslashes($table['topic_id'])."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) return $this->db->error();

		$topics_tmp=$this->db->fetch_array();
		$table['topic'] = $topics_tmp[0];

		$sqlc_q = "SELECT section FROM ".$config->tables['sections'].
			" WHERE id='".addslashes($table['section_id'])."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) return $this->db->error();

		$sections_tmp=$this->db->fetch_array();
		$table['section'] = $sections_tmp[0];

		return $this->html->newsbox($table,1) . "<br><br>\n";
	}

	Function submit() {
		global $config;
		global $HTTP_POST_VARS,$HTTP_REFERER,$name_cookie,$mail_cookie;

		$pass = 1;
		$table = $HTTP_POST_VARS['table'];
		$table2 = $HTTP_POST_VARS['table2'];
		if (is_array($table)) {
			//  First check for referer
			if ($HTTP_REFERER != $config->basehref.'submit.'.$config->php &&
					!($this->session->param & pow(2,3))) {
				return $this->warn_referer();
			}

			//  Check whether $table and $table2 are identical
			//  If box is unchecked, this variable is unset
			if ($table2['attachments'] != $table['attachments']) {
				$pass = 2;
			} elseif ($this->utils->cmp_array($table,$table2)) {
				if ($table2['attachments']) {
					return $this->submit_upload($table);
				} else {
					return $this->submit_confirm($table);
				}
			} else {
				$pass = 2;
			}
		}

		$out = "";

		if ($pass == 2) {
			$out = $this->preview($table);
		}

		$out .= "<form method=\"post\" action=\"".
			$config->basehref."submit.".$config->php."\">";

		//  Previous answers are stored in hidden fields
		if (is_array($table)) {
			reset($table);
			while(list($key,$value)=each($table)) {
				if ($key != 'section' && $key != 'topic') {
					$out .= "<input type=\"hidden\" name=\"table2[$key]\"".
						" value=\"".htmlentities($table[$key])."\">\n";
				}
			}
		}

		//  Name
		$out .= lecho("Your name (Leave Blank to be Anonymous)");
		$out .= "<br>".
			"<input type=\"text\" name=\"table[name]\" value=\"";
		if (!empty($table['name']))
			$out .= htmlentities($table['name']);
		elseif (!empty($name_cookie))
			$out .= htmlentities("$name_cookie");
		else
			$out .= htmlentities(lecho("Anonymous"));
		$out .= "\" size=50 maxlength=50><br><br>\n";

		//  E-mail or homepage
		$out .= lecho("Your email or homepage (Must looks like http://)");
		$out .= "<br>".
			"<input type=\"text\" name=\"table[contact]\" value=\"";
		if (!empty($table['contact']))
			$out .= htmlentities($table['contact']);
		elseif (!empty($mail_cookie))
			$out .= htmlentities("$mail_cookie");
		$out .= "\" size=50 maxlength=100><br><br>\n";

		//  Subject
		$out .= lecho("Subject (Be descriptive, clear, and simple!)");
		$out .= "<br>".
			"<input type=\"text\" name=\"table[title]\" value=\"";
		if (!empty($table['title']))
			$out .= htmlentities($table['title']);
		$out .= "\" size=50 maxlength=150><br><br>\n";

		//  Topic
		$out .= lecho("Topic, section, and departement (free speech space)");
		$out .= "<br>".
			"<select name=\"table[topic_id]\">";
		$sqlc_q = "SELECT id,topic FROM ".$config->tables['topics'] ." ORDER BY topic";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) return $this->db->error();

		while($topics_tmp=$this->db->fetch_array()) {
			if (isset($table['topic_id']) && $table['topic_id'] == $topics_tmp[0])
				$out .= "<option value=\"$topics_tmp[0]\" selected>$topics_tmp[1]\n";
			else
				$out .= "<option value=\"$topics_tmp[0]\">$topics_tmp[1]\n";
		}
		$this->db->free();
		$out .= "</select>\n";

		//  Section
		$out .= "<select name=\"table[section_id]\">";
		$sqlc_q = "SELECT id,section FROM ".$config->tables['sections'] ." ORDER BY section";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) return $this->db->error();

		while($sections_tmp=$this->db->fetch_array()) {
			if (isset($table['section_id']) && $table['section_id'] == $sections_tmp[0])
				$out .= "<option value=\"$sections_tmp[0]\" selected>$sections_tmp[1]\n";
			else
				$out .= "<option value=\"$sections_tmp[0]\">$sections_tmp[1]\n";
		}
		$this->db->free();
		$out .= "</select>\n";

		//  Department
		$out .= "<input type=\"text\" name=\"table[departement]\" value=\"";
		if (!empty($table['departement']))
			$out .= htmlentities($table['departement']);
		$out .= "\" size=\"30\" maxlength=\"100\"><br><br>\n";

		//  Body
		$out .= lecho("The scoop (HTML is fine, but double check thoses URLs and HTML tags!)");
		$out .= "<select name=\"table[content_type]\">";
		if ($table['content_type'] == 'text/html') {
			$out .= "<option value=\"text/plain\">text".
				"<option value=\"text/html\" selected>html";
		} else {
			$out .= "<option value=\"text/plain\" selected>text".
				"<option value=\"text/html\">html";
		}
		$out .= "</select><br>\n";

		$out .= "<textarea name=\"table[body]\" wrap=VIRTUAL rows=10 cols=70>";
		if (isset($table['body']))
			$out .= htmlentities($table['body']);
		$out .= "</textarea><br><br>\n";

		$out .= lecho("Attached File");
		$out .= " <input type=\"checkbox\" name=\"table[attachments]\"";
		if ($table['attachments'] == "on") {
			$out .= " checked";
		}
		$out .= "><br><br>\n";

		//  Links
		$out .= lecho("HTML Links. <b>Don't forget to choose the lang!</b>");
		$out .= "<br><table width=\"100%\">".
			"<tr><td>".lecho("Name")."</td><td>".lecho("Urls (Must looks like http://)")."</td><td>&nbsp;</td></tr>\n";
		$sqlc_q = "SELECT id,lang FROM ".$config->tables['lang'] ." ORDER BY lang";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) return $this->db->error();
		while($lang_tmp = $this->db->fetch_array()) {
			$lang_id       = $lang_tmp[0];
			$lang_lan      = $lang_tmp[1];
			$lan[$lang_id] = $lang_lan;
		}
		$this->db->free();

		for ($k=0;$k<$config->numberoflinks;$k++) {
			$nomk = $table["nom$k"];
			$urlk = $table["url$k"];
			$lank = ereg_replace(':.*$', '', $table["lan$k"]);

			$out .= "<tr><td><input type=\"text\" name=\"table[nom$k]\" size=\"20\" ";
			if (!empty($nomk))
				$out .= "value=\"" . htmlentities($nomk) . "\"";
			$out .= "></td><td><input type=\"text\" name=\"table[url$k]\" size=\"50\" maxlength=\"200\" ";
			if (!empty($urlk))
				$out .= "value=\"" . htmlentities($urlk) . "\"";
			$out .= "></td><td><select name=\"table[lan$k]\">";
			$out .= "<option value=\"0\">".lecho("Language")."\n";
			reset($lan);
			while (current($lan)) {
				$out .= '<option value="'.key($lan).':'.current($lan) .'"'.
					($lank==key($lan) ? " selected" : "").
					">".current($lan)."\n";
				next($lan);
			}
			$out .= "</select></td></tr>\n";
		}
		$out .= "</table>\n";

		$out .= "<input type=\"submit\" name=\"submit\" value=\"".
			lecho("Next")."\"></form>\n";
		$out .= "<p><div align=\"center\">".lecho("Step")." ".$pass."/4</div>";
		return $out;
	}

	//  Upload files
	Function submit_upload($table) {
		global $config;

		$out = lecho("Attached Files");
		$out .= "<br><form method=\"post\" action=\"".
			$config->basehref."submit.".$config->php.
			"\" enctype=\"multipart/form-data\">";

		//  Pass variables through hidden files so that they can be
		//  treated in pass 4.
		reset($table);
		while(list($key,$value)=each($table)) {
			if ($key != 'section' && $key != 'topic' && $key != 'attachments') {
				$out .= "<input type=\"hidden\" name=\"table[$key]\"".
					" value=\"".htmlentities($table[$key])."\">\n".
					"<input type=\"hidden\" name=\"table2[$key]\"".
					" value=\"".htmlentities($table[$key])."\">\n";
			}
		}
		for ($k=0;$k<$config->numberoffiles;$k++) {
			$out .= "<input type=\"file\" size=\"50\" name=\"files$k\"><br>\n";
		}
		$out .= "<input type=\"submit\" name=\"submit\" value=\"".
			lecho("Next")."\"></form>\n";
		$out .= "<p><div align=\"center\">".lecho("Step")." 3/4</div>";
		return $out;
	}

	//  Message printed when news has been successfully fulfilled
	Function submit_confirm($table) {
		global $config;

		for ($k=0;$k<$config->numberoffiles;$k++) {
			$out .= "<input type=\"hidden\" name=\"table2[files$k]\"".
				" value=\"".htmlentities($GLOBALS["files$k"])."\">\n";
		}

		/* We verify the user exist, if it doesn't exist we
		 * create the entry in the database. In any case the
		 * function return the id of the user
		 */

		$id_author = $this->verify_author($table['name'],$table['contact']);
		/* We INSERT the title of the news and the rest in news table */
		$sqlc_q = "INSERT INTO ".$config->tables['news'].
			" (topic_id,section_id,author_id,lang_id,title,departement,ip,user_id) ".
			"VALUES ('".
			addslashes($table['topic_id'])."','".
			addslashes($table['section_id'])."','".
			addslashes($id_author)."','".
			addslashes($config->langdefault)."','".
			addslashes($table['title'])."','".
			addslashes($table['departement'])."','".
			addslashes($this->utils->ip())."','".
			addslashes($this->session->user_id)."')";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) return $this->db->error();
		$last_insert_id = $this->db->last_insert_id();

		/* We INSERT the BODY of the NEWS */
		$sqlc_q = "INSERT INTO ".$config->tables['news_body']." (id,body,content_type) VALUES ('".
			addslashes($last_insert_id)."','".
			addslashes($table['body'])."','".
			addslashes($table['content_type'])."')";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) return $this->db->error();

		/* We INSERT ALL the LINKS */
		for ($k=0;$k<$config->numberoflinks;$k++) {
			$nomk = $table["nom$k"];
			$urlk = $table["url$k"];
			$lank = $table["lan$k"];
			if (!empty($nomk)) {

				/* We verify urls is in $config->tables['urls'] */
				$sqlc_q = "SELECT id FROM ".$config->tables['urls']." WHERE url like ".
					"'".addslashes($urlk)."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) return $this->db->error();
				if (!$this->db->num_rows()) {
					$sqlc_q = "INSERT INTO ".$config->tables['urls']." (url) VALUES ".
						"('".addslashes($urlk)."')";
					$ret = $this->db->query($sqlc_q);
					if (!$ret) return $this->db->error();
					$url_id = $this->db->last_insert_id();
				} else {
					$url_id_tmp = $this->db->fetch_array();
					$url_id = $url_id_tmp[0];
				}


				/* We insert the news_urls */
				$sqlc_q = "INSERT INTO ".$config->tables['news_urls'].
					" (news_id,lang_id,urls_id,name) ".
					"VALUES ('".
					addslashes($last_insert_id)."','".
					addslashes($lank)."','".
					addslashes($url_id)."','".
					addslashes($nomk)."')";

				$ret = $this->db->query($sqlc_q);
				if (!$ret) return $this->db->error();

				$tempo_id = $url_id = $this->db->last_insert_id();

				$sqlc_q = "INSERT INTO ".$config->tables['urls_hits'].
					" (news_urls_id,hits) VALUES ('".
					addslashes($tempo_id)."', '0')";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) return $this->db->error();

			}
		}

		/* We INSERT all the attached files */
		for ($k=0;$k<$config->numberoffiles;$k++) {
			$filesk = $GLOBALS["files$k"];
			if (!empty($filesk) && $filesk != "none") {
				$fd = fopen( $filesk, "r" );
				$contents = fread( $fd, filesize( $filesk ) );
				fclose( $fd );

				/* I know it sucks, but hey, it works.
				 * If you have a better way tell me ! */
				$files_tmp_name = $GLOBALS["files$k"."_name"];
				$files_tmp_size = $GLOBALS["files$k"."_size"];
				$files_tmp_type = $GLOBALS["files$k"."_type"];

				$sqlc_q = "INSERT INTO ".$config->tables['attach'].
					" (news_id,content_type,".
					"size,name,attachement) VALUES ('".
					addslashes($last_insert_id)."','".
					addslashes($files_tmp_type)."','".
					addslashes($files_tmp_size)."','".
					addslashes($files_tmp_name)."','".
					addslashes($contents)."')";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) return $this->db->error();
			}
		}
		return  "<div class=\"bgtext\">".
			lecho("Your message has been recorded and will be processed").
			lecho(" by one of the moderators.")." ".
			lecho("If approved, it will be published on our website:").
			" <a href=\"".$config->basehref."\">".
			$config->basehref."</a></div>".
			"<p><div align=\"center\">".lecho("Step")." 4/4</div>";
	}

	/*
	 * We print the form to send the news by email
	 */
	Function send_email_view($news_id=0) {
		global $config;

		if ($news_id == '0' ||
			$this->is_approved($news_id) == "0") {
			return;
		}

		$out = "";
		$out .= "<form action=\"".$config->basehref."news/send_email.".
				$config->php."\" type=\"POST\">\n";
		$out .= "<center><b>".lecho("Send to a friend")."</b></center><br><br>".
				lecho("Enter an email address").":<br>";
		$out .= "<input name=\"email_address\" value=\"\" type=\"text\" size=\"20\"><br><br>\n";
		$out .= lecho("Enter a comment").":<br>";
		$out .= "<textarea name=\"body\" cols=\"20\" rows=\"3\"></textarea><br><br>\n";
		$out .= "<center><input type=\"submit\" value=\"".lecho("Submit")."\"></center>\n";
		$out .= "<input name=\"news_id\" value=\"$news_id\" type=\"hidden\">\n";
		$out .= "</form>";

		return $out;
	}

	/*
	 * We send the news if it has been approved
	 */
	Function send_email($news_id=0,$email_address="",$body="") {
		global $config;

		if ($news_id=='0' || $email_address=="" || 
			$this->is_approved($news_id) == "0") {
			return;
		}

		$out = "";

		if (! preg_match("/^[\w_\-\.]+@[\w_\-\.]+$/",$email_address)) {
			$out .= lecho("Email looks wrong");
			$out .= ": $email_address-$news_id";
		} else {

			$ts = $this->utils->gettimestampnews($news_id);
			$news_url = $this->session->newsurls($news_id,"","",$ts[0],$ts[1],$ts[2]);
			$title = $this->show_title($news_id);

			$text = lecho("Hello,\n\n");

			if ($this->session->checked) {
				if (($this->session->param & pow(2,0)) && 
					(!empty($this->session->fname) || 
					 !empty($this->session->lname))) {
					$text .= ucfirst($this->session->fname) ." ". 
					  ucfirst($this->session->lname)." ";
				} else {
					$text .= ucfirst($this->session->login)." ";
				}
			} else {
				$text .= lecho("Someone, ");
			}

			if ($this->session->checked) {
				$text .= lecho("whose email address is ").$this->session->email;
			} else {
				$text .= lecho("whose ip address is ");
				$text .= $config->REMOTE_ADDR;
			}

			$text .= lecho("\nthought you should be interested by the news that you can find at :\n\n");
			$text .= $news_url."\n\n\n";
			$text .= lecho("The title of this news is :\n\n");
			$text .= $title."\n\n";

			if (!empty($body)) {
				$text .= lecho("He also wanted to add the following comment :\n\n").ucfirst($body).
					"\n\n";
			}

			$text .= lecho("If someone is abusing with this service, please\n");
			$text .= lecho("contact us at : ").$config->mailadmin."\n";
			

			$this->utils->send_email($email_address,$title,$text);

			$out .= lecho("Sent!");
			$out .= "<script language=\"javascript\">self.close()</script>\n";
		}

		return $out;
	}

	/*
	 * Returns the simplebox with icon inside if $news_id != 0
	 * Returns nothing if not
	 */
	Function show_print($news_id=0) {
		global $config;

		if ($news_id == 0) {
			return;
		}

		$out = '<center><a href="'.$config->basehref.'news/send_email_view.'.
			$config->php.'?news_id='.$news_id.'" onclick="window.open(\''.
			$config->basehref."news/send_email_view.".$config->php."?news_id=".
			$news_id."','M',"."'toolbar=no,location=no,directories=no,status=no,".
			"alwaysRaised=yes,dependant=no,menubar=no,scrollbars=no,".
			"resizable=no,width=200,height=300'); return false\" ".
			"onmouseout=\"window.status=''; return true;\" ".
			"onmouseover=\"window.status='".lecho("Send to a friend").
			"'; return true;\"><img src=\"".$this->session->imgurl("icon_send").
			"\" border=\"0\" alt=\"".lecho("Send to a friend")."\"></a>";


		reset($config->listofthemes);
		while(list($key,$val) = each ($config->listofthemes)) {
			if ($val == "printable") {
				$theme_print=$key;
				break;
			}
		}

		if (isset($theme_print)) {
			$backup_ext = $config->ext;
			$config->ext = ','.$theme_print;
			if ($this->session->checked) {
				$config->ext .= '.'.$config->php;
			} else {
				$config->ext .= '.html';
			}

			$ts = $this->utils->gettimestampnews($news_id);
			$news_url = $this->session->newsurls($news_id, "", "", 
														$ts[0], $ts[1], $ts[2]);

			$out .= "<br><a href=\"$news_url\" onmouseout=\"window.status=''; return true;\" ".
				"onmouseover=\"window.status='".lecho("Print")."'; return true;\">".
				"<img src=\"".$this->session->imgurl("icon_print")."\" alt=\"".lecho("Print").
				"\" border=\"0\"></a>";

			$config->ext = $backup_ext;
		}
		$out .= "</center>\n";

		return $this->html->simplebox($out);
	}

	/*
	 * Returns 1 if the news is approved (state=1)
	 * Returns 0 if the news isn't approved neither doesn't exists.
	 */
	Function is_approved($news_id) {
		global $config;

		$sqlc_q = "SELECT state FROM ".$config->tables['news'].
			" WHERE id='".addslashes($news_id)."'";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			return $this->db->error();
		}

		if (!$this->db->num_rows()) {
			return 0;
		} else {
			$state_tmp = $this->db->fetch_array();
			$this->db->free();
			if ($state_tmp[0] == "1") {
				return 1;
			} else {
				return 0;
			}
		}
	}

}

?>
