<?php
/* daCode http://www.dacode.org/
 * src/phplib/redirects.php3
 * $Id: redirects.php3,v 1.32 2001/07/12 09:48:15 penso Exp $
 * Fabien PENSO <penso@linuxfr.org>
 *
 * Depends: Config Db
*/

Class Redirect {
	var $db,$QUERY_STRING,$HTTP_GET_VARS;

	Function Redirect() {
		global $QUERY_STRING,$HTTP_GET_VARS;

//echo '<br>Redirect';

		$this->db = LoadClass('Db');
		$this->QUERY_STRING=$QUERY_STRING;
		$this->HTTP_GET_VARS=$HTTP_GET_VARS;
	}

	/* return number of hits */
	Function view($url) {
		global $config;

		if (!$config->countredirect) {
			return 0;
		}

		$url = urldecode($url);
		$sqlc_q = "SELECT ".$config->tables['redirect'].".hits FROM ".
			$config->tables['redirect'].",".$config->tables['urls']." WHERE ".
			$config->tables['redirect'].".urls_id=".
			$config->tables['urls'].".id AND ".$config->tables['urls'].".url='".addslashes($url)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			return -1;
		}
		$row = $this->db->fetch_array();
		if ($this->db->num_rows()) {
			if ($row[0] <= 1) {
				$out = $row[0] . " hit";
			} else {
				$out = $row[0] . " hits";
			}
		} else {
			$out = "0 hit";
		}

		$this->db->free();

		return $out;
	}

	/* Add hits+1 or create it */
	Function add($url) {
		global $config;

		if (!$config->countredirect) {
			return 0;
		}

		$url = urldecode($url);
		$sqlc_q = "SELECT ".$config->tables['redirect'].".hits,".$config->tables['urls'].
			".id FROM ".
			$config->tables['redirect'].",".$config->tables['urls']." WHERE ".
			$config->tables['redirect'].".urls_id=".
			$config->tables['urls'].".id AND ".$config->tables['urls'].".url='".addslashes($url)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			return -1;
		}

		if (!$this->db->num_rows()) {
			$sqlc_q = "INSERT INTO ".$config->tables['urls']." (url) VALUES ('".addslashes($url)."')";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo lecho("SQL Failed: ").$this->db->error();
				return -1;
			}
			$id = $this->db->last_insert_id();
		} else {
			$row = $this->db->fetch_array();
			$id = $row[1];
		}

		$sqlc_q = "SELECT hits FROM ".$config->tables['redirect']." WHERE urls_id='".addslashes($id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			return -1;
		}
		if (!$this->db->num_rows()) {
			$sqlc_q = "INSERT INTO ".$config->tables['redirect']." (urls_id,hits)".
				" VALUES ('".addslashes($id)."', '1')";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo lecho("SQL Failed: ").$this->db->error();
				return -1;
			}
		} else {
			$sqlc_q = "UPDATE ".$config->tables['redirect']." set hits=hits+1 WHERE ".
				"urls_id='".addslashes($id)."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo lecho("SQL Failed: ").$this->db->error();
				return -1;
			}
		}
	}

	/* Returns a <a href="url">name</a> link with appropriate redirect */
	Function make($name,$url,$arg="") {
		global $config;

		if(ereg( "^".$config->basehref, $url, $regs)) {
			$out = $url;
			if (!empty($arg)) {
				// This is to modify var which are already defined.
				// Thanks Fabien Seisen
				$a_args = explode("&", $arg);
				reset($a_args);
				$new_args = $this->HTTP_GET_VARS;
				while ($cur_tmp = current($a_args)) {
					$a = explode("=", $cur_tmp);
					// We overwrite. If empty we delete it from array
					if ($a[0] == "section" || $a[0] == "topic") {
						if (empty($a[1])) {
							unset($new_args[$a[0]]);
							next($a_args);
						} else {
							$new_args[$a[0]] = $a[1];
							next($a_args);
						}
					} else {
						unset($new_args[$a[0]]);
						next($a_args);
					}
				}
				$url = "";
				reset($new_args);
				while ($cur_tmp = current($new_args)) {

					/* We only keep var which starts with _persist as name */
					if (!ereg("^persist",key($new_args))) {
						next($new_args);
						continue;
					}

					$url .= key($new_args)."=".$cur_tmp;
					if (!next($new_args)) {
						$url.="";
					} else {
						$url.="&amp;";
					}
					//next($new_args);
				}
				// Done !

				if (!empty($url)) {
					$out .= "?$url";
				}

			} elseif (!empty($this->QUERY_STRING)) {
				$a_args = explode("&", $this->QUERY_STRING);
				reset($a_args);
				$new_args = array();
				while ($cur_tmp = current($a_args)) {
					$a = explode("=", $cur_tmp);
					if (!ereg("^persist",$a[0])) {
						next($a_args);
						continue;
					} 
					$new_args[$a[0]] = $a[1];
					next($a_args);
				}
				reset($new_args);
				while ($cur_tmp = current($new_args)) {
					$url_args .= key($new_args)."=".$cur_tmp;
					if (next($new_args)) {
						$urls_args .= "&amp;";
					}
				}

				if (!empty($urls_args)) {
					$out = $url."?".$url_args;
				} else {
					$out = $url;
				}
			}

			return "<a href=\"".$out."\">$name</a>";
		} else {
			$url=urlencode($url);

			if (!$config->countredirect) {
				return "<a href=\"".urldecode($url)."\">$name</a>";
			} else {
				if ($config->user_checked) {
					return "<a href=\"".$config->basehref.
						$config->redirecthref.
						"?$url\">$name</a> (".
						$this->view($url) . ") ";
				} else {
					return "<a href=\"".$config->basehref.
						$config->redirecthref.
						"?$url\">$name</a>";
				}
			}
		}
	}

	/* Redirect to url, add one hit */
	Function header($url) {
		$this->add($url);
		$url = urldecode($url);
		header("Location: $url");
	}

}


?>
