<?php
/* daCode http://www.dacode.org/
 * src/phplib/session.php3
 * $Id: session.php3,v 1.44 2001/07/22 22:07:15 penso Exp $
 */

Class Session {
	var $db;
	var $user_id;
	var $fname;
	var $lname;
	var $login;
	var $email;
	var $level;
	var $param;
	var $timestamp;
	var $fake_email;
	var $last;
	var $checked;
	var $sig_id;
	var $hide_sig;
	var $homesite;
	var $signature;
	var $password;
	var $status;
	var $score;
	var $theme;
	var $supp_info;

	Function Session() {
		global $HTTP_COOKIE_VARS, $HTTP_REFERER, $config;

		$this->db = LoadClass('Db');
		$this->utils = LoadClass('Utils');

		$this->user_id=0;
		$this->fname="";
		$this->lname="";
		$this->login=(isset($HTTP_COOKIE_VARS['login']) ? $HTTP_COOKIE_VARS['login'] : lecho("Anonymous"));
		$this->email="";
		$this->level=0;
		$this->param=128;
		$this->timestamp=0;
		$this->fake_email="";
		$this->homesite="";
		$this->last=0;
		$this->checked=0;
		$this->sig_id=0;
		$this->status=0;
		$this->score=$config->dft_prefs['score'];
		$this->hide_sig=$config->dft_prefs['hide_sig'];
		$this->theme=$config->dft_prefs['theme'];
		$this->signature="";
		$this->password="";
		$this->HTTP_REFERER=$HTTP_REFERER;
		$this->supp_info = array();

		$this->check();

		//  Adjust some variables
		$config->score=$this->score;
		$config->hide_sig=$this->hide_sig;
		$config->theme=$this->theme;
		$config->theme_name=$config->listofthemes[$config->theme];

		$this->is_moderator = $this->checked && ($this->level&pow(2,21));
		$this->is_admin  = $this->checked && ($this->level&pow(2,22));
		$this->is_scoror = $this->checked && ($this->level&pow(2,23));

		//  Make sure this theme is valid
		if (empty($config->theme_name)) {
			$config->theme = $config->dft_prefs['theme'];
			$config->theme_name=$config->listofthemes[$config->theme];
		}

		$config->ext = ','.$config->theme;
		if ($this->checked) {
			$config->ext .= '.'.$config->php;
		} else {
			$config->ext .= '.html';
		}
		$config->extraopts = ','.$this->hide_sig.','.$this->score;
	}

	/*
	 * Close the session
	 */
	Function close($a) {
		global $HTTP_COOKIE_VARS,$REMOTE_ADDR,$config;
		if ($a=="cs" && $HTTP_COOKIE_VARS['session_id']) {
			setcookie("session_id","",0,"/",$config->cookiedomain);
			$ref = ereg_replace('\.'.$config->php.'$', '.html', $this->HTTP_REFERER);
			//   Reset session variables
			$this->Session();
			header("Location: $ref".'?reload');
			exit;
		}
	}

	/*
	 * Check the session
	 */
	Function check() {
		global $HTTP_COOKIE_VARS;
		global $config;

		$session_id=isset($HTTP_COOKIE_VARS['session_id'])?$HTTP_COOKIE_VARS['session_id']:'';

		if (empty($session_id))
			return 0;
		$ip=$this->utils->ip();
		$sqlc_q = "SELECT expire,users.id,fname,lname,users.login,email,level,param".
			",created,fake_email,lastseen,sig_id,homesite,passwd,theme,status,".
			"score FROM ".$config->tables['sessions'].",".
			$config->tables['users']." WHERE ".
			$config->tables['sessions'].".user_id=".
			$config->tables['users'] .".id AND ".
			$config->tables['sessions'].".id='".addslashes($session_id)."'".
			" AND expire>=CURRENT_TIMESTAMP";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "It looks like admin are working on the server";
			exit;
		}

		if ($this->db->num_rows()==1) {
			$c=$this->db->fetch_array();
			if ($c[0]) {
				$this->user_id=$c[1];
				$this->fname=$c[2];
				$this->lname=$c[3];
				$this->login=$c[4];
				$this->email=$c[5];
				$this->level= (int) $c[6];
				$this->param=$c[7];
				$this->timestamp=$c[8];
				$this->fake_email=$c[9];
				$this->last=$c[10];
				$this->sig_id=$c[11];
				$this->homesite=$c[12];
				$this->password=$c[13];
				$this->theme=$c[14];
				$this->status=$c[15];
				$this->score=$c[16];
			}

			$this->checked = 1;
			$this->hide_sig = ($this->param & pow(2,2) ? 1 : 0);

			$this->db->free();

			$sqlc_q = "SELECT supp_info FROM ".$config->tables['users_supp'].
			  " WHERE user_id='".addslashes($c[1])."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo "<!-- SQL failed: $sqlc_q".$this->db->error()." -->";
				return "<span class=\"newstext\">".
					lecho("Something went wrong. ").
				  lecho("Please contact the webmaster.")."</span><br>";
			}
			if ($this->db->num_rows()) {
				$c=$this->db->fetch_array();
				$this->supp_info = unserialize($c[0]);
				$this->db->free();
			} else {
				$this->supp_info = array ();
			}

			// This is in case the account hasn't be validated yet
			if ($this->status == 0) {
				$sqlc_q = "UPDATE ".$config->tables['users'].
					" SET status='1',created=created WHERE id='".
					addslashes($this->user_id)."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					echo lecho("SQL Failed: ").$sqlc_q.$this->db->error();
					return -1;
				}
			}
			//

			$sqlc_q = "UPDATE ".$config->tables['sessions'].
				" SET lastseen=NULL WHERE id='".
				addslashes($session_id)."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo lecho("SQL Failed: ").$sqlc_q.$this->db->error();
				return -1;
			}
			return 1;
		}
		return 0;
	}

	//  Return news URL
	Function newsurls ($id,$section,$topic,$yea,$mon,$day,$score="-2") {
		global $config;

		if ($score == -2) {
			$score = $config->score;
		}
		$tmp = $config->basehref;
		if ($config->visiblenewsfile)
			$tmp .= $config->newsfile . "/";
		if (!empty($section)) {
			$tmp .= "section/".urlencode($section).
				(empty($id) ? '' : '/'.$id).
				','.$config->hide_sig.','.$score.$config->ext;
		} else if (!empty($topic)) {
			$tmp .= "topic/".urlencode($topic).
				(empty($id) ? '' : '/'.$id).
				','.$config->hide_sig.','.$score.$config->ext;
		} else {
			$tmp .= "$yea/$mon/$day/".(empty($id) ? 'index' : $id).
				','.$config->hide_sig.','.$score.$config->ext;
		}
		return $tmp;
	}

	//  Return an URL of a themable file
	Function href_theme ($file) {
		global $config;

		$themefile = "themes/".$config->theme_name."/".$file;
		$theme_contrib_file = "themes/".$config->theme_subdir.$config->theme_name."/".$file;
		$tmp = $config->basehref.
			(file_exists($config->topdir.$themefile) ?
				$themefile :
				(file_exists($config->topdir.$theme_contrib_file) ?
					$theme_contrib_file : $file));
		return $tmp;
	}

	//  Return images URL depending on current theme
	Function imgurl ($name,$format="png") {
		global $config;

		return $this->href_theme("images/".$name.".".$format);
	}

}

?>
