<?php
/* daCode http://www.dacode.org
 * src/phplib/themes/linuxfr/html.php3
 * $Id: html.php3,v 1.25 2001/07/22 22:12:20 barbier Exp $
 *
 *	All HTML design will be put here
 *
 *	header($title)	Return the header with $title as title.
 *	footer()		Return footer.
 *	newsbox($title, $news, $icon, $urls, footer)	Return the box.
 *
 * Depends: Config Redirect Utils User
 */

class Htmllinuxfr extends Html {
	var $session;
	var $redirect;
	var $hits;
	var $fortune;
	var $utils;

	Function Htmllinuxfr() {
		global $config;

		//echo '<br>Htmldefault';
		$this->utils = LoadClass('Utils',$config);
		$this->session = LoadClass('Session',$config);
		$this->hits = LoadClass('Hits',$config);
		$this->redirect = LoadClass('Redirect',$config);
		$this->fortune = LoadClass('Fortunes',$config);
	}

	/* Returns the header */
	Function header($title,$nobanner="0") {
		global $config;

		$title = (empty($title)) ? $config->titledefault : $title;
		$tmp = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\" ";
		$tmp .= "\"http://www.w3.org/TR/REC-html40/loose.dtd\">\n";
		$tmp .= "<!-- This page has been generated at the following time: ".
			date("d/m/Y H:i:s")." -->\n";
		$tmp .= "\n<html>\n<head>\n";
		$tmp .= "<title>$title</title>\n";
		$tmp .= "<link rel=\"stylesheet\" type=\"text/css\" href=\"".
				$this->session->href_theme('linuxfr.css')."\" >\n";
		$tmp .= "</head>\n";
		$tmp .= "<body bgcolor=\"#dae6e6\">\n";

		if ($nobanner==0) {

			$tmp .= "<table cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" border=\"0\"> \n";
			$tmp .= "<tr bgcolor=\"#e7e7e7\"> \n";
			$tmp .= "<td>";
			$tmp .= "<img src=\"".$this->session->imgurl('pix')."\" width=\"1\" height=\"1\" alt=\"\">";
			$tmp .= "</td> \n";
			$tmp .= "</tr> \n";
			$tmp .= "</table> \n";
			$tmp .= "\n";
			$tmp .= "<table cellspacing=\"0\" cellpadding=\"1\" width=\"100%\" border=\"0\"> \n";
			$tmp .= "<tr valign=\"middle\" bgcolor=\"#cccccc\"> \n";
			$tmp .= "<td class=\"newstext\"> \n";
			$tmp .= "&nbsp;&nbsp;<a class=\"topbanner\" href=\"http://www.daCode.org\">daCode</a>&nbsp;&middot;&nbsp;\n";
			$tmp .= "<a class=\"topbanner\" href=\"http://www.jesuislibre.org\">jesuislibre</a>&nbsp;&middot;&nbsp;\n";
			$tmp .= "<a class=\"topbanner\" href=\"http://www.lolix.org\">Lolix</a>&nbsp;&middot;&nbsp;\n";
			$tmp .= "<a class=\"topbanner\" href=\"http://www.lea-linux.org\">La-Linux</a>\n";
			$tmp .= "</td>";
			$tmp .= "<td align=\"right\" class=\"topbanner\">";
			$tmp .= "<a href=\"http://linuxfr.org/bouffe/mensuelle/\">First Jeudi</a></td>";
			$tmp .= "<td align=\"right\" class=\"topbanner\"><a class=\"topbanner\" href=\"http://www.lsfn.net\">LSFN&nbsp;</a>";
			$tmp .= "</td></tr></table>\n";
	
			$tmp .= "<table cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" border=\"0\">\n";
			$tmp .= " <tr valign=\"middle\" bgcolor=\"#6f6f6f\">\n";
			$tmp .= "  <td><img src=\"".$this->session->imgurl('pix')."\" width=\"1\" height=\"1\" alt=\"\"></td>\n";
			$tmp .= " </tr>\n";
			$tmp .= " <tr bgcolor=\"#e7e7e7\">\n";
			$tmp .= "  <td><img src=\"".$this->session->imgurl('pix')."\" width=\"1\" height=\"1\" alt=\"\"></td>\n";
			$tmp .= " </tr>\n";
			$tmp .= "</table>\n";
			$tmp .= "<center><a href=\"".$config->basehref."\"><img src=\"".  
			 	$this->session->imgurl('logo').
			 		"\" border=\"0\" alt=\"top banner\"></a><br>".
			 		"<span class=\"logoinfo\">[Logo par Tom4. Envoie <a href=\"mailto:contact@linuxfr.org\">le tien</a> et deviens clbre! - Pingouin dessin par <a href=\"mailto:made@planet-d.net\">M4de</a>]</span></center>\n";
		}

		return $tmp;
	}


	/* Returns the footer */
	Function footer($text="",$nobanner="0") {
		$tmp = '';
		if (!$nobanner) {
			$out = "<table width=\"100%\" border=\"0\"><tr>";
			$out .= "<td class=\"newstext\"><ul>";
			$out .= "<li>".lecho("This website runs")." <a href=\"http://www.dacode.org/\">";
			$out .= "daCode</a></li>\n";
			$out .= "</ul></td>";

			$out .= "<td class=\"newstext\">";
			$out .= $this->fortune->get_random();
			$out .= "</td></tr>";
			$out .= "</table>";
			$out .= $text;
			$tmp = $this->simplebox($out);
		}
		$tmp .= "</body>\n</html>\n";
		return $tmp;
	}

	/* Return HTML code for side box with $text */
	Function sidebox($title,$text, $type="") {
		$tmp = "
		<!-- SIDEBOX $type -->
		<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">
		<tr>
		<td class=\"blackbox\" bgcolor=\"#000000\" width=\"100%\">
		<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\" width=\"100%\">
		<tr>
		<td class=\"boxheader\" bgcolor=\"#cacaca\" width=\"100%\">$title</td></tr>
		<tr><td class=\"boxtext\" bgcolor=\"#dae6e6\" width=\"100%\">$text</td></tr></table>
		</td></tr></table><br>
		<!-- /SIDEBOX $type -->\n";
		return $tmp;
	}
	
	/* Return HTML code for simple box with $text */
	Function simplebox($text) {
		$tmp = "<!-- SIMPLEBOX -->\n";
		$tmp .= "<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" width=\"100%\" bgcolor=\"#736199\">\n<tbody>\n";
		$tmp .= "  <tr><td width=\"100%\">\n";
		$tmp .= "   <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" bgcolor=\"#cacaca\">\n<tbody>";
		$tmp .= "   <tr><td class=\"newstext\" width=\"100%\">\n";
		$tmp .= "   $text\n";
		$tmp .= "   </td></tr>\n";
		$tmp .= "   </table>\n";
		$tmp .= "  </td></tr>\n";
		$tmp .= "</table><br>\n";
		$tmp .= "<!-- /SIMPLEBOX -->\n";
		return $tmp;
	}

	/* Return HTML code for news box with $row from news table */
	Function newsbox($row,$preview=0) {
		global $section,$topic;
		global $config;
	
		$tmp = '';

		// Title is referenced by a <a name>

		/* if ($row[section] != "Articles" && $row[section] != $section) {
			$row[title] = $row['section']." : $row[title]";
		}*/
		
		$title = 	'<a name="n'.$row['id'].'">'.
				((empty($row['title'])) ?
					$config->newstitledefault :
					$row['title']).
				'</a>';

		if ($row['section'] != "Articles" && $row['section'] != $section) {
			$url_tmp = $config->basehref.($config->visiblenewsfile ? $config->newsfile : "");
			$title = $this->redirect->make($row['section'],
						$url_tmp."/section/".urlencode($row['section']).
						$config->extraopts.$config->ext) . ": $title";
		}
					
		$body  = (empty($row['body'])) ? 
			$config->newsbodydefault : 
			(($row['content_type']=="text/plain") ? 
			 nl2br($row['body']) : $row['body']);
			 
		$departement = (empty($row['departement']))
			 ? $config->newsdepartementdefault : $row['departement'];
		$row['section'] = (empty($row['section'])) ? "nosection" : $row['section'];
		$row['topic'] = (empty($row['topic'])) ? "notopic" : $row['topic'];

		// Let's do HTML code
		$tmp .= "
		<!-- NEWSBOX ".$row['id']." -->
		<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr valign=\"top\"
		bgcolor=\"#736199\"><td bgcolor=\"#dae6e6\">
		<img src=\"".$this->session->imgurl('pix')."\" width=\"5\" alt=\" \"></td>
		<td width=\"10\" valign=\"top\"><img border=\"0\" width=\"10\" height=\"13\"".
		" src=\"".$this->session->imgurl('ul')."\" alt=\"(( \"></td>
		<td bgcolor=\"#736199\" class=\"newstitle\">$title</td><td width=\"10\""
		." align=\"right\" valign=\"top\"><img border=\"0\" width=\"10\" height=\"13\"".
		" src=\"".$this->session->imgurl('ur')."\" alt=\"))\"></td></tr></table>\n".
		"<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" width=\"100%\" bgcolor=\"#736199\">
		<tr><td valign=\"bottom\"><table border=\"0\" bgcolor=\"#cacaca\" cellspacing=\"0\" 
		cellpadding=\"3\" width=\"100%\"><tr><td class=\"newsinfo\">";

		$tmp .= $this->newsbox_posted_by($row,$preview);

		$tmp .= "<!-- ADMINEDIT:".$row['id']." -->";
		if ($this->session->checked && ($this->session->level&pow(2,21))) {
			$tmp .= " - <b><a href=\"".$config->basehref.
				$config->adminfile."?action=edit_news&amp;news_id=".
				$row['id']."\">Edit!</a></b>";
		}
		$tmp .= "<!-- /ADMINEDIT -->";

		if (!empty($departement)) {
			$tmp .= "<br>\n" . ucfirst(lecho("dept")) . ": <b>$departement</b>";
		}

		$tmp .= "\n      </td>\n     </tr>\n     <tr>\n";
		$tmp .= "<td class=\"newstext\">";
		$tmp .= $this->linkto_topic($row['topic']);
		$tmp .= "       $body\n      </td>\n";
		$tmp .= "</tr>\n     <tr>\n";
		$tmp .= "<td class=\"newslink\">\n";
		$tmp .= $this->newsbox_show_links($row,$preview);
		$tmp .= "</td>\n     </tr>\n     <tr>\n";
		$tmp .= "<td class=\"newsinfo\" valign=\"middle\">\n";

		$tmp .= "<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"newsinfo\">";

		ereg("^([0-9]{4})([0-9]{2})([0-9]{2})", $row['timestamp'], $regs);
		$tmp .= $this->newsbox_count_comments($row,$section,$topic,$regs[1],$regs[2],$regs[3]);
		$tmp .= "</td><td align=\"right\">\n";
		$tmp .= $this->newsbox_show_attachments($row);
		$tmp .= "</td></tr></table>\n";

		$tmp .= "\n     </td>\n     </tr>\n    </table>\n   </td>\n  </tr>\n".
			 " </table>\n <br>\n";
		$tmp .= "<!-- /NEWSBOX -->\n";
		return $tmp;
	}

	/* Function to print comment top banner */
	Function commentbanner ($score) {
		global $config,$news;
		global $section,$topic;
		global $HTTP_GET_VARS,$news_id;

		// Get information to get timestamp + news
		global $PATH_INFO;
		$path = ereg_replace('^/'.$config->htmldir, '/', $PATH_INFO);
		if (ereg("^(.*)\\.(html|$config->php)", $path, $res)) {
			$path = $res[1];
		}
		if (ereg('^([^,]*)(,.+)$', $path, $res)) {
			$path = $res[1];
		}
		if (ereg("^/([0-9]{4})/([0-9]{2})/([0-9]{2})/([0-9]+)$", $path, $res)) {
			$year = $res[1];
			$month= $res[2];
			$day  = $res[3];
		} else {
			$ts = $this->utils->gettimestampnews($news_id);
			$year = $ts[0];
			$month= $ts[1];
			$day  = $ts[2];
		}

		if (isset($HTTP_GET_VARS['score'])) {
			$score = $HTTP_GET_VARS['score'];
		}
		$out = "";
		$out .= "<table width=\"100%\" border=\"0\" cellspacing=\"1\"".
				"cellpadding=\"2\">\n";
		$out .= "<tr><td class=\"commentbox\"><a name=\"banner\" href=\"".
			$this->session->newsurls($news_id,'','',$year,$month,$day,$score).
			"\"><font color=\"#ffffff\">\n";
		$out .= $news->show_title($news_id);
		$out .= "</font></a> | ";
		$out .= "<a href=\"".$config->basehref.
				"users/?a=na\"><font color=\"#ffffff\">".lecho("New Account").
				"</font></a> | <b>";
		$counttmp = $news->count_comments($news_id);
		$out .= $counttmp . "</b> ";
		if ($counttmp <= 1) {
			$out .= lecho("comment")."\n";
		} else {
			$out .= lecho("comments")."\n";
		}

		$out .= "</td></tr>\n";
		$out .= "<tr><td class=\"commentboxmiddle\">\n";
		$out .= "<form method=\"POST\" action=\"".$config->basehref.$config->commaddfile."\">\n";
		$out .= "<input type=\"hidden\" name=\"news_id\" value=\"$news_id\">\n";
		$out .= "<input type=\"hidden\" name=\"year\" value=\"$year\">\n";
		$out .= "<input type=\"hidden\" name=\"month\" value=\"$month\">\n";
		$out .= "<input type=\"hidden\" name=\"day\" value=\"$day\">\n";

		if (!empty($section)) {
			$out .= "<input type=\"hidden\" name=\"section\" value=\"$section\">\n";
		} else {
			$out .= "<input type=\"hidden\" name=\"section\" value=\"0\">\n";
		}

		if (!empty($topic)) {
			$out .= "<input type=\"hidden\" name=\"topic\" value=\"$topic\">\n";
		} else {
			$out .= "<input type=\"hidden\" name=\"topic\" value=\"0\">\n";
		}

		$out .= "<input type=\"checkbox\" name=\"hide_sig\"";
		if ($config->hide_sig == "1") {
			$out .= " checked>\n";
		} else {
			$out .= ">\n";
		}
		$out .= "Score: <select name=\"score\">\n";
		$score_comment = (array) $news->count_comments_array($news_id);
		for ($i=-1;$i<6;$i++) {
			$counttmp = $score_comment['n'.$news_id]['s'.$i];
			$out .= "<option value=\"$i\" ";

			if ($i == $score || (!isset($score) && $this->session->score == $i)) {
				$out .= "selected";
			}

			$out .= ">$i: $counttmp ";
			if ($counttmp <= 1) {
				$out .= lecho("comment")."\n";
			} else {
				$out .= lecho("comments")."\n";
			}
		}
		$out .= "</select>";
		$out .= "<input type=\"submit\" name=\"op\"".
				" value=\"".lecho("Change")."\">\n";
		$out .= "<input type=\"submit\" name=\"op\"".
				" value=\"".lecho("Reply")."\">\n</form></td></tr>\n";
		$out .= "<tr><td class=\"commentbox\">\n";
		$out .= lecho("<b>The fine print</b>: The following comments are owned by whoever posted them.")." ";
		$out .= lecho("We are not responsible for what they say.")."\n";
		$out .= "</td></tr></table><br><br>\n";

		return $out;
	}

}
?>
