<?php
/* daCode http://www.dacode.org
 * src/phplib/themes/linuxfr/html.php3
 * $Id: html.php3,v 1.7 2001/07/22 22:12:20 barbier Exp $
 *
 *	All HTML design will be put here
 *
 *	header($title)	Return the header with $title as title.
 *	footer()		Return footer.
 *	newsbox($title, $news, $icon, $urls, footer)	Return the box.
 *
 * Depends: Config Redirect Utils User
 */

class Htmlphpnukeopenmind extends Html {
	var $session;
	var $redirect;
	var $hits;
	var $fortune;
	var $utils;

	Function Htmlphpnukeopenmind() {
		global $config;

		//echo '<br>Htmldefault';
		$this->utils = LoadClass('Utils',$config);
		$this->session = LoadClass('Session',$config);
		$this->hits = LoadClass('Hits',$config);
		$this->redirect = LoadClass('Redirect',$config);
		$this->fortune = LoadClass('Fortunes',$config);
	}

	/* Returns the header */
	Function header($title,$nobanner="0") {
		global $config;

		$title = (empty($title)) ? $config->titledefault : $title;
		$tmp = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\" ";
		$tmp .= "\"http://www.w3.org/TR/REC-html40/loose.dtd\">\n";
		$tmp .= "<!-- This page has been generated at the following time: ".
			date("d/m/Y H:i:s")." -->\n";
		$tmp .= "\n<html>\n<head>\n";
		$tmp .= "<title>$title</title>\n";
		$tmp .= "<link rel=\"stylesheet\" type=\"text/css\" href=\"".
				$this->session->href_theme('style.css')."\" >\n";
		$tmp .= "</head>\n";
		$tmp .= "<body bgcolor=\"#FFFFFF\" link=\"#363636\" vlink=\"#363636\" alink=\"#d5ae83\">\n";

		if ($nobanner==0) {

			$tmp .= "<br><br><center><a href=\"".$config->basehref."\"><img src=\"".  
			 		$this->session->imgurl('logo').
			 		"\" border=\"0\" alt=\"top banner\"></a><br>";
		}

		return $tmp;
	}


	/* Returns the footer */
	Function footer($text="",$nobanner="0") {
		$tmp = '';
		if (!$nobanner) {
			$out = "<table width=\"100%\" border=\"0\" cellpadding=0 cellspacing=0><tr>";
			$out .= "<td bgcolor=\"#d8ecea\"><ul>";
			$out .= "<li>Ce site tourne sous <a href=\"http://www.dacode.org/\">";
			$out .= "daCode</a></li>\n";
			$out .= "</ul></td>";

			$out .= "<td class=\"newstext\" yeswrap bgcolor=\"#d8ecea\">";
			$out .= $this->fortune->get_random();
			$out .= "</td></tr>";
			$out .= "</table>";
			$out .= $text;
			$tmp = $this->simplebox($out);
		}
		$tmp .= "</body>\n</html>\n";
		return $tmp;
	}

	/* Return HTML code for side box with $text */
	Function sidebox($title,$text, $type="") {
		$tmp = "
		<!-- SIDEBOX $type -->

<table border=0 cellpadding=1 cellspacing=0 bgcolor=#000000 width=\"100%\"><tr><td width=\"100%\">
<table border=0 cellpadding=0 cellspacing=0 bgcolor=#d8ecea width=\"100%\"><tr>
<td bgcolor=\"#ffffff\"><img src=\"".$this->session->imgurl("pixel","gif")."\" width=1 height=1 alt=\"\" border=0 width=\"100%\"></td></tr>
<tr><td align=left height=20 class=\"boxheader\" width=\"100%\">

<b>&nbsp;&nbsp;$title</b></td></tr>

<tr><td bgcolor=\"#aaaaaa\"><img src=\"".$this->session->imgurl("pixel","gif")."\" width=1 height=1 alt=\"\" border=0></td>
</tr></table></td></tr></table>
<table border=0 cellpadding=0 cellspacing=0 bgcolor=\"#ffffff\" width=\"100%\">
<tr valign=top><td bgcolor=#ffffff class=\"boxtext\" width=\"100%\">
$text
</td></tr>
<tr><td width=\"100%\"><br><img src=\"".$this->session->imgurl("shadow","gif")."\" width=\"150\" border=0 alt=\"\">
</td></tr></table>
<br>
		<!-- /SIDEBOX $type -->\n";
		return $tmp;
	}
	
	/* Return HTML code for simple box with $text */
	Function simplebox($text) {
		$tmp = "<!-- SIMPLEBOX -->\n

<table cellpadding=0 cellspacing=0 width=\"100%\" border=\"0\" align=\"center\" bgcolor=\"#fefefe\">
<tr><td bgcolor=\"#000000\" colspan=6 width=\"100%\">
<img src=\"".$this->session->imgurl("pixel","gif")."\" width=1 height=1 Alt=\"\" border=0></TD>
</tr><tr>
<td bgcolor=\"#FFFFFF\" width=\"100%\"><IMG src=\"".$this->session->imgurl("pixel","gif")."\" width=1 height=1 alt=\"\" border=0></TD>
</tr><tr bgcolor=\"#d8ecea\"><td width=\"100%\"><img src=\"".$this->session->imgurl("pixel","gif")."\" width=1 height=6 Alt=\"\"></td>
</tr>

<tr valign=\"middle\" bgcolor=\"#d8ecea\">
<td width=\"100%\">

$text
</td></tr>

<tr bgcolor=\"#d8ecea\"><td width=\"100%\"><img src=\"".$this->session->imgurl("pixel","gif")."\" width=1 height=6 alt=\"\"></td></tr>
<tr>
<td bgcolor=\"#cccccc\" width=\"100%\"><img src=\"".$this->session->imgurl("pixel","gif")."\" width=1 height=1 alt=\"\" border=0></td>
</tr>
<tr>
<td bgcolor=\"#000000\" width=\"100%\"><img src=\"".$this->session->imgurl("pixel","gif")."\" width=1 height=1 alt=\"\" border=0></td>
</tr></table>";




		$tmp .= "<!-- /SIMPLEBOX -->\n";
		return $tmp;
	}

	/* Return HTML code for news box with $row from news table */
	Function newsbox($row,$preview=0) {
		global $section,$topic;
		global $config;
	
		$tmp = '';

		// Title is referenced by a <a name>

		/* if ($row[section] != "Articles" && $row[section] != $section) {
			$row[title] = $row['section']." : $row[title]";
		}*/
		
		$title = 	'<a name="n'.$row['id'].'">'.
				((empty($row['title'])) ?
					$config->newstitledefault :
					$row['title']).
				'</a>';

		if ($row[section] != "Articles" && $row[section] != $section) {
			$url_tmp = $config->basehref.($config->visiblenewsfile ? $config->newsfile : "");
			$title = $this->redirect->make($row[section],
						$url_tmp."/section/".urlencode($row[section]).
						$config->extraopts.$config->ext) . ": $title";
		}
					
		$body  = (empty($row['body'])) ? 
			$config->newsbodydefault : 
			(($row['content_type']=="text/plain") ? 
			 nl2br($row['body']) : $row['body']);
			 
		$departement = (empty($row['departement']))
			 ? $config->newsdepartementdefault : $row['departement'];
		$row['section'] = (empty($row['section'])) ? "nosection" : $row['section'];
		$row['topic'] = (empty($row['topic'])) ? "notopic" : $row['topic'];

		// Let's do HTML code
		$tmp .= "
		<!-- NEWSBOX ".$row['id']." -->

<table border=0 cellpadding=0 cellspacing=0 bgcolor=ffffff width=\"100%\"><tr><td align=\"left\">
<table border=0 cellpadding=1 cellspacing=0 bgcolor=000000 width=\"100%\"><tr><td align=\"left\">
<table border=0 cellpadding=0 cellspacing=0 bgcolor=d8ecea width=\"100%\"><tr>
<td bgcolor=\"#ffffff\" align=\"left\"><img src=\"".$this->session->imgurl("pixel","gif")."\" width=1 height=1 alt=\"\" border=0></td></tr>
<tr><td align=\"left\" height=\"20\"><font size=\"3\" color=\"#363636\"><b>&nbsp;$title</b></font>
</td></tr>
<td bgcolor=\"#aaaaaa\" align=\"left\"><img src=\"".$this->session->imgurl("pixel","gif")."\" width=1 height=1 alt=\"\" border=0></td></tr>
</table></td></tr></table>";

		$tmp .= $this->linkto_topic($row['topic']);

		$tmp .= "<font color=\"#999999\" size=2>" .
				$this->newsbox_posted_by($row,$preview)."\n";

		$tmp .= "<!-- ADMINEDIT:".$row['id']." -->";
		if ($this->session->checked && ($this->session->level&pow(2,21))) {
			$tmp .= " - <b><a href=\"".$config->basehref.
				$config->adminfile."?action=edit_news&amp;news_id=".
				$row['id']."\">Edit!</a></b>";
		}
		$tmp .= "<!-- /ADMINEDIT -->";

		if (!empty($departement)) {
			$tmp .= "<br>\n" . ucfirst("dpt") . ": <b>$departement</b>";
		}
		$tmp .= "</font><br><br>";

		$tmp .= " <font size=3 color=\"#505050\">$body</a><br><br>";

		$tmp .= $this->newsbox_show_links($row,$preview);

		$tmp .= "<br><br><div align=\"left\"><img src=\"".$this->session->imgurl("point","gif")."\" border=0 alt=\"\">&nbsp;<font size=2>";
		ereg("^([0-9]{4})([0-9]{2})([0-9]{2})", $row['timestamp'], $regs);
		$tmp .= $this->newsbox_count_comments($row,$section,$topic,$regs[1],$regs[2],$regs[3]);
		$tmp .= $this->newsbox_show_attachments($row);
		$tmp .= "</div></td></tr></table>\n";

		$tmp .= "<!-- /NEWSBOX --><br><br>\n";
		return $tmp;
	}

	/* Function to print comment top banner */
	Function commentbanner ($score) {
		global $config,$news;
		global $section,$topic;
		global $HTTP_GET_VARS,$news_id;

		// Get information to get timestamp + news
		global $PATH_INFO;
		$path = ereg_replace('^/'.$config->htmldir, '/', $PATH_INFO);
		if (ereg("^(.*)\\.(html|$config->php)", $path, $res)) {
			$path = $res[1];
		}
		if (ereg('^([^,]*)(,.+)$', $path, $res)) {
			$path = $res[1];
		}
		if (ereg("^/([0-9]{4})/([0-9]{2})/([0-9]{2})/([0-9]+)$", $path, $res)) {
			$year = $res[1];
			$month= $res[2];
			$day  = $res[3];
		} else {
			$ts = $this->utils->gettimestampnews($news_id);
			$year = $ts[0];
			$month= $ts[1];
			$day  = $ts[2];
		}

		if (isset($HTTP_GET_VARS['score'])) {
			$score = $HTTP_GET_VARS['score'];
		}
		$out = "";
		$out .= "<table width=\"100%\" border=\"0\" cellspacing=\"1\"".
				"cellpadding=\"2\">\n";
		$out .= "<tr><td class=\"commentbox\" align=\"left\"><a name=\"banner\" href=\"".
			$this->session->newsurls($news_id,'','',$year,$month,$day,$score).
			"\"><font color=\"#ffffff\">\n";
		$out .= $news->show_title($news_id);
		$out .= "</font></a> | ";
		$out .= "<a href=\"".$config->basehref.
				"users/?a=na\"><font color=\"#ffffff\">"."Nouveau Compte".
				"</font></a> | <b>";
		$counttmp = $news->count_comments($news_id);
		$out .= $counttmp . "</b> ";
		if ($counttmp <= 1) {
			$out .= "commentaire"."\n";
		} else {
			$out .= "commentaires"."\n";
		}

		$out .= "</td></tr>\n";
		$out .= "<tr><td class=\"commentboxmiddle\" align=\"left\">\n";
		$out .= "<form method=\"POST\" action=\"".$config->basehref.$config->commaddfile."\">\n";
		$out .= "<input type=\"hidden\" name=\"news_id\" value=\"$news_id\">\n";
		$out .= "<input type=\"hidden\" name=\"year\" value=\"$year\">\n";
		$out .= "<input type=\"hidden\" name=\"month\" value=\"$month\">\n";
		$out .= "<input type=\"hidden\" name=\"day\" value=\"$day\">\n";

		if (!empty($section)) {
			$out .= "<input type=\"hidden\" name=\"section\" value=\"$section\">\n";
		} else {
			$out .= "<input type=\"hidden\" name=\"section\" value=\"0\">\n";
		}

		if (!empty($topic)) {
			$out .= "<input type=\"hidden\" name=\"topic\" value=\"$topic\">\n";
		} else {
			$out .= "<input type=\"hidden\" name=\"topic\" value=\"0\">\n";
		}

		$out .= "<input type=\"checkbox\" name=\"hide_sig\"";
		if ($config->hide_sig == "1") {
			$out .= " checked>\n";
		} else {
			$out .= ">\n";
		}
		$out .= "Score: <select name=\"score\">\n";
		for ($i=-1;$i<6;$i++) {
			$counttmp = $news->count_comments($news_id,$i);
			$out .= "<option value=\"$i\" ";

			if ($i == $score || (!isset($score) && $this->session->score == $i)) {
				$out .= "selected";
			}

			$out .= ">$i: $counttmp ";
			if ($counttmp <= 1) {
				$out .= "commentaire"."\n";
			} else {
				$out .= "commentaires"."\n";
			}
		}
		$out .= "</select>";
		$out .= "<input type=\"submit\" name=\"op\"".
				" value=\""."Changer"."\">\n";
		$out .= "<input type=\"submit\" name=\"op\"".
				" value=\""."Rpondre"."\">\n</form></td></tr>\n";
		$out .= "<tr><td class=\"commentbox\">\n";
		$out .= "<b>Note</b>: Les commentaires appartiennent  ceux qui les".
				" ont posts. Nous n'en sommes pas responsables.\n";
		$out .= "</td></tr></table><br><br>\n";

		return $out;
	}

}
?>
