<?php
/* daCode http://www.dacode.org/
 *
 * $Id: tips.php3,v 1.20 2001/07/12 09:48:15 penso Exp $
 *
 * Depends: Config Db Html User
*/

Class Tips {
	var $db, $html, $session, $cache;

	Function Tips() {
		$this->db = LoadClass('Db');
		$this->session = LoadClass('Session');
		$this->html = LoadClass('Html');
		$this->cache = LoadClass('Cache');
	}

	Function get_random() {
		global $config;

		$cachetmp = array ($this->session->checked,$config->ext,$this->session->is_moderator||$this->session->is_admin);

		$fcontents = $this->cache->check_box("300","tips", $cachetmp);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		$sqlc_q = "SELECT count(*) FROM ".$config->tables['tips'].
		  " WHERE state='1'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: ".$this->db->error()."-->\n";
			return;
		}
		$row = $this->db->fetch_array();
		$this->db->free();

		if ($row[0] == 0) {
			$tmp = "<center>".lecho("No tips yet")."</center>";
			$title = lecho("Tip");
		} else {

			if ($row[0] >= 2) {
				$number = mt_rand(0,($row[0] - 1));
			} else {
				$number = $row[0] - 1;
			}

			$sqlc_q = "SELECT ".
			  $config->tables['tips'].".tip,".
			  $config->tables['tips'].".name,".
			  $config->tables['tips'].".timestamp,".
			  $config->tables['users'].".login,".
			  $config->tables['users'].".fname,".
			  $config->tables['users'].".lname,".
			  $config->tables['tips_sections'].".tip_section,".
			  $config->tables['tips'].".id AS id".
			  " FROM ".$config->tables['tips'].",".
			  $config->tables['users'].",".
			  $config->tables['tips_sections'] . " WHERE ".
			  $config->tables['tips'].".user_id=".
			  $config->tables['users'].".id AND ".
			  $config->tables['tips'].".tip_section_id=".
			  $config->tables['tips_sections'].".id AND ".
			  $config->tables['tips'].".state='1' ".
			  $this->db->compat_limit(1,$number);
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo "<!-- SQL failed: ".$this->db->error()."-->\n";
				return;
			}
			$row = $this->db->fetch_array();
			$this->db->free();

			$row['tip'] = ereg_replace(
				"((ftp://)|(http://))(([[:alnum:]]|[[:punct:]])*)",
				"<a href=\"\\0\"><b>[url]</b></a>",$row['tip']);

			$tmp = "<center><b>" . $row['tip_section'] . " - " . $row['name'] .
			  "</b></center><br>\n" . $row['tip'] . "<br><br><center> (";

			if (!empty($row['fname']) || !empty($row['lname'])) {
				$tmp .= htmlentities($row['fname']) . " " . htmlentities($row['lname']);
			} else {
				$tmp .= htmlentities($row['login']);
			}

			$tmp .= ") <br>\n";

			if (!$this->session->is_moderator &&
				!$this->session->is_admin) {
				$title = "<!-- TIPTITLE:".$row['id'].
				  " --><a href=\"".$config->basehref."tips/\">".lecho("Tip").
				  "</a><!-- /TIPTITLE -->\n";
			} else {
				$title = " <!-- TIPTITLE:".$row['id'].
				  " --><a href=\"".$config->basehref."tips/\">".lecho("Tip").
				  "</a> - <a href=\"".$config->basehref. "tips/".$config->tipsadminfile.
				  "?tip_id=".$row['id']."\">".lecho("Edit!")."</a><!-- /TIPTITLE -->\n";
			}
		}

		if ($this->session->checked) {
			$tmp .= "<a href=\"".$config->basehref."tips/submit.".$config->php.
			  "\">".lecho("Submit a tip")."!</a>";
		} else {
			$tmp .= lecho("Must be logged to submit a tip.");
		}

		$tmp .= "</center>\n";
		$tmp = $this->html->sidebox($title,$tmp);
		$this->cache->write_box("tips",$cachetmp,$tmp);
		return $tmp;
	}

	Function tips_list($nb_tips,$tip_section,$tip_index) {
		global $config;

		$sqlc_q = "SELECT count(*) FROM ".$config->tables['tips'].
		  " WHERE state='1'";
		if ($tip_section<>"") {
		  	$sqlc_q .= " AND ".$config->tables['tips'].".tip_section_id='".
			  addslashes($tip_section)."'";
		}
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL failed: ".$this->db->error()."-->\n";
			return;
		}
		$row = $this->db->fetch_array();
		$this->db->free();

		$i=0;
		if ($row[0] == 0) {
			$tmp = "<center>".lecho("No tips yet")."</center>";
			$title = lecho("Tip");
		} else {

			$nb_tips_total = $row[0];

			$sqlc_q = "SELECT ".
			  $config->tables['tips'].".tip,".
			  $config->tables['tips'].".name,".
			  $config->tables['tips'].".timestamp,".
			  $config->tables['users'].".login,".
			  $config->tables['users'].".fname,".
			  $config->tables['users'].".lname,".
			  $config->tables['tips_sections'].".tip_section,".
			  $config->tables['tips'].".id AS id".
			  " FROM ".$config->tables['tips'].",".
			  $config->tables['users'].",".
			  $config->tables['tips_sections'] . " WHERE ".
			  $config->tables['tips'].".user_id=".
			  $config->tables['users'].".id AND ".
			  $config->tables['tips'].".tip_section_id=".
			  $config->tables['tips_sections'].".id AND ";

			if ($tip_section<>"") {
			  	$sqlc_q .= $config->tables['tips'].".tip_section_id=".addslashes($tip_section).
				  " AND ";
			}

			$sqlc_q .= $config->tables['tips'].".state='1' ".
			  "ORDER BY ".$config->tables['tips'].".timestamp DESC ";

			if ($tip_index<>"") {
 				$sqlc_q .= $this->db->compat_limit($nb_tips,$tip_index);
			} else {
				$sqlc_q .= $this->db->compat_limit($nb_tips,0);
			}

			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo "<!-- SQL failed: ".$this->db->error()."-->\n";
				return;
			}

			$page = "<table width=\"100%\">\n";
			while($row=$this->db->fetch_array()) {
				$i++;

				$row['tip'] = ereg_replace(
					"((ftp://)|(http://))(([[:alnum:]]|[[:punct:]])*)",
					"<a href=\"\\0\"><b>[url]</b></a>",$row['tip']);

				$tmp = "<b><center>" . $row['name'] . "</center></b><br>" .
				  $row['tip'] . "<br><br><center> (";

				if (!empty($row['fname']) || !empty($row['lname'])) {
					$tmp .= htmlentities($row['fname']) . " " . htmlentities($row['lname']);
				} else {
					$tmp .= htmlentities($row['login']);
				}

				$tmp .= ") <br>\n";

				$title = $row['tip_section'];

				if ($this->session->checked &&
							($this->session->is_admin ||
							$this->session->is_moderator)) {
					$title = $row['tip_section']." - <a href=\"".$config->basehref.
					  "tips/".$config->tipsadminfile.
					  "?tip_id=".$row['id']."\">".lecho("Edit!")."</a>\n";
				}

				$tmp .= "</center>\n";

				$i % 2 ?
				  $page .= "<tr><td valign=\"top\" width=\"50%\">".
				  $this->html->sidebox($title,$tmp)."</td>" :
				  $page .= "<td valign=\"top\" width=\"50%\">".
				  $this->html->sidebox($title,$tmp)."</td></tr>";
			}
			$this->db->free();
		}
		if ( $i != 0 ) {
			$i % 2 ? $page .= "</tr></table>\n" : $page .= "</table>\n";
		}
		if ($tip_section<>"") {
			$url_section = "tip_section=$tip_section&amp;";
		}

		$prev = $next = "";
		if ($tip_index >= $nb_tips) {
			$prev = "<a href=\"index.".$config->php."?".$url_section."tip_index=";
			$prev .= $tip_index-$nb_tips;
			$prev .= "\"> &lt;&lt; ".lecho("Previous Tips")."</a>";
		}
		if ($tip_index+$nb_tips <= $nb_tips_total) {
			$next = "<a href=\"index.".$config->php."?".$url_section."tip_index=";
			$next .= $tip_index+$nb_tips;
			$next .= "\">".lecho("Next Tips")." &gt;&gt; </a>";
		}

		$page .= "<table width=\"100%\"><tr><td class=\"newstext\" width=\"50%\" align=\"left\">". $prev .
		  "</td><td class=\"rightnewstext\" width=\"50%\" align=\"right\">". $next ."</td></tr></table>";

		return $page;
	}

	Function tips_to_moderate() {
		global $config;
		$tmp = "";

		if (!$this->session->checked || !$this->session->is_admin &&
			!$this->session->is_moderator) {
			return;
		}

		$sqlc_q = "SELECT ".
		  $config->tables['tips'].".id AS id,".
		  $config->tables['tips'].".tip,".
		  $config->tables['tips'].".name,".
		  $config->tables['tips_sections'].".tip_section".
		  " FROM ".$config->tables['tips'].",".
		  $config->tables['tips_sections'] . " WHERE ".
		  $config->tables['tips'].".tip_section_id=".
		  $config->tables['tips_sections'].".id AND tips.state='0'";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			return lecho("Tips: SQL Error !")."<br>\n";
		}

		while($row=$this->db->fetch_array()) {
			$row['id'] = htmlentities(stripslashes($row['id']));
			$row['name'] = htmlentities(stripslashes($row['name']));
			$row['tip'] = htmlentities(stripslashes($row['tip']));

			$tmp .= "&nbsp;-&nbsp;[".lecho("Tip")."]&nbsp;".$row['tip_section'].
			  "-<a href=\"". $config->basehref."tips/".$config->tipsadminfile.
			  "?tip_id=".$row['id']."\">".$row['name']."</a><br>\n";

		}

		$this->db->free();

		return $tmp;
	}

	Function show_tips_to_moderate($id) {
		global $config;

		if (!$this->session->checked || !$this->session->is_admin &&
			!$this->session->is_moderator) {
			return;
		}

		$tmp = "";
		$sqlc_q = "SELECT ".
		  $config->tables['tips'].".tip,".
		  $config->tables['tips'].".name,".
		  $config->tables['tips'].".timestamp,".
		  $config->tables['users'].".login,".
		  $config->tables['users'].".fname,".
		  $config->tables['users'].".lname,".
		  $config->tables['tips_sections'].".tip_section,".
		  $config->tables['tips'].".id AS id".
		  " FROM ".$config->tables['tips'].",".
		  $config->tables['users'].",".
		  $config->tables['tips_sections'] . " WHERE ".
		  $config->tables['tips'].".user_id=".
		  $config->tables['users'].".id AND ".
		  $config->tables['tips'].".tip_section_id=".
		  $config->tables['tips_sections'].".id AND tips.id='".
		  addslashes($id)."'";

		$ret=$this->db->query($sqlc_q);
		if(!$ret) {
			return lecho("Tips: SQL Request Failed: ")."\n".$sqlc_q."\n";
		}

		$row=$this->db->fetch_array();

		$tmp .= "<form action=\"".$config->basehref."tips/".
		  $config->tipschangefile."\">";

		$tmp .= "<b><center>\n<select name=\"table[tip_section]\">\n";
		$sqlc_q = "SELECT id,tip_section FROM ". $config->tables['tips_sections'].
		  " ORDER BY tip_section";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			return lecho("Tips: SQL Request Failed: ")."\n".$sqlc_q."\n";
		}

		while($sectionrow=$this->db->fetch_array()) {
			if ($sectionrow['tip_section'] == $row['tip_section'] ) {
				$tmp .= "<option value=\"".$sectionrow['id']."\" selected>".
				  $sectionrow['tip_section']."</OPTION>\n";
			} else {
				$tmp .= "<option value=\"".$sectionrow['id']."\">".
				  $sectionrow['tip_section']."</option>\n";
			}
		}

		$tmp .= "</select>\n - <input type=\"text\" name=\"table[name]\" value=\"" .
		  $row['name'];
		$tmp .= "\"></b><br>";
		$tmp .= "<textarea name=\"table[tip]\" rows=\"10\" cols=\"50\">" .
		  $row['tip'] . "</textarea><BR>\n (";

		if (!empty($row['fname']) || !empty($row['lname'])) {
			$tmp .= htmlentities($row['fname']) . " " . htmlentities($row['lname']);
		} else {
			$tmp .= htmlentities($row['login']);
		}

		$tmp .= ")<br><br>\n";

		$tmp .= "<input type=\"hidden\" name=\"table[id]\" value=\"".$row['id']."\">".
		  "<input type=\"submit\" value=\"Valider\" name=\"table[submit]\">".
		  "<input type=\"submit\" value=\"Effacer\" name=\"table[submit]\">".
		  "</form></center>";

		$title = lecho("Moderate a tip");
		return $this->html->sidebox($title,$tmp);
	}

	Function do_moderate($row) {
		global $config;

		if (!$this->session->checked || !$this->session->is_moderator &&
			!$this->session->is_admin) {
			return;
		}

		if ($row['submit'] == "Valider") {
			$sqlc_q = "UPDATE ". $config->tables['tips']." SET ".
				"state='1',".
				"name='".addslashes($row['name'])."',".
				"tip='".addslashes($row['tip'])."',".
				"tip_section_id='".addslashes($row['tip_section'])."' WHERE ".
				"id='".addslashes($row['id'])."'";
		} elseif ($row['submit'] == "Effacer") {
			$sqlc_q = "DELETE FROM ". $config->tables['tips']." WHERE id='".addslashes($row['id'])."'";
		} else {
			return;
		}

		$ret=$this->db->query($sqlc_q);
		if(!$ret) {
			echo "<!-- SQL failed: ".$this->db->error()."-->\n";
			return lecho("Tips: SQL Request Failed: ")."\n".$sqlc_q."\n";
		}

		$this->cache->delete_boxfiles('tips',0,0,0,'.');
		$this->cache->delete_boxfiles('tips_sections',0,0,0,'.');

		return;
	}

	Function tips_sections() {
		global $config;

		$fcontents = $this->cache->check_box("300","tips_sections", $config->ext);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		$out = "";
		$sqlc_q = "SELECT id,tip_section FROM ". $config->tables['tips_sections'].
			" ORDER BY tip_section";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL Failed: ".$this->db->error()."-->";
			return;
		}

		while($row=$this->db->fetch_array()) {
			$out .= "&nbsp;-&nbsp;<a href=\"".$config->basehref."tips/index.".$config->php."?tip_section=" .
			  $row[0] . "\">$row[1]</a><br>";
		}
		$title = "<a href=\"".$config->basehref."tips/\">".lecho("Tip")."</a>";

		$out = $this->html->sidebox($title,$out);
		$this->cache->write_box("tips_sections",$config->ext,$out);
		return $out;
	}

}

?>
