
#ifndef _LIBIBERTY_H_
#define _LIBIBERTY_H_

#include <sys/cdefs.h>
#include <stdlib.h>

#include "getopt.h"

struct qelem {
	struct qelem *q_forw;
	struct qelem *q_back;
};

__BEGIN_DECLS
char    *basename __P((const char *));
char    *concat __P((char *, ...));
int      error_max __P((void));
int      fdmatch __P((int, int));
long     get_run_time __P((void));
void     insque __P((struct qelem *, struct qelem *));
void     remque __P((struct qelem *));
int      signo_max __P((void));
char    *spaces __P((int));
const char    *strerrno __P((int));
const char    *strsigno __P((int));
int      strtoerrno __P((const char *));
int      strtosigno __P((const char *));
void    *xcalloc __P((size_t, size_t));
void     xexit __P((int));
void    *xmalloc __P((size_t));
void    *xrealloc __P((void *, size_t));
char	*xstrdup __P((const char *));
char    *xstrerror __P((int));
__END_DECLS

#endif /* !_LIBIBERTY_H_ */
