#
# FtpCube
# Copyright (C) 2001 Michael Gilfix
#
# This file is part of FtpCube.
#
# You should have received a file COPYING containing license terms
# along with this program; if not, write to Michael Gilfix
# (mgilfix@eecs.tufts.edu) for a copy.
#
# This version of FtpCube is open source; you can redistribute it and/or
# modify it under the terms listed in the file COPYING.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#

# Import checking code - Check if we can actually
# import in the pygtk stuff and report an intelligeable
# error to the user if we can't
import sys, os

from intl import _

failure = None

try:
	import gtk, GtkExtra
except ImportError, strerror:
	failure = strerror

# Import the appropriate GTK constant file. In the win32 pygtk
# package, GTK is GTKconst
if os.name == "nt":
	try:
		import GTKconst
	except ImportError, strerror:
		failure = strerror
else:
	try:
		import GTK
	except ImportError, strerror:
		failure = strerror

if failure is not None:
	sys.stderr.write (_("ftpcube - Compilation Error: %s.\n") %failure)
	sys.stderr.write (_("\tUnable to import the pygtk modules.\n"))
	sys.stderr.write (_("\tFtpCube cannot run without pygtk modules properly installed.\n"))
	sys.stderr.write (_("\tFor more information on how to obtain these vital packages, visit:\n"))
	sys.stderr.write (_("\t\thttp://ftpcube.sourceforge.net\n"))
	sys.exit (1)

__all__ = [
	'aboutwin',
	'app',
	'bookmarkwin',
	'cmdwin',
	'connectwin',
	'ctrlwin',
	'defaults',
	'filewin',
	'ftp',
	'logging',
	'main',
	'optionwin',
	'threads',
	'intl',
	'cache',
	'browsewin'
]
