#
# FtpCube
# Copyright (C) 2001 Michael Gilfix
#
# This file is part of FtpCube.
#
# You should have received a file COPYING containing license terms
# along with this program; if not, write to Michael Gilfix
# (mgilfix@eecs.tufts.edu) for a copy.
#
# This version of FtpCube is open source; you can redistribute it and/or
# modify it under the terms listed in the file COPYING.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#

import GtkExtra
import os
import main

from intl import _

class AboutWindow:

	"""About Window class

	Implements the about window object, which provides a popup window
	with a brief description of the program. This object is accessable
	through the main menu."""

	def __init__ (self):
		"""Initializes the AboutWindow object and creates the about
		window popup."""

		GtkExtra.message_box (title=_("ftpcube - About"),
		                      message=self.about_text (),
		                      pixmap=os.path.join (main.ICONS_PREFIX, "ftpcube.xpm"),
		                      buttons=( [ _("Ok") ] ))

	def about_text (self):
		"""Returns the about message"""

		return \
_("""FtpCube - A graphical FTP Client\n
FtpCube is a graphical ftp client written in Python with GTK bindings, and based on LeechFTP by Jan Debis.
Feel free to visit the homepage at: http://ftpcube.sourceforge.net.\n
Michael Gilfix <mgilfix@eecs.tufts.edu>
Copyright (C) 2001
Licensing: ARTISTIC""")
