//-< REFERENCE.H >---------------------------------------------------*--------*
// GigaBASE                  Version 1.0         (c) 1999  GARRET    *     ?  *
// (Post Relational Database Management System)                      *   /\|  *
//                                                                   *  /  \  *
//                          Created:     20-Nov-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 10-Dec-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// Database table field reference type
//-------------------------------------------------------------------*--------*

#ifndef __REFERENCE_H__
#define __REFERENCE_H__

BEGIN_GIGABASE_NAMESPACE

class GIGABASE_DLL_ENTRY dbAnyReference {
    friend class dbAnyCursor;
    friend class dbDatabase;
    friend class dbFieldDescriptor;
  protected:
    oid_t       oid;

  public:
    dbAnyReference(oid_t oid = 0) {
	this->oid = oid;
    }
    oid_t getOid() const {
	return oid;
    }
    friend bool isNull(dbAnyReference const& ref) {
	return ref.oid == 0;
    }
    dbAnyReference& operator = (dbAnyReference const& ref) {
	oid = ref.oid;
	return *this;
    }
    bool isNull() { return oid == 0; }

    dbFieldDescriptor* dbDescribeComponents(dbFieldDescriptor* fd) {
        fd->type = fd->appType = dbField::tpReference;
        fd->refTable = NULL;
	fd->dbsSize = fd->alignment = sizeof(oid_t);
        return NULL;
    }
};

class GIGABASE_DLL_ENTRY dbNullReference {};

extern GIGABASE_DLL_ENTRY dbNullReference null;

#if defined(_MSC_VER) && _MSC_VER+0 <= 1100
//
// Visual C++ prior to 5.0 version (with applied Service Pack 3)
// didn't support lazy template instantiation. As far as VC has bug
// with treating local function prototypes, we have to use friend function.
//
template<class T>
extern dbTableDescriptor* dbGetTableDescriptor(T*);
#endif


template<class T>
class dbReference : public dbAnyReference {
  public:
    dbFieldDescriptor* dbDescribeComponents(dbFieldDescriptor* fd) {
        fd->type = fd->appType = dbField::tpReference;
#if defined(_MSC_VER) && _MSC_VER+0 <= 1100 
	fd->refTable = dbGetTableDescriptor((T*)0);
#else
#if (defined(__GNUC__) && __GNUC_MINOR__ <= 95) || defined(__VACPP_MULTI__) || defined(__IBMCPP__)
	extern dbTableDescriptor* dbGetTableDescriptor(T*);
	fd->refTable = dbGetTableDescriptor((T*)0);
#else
        fd->refTable = &T::dbDescriptor;
#endif
#endif
	fd->dbsSize = fd->alignment = sizeof(oid_t);
        return NULL;
    }

    dbReference<T>& operator = (dbReference<T> const& ref) {
	oid = ref.oid;
	return *this;
    }
    dbReference<T>& operator = (dbNullReference const&) {
	oid = 0;
	return *this;
    }
    dbReference<T>& unsafeAssign(dbAnyReference const& ref) {
	oid = ref.getOid();
	return *this;
    }

    bool operator == (dbReference<T> const& ref) const {
	return oid == ref.oid;
    }
    bool operator != (dbReference<T> const& ref) const {
	return oid != ref.oid;
    }
    bool operator == (dbNullReference const&) const {
	return oid == 0;
    }
    bool operator != (dbNullReference const&) const {
	return oid != 0;
    }

    dbReference(dbNullReference const&) : dbAnyReference(0) {}
    dbReference(dbReference<T> const& ref) : dbAnyReference(ref.oid) {}
    dbReference(oid_t oid=0) : dbAnyReference(oid) {}
};

END_GIGABASE_NAMESPACE

#endif





