/*
    GSK - a library to write servers
    Copyright (C) 1999-2000 Dave Benson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
*/

/* GskActor: a generic class that can be added to a main loop.  */

#ifndef __GSK_ACTOR_H_
#define __GSK_ACTOR_H_

typedef struct _GskActor GskActor;
typedef struct _GskActorClass GskActorClass;

#include "gskmainloop.h"

/* --- type macros --- */
GtkType gsk_actor_get_type();
#define GSK_TYPE_ACTOR			(gsk_actor_get_type ())
#define GSK_ACTOR(obj)              (GTK_CHECK_CAST ((obj), GSK_TYPE_ACTOR, GskActor))
#define GSK_ACTOR_CLASS(klass)      (GTK_CHECK_CLASS_CAST ((klass), GSK_TYPE_ACTOR, GskActorClass))
#define GSK_ACTOR_GET_CLASS(obj)    (GSK_ACTOR_CLASS(GTK_OBJECT(obj)->klass))
#define GSK_IS_ACTOR(obj)           (GTK_CHECK_TYPE ((obj), GSK_TYPE_ACTOR))
#define GSK_IS_ACTOR_CLASS(klass)   (GTK_CHECK_CLASS_TYPE ((klass), GSK_TYPE_ACTOR))

/* --- structures & typedefs --- */

struct _GskActorClass
{
  GtkObjectClass  base;
  void          (*added_main_loop)    (GskActor      *actor);
  void          (*removing_main_loop) (GskActor      *actor);

  void          (*blocked)            (GskActor      *actor);
  void          (*unblocked)          (GskActor      *actor);
};

struct _GskActor
{
  GtkObject	base;
  int		block_count;
  GskMainLoop  *main_loop;

  /* id for connection to the main loop's `destroy' signal */
  guint         main_loop_destroy_id;
};

/* --- public prototypes --- */
void            gsk_actor_block        (GskActor    *actor);
void            gsk_actor_unblock      (GskActor    *actor);
void            gsk_actor_set_main_loop(GskActor    *actor,
                                        GskMainLoop *main_loop);

/* Private.  (For backward compatbility purposes only) */
void            _gsk_actor_addto_mainloop(GskActor *actor, GskMainLoop *loop);


#endif
