/*
    GSK - a library to write servers
    Copyright (C) 1999-2000 Dave Benson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
*/

/*
 * An actor to handle a listening file descriptor.
 */

#ifndef __GSK_ACTOR_LISTENER_H_
#define __GSK_ACTOR_LISTENER_H_

#include "gskactor.h"
#include "gsksocketlistener.h"

/* --- type macros --- */
GtkType gsk_actor_listener_get_type();
#define GSK_TYPE_ACTOR_LISTENER		     (gsk_actor_listener_get_type ())
#define GSK_ACTOR_LISTENER(obj)              (GTK_CHECK_CAST ((obj), GSK_TYPE_ACTOR_LISTENER, GskActorListener))
#define GSK_ACTOR_LISTENER_CLASS(klass)      (GTK_CHECK_CLASS_CAST ((klass), GSK_TYPE_ACTOR_LISTENER, GskActorListenerClass))
#define GSK_IS_ACTOR_LISTENER(obj)           (GTK_CHECK_TYPE ((obj), GSK_TYPE_ACTOR_LISTENER))
#define GSK_IS_ACTOR_LISTENER_CLASS(klass)   (GTK_CHECK_CLASS_TYPE ((klass), GSK_TYPE_ACTOR_LISTENER))


/* --- structures & typedefs --- */
typedef struct _GskActorListener GskActorListener;
typedef struct _GskActorListenerClass GskActorListenerClass;

struct _GskActorListenerClass
{
  GskActorClass 	  actor_class;
  gboolean              (*on_accept)(GskActorListener *actor,
                                     GskMainLoop      *main_loop,
                                     GskStreamSocket  *accepted,
                                     GskSocketAddress *addr);
};

/*
 * The return value indicates whether we should try to accept
 * on this listener again.
 */

struct _GskActorListener
{
  GskActor		   actor;
  GskSocketListener       *listener;
  GskSource               *source;
  guint			   accept_count;
  unsigned                 tcp_reuse_address : 1;

  /* to avoid recursing while removing the main loop on destroyed handlers */
  unsigned                 removing_main_loop : 1;
};

/* --- public method prototypes --- */
gboolean gsk_actor_listener_set_listener(GskActorListener         *actor,
				         GskSocketListener        *listener);

#endif
