#ifndef __GSK_ARRAYED_ARG_INFO_H_
#define __GSK_ARRAYED_ARG_INFO_H_

/* Arrayed arguments */
typedef struct _GskArrayedArgInfo GskArrayedArgInfo;

#include "gskgtk.h"

struct _GskArrayedArgInfo
{
  GtkType     type;
  GtkType     subtype;
  const char *name;
  void       (*append)(GtkObject *, GtkArg *);
  guint      (*count) (GtkObject *);
  gboolean   (*lookup)(GtkObject *, guint, GtkArg *out);
};

void                gsk_arrayed_arg_info_register(GskArrayedArgInfo *arg_info);
GskArrayedArgInfo * gsk_arrayed_arg_info_lookup  (GtkType            type,
                                                  const char        *name);

/* Helper functions. */
gboolean            gsk_arrayed_arg_append       (GtkObject         *object,
						  GtkArg            *sub);
gboolean            gsk_arrayed_arg_lookup       (GtkObject         *object,
                                                  guint              index,
						  GtkArg            *arg_out);
guint               gsk_arrayed_arg_count        (GtkObject         *object,
                                                  const char        *arg_name);

gboolean            gsk_arrayed_arg_is_arrayed_arg(GtkType           type,
                                                   const char       *arg_name);

#endif
