/*
    GSK - a library to write servers
    Copyright (C) 1999-2000 Dave Benson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
*/

#ifndef __GSK_BASIC_H_
#define __GSK_BASIC_H_

#include "gskdebug.h"

#include <glib.h>

#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <assert.h>
#include <unistd.h>
#include <sys/socket.h>

/* For compatibility. */
#include "gsklog.h"

extern int gsk_debug;

#define gsk_skip_char_type(char_ptr, condition)			\
	G_STMT_START {						\
		while (*(char_ptr) && condition (* (char_ptr)))	\
			(char_ptr)++;				\
	             } G_STMT_END

#define gsk_skip_whitespace(char_ptr)    gsk_skip_char_type(char_ptr,  isspace)
#define gsk_skip_nonwhitespace(char_ptr) gsk_skip_char_type(char_ptr, !isspace)
#define gsk_skip_alpha(char_ptr)         gsk_skip_char_type(char_ptr,  isalpha)
#define gsk_skip_nonalpha(char_ptr)      gsk_skip_char_type(char_ptr, !isalpha)
#define gsk_skip_alnum(char_ptr)         gsk_skip_char_type(char_ptr,  isalnum)
#define gsk_skip_nonalnum(char_ptr)      gsk_skip_char_type(char_ptr, !isalnum)
#define gsk_skip_digit(char_ptr)         gsk_skip_char_type(char_ptr,  isdigit)
#define gsk_skip_nondigit(char_ptr)      gsk_skip_char_type(char_ptr, !isdigit)

#define g_goto_if_fail(expr, label)		G_STMT_START{		\
     if (!(expr))							\
       {								\
	 g_log (G_LOG_DOMAIN,						\
		G_LOG_LEVEL_CRITICAL,					\
		"file %s: line %d (%s): assertion `%s' failed.",	\
		__FILE__,						\
		__LINE__,						\
		__PRETTY_FUNCTION__,					\
		#expr);							\
	 goto label;							\
       };				}G_STMT_END

/* This is either G_BIG_ENDIAN or G_LITTLE_ENDIAN;
 * you can use G_BYTE_ORDER to use the native endianness.
 *
 * BigEndian means that the 32-bit number 0x01020304
 * when written directly to a file (maybe with fwrite(3))
 * will output the four bytes,
 *    0x01 0x02 0x03 0x04
 * and LittleEndian means the result will be
 *    0x04 0x03 0x02 0x01
 */
#define GskByteOrder guint

#endif
