/*
    GSK - a library to write servers
    Copyright (C) 1999-2000 Dave Benson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
*/


#ifndef __GSK_ARG_H_
#define __GSK_ARG_H_

#include "gskbasic.h"
#include "gtk/gtkarg.h"
#include "gtk/gtkobject.h"
#include "gtk/gtksignal.h"

/* Use Gsk's somewhat different argument handling rules:
 *
 * In gsk, we hold a reference to GtkArg->object.
 */
char     *gsk_gtk_arg_to_string        (GtkArg   *arg);
GtkArg   *gsk_gtk_arg_new              (GtkType   type);
void      gsk_gtk_arg_destruct         (GtkArg   *arg);
void      gsk_gtk_arg_destroy          (GtkArg   *arg);
void      gsk_gtk_arg_destroy_array    (GtkArg   *args,
                                        guint     num_args);
void      gsk_gtk_arg_destruct_array   (GtkArg   *args,
                                        guint     num_args);

void      gsk_gtk_arg_copy             (GtkArg   *dst_arg,
                                        GtkArg   *src_arg);

/* Make a new sunk object. */
GtkObject *gsk_gtk_object_new          (GtkType   type);

/* Memory-tracking safe versions of some functions. */
GtkArg   *gsk_gtk_object_query_args    (GtkType   type,
                                        guint32 **arg_flags,
                                        guint    *num_args);
GtkSignalQuery *gsk_gtk_signal_query   (guint     signal_id);
#define gsk_gtk_signal_query(sigid) gtk_signal_query(sigid)

/* plugin support */
GtkType   gsk_gtk_type_from_name       (const char         *class_name);

/* registering new types of plugins (eg new loading conventions) */
typedef GtkType (*GskGtkTypeLoadFunc)  (const char         *class_name,
                                        gpointer            loader_data);
void      gsk_gtk_type_loader_register (GskGtkTypeLoadFunc  loader_func,
                                        gpointer            loader_data);
#ifdef GSK_DEBUG
GtkObject *gsk_gtk_object_new_debug    (GtkType   type,
					const char *file,
					int       line);
#define gsk_gtk_object_new(type)  \
        gsk_gtk_object_new_debug(type,__FILE__,__LINE__)
#endif

/* Questionable interface: get the size of a GtkType as it will be
   in the GtkArg. */
guint gsk_gtk_arg_value_size (GtkType type);
#endif
