/*
    GSK - a library to write servers
    Copyright (C) 2001 Dave Benson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
*/

/* interfaces:  class-specific functions and data added
 *              outside the class structure (and type hierarchy).
 */

#ifndef __GSK_INTERFACE_H_
#define __GSK_INTERFACE_H_

#include "gskgtk.h"

typedef guint GskInterfaceType;

/* --- define a new class of interface --- */
GskInterfaceType  gsk_interface_register        (guint             iface_size,
                                                 const char       *iface_name);

/* --- define a specific implementation of an interface --- */
void              gsk_interface_implement       (GskInterfaceType  iface_type,
                                                 GtkObjectClass   *impl_class,
					         gpointer          iface);

/* For implementing the casting macros */
#define GSK_INTERFACE_TEST(obj, iface_type) (gsk_interface_test ((GtkObject *) (obj), iface_type))

#ifdef GSK_DEBUG
#define GSK_INTERFACE_CAST(struct_id, obj, iface_type)    ((struct_id *) (gsk_interface_cast ((GtkObject *) (obj), iface_type, __FILE__, __LINE__)))
#define GSK_INTERFACE_GET_IFACE(struct_id, obj, iface_type)    ((struct_id *) (gsk_interface_get_iface ((GtkObject *) (obj), iface_type, __FILE__, __LINE__)))
#endif

/* --- interface implementation querying --- */
gpointer          gsk_interface_type_get_iface  (GtkType           type,
						 GskInterfaceType  iface_type);
const char       *gsk_interface_name            (GskInterfaceType  iface_type);



/* Casting macros:  Fast, non-debug implementations */
#ifndef GSK_DEBUG
#define GSK_INTERFACE_CAST(struct_id, obj, iface_type)		((struct_id *) (obj))
#define GSK_INTERFACE_GET_IFACE(struct_id, obj, iface_type)	(gsk_interface_type_get_iface (((GtkObject *) (obj))->klass->type, iface_type))
#endif

/*< private >*/
gboolean          gsk_interface_test            (GtkObject        *object,
						 GskInterfaceType  iface_type);
gpointer          gsk_interface_cast            (GtkObject        *object,
						 GskInterfaceType  iface_type,
						 const char       *filename,
						 int               line);
gpointer          gsk_interface_get_iface       (GtkObject        *object,
						 GskInterfaceType  iface_type,
						 const char       *filename,
						 int               line);
#endif
