/*
    GSK - a library to write servers
    Copyright (C) 1999-2000 Dave Benson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
*/

#ifndef __GSK_LOG_H_
#define __GSK_LOG_H_

#include <glib.h>

/* --- builtin log types --- */
enum
{
  GSK_LOG_ERR = 1,
  GSK_LOG_LOG,
  GSK_LOG_DEBUG
} GskLogType;

/* --- options for writing a log line --- */
enum {
  GSK_LOG_OPTION_ERRNO 	= (1<<0)
} GskLogOptions;

/* --- function to be called at every log line --- */
typedef void (*GskLogLineHandler)(int                    log_channel_id,
                                  const char            *log_line,
                                  gpointer               handler_data);

/* --- prototypes --- */
/* Simple logging interface. */
void gsk_log_err        (const char*       format,
                         ...);
void gsk_log_errno      (const char*       format,
                         ...);
void gsk_log_log        (const char*       format,
                         ...);
void gsk_log_debug      (const char*       format,
                         ...);

/* More generic logging interface */
void gsk_log            (int               log_type,
                         const char*       format,
		         ...);
void gsk_log_v          (int               log_type,
			 const char*       format,
                         va_list           args);
void gsk_log_full_v     (int               log_id,
			 unsigned          flags,
			 const char       *prefix,
                         const char       *format,
                         va_list           args);


int  gsk_log_channel_new(const char       *name,
                         int               fd);


/* Register a method to call when logs of a particular
 * type are given. */
void gsk_log_trap       (int               log_type,
                         GskLogLineHandler handler,
		         gpointer          handler_data);

#endif
