/*
    GSK - a library to write servers
    Copyright (C) 1999-2000 Dave Benson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
*/


/*
 * A listener:  like a server-socket, listening waiting for connections.
 */

#ifndef __GSK_SOCKET_LISTENER_H_
#define __GSK_SOCKET_LISTENER_H_

#include "gsksocket.h"
#include "gtk/gtkobject.h"

/* --- type macros --- */
GtkType gsk_socket_listener_get_type();
#define GSK_TYPE_SOCKET_LISTENER	      (gsk_socket_listener_get_type ())
#define GSK_SOCKET_LISTENER(obj)              (GTK_CHECK_CAST ((obj), GSK_TYPE_SOCKET_LISTENER, GskSocketListener))
#define GSK_SOCKET_LISTENER_CLASS(klass)      (GTK_CHECK_CLASS_CAST ((klass), GSK_TYPE_SOCKET_LISTENER, GskSocketListenerClass))
#define GSK_SOCKET_LISTENER_GET_CLASS(obj)    (GSK_SOCKET_LISTENER_CLASS(GTK_OBJECT(obj)->klass))
#define GSK_IS_SOCKET_LISTENER(obj)           (GTK_CHECK_TYPE ((obj), GSK_TYPE_SOCKET_LISTENER))
#define GSK_IS_SOCKET_LISTENER_CLASS(klass)   (GTK_CHECK_CLASS_TYPE ((klass), GSK_TYPE_SOCKET_LISTENER))

/* --- structures & typedefs --- */
typedef struct _GskSocketListener GskSocketListener;
typedef struct _GskSocketListenerClass GskSocketListenerClass;

struct _GskSocketListenerClass
{
  GtkObjectClass        base;
  gboolean            (*bind)   (GskSocketListener *listener);
  GskStreamSocket *   (*accept) (GskSocketListener *listener,
                                 GskSocketAddress  *remote_addr,
                                 gboolean          *socket_died);
};

struct _GskSocketListener
{
  GtkObject             object;
  int			fd;
  GskSocketAddress	bind_address;
  char                 *unix_path;
  unsigned		tcp_reuse_address : 1,
                        is_tcp : 1;
};

/* --- public prototypes --- */
#define gsk_socket_listener_get_fd(socket_listener) ((socket_listener)->fd)

GskSocketListener* gsk_socket_listener_new_tcp (GskSocketAddress  *local_addr,
                                                gboolean           reuse_addr);

void               gsk_socket_listener_set_local_port
                                               (GskSocketListener *lis,
                                                int                port);
GskSocketListener* gsk_socket_listener_new_unix(const char        *unix_path);

GskStreamSocket   *gsk_socket_listener_accept  (GskSocketListener *listener,
			                        GskSocketAddress  *remote_addr,
			                        gboolean          *socket_died);
#endif
