/*
    GSK - a library to write servers
    Copyright (C) 1999-2000 Dave Benson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
*/

#ifndef __GSK_SOCKET_LOCATION_H_
#define __GSK_SOCKET_LOCATION_H_

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "gtk/gtkobject.h"
#include "gsksocketaddress.h"

/* --- type macros --- */
GtkType gsk_socket_location_get_type();
#define GSK_TYPE_SOCKET_LOCATION			(gsk_socket_location_get_type ())
#define GSK_SOCKET_LOCATION(obj)              (GTK_CHECK_CAST ((obj), GSK_TYPE_SOCKET_LOCATION, GskSocketLocation))
#define GSK_SOCKET_LOCATION_CLASS(klass)      (GTK_CHECK_CLASS_CAST ((klass), GSK_TYPE_SOCKET_LOCATION, GskSocketLocationClass))
#define GSK_IS_SOCKET_LOCATION(obj)           (GTK_CHECK_TYPE ((obj), GSK_TYPE_SOCKET_LOCATION))
#define GSK_IS_SOCKET_LOCATION_CLASS(klass)   (GTK_CHECK_CLASS_TYPE ((klass), GSK_TYPE_SOCKET_LOCATION))

/* --- structures & typedefs --- */
typedef struct _GskSocketLocation GskSocketLocation;
typedef struct _GskSocketLocationClass GskSocketLocationClass;

struct _GskSocketLocationClass
{
  GtkObjectClass	object_class;
};
struct _GskSocketLocation
{
  GtkObject		object;
  GskSocketAddress      address;
};

/* --- constructors --- */
GskSocketLocation *gsk_socket_location_new    (const GskSocketAddress *address);
GskSocketLocation *gsk_socket_location_new_parsed (const char *spec);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
