#ifndef __GSK_LISP_NODE_H_
#define __GSK_LISP_NODE_H_

typedef struct _GskLispNode GskLispNode;

#include <glib.h>

#define GSK_LISP_NODE_IS_ATOM(node)   ((node)->is_atom)
#define GSK_LISP_NODE_IS_LIST(node)   (!(node)->is_atom)

struct _GskLispNode
{
  gboolean is_atom;
  GskLispNode *parent;
  union {
    GPtrArray *sub_nodes;
    char *atom;
  } info;
};

GskLispNode *gsk_lisp_node_new_atom             (GskLispNode    *parent,
						 const char     *txt);
GskLispNode *gsk_lisp_node_new_list             (GskLispNode    *parent);
void         gsk_lisp_node_list_append          (GskLispNode    *list,
                                                 GskLispNode    *child);
void         gsk_lisp_node_destroy              (GskLispNode    *lisp);
void         gsk_lisp_node_destroy_recursive    (GskLispNode    *lisp);

#endif
