#ifndef __GSK_HTTP_SERVLET_H_
#define __GSK_HTTP_SERVLET_H_

typedef struct _GskHttpServletIface GskHttpServletIface;
typedef struct _GskHttpPredicateIface GskHttpPredicateIface;

#include "../gskinterface.h"
#include "gskhttpserver.h"
#include "gskurl.h"

GskInterfaceType gsk_http_servlet_iface_get_type ();
GskInterfaceType gsk_http_predicate_iface_get_type ();
#define GSK_TYPE_HTTP_SERVLET_IFACE 		(gsk_http_servlet_iface_get_type ())
#define GSK_IS_HTTP_SERVLET(obj)		GSK_INTERFACE_TEST (obj, GSK_TYPE_HTTP_SERVLET_IFACE)
#define GSK_HTTP_SERVLET(obj)			GSK_INTERFACE_CAST (GskHttpServlet, obj, GSK_TYPE_HTTP_SERVLET_IFACE)
#define GSK_HTTP_SERVLET_GET_IFACE(obj)		GSK_INTERFACE_GET_IFACE (GskHttpServletIface, obj, GSK_TYPE_HTTP_SERVLET_IFACE)
#define GSK_TYPE_HTTP_PREDICATE_IFACE 		(gsk_http_predicate_iface_get_type ())
#define GSK_IS_HTTP_PREDICATE(obj)		GSK_INTERFACE_TEST (obj, GSK_TYPE_HTTP_PREDICATE_IFACE)
#define GSK_HTTP_PREDICATE(obj)			GSK_INTERFACE_CAST (GskHttpPredicate, obj, GSK_TYPE_HTTP_PREDICATE_IFACE)
#define GSK_HTTP_PREDICATE_GET_IFACE(obj)	GSK_INTERFACE_GET_IFACE (GskHttpPredicateIface, obj, GSK_TYPE_HTTP_PREDICATE_IFACE)


/* interface to test whether we can handle a query */
struct _GskHttpPredicateIface
{
  gboolean  (*test)     (GskHttpPredicate   *predicate,
			 GskHttpHeader      *header);
};

struct _GskHttpServletIface
{
  gboolean (*process_request)      (GskHttpServlet *servlet,
				    GskHttpHeader  *header,
				    GskHttpServer  *server);
  gboolean (*process_post)         (GskHttpServlet *servlet,
				    gconstpointer   data,
				    guint           len,
				    GskHttpServer  *server);
};
/* --- specific types of servlets and predicates --- */
GskHttpServlet   *gsk_http_servlet_new_url_map    (GskUrl         *base_url,
						   const char     *path_prefix);
GskHttpPredicate *gsk_http_predicate_new_uri_slice(const char     *hostname,
						   const char     *path_prefix,
						   const char     *extension);

/*< private >*/
/* generic code to manipulate lists of servlets */
GskHttpServletList *gsk_http_servlet_list_new ();
void                gsk_http_servlet_list_append (GskHttpServletList *list,
					          GskHttpPredicate   *pred,
					          GskHttpServlet     *servlet);
void                gsk_http_servlet_list_prepend(GskHttpServletList *list,
					          GskHttpPredicate   *pred,
					          GskHttpServlet     *servlet);
GskHttpServlet     *gsk_http_servlet_list_match  (GskHttpServletList *list,
						  GskHttpHeader      *header);
void                gsk_http_servlet_list_ref    (GskHttpServletList *list);
void                gsk_http_servlet_list_unref  (GskHttpServletList *list);

/* usually not needed */
void              gsk_http_servlet_builtins_init ();

#endif
