/*
    GSK - a library to write servers
    Copyright (C) 1999-2000 Dave Benson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
*/

#ifndef __GSK_SIMPLE_PROXY_H_
#define __GSK_SIMPLE_PROXY_H_

#include "../gskmainloop.h"
#include "../gskactorbuffered.h"
#include "../gsksocketlistener.h"
#include "../gskactorlistener.h"
#include <stdio.h>
#include <ctype.h>

typedef struct _GskSimpleProxyClass GskSimpleProxyClass;
typedef struct _GskSimpleProxy GskSimpleProxy;

GtkType gsk_simple_proxy_get_type();
#define GSK_TYPE_SIMPLE_PROXY	           (gsk_simple_proxy_get_type ())
#define GSK_SIMPLE_PROXY(obj)              (GTK_CHECK_CAST ((obj), GSK_TYPE_SIMPLE_PROXY, GskSimpleProxy))
#define GSK_SIMPLE_PROXY_CLASS(klass)      (GTK_CHECK_CLASS_CAST ((klass), GSK_TYPE_SIMPLE_PROXY, GskSimpleProxyClass))
#define GSK_IS_SIMPLE_PROXY(obj)           (GTK_CHECK_TYPE ((obj), GSK_TYPE_SIMPLE_PROXY))
#define GSK_IS_SIMPLE_PROXY_CLASS(klass)   (GTK_CHECK_CLASS_TYPE ((klass), GSK_TYPE_SIMPLE_PROXY))


struct _GskSimpleProxyClass
{
  GskActorBufferedClass base;
};

struct _GskSimpleProxy
{
  GskActorBuffered base;
  GskSimpleProxy *buffer_to;
};

void            gsk_simple_proxy_pair_add(GskMainLoop         *main_loop,
                                          GskStreamSocket     *accepted,
                                          GskSocketAddress    *server);

GskSimpleProxy* gsk_simple_proxy_new     (GskStreamSocket     *sock);

#endif
