/*
    GSK - a library to write servers
    Copyright (C) 1999-2000 Dave Benson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA

    Contact:
        daveb@ffem.org <Dave Benson>
*/


#ifndef __GSK_SIMPLE_PROXY_LISTENER_H_
#define __GSK_SIMPLE_PROXY_LISTENER_H_

#include "../gskactorlistener.h"
#include "../gsksocketaddress.h"

typedef struct _GskSimpleProxyListener GskSimpleProxyListener;
typedef struct _GskSimpleProxyListenerClass GskSimpleProxyListenerClass;

GtkType gsk_simple_proxy_listener_get_type();
#define GSK_TYPE_SIMPLE_PROXY_LISTENER			(gsk_simple_proxy_listener_get_type ())
#define GSK_SIMPLE_PROXY_LISTENER(obj)              (GTK_CHECK_CAST ((obj), GSK_TYPE_SIMPLE_PROXY_LISTENER, GskSimpleProxyListener))
#define GSK_SIMPLE_PROXY_LISTENER_CLASS(klass)      (GTK_CHECK_CLASS_CAST ((klass), GSK_TYPE_SIMPLE_PROXY_LISTENER, GskSimpleProxyListenerClass))
#define GSK_IS_SIMPLE_PROXY_LISTENER(obj)           (GTK_CHECK_TYPE ((obj), GSK_TYPE_SIMPLE_PROXY_LISTENER))
#define GSK_IS_SIMPLE_PROXY_LISTENER_CLASS(klass)   (GTK_CHECK_CLASS_TYPE ((klass), GSK_TYPE_SIMPLE_PROXY_LISTENER))


/*=====================================================================*
 *                        GskSimpleProxyListener                       *
 *                                                                     *
 * Listener for connections; greet them with SimpleProxies.            *
 *=====================================================================*/
struct _GskSimpleProxyListenerClass
{
  GskActorListenerClass	base_class;
};
struct _GskSimpleProxyListener
{
  GskActorListener	base;
  GskSocketAddress	address;
};

GskActor*   gsk_simple_proxy_listener_new(int                     local_port,
                                          const GskSocketAddress *remote);

#endif
