/* gdkDPS.h --- DPS context and coordinate representations in gdk
 *
 * Copyright (C) 1997, 1998, 1999 GYVE Development Team
 *
 * Author:  Terumoto 'tel' HAYAKAWA <hayakawa@cv.cs.ritsumei.ac.jp>
 * Maintainer: Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
 * Created: 
 *
 * This file is part of gtkDPS Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GDK__DPS_H
#define GDK__DPS_H

#include <gdk/gdk.h>
#include <gdk/gdktypes.h>
#include <DPS/dpsclient.h>

#include <gtkDPS/gdkDPSgeometry.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

typedef enum {
  GDK_DPS_DEBUG_CONTEXT  = 1 << 0,
  GDK_DPS_DEBUG_FONT     = 1 << 1,
  GDK_DPS_DEBUG_LINE     = 1 << 2,
  GDK_DPS_DEBUG_GEOMETRY = 1 << 3,
  GDK_DPS_DEBUG_MISC     = 1 << 4
} GdkDPSDebugFlag;
extern gint gdk_dps_debug_flags;

/* Initialize */
void gdk_dps_init (int *argc, char ***argv);
/* Finalize */
void gdk_dps_exit (void);

typedef struct _GdkDPSContext   GdkDPSContext;

/* Product */
typedef enum 
{
  GDK_DPS_AGENT_PRODUCT_ADOBE_DPS = 1,
  GDK_DPS_AGENT_PRODUCT_GNU_DGS,
  GDK_DPS_AGENT_PRODUCT_ALADDIN_DGS
} GdkDPSAgentProduct;
GdkDPSAgentProduct gdk_dps_get_agent_product();

/* Agent revision */
typedef enum 
{
  GDK_DPS_AGENT_REVISION_5 = 1,
  GDK_DPS_AGENT_REVISION_6

} GdkDPSAgentRevision;
GdkDPSAgentRevision gdk_dps_get_agent_revision();


/* Context */
struct _GdkDPSContext
{
  DPSContext raw_ctxt;
  GdkDrawable * drawable;
  GdkGC* gc;
};

/* Create context */
GdkDPSContext* gdk_dps_context_get_shared (void);
GdkDPSContext* gdk_dps_context_new (GdkDrawable *);

/* Drawable */
GdkDrawable *gdk_dps_context_get_drawable(GdkDPSContext *);
void gdk_dps_context_set_drawable(GdkDPSContext *, GdkDrawable *);

/* Flush & Wait */
void gdk_dps_context_flush(GdkDPSContext *);

/* Query */
gboolean gdk_dps_context_is_shared (GdkDPSContext*);

/* Destroy context */
void           gdk_dps_context_free    (GdkDPSContext *);

/* Access struct internal variables */
GdkGC*     gdk_dps_context_get_gc (GdkDPSContext *);
DPSContext gdk_dps_context_get_raw_context(GdkDPSContext *);

/* Block */
#define gdk_dps_context_begin(ctxt)                           \
{                                                             \
  DPSContext raw_ctxt = gdk_dps_context_get_raw_context(ctxt); \
  if (gdk_dps_debug_flags & GDK_DPS_DEBUG_CONTEXT) \
	    g_message("Enter context: %p", raw_ctxt);
#define  gdk_dps_context_end(ctxt) \
  if (gdk_dps_debug_flags & GDK_DPS_DEBUG_CONTEXT) \
	    g_message("Leave context: %p", raw_ctxt); \
}

/* Coord */
void gdk_dps_context_update_coordtr(GdkDPSContext * ctxt, 
				    GdkDPSCoordtr * coordtr);
gboolean gdk_dps_context_try_update_coordtr(GdkDPSContext * ctxt, 
					    GdkDPSCoordtr * coordtr);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* GDK__DPS_CONTEXT_H */
