/* gdkDPSfont.h --- DPS fonts representation in gdk
 * 
 * This file is derived from gtkDPSfontpanel.h by 
 * Masatake YAMATO<masata-y@is.aist-nara.ac.jp>.
 *
 * Copyright (C) 1998 Hideki FUJIMOTO
 *
 * Author: Hideki FUJIMOTO <hideki70@osk2.3web.ne.jp>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GDK_DPS_FONT_H
#define GDK_DPS_FONT_H 

#include <glib.h>
#include <stdio.h>
#include <gtkDPS/parseAFM.h>

typedef struct _GdkDPSTypeFace GdkDPSTypeFace;
struct _GdkDPSTypeFace
{
  gchar * type_face;		/* Full name - Family name */
  gchar * font_name;		/* Font name */
};

typedef struct _GdkDPSFontFamily GdkDPSFontFamily;
struct _GdkDPSFontFamily
{
  gchar * font_family;		/* Family name */
  GSList * type_faces_list;
};

typedef struct _GdkDPSAFMFontInfo GdkDPSAFMFontInfo;
struct _GdkDPSAFMFontInfo
{
  gchar * file_name;
  AFMFontInfo * font_info;
};

/* Font name -> GdkDPSAFMFontInfo */
GHashTable * gdk_dps_fonts_raw_table_new (void);
GHashTable * gdk_dps_fonts_raw_table_get_shared (void);
void gdk_dps_fonts_raw_table_free (GHashTable *);
void gdk_dps_fonts_raw_table_dump (GHashTable * table, FILE * to);

GSList * gdk_dps_font_families_list_new (GHashTable * raw_table);
void gdk_dps_font_families_list_free (GSList *);
void gdk_dps_font_families_list_dump (GSList * list, FILE * to);

#endif /* Not def: GDK_DPS_FONT_H */
