/* gtkDPSlinesel.h --- DPS line style selection widget
 * Copyright (C) 1999 Masatake YAMATO
 * 
 * Author: Masatake YAMATO<masata-y@is.aist-nara.ac.jp>
 * Created: Sun Oct  3 00:00:21 1999
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GTK_DPS_LINESEL_H
#define GTK_DPS_LINESEL_H 

#include <gtk/gtkvbox.h>
#include <gtkDPS/gdkDPSline.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_DPS_LINE_SELECTION (gtk_dps_line_selection_get_type ())
#define GTK_DPS_LINE_SELECTION(obj) (GTK_CHECK_CAST ((obj), GTK_TYPE_DPS_LINE_SELECTION, GtkDPSLineSelection))
#define GTK_DPS_LINE_SELECTION_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_DPS_LINE_SELECTION, GtkDPSLineSelectionClass))
#define GTK_IS_DPS_LINE_SELECTION(obj) (GTK_CHECK_TYPE ((obj), GTK_TYPE_DPS_LINE_SELECTION))
#define GTK_IS_DPS_LINE_SELECTION_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_DPS_LINE_SELECTION))

typedef struct _GtkDPSLineSelection GtkDPSLineSelection;
typedef struct _GtkDPSLineSelectionClass GtkDPSLineSelectionClass;

struct _GtkDPSLineSelection
{
  GtkVBox vbox;
  GtkWidget * dps_area;
  
  GtkObject * line_width_adj;
  GtkObject * miter_limit_adj;
  
  GtkWidget * join_buttons[3];
  GtkWidget * cap_buttons[3];

  GtkWidget * dash_pattern_check;
  GtkWidget * dash_pattern_entries_table;
  /* TODO: The dash pattern length is  restricted to 6... */
  GtkObject * dash_pattern_adjs[6];
  GdkDPSDashPattern * dash_pattern;
  GdkDPSDashPattern * empty_dash_pattern;
};

struct _GtkDPSLineSelectionClass
{
  GtkVBoxClass parent_class;
  void (* line_changed) (GtkDPSLineSelection *);
};

GtkWidget * gtk_dps_line_selection_new(void);
GtkType gtk_dps_line_selection_get_type (void);

gfloat gtk_dps_line_selection_get_line_width (GtkDPSLineSelection *);
gfloat gtk_dps_line_selection_get_miter_limit (GtkDPSLineSelection *);
GdkDPSJoinStyle gtk_dps_line_selection_get_join_style(GtkDPSLineSelection *);
GdkDPSCapStyle gtk_dps_line_selection_get_cap_style(GtkDPSLineSelection *);
GdkDPSDashPattern* gtk_dps_line_selection_get_dash_pattern(GtkDPSLineSelection *);

void gtk_dps_line_selection_set_line_width (GtkDPSLineSelection *,
					    gfloat);
void gtk_dps_line_selection_set_miter_limit (GtkDPSLineSelection *,
					   gfloat);
void gtk_dps_line_selection_set_join_style(GtkDPSLineSelection *,
					   GdkDPSJoinStyle);
void gtk_dps_line_selection_set_cap_style(GtkDPSLineSelection *,
					  GdkDPSCapStyle);
void gtk_dps_line_selection_set_dash_pattern(GtkDPSLineSelection *,
					     GdkDPSDashPattern* );


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* Not def: GTK_DPS_LINESEL_H */
