//==========================================================================
//
//   GTL.h - Internal header: DO NO USE IT DIRECTLY !!!
//
//==========================================================================
// $Id: GTL.h,v 1.16 2000/02/03 12:50:16 raitner Exp $

#ifndef GTL_GTL_H
#define GTL_GTL_H

#include <GTL/version.h>

//--------------------------------------------------------------------------
//   Generic iteration over container elements
//--------------------------------------------------------------------------
//
// elem: loop variable
// cont: container to iterate over
// iter_t: iterator type
// iter: prefix for begin() and end()
//
// contains a hack for Microsoft Visual C++ 5.0, because code like
//
//   for(int i=0; i<10; ++i) { ... do something ... }
//   for(int i=0; i<10; ++i) { ... do something again ... }
//
// is illegal with Microsoft Extensions enabled, but without Microsoft
// Extensions, the Microsoft STL does not work :-(.
// So we code the line number (__LINE__) into our loop variables.

#define GTL_CONCAT(x,y) x##y
#define GTL_FORALL_VAR(y) GTL_CONCAT(GTL_FORALL_VAR,y)

#define GTL_FORALL(elem,cont,iter_t,iter)			\
if((cont).iter##begin() != (cont).iter##end())			\
    (elem) = *((cont).iter##begin());				\
for(iter_t GTL_FORALL_VAR(__LINE__) = (cont).iter##begin();	\
    GTL_FORALL_VAR(__LINE__) != (cont).iter##end();		\
    (elem)=*(++GTL_FORALL_VAR(__LINE__)))
    
//--------------------------------------------------------------------------
//   Configuration for GCC >= 2.8.0
//--------------------------------------------------------------------------

//
// Using namespaces is the default; may be unset by one of the 
// following configurations.
//
 
#define __GTL_USE_NAMESPACES

#ifdef __GNUC__
#  if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 8)

#    undef __GTL_USE_NAMESPACES
#    define __GTL_GCC

#  else

#    error "Need at least version 2.8.0 of GCC to compile GTL."

#  endif
#endif

//--------------------------------------------------------------------------
//    Configuration for Microsoft Visual C++ 5.0
//--------------------------------------------------------------------------

#ifdef _MSC_VER
#  if _MSC_VER >= 1100
    
#    define __GTL_USE_NAMESPACES
#    define __GTL_MSVCC

#    pragma warning( disable : 4786 )
#    pragma warning( disable : 4251 )

#    if defined(GTL_STATIC)
#      define GTL_EXTERN
#    elif defined(GTL_EXPORTS)
#      define GTL_EXTERN __declspec(dllexport)
#    else
#      define GTL_EXTERN __declspec(dllimport)
#    endif

#  else

#    error "Need at least version 5.0 of MS Visual C++ to compile GTL."

#  endif
#else

#   define GTL_EXTERN

#endif

//--------------------------------------------------------------------------
//   Namespaces
//--------------------------------------------------------------------------

#ifdef __GTL_USE_NAMESPACES

#  define __GTL_BEGIN_NAMESPACE namespace GTL {
#  define __GTL_END_NAMESPACE }

#else

#  define __GTL_BEGIN_NAMESPACE
#  define __GTL_END_NAMESPACE

#endif

//--------------------------------------------------------------------------
//   Temporary hack until Graphlet (i.e. gcc) supports Namespaces
//--------------------------------------------------------------------------

#ifdef __GTL_USE_NAMESPACES

namespace GTL {};
using namespace GTL;

namespace std {};
using namespace std;

#endif // __GTL_USE_NAMESPACES

//--------------------------------------------------------------------------
//   Bugfix for EGCS & GCC < 2.95
//--------------------------------------------------------------------------

#if defined(__GNUC__) && __GNUC__ == 2 && __GNUC_MINOR__ < 95

#include <map>
#include <memory>

#ifndef __FreeBSD__
/**
 * @internal
 */
template <class T>
class allocator : public alloc
{
};
#endif

#endif

//--------------------------------------------------------------------------
//   MSVC does not define min and max in <algorithm>
//--------------------------------------------------------------------------

#ifdef __GTL_MSVCC

template<class T>
const T& min(const T& x, const T& y)
{
    return ( x < y ? x : y);
}

template<class T>
const T& max(const T& x, const T& y)
{
    return ( x > y ? x : y);
}

#endif

#endif // GTL_GTL_H

//--------------------------------------------------------------------------
//   end of file
//--------------------------------------------------------------------------
