//==========================================================================
//
//   debug.h - Functions, which are useful for debugging 
//
//==========================================================================
// $Id: debug.h,v 1.7 2000/01/05 16:32:33 raitner Exp $

#ifndef GTL_DEBUG_H
#define GTL_DEBUG_H

#include <GTL/GTL.h>

#include <iostream>

__GTL_BEGIN_NAMESPACE

//
// If DEBUG is defined the funtions defined here will produce output.
// You can either define DEBUG here (or undef it) or you can set it as 
// option of your compiler.
//
//#define DEBUG 1
#undef DEBUG
//

/**
 * @internal
 */
class GTL_EXTERN GTL_debug {
public:
    static void debug_message (const char*, ...); 
    static void init_debug();
    static void close_debug();
    static ostream& os ()
	{ return *GTLerr; }

private:
	static ostream* GTLerr;
};

__GTL_END_NAMESPACE

#endif // GTL_DEBUG_H

//--------------------------------------------------------------------------
//   end of file
//--------------------------------------------------------------------------
