{-# OPTIONS -fno-implicit-prelude #-}
-----------------------------------------------------------------------------
-- |
-- Module      :  Foreign.C.Types
-- Copyright   :  (c) The FFI task force 2001
-- License     :  BSD-style (see the file libraries/base/LICENSE)
-- 
-- Maintainer  :  ffi@haskell.org
-- Stability   :  provisional
-- Portability :  portable
--
-- Mapping of C types to corresponding Haskell types. A cool hack...
--
-----------------------------------------------------------------------------

module Foreign.C.Types
	( -- Integral types, instances of: Eq, Ord, Num, Read, Show, Enum,
	  -- Typeable, Storable, Bounded, Real, Integral, Bits
	  CChar(..),  CSChar(..),  CUChar(..)
	, CShort(..), CUShort(..), CInt(..),   CUInt(..)
	, CLong(..),  CULong(..)
	, CPtrdiff(..), CSize(..), CWchar(..), CSigAtomic(..)

	  -- Numeric types, instances of: Eq, Ord, Num, Read, Show, Enum,
	  -- Typeable, Storable
	, CClock(..),   CTime(..)

	  -- Floating types, instances of: Eq, Ord, Num, Read, Show, Enum,
	  -- Typeable, Storable, Real, Fractional, Floating, RealFrac,
	  -- RealFloat 
	, CFloat(..),  CDouble(..), CLDouble(..)

          -- Instances of: Eq and Storable
	, CFile,        CFpos,     CJmpBuf
	) where

import Foreign.C.TypesISO
import Foreign.Storable
import Data.Bits	( Bits(..) )
import Data.Int		( Int8,  Int16,  Int32,  Int64  )
import Data.Word	( Word8, Word16, Word32, Word64 )
import Data.Dynamic

import Control.Monad
import Foreign.Ptr

 

newtype CChar = CChar Int8 deriving (Eq, Ord) ; instance Num CChar where { (CChar i) + (CChar j) = CChar (i + j) ; (CChar i) - (CChar j) = CChar (i - j) ; (CChar i) * (CChar j) = CChar (i * j) ; negate  (CChar i) = CChar (negate i) ; abs     (CChar i) = CChar (abs    i) ; signum  (CChar i) = CChar (signum i) ; fromInteger x = CChar (fromInteger x) } ; instance Read CChar where { readsPrec p s = map (\(x, t) -> (CChar x, t)) (readsPrec p s) } ; instance Show CChar where { showsPrec p (CChar x) = showsPrec p x } ; instance Enum CChar where { succ           (CChar i)             = CChar (succ i) ; pred           (CChar i)             = CChar (pred i) ; toEnum               x           = CChar (toEnum x) ; fromEnum       (CChar i)             = fromEnum i ; enumFrom       (CChar i)             = map CChar (enumFrom i) ; enumFromThen   (CChar i) (CChar j)       = map CChar (enumFromThen i j) ; enumFromTo     (CChar i) (CChar j)       = map CChar (enumFromTo i j) ; enumFromThenTo (CChar i) (CChar j) (CChar k) = map CChar (enumFromThenTo i j k) } ; instance Storable CChar where { sizeOf    (CChar x)       = sizeOf x ; alignment (CChar x)       = alignment x ; peekElemOff a i       = liftM CChar (peekElemOff (castPtr a) i) ; pokeElemOff a i (CChar x) = pokeElemOff (castPtr a) i x } ; tyConCChar = mkTyCon "CChar"; instance Typeable CChar where { typeOf _ = mkAppTy tyConCChar [] } ; ; instance Bounded CChar where { minBound = CChar minBound ; maxBound = CChar maxBound } ; instance Real CChar where { toRational (CChar i) = toRational i } ; instance Integral CChar where { (CChar i) `quot`    (CChar j) = CChar (i `quot` j) ; (CChar i) `rem`     (CChar j) = CChar (i `rem`  j) ; (CChar i) `div`     (CChar j) = CChar (i `div`  j) ; (CChar i) `mod`     (CChar j) = CChar (i `mod`  j) ; (CChar i) `quotRem` (CChar j) = let (q,r) = i `quotRem` j in (CChar q, CChar r) ; (CChar i) `divMod`  (CChar j) = let (d,m) = i `divMod`  j in (CChar d, CChar m) ; toInteger (CChar i)       = toInteger i } ; instance Bits CChar where { (CChar x) .&.     (CChar y)   = CChar (x .&.   y) ; (CChar x) .|.     (CChar y)   = CChar (x .|.   y) ; (CChar x) `xor`   (CChar y)   = CChar (x `xor` y) ; complement    (CChar x)   = CChar (complement x) ; shift         (CChar x) n = CChar (shift x n) ; rotate        (CChar x) n = CChar (rotate x n) ; bit                 n = CChar (bit n) ; setBit        (CChar x) n = CChar (setBit x n) ; clearBit      (CChar x) n = CChar (clearBit x n) ; complementBit (CChar x) n = CChar (complementBit x n) ; testBit       (CChar x) n = testBit x n ; bitSize       (CChar x)   = bitSize x ; isSigned      (CChar x)   = isSigned x }
newtype CSChar = CSChar Int8 deriving (Eq, Ord) ; instance Num CSChar where { (CSChar i) + (CSChar j) = CSChar (i + j) ; (CSChar i) - (CSChar j) = CSChar (i - j) ; (CSChar i) * (CSChar j) = CSChar (i * j) ; negate  (CSChar i) = CSChar (negate i) ; abs     (CSChar i) = CSChar (abs    i) ; signum  (CSChar i) = CSChar (signum i) ; fromInteger x = CSChar (fromInteger x) } ; instance Read CSChar where { readsPrec p s = map (\(x, t) -> (CSChar x, t)) (readsPrec p s) } ; instance Show CSChar where { showsPrec p (CSChar x) = showsPrec p x } ; instance Enum CSChar where { succ           (CSChar i)             = CSChar (succ i) ; pred           (CSChar i)             = CSChar (pred i) ; toEnum               x           = CSChar (toEnum x) ; fromEnum       (CSChar i)             = fromEnum i ; enumFrom       (CSChar i)             = map CSChar (enumFrom i) ; enumFromThen   (CSChar i) (CSChar j)       = map CSChar (enumFromThen i j) ; enumFromTo     (CSChar i) (CSChar j)       = map CSChar (enumFromTo i j) ; enumFromThenTo (CSChar i) (CSChar j) (CSChar k) = map CSChar (enumFromThenTo i j k) } ; instance Storable CSChar where { sizeOf    (CSChar x)       = sizeOf x ; alignment (CSChar x)       = alignment x ; peekElemOff a i       = liftM CSChar (peekElemOff (castPtr a) i) ; pokeElemOff a i (CSChar x) = pokeElemOff (castPtr a) i x } ; tyConCSChar = mkTyCon "CSChar"; instance Typeable CSChar where { typeOf _ = mkAppTy tyConCSChar [] } ; ; instance Bounded CSChar where { minBound = CSChar minBound ; maxBound = CSChar maxBound } ; instance Real CSChar where { toRational (CSChar i) = toRational i } ; instance Integral CSChar where { (CSChar i) `quot`    (CSChar j) = CSChar (i `quot` j) ; (CSChar i) `rem`     (CSChar j) = CSChar (i `rem`  j) ; (CSChar i) `div`     (CSChar j) = CSChar (i `div`  j) ; (CSChar i) `mod`     (CSChar j) = CSChar (i `mod`  j) ; (CSChar i) `quotRem` (CSChar j) = let (q,r) = i `quotRem` j in (CSChar q, CSChar r) ; (CSChar i) `divMod`  (CSChar j) = let (d,m) = i `divMod`  j in (CSChar d, CSChar m) ; toInteger (CSChar i)       = toInteger i } ; instance Bits CSChar where { (CSChar x) .&.     (CSChar y)   = CSChar (x .&.   y) ; (CSChar x) .|.     (CSChar y)   = CSChar (x .|.   y) ; (CSChar x) `xor`   (CSChar y)   = CSChar (x `xor` y) ; complement    (CSChar x)   = CSChar (complement x) ; shift         (CSChar x) n = CSChar (shift x n) ; rotate        (CSChar x) n = CSChar (rotate x n) ; bit                 n = CSChar (bit n) ; setBit        (CSChar x) n = CSChar (setBit x n) ; clearBit      (CSChar x) n = CSChar (clearBit x n) ; complementBit (CSChar x) n = CSChar (complementBit x n) ; testBit       (CSChar x) n = testBit x n ; bitSize       (CSChar x)   = bitSize x ; isSigned      (CSChar x)   = isSigned x }
newtype CUChar = CUChar Word8 deriving (Eq, Ord) ; instance Num CUChar where { (CUChar i) + (CUChar j) = CUChar (i + j) ; (CUChar i) - (CUChar j) = CUChar (i - j) ; (CUChar i) * (CUChar j) = CUChar (i * j) ; negate  (CUChar i) = CUChar (negate i) ; abs     (CUChar i) = CUChar (abs    i) ; signum  (CUChar i) = CUChar (signum i) ; fromInteger x = CUChar (fromInteger x) } ; instance Read CUChar where { readsPrec p s = map (\(x, t) -> (CUChar x, t)) (readsPrec p s) } ; instance Show CUChar where { showsPrec p (CUChar x) = showsPrec p x } ; instance Enum CUChar where { succ           (CUChar i)             = CUChar (succ i) ; pred           (CUChar i)             = CUChar (pred i) ; toEnum               x           = CUChar (toEnum x) ; fromEnum       (CUChar i)             = fromEnum i ; enumFrom       (CUChar i)             = map CUChar (enumFrom i) ; enumFromThen   (CUChar i) (CUChar j)       = map CUChar (enumFromThen i j) ; enumFromTo     (CUChar i) (CUChar j)       = map CUChar (enumFromTo i j) ; enumFromThenTo (CUChar i) (CUChar j) (CUChar k) = map CUChar (enumFromThenTo i j k) } ; instance Storable CUChar where { sizeOf    (CUChar x)       = sizeOf x ; alignment (CUChar x)       = alignment x ; peekElemOff a i       = liftM CUChar (peekElemOff (castPtr a) i) ; pokeElemOff a i (CUChar x) = pokeElemOff (castPtr a) i x } ; tyConCUChar = mkTyCon "CUChar"; instance Typeable CUChar where { typeOf _ = mkAppTy tyConCUChar [] } ; ; instance Bounded CUChar where { minBound = CUChar minBound ; maxBound = CUChar maxBound } ; instance Real CUChar where { toRational (CUChar i) = toRational i } ; instance Integral CUChar where { (CUChar i) `quot`    (CUChar j) = CUChar (i `quot` j) ; (CUChar i) `rem`     (CUChar j) = CUChar (i `rem`  j) ; (CUChar i) `div`     (CUChar j) = CUChar (i `div`  j) ; (CUChar i) `mod`     (CUChar j) = CUChar (i `mod`  j) ; (CUChar i) `quotRem` (CUChar j) = let (q,r) = i `quotRem` j in (CUChar q, CUChar r) ; (CUChar i) `divMod`  (CUChar j) = let (d,m) = i `divMod`  j in (CUChar d, CUChar m) ; toInteger (CUChar i)       = toInteger i } ; instance Bits CUChar where { (CUChar x) .&.     (CUChar y)   = CUChar (x .&.   y) ; (CUChar x) .|.     (CUChar y)   = CUChar (x .|.   y) ; (CUChar x) `xor`   (CUChar y)   = CUChar (x `xor` y) ; complement    (CUChar x)   = CUChar (complement x) ; shift         (CUChar x) n = CUChar (shift x n) ; rotate        (CUChar x) n = CUChar (rotate x n) ; bit                 n = CUChar (bit n) ; setBit        (CUChar x) n = CUChar (setBit x n) ; clearBit      (CUChar x) n = CUChar (clearBit x n) ; complementBit (CUChar x) n = CUChar (complementBit x n) ; testBit       (CUChar x) n = testBit x n ; bitSize       (CUChar x)   = bitSize x ; isSigned      (CUChar x)   = isSigned x }

newtype CShort = CShort Int16 deriving (Eq, Ord) ; instance Num CShort where { (CShort i) + (CShort j) = CShort (i + j) ; (CShort i) - (CShort j) = CShort (i - j) ; (CShort i) * (CShort j) = CShort (i * j) ; negate  (CShort i) = CShort (negate i) ; abs     (CShort i) = CShort (abs    i) ; signum  (CShort i) = CShort (signum i) ; fromInteger x = CShort (fromInteger x) } ; instance Read CShort where { readsPrec p s = map (\(x, t) -> (CShort x, t)) (readsPrec p s) } ; instance Show CShort where { showsPrec p (CShort x) = showsPrec p x } ; instance Enum CShort where { succ           (CShort i)             = CShort (succ i) ; pred           (CShort i)             = CShort (pred i) ; toEnum               x           = CShort (toEnum x) ; fromEnum       (CShort i)             = fromEnum i ; enumFrom       (CShort i)             = map CShort (enumFrom i) ; enumFromThen   (CShort i) (CShort j)       = map CShort (enumFromThen i j) ; enumFromTo     (CShort i) (CShort j)       = map CShort (enumFromTo i j) ; enumFromThenTo (CShort i) (CShort j) (CShort k) = map CShort (enumFromThenTo i j k) } ; instance Storable CShort where { sizeOf    (CShort x)       = sizeOf x ; alignment (CShort x)       = alignment x ; peekElemOff a i       = liftM CShort (peekElemOff (castPtr a) i) ; pokeElemOff a i (CShort x) = pokeElemOff (castPtr a) i x } ; tyConCShort = mkTyCon "CShort"; instance Typeable CShort where { typeOf _ = mkAppTy tyConCShort [] } ; ; instance Bounded CShort where { minBound = CShort minBound ; maxBound = CShort maxBound } ; instance Real CShort where { toRational (CShort i) = toRational i } ; instance Integral CShort where { (CShort i) `quot`    (CShort j) = CShort (i `quot` j) ; (CShort i) `rem`     (CShort j) = CShort (i `rem`  j) ; (CShort i) `div`     (CShort j) = CShort (i `div`  j) ; (CShort i) `mod`     (CShort j) = CShort (i `mod`  j) ; (CShort i) `quotRem` (CShort j) = let (q,r) = i `quotRem` j in (CShort q, CShort r) ; (CShort i) `divMod`  (CShort j) = let (d,m) = i `divMod`  j in (CShort d, CShort m) ; toInteger (CShort i)       = toInteger i } ; instance Bits CShort where { (CShort x) .&.     (CShort y)   = CShort (x .&.   y) ; (CShort x) .|.     (CShort y)   = CShort (x .|.   y) ; (CShort x) `xor`   (CShort y)   = CShort (x `xor` y) ; complement    (CShort x)   = CShort (complement x) ; shift         (CShort x) n = CShort (shift x n) ; rotate        (CShort x) n = CShort (rotate x n) ; bit                 n = CShort (bit n) ; setBit        (CShort x) n = CShort (setBit x n) ; clearBit      (CShort x) n = CShort (clearBit x n) ; complementBit (CShort x) n = CShort (complementBit x n) ; testBit       (CShort x) n = testBit x n ; bitSize       (CShort x)   = bitSize x ; isSigned      (CShort x)   = isSigned x }
newtype CUShort = CUShort Word16 deriving (Eq, Ord) ; instance Num CUShort where { (CUShort i) + (CUShort j) = CUShort (i + j) ; (CUShort i) - (CUShort j) = CUShort (i - j) ; (CUShort i) * (CUShort j) = CUShort (i * j) ; negate  (CUShort i) = CUShort (negate i) ; abs     (CUShort i) = CUShort (abs    i) ; signum  (CUShort i) = CUShort (signum i) ; fromInteger x = CUShort (fromInteger x) } ; instance Read CUShort where { readsPrec p s = map (\(x, t) -> (CUShort x, t)) (readsPrec p s) } ; instance Show CUShort where { showsPrec p (CUShort x) = showsPrec p x } ; instance Enum CUShort where { succ           (CUShort i)             = CUShort (succ i) ; pred           (CUShort i)             = CUShort (pred i) ; toEnum               x           = CUShort (toEnum x) ; fromEnum       (CUShort i)             = fromEnum i ; enumFrom       (CUShort i)             = map CUShort (enumFrom i) ; enumFromThen   (CUShort i) (CUShort j)       = map CUShort (enumFromThen i j) ; enumFromTo     (CUShort i) (CUShort j)       = map CUShort (enumFromTo i j) ; enumFromThenTo (CUShort i) (CUShort j) (CUShort k) = map CUShort (enumFromThenTo i j k) } ; instance Storable CUShort where { sizeOf    (CUShort x)       = sizeOf x ; alignment (CUShort x)       = alignment x ; peekElemOff a i       = liftM CUShort (peekElemOff (castPtr a) i) ; pokeElemOff a i (CUShort x) = pokeElemOff (castPtr a) i x } ; tyConCUShort = mkTyCon "CUShort"; instance Typeable CUShort where { typeOf _ = mkAppTy tyConCUShort [] } ; ; instance Bounded CUShort where { minBound = CUShort minBound ; maxBound = CUShort maxBound } ; instance Real CUShort where { toRational (CUShort i) = toRational i } ; instance Integral CUShort where { (CUShort i) `quot`    (CUShort j) = CUShort (i `quot` j) ; (CUShort i) `rem`     (CUShort j) = CUShort (i `rem`  j) ; (CUShort i) `div`     (CUShort j) = CUShort (i `div`  j) ; (CUShort i) `mod`     (CUShort j) = CUShort (i `mod`  j) ; (CUShort i) `quotRem` (CUShort j) = let (q,r) = i `quotRem` j in (CUShort q, CUShort r) ; (CUShort i) `divMod`  (CUShort j) = let (d,m) = i `divMod`  j in (CUShort d, CUShort m) ; toInteger (CUShort i)       = toInteger i } ; instance Bits CUShort where { (CUShort x) .&.     (CUShort y)   = CUShort (x .&.   y) ; (CUShort x) .|.     (CUShort y)   = CUShort (x .|.   y) ; (CUShort x) `xor`   (CUShort y)   = CUShort (x `xor` y) ; complement    (CUShort x)   = CUShort (complement x) ; shift         (CUShort x) n = CUShort (shift x n) ; rotate        (CUShort x) n = CUShort (rotate x n) ; bit                 n = CUShort (bit n) ; setBit        (CUShort x) n = CUShort (setBit x n) ; clearBit      (CUShort x) n = CUShort (clearBit x n) ; complementBit (CUShort x) n = CUShort (complementBit x n) ; testBit       (CUShort x) n = testBit x n ; bitSize       (CUShort x)   = bitSize x ; isSigned      (CUShort x)   = isSigned x }

newtype CInt = CInt Int32 deriving (Eq, Ord) ; instance Num CInt where { (CInt i) + (CInt j) = CInt (i + j) ; (CInt i) - (CInt j) = CInt (i - j) ; (CInt i) * (CInt j) = CInt (i * j) ; negate  (CInt i) = CInt (negate i) ; abs     (CInt i) = CInt (abs    i) ; signum  (CInt i) = CInt (signum i) ; fromInteger x = CInt (fromInteger x) } ; instance Read CInt where { readsPrec p s = map (\(x, t) -> (CInt x, t)) (readsPrec p s) } ; instance Show CInt where { showsPrec p (CInt x) = showsPrec p x } ; instance Enum CInt where { succ           (CInt i)             = CInt (succ i) ; pred           (CInt i)             = CInt (pred i) ; toEnum               x           = CInt (toEnum x) ; fromEnum       (CInt i)             = fromEnum i ; enumFrom       (CInt i)             = map CInt (enumFrom i) ; enumFromThen   (CInt i) (CInt j)       = map CInt (enumFromThen i j) ; enumFromTo     (CInt i) (CInt j)       = map CInt (enumFromTo i j) ; enumFromThenTo (CInt i) (CInt j) (CInt k) = map CInt (enumFromThenTo i j k) } ; instance Storable CInt where { sizeOf    (CInt x)       = sizeOf x ; alignment (CInt x)       = alignment x ; peekElemOff a i       = liftM CInt (peekElemOff (castPtr a) i) ; pokeElemOff a i (CInt x) = pokeElemOff (castPtr a) i x } ; tyConCInt = mkTyCon "CInt"; instance Typeable CInt where { typeOf _ = mkAppTy tyConCInt [] } ; ; instance Bounded CInt where { minBound = CInt minBound ; maxBound = CInt maxBound } ; instance Real CInt where { toRational (CInt i) = toRational i } ; instance Integral CInt where { (CInt i) `quot`    (CInt j) = CInt (i `quot` j) ; (CInt i) `rem`     (CInt j) = CInt (i `rem`  j) ; (CInt i) `div`     (CInt j) = CInt (i `div`  j) ; (CInt i) `mod`     (CInt j) = CInt (i `mod`  j) ; (CInt i) `quotRem` (CInt j) = let (q,r) = i `quotRem` j in (CInt q, CInt r) ; (CInt i) `divMod`  (CInt j) = let (d,m) = i `divMod`  j in (CInt d, CInt m) ; toInteger (CInt i)       = toInteger i } ; instance Bits CInt where { (CInt x) .&.     (CInt y)   = CInt (x .&.   y) ; (CInt x) .|.     (CInt y)   = CInt (x .|.   y) ; (CInt x) `xor`   (CInt y)   = CInt (x `xor` y) ; complement    (CInt x)   = CInt (complement x) ; shift         (CInt x) n = CInt (shift x n) ; rotate        (CInt x) n = CInt (rotate x n) ; bit                 n = CInt (bit n) ; setBit        (CInt x) n = CInt (setBit x n) ; clearBit      (CInt x) n = CInt (clearBit x n) ; complementBit (CInt x) n = CInt (complementBit x n) ; testBit       (CInt x) n = testBit x n ; bitSize       (CInt x)   = bitSize x ; isSigned      (CInt x)   = isSigned x }
newtype CUInt = CUInt Word32 deriving (Eq, Ord) ; instance Num CUInt where { (CUInt i) + (CUInt j) = CUInt (i + j) ; (CUInt i) - (CUInt j) = CUInt (i - j) ; (CUInt i) * (CUInt j) = CUInt (i * j) ; negate  (CUInt i) = CUInt (negate i) ; abs     (CUInt i) = CUInt (abs    i) ; signum  (CUInt i) = CUInt (signum i) ; fromInteger x = CUInt (fromInteger x) } ; instance Read CUInt where { readsPrec p s = map (\(x, t) -> (CUInt x, t)) (readsPrec p s) } ; instance Show CUInt where { showsPrec p (CUInt x) = showsPrec p x } ; instance Enum CUInt where { succ           (CUInt i)             = CUInt (succ i) ; pred           (CUInt i)             = CUInt (pred i) ; toEnum               x           = CUInt (toEnum x) ; fromEnum       (CUInt i)             = fromEnum i ; enumFrom       (CUInt i)             = map CUInt (enumFrom i) ; enumFromThen   (CUInt i) (CUInt j)       = map CUInt (enumFromThen i j) ; enumFromTo     (CUInt i) (CUInt j)       = map CUInt (enumFromTo i j) ; enumFromThenTo (CUInt i) (CUInt j) (CUInt k) = map CUInt (enumFromThenTo i j k) } ; instance Storable CUInt where { sizeOf    (CUInt x)       = sizeOf x ; alignment (CUInt x)       = alignment x ; peekElemOff a i       = liftM CUInt (peekElemOff (castPtr a) i) ; pokeElemOff a i (CUInt x) = pokeElemOff (castPtr a) i x } ; tyConCUInt = mkTyCon "CUInt"; instance Typeable CUInt where { typeOf _ = mkAppTy tyConCUInt [] } ; ; instance Bounded CUInt where { minBound = CUInt minBound ; maxBound = CUInt maxBound } ; instance Real CUInt where { toRational (CUInt i) = toRational i } ; instance Integral CUInt where { (CUInt i) `quot`    (CUInt j) = CUInt (i `quot` j) ; (CUInt i) `rem`     (CUInt j) = CUInt (i `rem`  j) ; (CUInt i) `div`     (CUInt j) = CUInt (i `div`  j) ; (CUInt i) `mod`     (CUInt j) = CUInt (i `mod`  j) ; (CUInt i) `quotRem` (CUInt j) = let (q,r) = i `quotRem` j in (CUInt q, CUInt r) ; (CUInt i) `divMod`  (CUInt j) = let (d,m) = i `divMod`  j in (CUInt d, CUInt m) ; toInteger (CUInt i)       = toInteger i } ; instance Bits CUInt where { (CUInt x) .&.     (CUInt y)   = CUInt (x .&.   y) ; (CUInt x) .|.     (CUInt y)   = CUInt (x .|.   y) ; (CUInt x) `xor`   (CUInt y)   = CUInt (x `xor` y) ; complement    (CUInt x)   = CUInt (complement x) ; shift         (CUInt x) n = CUInt (shift x n) ; rotate        (CUInt x) n = CUInt (rotate x n) ; bit                 n = CUInt (bit n) ; setBit        (CUInt x) n = CUInt (setBit x n) ; clearBit      (CUInt x) n = CUInt (clearBit x n) ; complementBit (CUInt x) n = CUInt (complementBit x n) ; testBit       (CUInt x) n = testBit x n ; bitSize       (CUInt x)   = bitSize x ; isSigned      (CUInt x)   = isSigned x }

newtype CLong = CLong Int32 deriving (Eq, Ord) ; instance Num CLong where { (CLong i) + (CLong j) = CLong (i + j) ; (CLong i) - (CLong j) = CLong (i - j) ; (CLong i) * (CLong j) = CLong (i * j) ; negate  (CLong i) = CLong (negate i) ; abs     (CLong i) = CLong (abs    i) ; signum  (CLong i) = CLong (signum i) ; fromInteger x = CLong (fromInteger x) } ; instance Read CLong where { readsPrec p s = map (\(x, t) -> (CLong x, t)) (readsPrec p s) } ; instance Show CLong where { showsPrec p (CLong x) = showsPrec p x } ; instance Enum CLong where { succ           (CLong i)             = CLong (succ i) ; pred           (CLong i)             = CLong (pred i) ; toEnum               x           = CLong (toEnum x) ; fromEnum       (CLong i)             = fromEnum i ; enumFrom       (CLong i)             = map CLong (enumFrom i) ; enumFromThen   (CLong i) (CLong j)       = map CLong (enumFromThen i j) ; enumFromTo     (CLong i) (CLong j)       = map CLong (enumFromTo i j) ; enumFromThenTo (CLong i) (CLong j) (CLong k) = map CLong (enumFromThenTo i j k) } ; instance Storable CLong where { sizeOf    (CLong x)       = sizeOf x ; alignment (CLong x)       = alignment x ; peekElemOff a i       = liftM CLong (peekElemOff (castPtr a) i) ; pokeElemOff a i (CLong x) = pokeElemOff (castPtr a) i x } ; tyConCLong = mkTyCon "CLong"; instance Typeable CLong where { typeOf _ = mkAppTy tyConCLong [] } ; ; instance Bounded CLong where { minBound = CLong minBound ; maxBound = CLong maxBound } ; instance Real CLong where { toRational (CLong i) = toRational i } ; instance Integral CLong where { (CLong i) `quot`    (CLong j) = CLong (i `quot` j) ; (CLong i) `rem`     (CLong j) = CLong (i `rem`  j) ; (CLong i) `div`     (CLong j) = CLong (i `div`  j) ; (CLong i) `mod`     (CLong j) = CLong (i `mod`  j) ; (CLong i) `quotRem` (CLong j) = let (q,r) = i `quotRem` j in (CLong q, CLong r) ; (CLong i) `divMod`  (CLong j) = let (d,m) = i `divMod`  j in (CLong d, CLong m) ; toInteger (CLong i)       = toInteger i } ; instance Bits CLong where { (CLong x) .&.     (CLong y)   = CLong (x .&.   y) ; (CLong x) .|.     (CLong y)   = CLong (x .|.   y) ; (CLong x) `xor`   (CLong y)   = CLong (x `xor` y) ; complement    (CLong x)   = CLong (complement x) ; shift         (CLong x) n = CLong (shift x n) ; rotate        (CLong x) n = CLong (rotate x n) ; bit                 n = CLong (bit n) ; setBit        (CLong x) n = CLong (setBit x n) ; clearBit      (CLong x) n = CLong (clearBit x n) ; complementBit (CLong x) n = CLong (complementBit x n) ; testBit       (CLong x) n = testBit x n ; bitSize       (CLong x)   = bitSize x ; isSigned      (CLong x)   = isSigned x }
newtype CULong = CULong Word32 deriving (Eq, Ord) ; instance Num CULong where { (CULong i) + (CULong j) = CULong (i + j) ; (CULong i) - (CULong j) = CULong (i - j) ; (CULong i) * (CULong j) = CULong (i * j) ; negate  (CULong i) = CULong (negate i) ; abs     (CULong i) = CULong (abs    i) ; signum  (CULong i) = CULong (signum i) ; fromInteger x = CULong (fromInteger x) } ; instance Read CULong where { readsPrec p s = map (\(x, t) -> (CULong x, t)) (readsPrec p s) } ; instance Show CULong where { showsPrec p (CULong x) = showsPrec p x } ; instance Enum CULong where { succ           (CULong i)             = CULong (succ i) ; pred           (CULong i)             = CULong (pred i) ; toEnum               x           = CULong (toEnum x) ; fromEnum       (CULong i)             = fromEnum i ; enumFrom       (CULong i)             = map CULong (enumFrom i) ; enumFromThen   (CULong i) (CULong j)       = map CULong (enumFromThen i j) ; enumFromTo     (CULong i) (CULong j)       = map CULong (enumFromTo i j) ; enumFromThenTo (CULong i) (CULong j) (CULong k) = map CULong (enumFromThenTo i j k) } ; instance Storable CULong where { sizeOf    (CULong x)       = sizeOf x ; alignment (CULong x)       = alignment x ; peekElemOff a i       = liftM CULong (peekElemOff (castPtr a) i) ; pokeElemOff a i (CULong x) = pokeElemOff (castPtr a) i x } ; tyConCULong = mkTyCon "CULong"; instance Typeable CULong where { typeOf _ = mkAppTy tyConCULong [] } ; ; instance Bounded CULong where { minBound = CULong minBound ; maxBound = CULong maxBound } ; instance Real CULong where { toRational (CULong i) = toRational i } ; instance Integral CULong where { (CULong i) `quot`    (CULong j) = CULong (i `quot` j) ; (CULong i) `rem`     (CULong j) = CULong (i `rem`  j) ; (CULong i) `div`     (CULong j) = CULong (i `div`  j) ; (CULong i) `mod`     (CULong j) = CULong (i `mod`  j) ; (CULong i) `quotRem` (CULong j) = let (q,r) = i `quotRem` j in (CULong q, CULong r) ; (CULong i) `divMod`  (CULong j) = let (d,m) = i `divMod`  j in (CULong d, CULong m) ; toInteger (CULong i)       = toInteger i } ; instance Bits CULong where { (CULong x) .&.     (CULong y)   = CULong (x .&.   y) ; (CULong x) .|.     (CULong y)   = CULong (x .|.   y) ; (CULong x) `xor`   (CULong y)   = CULong (x `xor` y) ; complement    (CULong x)   = CULong (complement x) ; shift         (CULong x) n = CULong (shift x n) ; rotate        (CULong x) n = CULong (rotate x n) ; bit                 n = CULong (bit n) ; setBit        (CULong x) n = CULong (setBit x n) ; clearBit      (CULong x) n = CULong (clearBit x n) ; complementBit (CULong x) n = CULong (complementBit x n) ; testBit       (CULong x) n = testBit x n ; bitSize       (CULong x)   = bitSize x ; isSigned      (CULong x)   = isSigned x }

{-# RULES
"fromIntegral/a->CChar"   fromIntegral = \x -> CChar   (fromIntegral x)
"fromIntegral/a->CSChar"  fromIntegral = \x -> CSChar  (fromIntegral x)
"fromIntegral/a->CUChar"  fromIntegral = \x -> CUChar  (fromIntegral x)
"fromIntegral/a->CShort"  fromIntegral = \x -> CShort  (fromIntegral x)
"fromIntegral/a->CUShort" fromIntegral = \x -> CUShort (fromIntegral x)
"fromIntegral/a->CInt"    fromIntegral = \x -> CInt    (fromIntegral x)
"fromIntegral/a->CUInt"   fromIntegral = \x -> CUInt   (fromIntegral x)
"fromIntegral/a->CLong"   fromIntegral = \x -> CLong   (fromIntegral x)
"fromIntegral/a->CULong"  fromIntegral = \x -> CULong  (fromIntegral x)
"fromIntegral/a->CLLong"  fromIntegral = \x -> CLLong  (fromIntegral x)
"fromIntegral/a->CULLong" fromIntegral = \x -> CULLong (fromIntegral x)

"fromIntegral/CChar->a"   fromIntegral = \(CChar   x) -> fromIntegral x
"fromIntegral/CSChar->a"  fromIntegral = \(CSChar  x) -> fromIntegral x
"fromIntegral/CUChar->a"  fromIntegral = \(CUChar  x) -> fromIntegral x
"fromIntegral/CShort->a"  fromIntegral = \(CShort  x) -> fromIntegral x
"fromIntegral/CUShort->a" fromIntegral = \(CUShort x) -> fromIntegral x
"fromIntegral/CInt->a"    fromIntegral = \(CInt    x) -> fromIntegral x
"fromIntegral/CUInt->a"   fromIntegral = \(CUInt   x) -> fromIntegral x
"fromIntegral/CLong->a"   fromIntegral = \(CLong   x) -> fromIntegral x
"fromIntegral/CULong->a"  fromIntegral = \(CULong  x) -> fromIntegral x
"fromIntegral/CLLong->a"  fromIntegral = \(CLLong  x) -> fromIntegral x
"fromIntegral/CULLong->a" fromIntegral = \(CULLong x) -> fromIntegral x
 #-}

newtype CFloat = CFloat Float deriving (Eq, Ord) ; instance Num CFloat where { (CFloat i) + (CFloat j) = CFloat (i + j) ; (CFloat i) - (CFloat j) = CFloat (i - j) ; (CFloat i) * (CFloat j) = CFloat (i * j) ; negate  (CFloat i) = CFloat (negate i) ; abs     (CFloat i) = CFloat (abs    i) ; signum  (CFloat i) = CFloat (signum i) ; fromInteger x = CFloat (fromInteger x) } ; instance Read CFloat where { readsPrec p s = map (\(x, t) -> (CFloat x, t)) (readsPrec p s) } ; instance Show CFloat where { showsPrec p (CFloat x) = showsPrec p x } ; instance Enum CFloat where { succ           (CFloat i)             = CFloat (succ i) ; pred           (CFloat i)             = CFloat (pred i) ; toEnum               x           = CFloat (toEnum x) ; fromEnum       (CFloat i)             = fromEnum i ; enumFrom       (CFloat i)             = map CFloat (enumFrom i) ; enumFromThen   (CFloat i) (CFloat j)       = map CFloat (enumFromThen i j) ; enumFromTo     (CFloat i) (CFloat j)       = map CFloat (enumFromTo i j) ; enumFromThenTo (CFloat i) (CFloat j) (CFloat k) = map CFloat (enumFromThenTo i j k) } ; instance Storable CFloat where { sizeOf    (CFloat x)       = sizeOf x ; alignment (CFloat x)       = alignment x ; peekElemOff a i       = liftM CFloat (peekElemOff (castPtr a) i) ; pokeElemOff a i (CFloat x) = pokeElemOff (castPtr a) i x } ; tyConCFloat = mkTyCon "CFloat"; instance Typeable CFloat where { typeOf _ = mkAppTy tyConCFloat [] } ; ; instance Real CFloat where { toRational (CFloat i) = toRational i } ; instance Fractional CFloat where { (CFloat x) / (CFloat y)  = CFloat (x / y) ; recip   (CFloat x)  = CFloat (recip x) ; fromRational	r = CFloat (fromRational r) } ; instance Floating CFloat where { pi                    = pi ; exp   (CFloat x)           = CFloat (exp   x) ; log   (CFloat x)           = CFloat (log   x) ; sqrt  (CFloat x)           = CFloat (sqrt  x) ; (CFloat x) **        (CFloat y) = CFloat (x ** y) ; (CFloat x) `logBase` (CFloat y) = CFloat (x `logBase` y) ; sin   (CFloat x)           = CFloat (sin   x) ; cos   (CFloat x)           = CFloat (cos   x) ; tan   (CFloat x)           = CFloat (tan   x) ; asin  (CFloat x)           = CFloat (asin  x) ; acos  (CFloat x)           = CFloat (acos  x) ; atan  (CFloat x)           = CFloat (atan  x) ; sinh  (CFloat x)           = CFloat (sinh  x) ; cosh  (CFloat x)           = CFloat (cosh  x) ; tanh  (CFloat x)           = CFloat (tanh  x) ; asinh (CFloat x)           = CFloat (asinh x) ; acosh (CFloat x)           = CFloat (acosh x) ; atanh (CFloat x)           = CFloat (atanh x) } ; instance RealFrac CFloat where { properFraction (CFloat x) = let (m,y) = properFraction x in (m, CFloat y) ; truncate (CFloat x) = truncate x ; round    (CFloat x) = round x ; ceiling  (CFloat x) = ceiling x ; floor    (CFloat x) = floor x } ; instance RealFloat CFloat where { floatRadix     (CFloat x) = floatRadix x ; floatDigits    (CFloat x) = floatDigits x ; floatRange     (CFloat x) = floatRange x ; decodeFloat    (CFloat x) = decodeFloat x ; encodeFloat m n      = CFloat (encodeFloat m n) ; exponent       (CFloat x) = exponent x ; significand    (CFloat x) = CFloat (significand  x) ; scaleFloat n   (CFloat x) = CFloat (scaleFloat n x) ; isNaN          (CFloat x) = isNaN x ; isInfinite     (CFloat x) = isInfinite x ; isDenormalized (CFloat x) = isDenormalized x ; isNegativeZero (CFloat x) = isNegativeZero x ; isIEEE         (CFloat x) = isIEEE x ; (CFloat x) `atan2`  (CFloat y) = CFloat (x `atan2` y) }
newtype CDouble = CDouble Double deriving (Eq, Ord) ; instance Num CDouble where { (CDouble i) + (CDouble j) = CDouble (i + j) ; (CDouble i) - (CDouble j) = CDouble (i - j) ; (CDouble i) * (CDouble j) = CDouble (i * j) ; negate  (CDouble i) = CDouble (negate i) ; abs     (CDouble i) = CDouble (abs    i) ; signum  (CDouble i) = CDouble (signum i) ; fromInteger x = CDouble (fromInteger x) } ; instance Read CDouble where { readsPrec p s = map (\(x, t) -> (CDouble x, t)) (readsPrec p s) } ; instance Show CDouble where { showsPrec p (CDouble x) = showsPrec p x } ; instance Enum CDouble where { succ           (CDouble i)             = CDouble (succ i) ; pred           (CDouble i)             = CDouble (pred i) ; toEnum               x           = CDouble (toEnum x) ; fromEnum       (CDouble i)             = fromEnum i ; enumFrom       (CDouble i)             = map CDouble (enumFrom i) ; enumFromThen   (CDouble i) (CDouble j)       = map CDouble (enumFromThen i j) ; enumFromTo     (CDouble i) (CDouble j)       = map CDouble (enumFromTo i j) ; enumFromThenTo (CDouble i) (CDouble j) (CDouble k) = map CDouble (enumFromThenTo i j k) } ; instance Storable CDouble where { sizeOf    (CDouble x)       = sizeOf x ; alignment (CDouble x)       = alignment x ; peekElemOff a i       = liftM CDouble (peekElemOff (castPtr a) i) ; pokeElemOff a i (CDouble x) = pokeElemOff (castPtr a) i x } ; tyConCDouble = mkTyCon "CDouble"; instance Typeable CDouble where { typeOf _ = mkAppTy tyConCDouble [] } ; ; instance Real CDouble where { toRational (CDouble i) = toRational i } ; instance Fractional CDouble where { (CDouble x) / (CDouble y)  = CDouble (x / y) ; recip   (CDouble x)  = CDouble (recip x) ; fromRational	r = CDouble (fromRational r) } ; instance Floating CDouble where { pi                    = pi ; exp   (CDouble x)           = CDouble (exp   x) ; log   (CDouble x)           = CDouble (log   x) ; sqrt  (CDouble x)           = CDouble (sqrt  x) ; (CDouble x) **        (CDouble y) = CDouble (x ** y) ; (CDouble x) `logBase` (CDouble y) = CDouble (x `logBase` y) ; sin   (CDouble x)           = CDouble (sin   x) ; cos   (CDouble x)           = CDouble (cos   x) ; tan   (CDouble x)           = CDouble (tan   x) ; asin  (CDouble x)           = CDouble (asin  x) ; acos  (CDouble x)           = CDouble (acos  x) ; atan  (CDouble x)           = CDouble (atan  x) ; sinh  (CDouble x)           = CDouble (sinh  x) ; cosh  (CDouble x)           = CDouble (cosh  x) ; tanh  (CDouble x)           = CDouble (tanh  x) ; asinh (CDouble x)           = CDouble (asinh x) ; acosh (CDouble x)           = CDouble (acosh x) ; atanh (CDouble x)           = CDouble (atanh x) } ; instance RealFrac CDouble where { properFraction (CDouble x) = let (m,y) = properFraction x in (m, CDouble y) ; truncate (CDouble x) = truncate x ; round    (CDouble x) = round x ; ceiling  (CDouble x) = ceiling x ; floor    (CDouble x) = floor x } ; instance RealFloat CDouble where { floatRadix     (CDouble x) = floatRadix x ; floatDigits    (CDouble x) = floatDigits x ; floatRange     (CDouble x) = floatRange x ; decodeFloat    (CDouble x) = decodeFloat x ; encodeFloat m n      = CDouble (encodeFloat m n) ; exponent       (CDouble x) = exponent x ; significand    (CDouble x) = CDouble (significand  x) ; scaleFloat n   (CDouble x) = CDouble (scaleFloat n x) ; isNaN          (CDouble x) = isNaN x ; isInfinite     (CDouble x) = isInfinite x ; isDenormalized (CDouble x) = isDenormalized x ; isNegativeZero (CDouble x) = isNegativeZero x ; isIEEE         (CDouble x) = isIEEE x ; (CDouble x) `atan2`  (CDouble y) = CDouble (x `atan2` y) }
-- HACK: Currently no long double in the FFI, so we simply re-use double
newtype CLDouble = CLDouble Double deriving (Eq, Ord) ; instance Num CLDouble where { (CLDouble i) + (CLDouble j) = CLDouble (i + j) ; (CLDouble i) - (CLDouble j) = CLDouble (i - j) ; (CLDouble i) * (CLDouble j) = CLDouble (i * j) ; negate  (CLDouble i) = CLDouble (negate i) ; abs     (CLDouble i) = CLDouble (abs    i) ; signum  (CLDouble i) = CLDouble (signum i) ; fromInteger x = CLDouble (fromInteger x) } ; instance Read CLDouble where { readsPrec p s = map (\(x, t) -> (CLDouble x, t)) (readsPrec p s) } ; instance Show CLDouble where { showsPrec p (CLDouble x) = showsPrec p x } ; instance Enum CLDouble where { succ           (CLDouble i)             = CLDouble (succ i) ; pred           (CLDouble i)             = CLDouble (pred i) ; toEnum               x           = CLDouble (toEnum x) ; fromEnum       (CLDouble i)             = fromEnum i ; enumFrom       (CLDouble i)             = map CLDouble (enumFrom i) ; enumFromThen   (CLDouble i) (CLDouble j)       = map CLDouble (enumFromThen i j) ; enumFromTo     (CLDouble i) (CLDouble j)       = map CLDouble (enumFromTo i j) ; enumFromThenTo (CLDouble i) (CLDouble j) (CLDouble k) = map CLDouble (enumFromThenTo i j k) } ; instance Storable CLDouble where { sizeOf    (CLDouble x)       = sizeOf x ; alignment (CLDouble x)       = alignment x ; peekElemOff a i       = liftM CLDouble (peekElemOff (castPtr a) i) ; pokeElemOff a i (CLDouble x) = pokeElemOff (castPtr a) i x } ; tyConCLDouble = mkTyCon "CLDouble"; instance Typeable CLDouble where { typeOf _ = mkAppTy tyConCLDouble [] } ; ; instance Real CLDouble where { toRational (CLDouble i) = toRational i } ; instance Fractional CLDouble where { (CLDouble x) / (CLDouble y)  = CLDouble (x / y) ; recip   (CLDouble x)  = CLDouble (recip x) ; fromRational	r = CLDouble (fromRational r) } ; instance Floating CLDouble where { pi                    = pi ; exp   (CLDouble x)           = CLDouble (exp   x) ; log   (CLDouble x)           = CLDouble (log   x) ; sqrt  (CLDouble x)           = CLDouble (sqrt  x) ; (CLDouble x) **        (CLDouble y) = CLDouble (x ** y) ; (CLDouble x) `logBase` (CLDouble y) = CLDouble (x `logBase` y) ; sin   (CLDouble x)           = CLDouble (sin   x) ; cos   (CLDouble x)           = CLDouble (cos   x) ; tan   (CLDouble x)           = CLDouble (tan   x) ; asin  (CLDouble x)           = CLDouble (asin  x) ; acos  (CLDouble x)           = CLDouble (acos  x) ; atan  (CLDouble x)           = CLDouble (atan  x) ; sinh  (CLDouble x)           = CLDouble (sinh  x) ; cosh  (CLDouble x)           = CLDouble (cosh  x) ; tanh  (CLDouble x)           = CLDouble (tanh  x) ; asinh (CLDouble x)           = CLDouble (asinh x) ; acosh (CLDouble x)           = CLDouble (acosh x) ; atanh (CLDouble x)           = CLDouble (atanh x) } ; instance RealFrac CLDouble where { properFraction (CLDouble x) = let (m,y) = properFraction x in (m, CLDouble y) ; truncate (CLDouble x) = truncate x ; round    (CLDouble x) = round x ; ceiling  (CLDouble x) = ceiling x ; floor    (CLDouble x) = floor x } ; instance RealFloat CLDouble where { floatRadix     (CLDouble x) = floatRadix x ; floatDigits    (CLDouble x) = floatDigits x ; floatRange     (CLDouble x) = floatRange x ; decodeFloat    (CLDouble x) = decodeFloat x ; encodeFloat m n      = CLDouble (encodeFloat m n) ; exponent       (CLDouble x) = exponent x ; significand    (CLDouble x) = CLDouble (significand  x) ; scaleFloat n   (CLDouble x) = CLDouble (scaleFloat n x) ; isNaN          (CLDouble x) = isNaN x ; isInfinite     (CLDouble x) = isInfinite x ; isDenormalized (CLDouble x) = isDenormalized x ; isNegativeZero (CLDouble x) = isNegativeZero x ; isIEEE         (CLDouble x) = isIEEE x ; (CLDouble x) `atan2`  (CLDouble y) = CLDouble (x `atan2` y) }

