;;; i18n-man-en.el --- browse UNIX English manual pages
;;; $Id: i18n-man-en.el,v 1.2 1998/09/20 16:28:15 iwasaki Exp $:

;;;  This file part of i18n-man - i18nized man,
;;;  a GNU Emacs front end to browse the UNIX manual pages in various languages.

;;; Everyone is granted permission to copy, modify and redistribute
;;; this program.

;;; HISTORY
;;;
;;;	Written by Mitsuru IWASAKI 11 Sep, 1998 (FreeBSD Japanese man Project)
;;;

;;; Suggested USAGE
;;;
;;;  In your ~/.emacs
;;;(autoload 'jman "i18n-man-ja" nil t)
;;;(autoload 'eman "i18n-man-en" nil t)
;;;  then
;;;  M-x jman
;;;    to get a Japanese manual page thru jman(1) and put it in a buffer.
;;;  M-x eman
;;;    to get a English manual page thru man(1) and put it in a buffer.

(require 'i18n-man)
(defun i18n-Man-en-init-defvars ()
  "Used for initialising variables for English i18n-man."
  (i18n-Man-init-lang-depend-variables)
  (setq i18n-manual-lang-depend-program "man")
  (setq i18n-Man-lang-depend-language-string "English")
  (setq i18n-Man-lang-depend-heading-regexp
	"^\\([A-Z][A-Z ]+\\)$")
  (setq i18n-Man-lang-depend-see-also-regexp
	"SEE ALSO")
  (setq i18n-Man-lang-depend-first-heading-regexp
	"^[ \t]*NAME$\\|^[ \t]*No manual entry fo.*$"))

;;;###autoload
(defun eman ()
  "i18n-man for English manpage."
  (interactive)
  (i18n-Man-en-init-defvars)
  (call-interactively 'i18n-man))

(provide 'eman)

;;; i18n-man-en.el ends here
