;;; i18n-man-ja.el --- browse UNIX Japanese manual pages
;;; $Id: i18n-man-ja.el,v 1.3 1998/09/12 20:25:53 iwasaki Exp iwasaki $:

;;;  This file part of i18n-man - i18nized man,
;;;  a GNU Emacs front end to browse the UNIX manual pages in various langages.

;;; Everyone is granted permission to copy, modify and redistribute
;;; this program.

;;; HISTORY
;;;
;;;	Written by Mitsuru IWASAKI 11 Sep, 1998 (FreeBSD Japanese man Project)
;;;

;;; Suggested USAGE
;;;
;;;  In your ~/.emacs
;;;(autoload 'jman "i18n-man-ja" nil t)
;;;(autoload 'eman "i18n-man-en" nil t)
;;;  then
;;;  M-x jman
;;;    to get a Japanese manual page thru jman(1) and put it in a buffer.
;;;  M-x eman
;;;    to get a English manual page thru man(1) and put it in a buffer.

(require 'i18n-man)

(defun i18n-Man-ja-init-defvars ()
  "Used for initialising variables for Japanese i18n-man."
  (i18n-Man-init-lang-depend-variables)
  (setq i18n-manual-lang-depend-program "jman")
  (setq i18n-Man-lang-depend-language-string "Japanese")
  (setq i18n-Man-lang-depend-heading-regexp
	"^\\([^ \t\n_][^0-9\n]+\\)$")
  (setq i18n-Man-lang-depend-see-also-regexp
	"Ϣ\\|^SEE ALSO")
  (setq i18n-Man-lang-depend-first-heading-regexp
	"^[ \t]*̾$\\|^[ \t]*NAME$\\|^[ \t]*No manual entry fo.*$")

  (setq i18n-Man-lang-depend-cooked-hook
	'i18n-Man-ja-depend-fontify-manpage)
  (setq i18n-Man-lang-depend-process-starting-hook
	'i18n-Man-ja-depend-process-starting-hook)
  (setq i18n-Man-lang-depend-process-started-hook
	'i18n-Man-ja-depend-process-started-hook))

(defun i18n-Man-ja-depend-fontify-manpage ()
  "Hook for the Japanese manpage depend fontify manpage.
Format the heading characters with BS such as ̾̾."
  (goto-char (point-min))
  (while (re-search-forward "\\(.\\)\\(\b+\\1\\)+" nil t)
    (replace-match "\\1")
    (put-text-property (- (point) 3) (point) 'face i18n-Man-overstrike-face)))

;; for temporary use.
(defvar i18n-Man-ja-depend-process-coding-system-alist nil)
(defvar i18n-Man-ja-depend-file-name-coding-system nil)
(defvar i18n-Man-ja-depend-default-process-coding-system nil)

(require 'cl)
(defun i18n-Man-ja-depend-process-starting-hook ()
  "Hook for the Japanese manpage depend default coding system setting.
Also save original values of variable to the local variable temporary."
  (setenv "LC_CTYPE" "ja_JP.EUC")
  (if (featurep 'mule)
      (case emacs-major-version
	(20 ;; XEmacs or Emacs-20.x (Mule-2.4, 3.0 or later)
	 (setq i18n-Man-ja-depend-process-coding-system-alist process-coding-system-alist)
	 (setq i18n-Man-ja-depend-file-name-coding-system file-name-coding-system)
	 (if (and (boundp 'mule-version)
		  (string-match "2.4" mule-version))
	     ;; Mule-2.4
	     (progn
	       (setq process-coding-system-alist '(("sh" coding-system-euc-japan . coding-system-euc-japan)))
	       (setq file-name-coding-system 'coding-system-euc-japan))
	   ;; XEmacs , Mule-3.0 or later
	   (progn
	     (setq process-coding-system-alist '(("sh" euc-japan . euc-japan)))
	     (setq file-name-coding-system 'euc-japan))
	     ))
	(19 ;; Emacs-19.x (Mule-2.3)
	 (setq i18n-Man-ja-depend-default-process-coding-system default-process-coding-system)
	 (setq default-process-coding-system (cons '*euc-japan* '*euc-japan*))
	 ))))

(defun i18n-Man-ja-depend-process-started-hook (process)
  "Hook for the Japanese manpage depend coding system setting.
Also restore original values of variable from the local variable."
  (if (featurep 'mule)
      (case emacs-major-version
	(20 ;; XEmacs or Emacs-20.x (Mule-2.4, 3.0 or later)
	 (setq process-coding-system-alist i18n-Man-ja-depend-process-coding-system-alist)
	 (setq file-name-coding-system i18n-Man-ja-depend-file-name-coding-system))
	(19 ;; Emacs-19.x (Mule-2.3)
	 (setq default-process-coding-system i18n-Man-ja-depend-default-process-coding-system)
	 (set-process-coding-system process '*euc-japan* '*euc-japan*)))))
  
;;;###autoload
(defun jman ()
  "i18n-man for Japanese manpage."
  (interactive)
  (i18n-Man-ja-init-defvars)
  (call-interactively 'i18n-man))

(provide 'jman)

;;; i18n-man-ja.el ends here
