#!/usr/bin/perl5.6.1
# $Id: mkres.pl,v 1.6 2002/11/19 14:37:14 taoka Exp $

require 'getopts.pl';

Getopts('hbJILm:f:Z:z:c:X:P:i:s:R:G:');

die "Usage: $0 [-hbJIL] [-m 'options'] [-z 'num1 num2 [...]'] [-n num]
            [-c num] [-X 'x-font'] [-P 'ps-font'] [-i num]
            [-Z num] -f format [directory-name [...]]

    -h: show this help
    -m 'options': options for mkttfdir (default '-d -j')
                  WARNING: '-d' must be included in it.
    -I: add resources for 'Oblique' fonts.
            (If this is set, '-o' is added to options of mkttfdir.)
    -f format: tgif         - X resources for tgif4
               tgif3        - X resources for Japanized tgif(version 3)
               CIDFnmap.jp  - CIDFnmap.jp for Ghostscript 6 or later
               idraw        - X resources for Japanized idraw
               xfig         - X resources for internationalized xfig
               vfontcap     - vfontcap for VFlib
               kconfig      - kconfig.ps for ghostscript using VFlib
               xv-fonts.dir - fonts.dir for X-V (X server with VFlib)

     directory-name: directory including truetype fonts
                     if you omit this, current directory is set;
                     if \"-\" is set, it means fonts data like \"fonts.dir\" format
                              are inputed from a standard input.

     [option for tgif]
       -J:  If you use JIS code as Japanese PS fonts, this is set (default EUC).
       -R:  X fonts for Ryumin-Light (defalut -jis-fixed-medium-r)
       -G:  X fonts for GothicBBB-Medium (defalut -jis-fixed-medium-r)
     [options for idraw]
       -z 'num1 num2 ...': values of font sizes (default '12 14 24')
       -s num: value of offset for X resources \"idraw.font$num\" and
               \"idraw.compositeFont$num\" (default 16)
       -c num: value of offset for a X resource \"idraw.PSCompositeFont\" (default 8)
       -X 'x-font': iso8859-1 font for X
             (default -adobe-times-medium-r-normal--%d-*-*-*-*-*-iso8859-1)
               WARNING: '%d' must be included in it.
       -P 'ps-font': iso8859-1 font for PS (default Times-Roman)
     [options for xfig]
       -Z num: size of ISO8859-1 and jisx0208.1983-0 fonts (default 64)
       -X 'x-font': see \"idraw\" section
       -P 'ps-font': see \"idraw\" section
     [options for CIDFnmap.jp]
     [options for vfontcap]
       -i num: value (0 <= num <= 1.0) for
                auto-italic (reverse auto-italic) option (default 0.2)
               (for reverse auto-italic fonts, it is treated as negative value)
       -b: If you use \"truetype\" as a font driver for VFlib, this is set
           (default \"freetype\").
     [options for kconfig]
       -s num:  offset of first Kanji font (default 4300400)
       -b: If you use \"VFlibkanji\" as operator for Kanji fonts using VFlib,
           this is set (default \"VFlibBMkanji\").
" if ($opt_h || ($opt_f ne "tgif" && $opt_f ne "idraw"
		 && $opt_f ne "xfig" && $opt_f ne "vfontcap"
		 && $opt_f ne "kconfig" && $opt_f ne "xv-fonts.dir"
		 && $opt_f ne "jps_font" && $opt_f ne "tgif3"
		 && $opt_f ne "CIDFnmap.jp"));

$ai = 0.2;
die "\n \"num\" of option \"-i num\" must satisfy 0 <= num <= 1.0 !!\n"
  unless ($opt_i >= 0 && $opt_i <= 1.0);
$ai = $opt_i if defined $opt_i;
$mktt_opt = "-d -j";
$mktt_opt = $opt_m if defined $opt_m;
$mktt_opt .= " -o -i $ai" if defined $opt_I;
$mktt_opt .= " -o -i $ai" if defined $opt_L;

if ( defined $opt_R ){
  $X_Font_Ryumin = $opt_R;
}
else{      
  $X_Font_Ryumin = "-jis-fixed-medium-r"
}
if ( defined $opt_G ){
  $X_Font_Gothic = $opt_G;
}
else{      
  $X_Font_Gothic = "-jis-fixed-medium-r"
}

push @ARGV, "." unless @ARGV;

### BEGIN main ############################################################

# Initialization
&init();

sub by_last { ($last{$a} cmp $last{$b}) || ($a cmp $b) }

foreach $dir (@ARGV){
  if ($dir ne "-"){
    opendir(DIR, $dir) || die "can't opendir $dir: $!";
    undef @tti_exist if ($opt_f eq "vfontcap");
    @tti_exist = grep { /^.+\.tti$/ } readdir(DIR) if ($opt_f eq "vfontcap");
    closedir DIR;
    push(@lines3, "$dir") if !defined @tti_exist && ($opt_f eq "vfontcap");

    open(MKTTFDIR, "mkttfdir $mktt_opt $dir |") ||
      die "Couldn't run mkttfdir $! \n";
    @input = <MKTTFDIR>;
  }
  else{
    die "For this format, you cannot set '-' as a font directory name!!!\n"
      if($opt_f eq "vfontcap");
    @input = <STDIN>;
  }
  foreach (@input){
    chop;
    $last = $_;
    $last =~ s/^([^\s]+) (.+)$/$2/;
    $last{$_} = $last;
  }
  foreach (sort by_last @input){ # e.g. W3 -> W5 -> W7 ...
    s/^[0-9]+$//;  # number of fonts in fonts.dir
    next if ($_ eq "" || !/.*jisx0208.1983-0$/); # Now only jisx0208.1983 fonts
    /^([^\s]+) (.+)$/;
    $filename = $1;
    $xled = $2;
    $filename =~ s/^.*[:](.*\.tt[fc])/$1/;
    $_ = $xled;
    ($dummy, $foundry, $family_name, $weight_name, $slant,
     $setwidth_name, $add_style_name) = split('-');
#    $weight_name = ucfirst $weight_name;
    $nb_family_name = $family_name;
    $nb_family_name =~ s/\s+//g; # no blank
    $pixel_size = "";
    $point_size = "*";	# decipoints
    $resolution_x = "*";
    $resolution_y = "*";
    $spacing = "*";
    $average_width = "*";
    $charset_registry = "";
    $charset_encoding = "";

    $ttf_id = "$family_name-$weight_name";
    $nb_ttf_id = "$nb_family_name-$weight_name";

#    my %FontIDList = 
#      ( "filename" => $filename, 
#	  "foundry" => $foundry,
#	  "ttf_id" => $ttf_id,
#	  "nb_ttf_id" => $nb_ttf_id,
#	  "weight_name" => $weight_name,
#	  "slant" => $slant,
#	  "setwidth_name" => $setwidth_name,
#	  "add_style_name" => $add_style_name );

    $x_jisx = "-$foundry-$ttf_id-$slant-$setwidth_name-$add_style_name-";
    if($slant eq "r"){
      $nb_ttf_id_sty = $nb_ttf_id;
    }
    elsif($slant eq "o"){
      $nb_ttf_id_sty = &oblique_ttf_id($nb_ttf_id);
    }
    elsif($slant eq "ro"){
      $nb_ttf_id_sty = &lefty_ttf_id($nb_ttf_id);
    }
    
    ##########
    # tgif
    ##########
    if($opt_f eq "tgif"){
      &tgif_res ($nb_ttf_id_sty,
		   $x_jisx . "%d-*-*-*-*-*-jisx0208.1983-0",
		   $jps_code);
    }
    
    ##########
    # tgif3
    ##########
    if($opt_f eq "tgif3"){
      &tgif3_res ($nb_ttf_id_sty,
		   $x_jisx . "%d-*-*-*-*-*-jisx0208.1983-0",
		   $jps_code);
    }
    
    ##########
    # idraw
    ##########
    if($opt_f eq "idraw"){
      &idraw_res($nb_ttf_id_sty,
		 $x_jisx . "%d-*-*-*-*-*-jisx0208.1983-0",
		 $x_iso);
    }

    ##########
    # xfig
    ##########
    if($opt_f eq "xfig"){
      &xfig_res ($nb_ttf_id_sty,
		 $x_jisx . "%d-*-*-*-*-*-jisx0208.1983-0",
		 $x_iso, $ps_iso);
    }

    ##########
    # xv-fonts.dir
    ##########
    elsif($opt_f eq "xv-fonts.dir"){
      push(@lines,"$nb_ttf_id_sty.vflib " . 
	   $x_jisx . "0-0-0-0-c-0-jisx0208.1983-0" . "\n");
    }

    ##########
    # vfontcap
    ##########
    elsif($opt_f eq "vfontcap"){
      die "\nWARNING!! WARNING!! WARNING!! WARNING!! WARNING!! WARNING!! \n".
	"You must use full path name as the directory name.\n"
	unless ($dir =~ /^\//);
      &vfontcap_res ($nb_ttf_id_sty, $filename, $ai);
    }

    ##########
    # CIDFnmap.jp
    ##########
    elsif($opt_f eq "CIDFnmap.jp"){
      die "\nWARNING!! WARNING!! WARNING!! WARNING!! WARNING!! WARNING!! \n".
	"You must use full path name as the directory name.\n"
	unless ($dir =~ /^\//);
      &CIDFnmap_res ($nb_ttf_id_sty, $filename);
    }

    ##########
    # kconfig
    ##########
    elsif($opt_f eq "kconfig"){
      if (length($nb_ttf_id_sty) > 16) {
	warn "Length of a entry name ($nb_ttf_id_sty)" .
	  " for $filename\n" .
	    " is too long, so this is omitted";
      }
      else{
	&kconfig_res($nb_ttf_id_sty);
	$ps_offset = $ps_offset + 200;
      }
    }

    ##########
    # jps_font
    ##########
    elsif($opt_f eq "jps_font"){
      if($slant eq "r"){
	$fn = $filename;
	$fn =~ s/(^.+)\.tt[cf]/$1/;
	push(@lines,"BuildFont $nb_ttf_id $ps_offset" .
	     "$fn $fn\n");
      }
    }
  }
}

# output
&output();

### END main ##############################################################

sub init{
  my $i;

  if($opt_f eq "tgif"){
    $jps_code = "-EUC";
    $jps_code = "" if defined $opt_J;
    # For horizontal fonts
    push(@lines, "! For Japanese fonts\n");
    push(@lines, "Tgif*FontSizes:   8 10 12 14 16 18 20 24 28 32 36" .
	 " 40 44 50 60 70 100 150 300 400\n");
    push(@lines, "Tgif.RyuminShowFontChar: 244242\n");
    push(@lines, "Tgif.SquareDoubleByteFonts: \\n\\\n");
    for ($i=1; $i<=4; $i++){
	push(@lines, " $X_Font_Ryumin-*--%d-*-*-*-*-*-jisx0208.1983-* \\n\\
     H \\n\\
     Ryumin-Light$jps_code-H \\n\\\n");
    }
    push(@lines, " \\n\\\n");
    for ($i=1; $i<=4; $i++){
	push(@lines, " $X_Font_Gothic-*--%d-*-*-*-*-*-jisx0208.1983-* \\n\\
     H \\n\\
     GothicBBB-Medium$jps_code-H \\n\\\n");
    }
    push(@lines, " \\n\\\n");
    # For Vertical fonts
    for ($i=1; $i<=4; $i++){
	push(@lines2, " $X_Font_Ryumin-*--%d-*-*-*-*-*-jisx0208.1983-* \\n\\
     V \\n\\
     Ryumin-Light$jps_code-V \\n\\\n");
    }
    push(@lines2, " \\n\\\n");
    for ($i=1; $i<=4; $i++){
	push(@lines2, " $X_Font_Gothic-*--%d-*-*-*-*-*-jisx0208.1983-* \\n\\
     V \\n\\
     GothicBBB-Medium$jps_code-V \\n\\\n");
    }
    push(@lines2, " \\n\\\n");
  }
  elsif ($opt_f eq "tgif3"){
    $jps_code = "-EUC";
    $jps_code = "" if defined $opt_J;
    push(@lines, "! Sizes\n");
    push(@lines, "Tgif*FontSizes:   8 10 12 14 16 17 18 20 24 34" .
	 " 38 40 42 44 50 60 70 100 150 300\n");
    # For horizontal fonts
    push(@lines, "! For Japanese fonts\n");
    push(@lines, "Tgif*NihongoFonts: \\\n");
    push(@lines, " $X_Font_Ryumin-*--%d-*-*-*-*-*-jisx0208.1983-*,, \\\n");
    push(@lines, "	Ryumin-Light$jps_code-H, Ryumin, \\\n");
    push(@lines, "	H, false, 14,16,24 \\n\\\n");
    push(@lines, " $X_Font_Gothic-*--%d-*-*-*-*-*-jisx0208.1983-*,, \\\n");
    push(@lines, "	GothicBBB-Medium$jps_code-H, Gothic, \\\n");
    push(@lines, "	H, true, 14,16,24");
    # For Vertical fonts
    push(@lines2, " $X_Font_Ryumin-*--%d-*-*-*-*-*-jisx0208.1983-*,, \\\n");
    push(@lines2, "	Ryumin-Light$jps_code-V, Ryumin-V, \\\n");
    push(@lines2, "	V, false, 14,16,24 \\n\\\n");
    push(@lines2, " $X_Font_Gothic-*--%d-*-*-*-*-*-jisx0208.1983-*,, \\\n");
    push(@lines2, "	GothicBBB-Medium$jps_code-V, Gothic-V, \\\n");
    push(@lines2, "	V, true, 14,16,24");
  }
  elsif ($opt_f eq "idraw"){
    $idraw_sizes = "12 14 24";
    $idraw_sizes = $opt_z if defined $opt_z;
    $idraw_fnum = "16";
    $idraw_fnum = $opt_s if defined $opt_s;
    $idraw_cfnum = $idraw_fnum;
    $idraw_pscfnum = "8";
    $idraw_pscfnum = $opt_c if defined $opt_c;
    $x_iso = "-adobe-times-medium-r-normal--%d-*-*-*-*-*-iso8859-1";
                                # iso8859-1
    $x_iso = $opt_X if defined $opt_X;
    $ps_iso = "Times-Roman";	# iso8859-1
    $ps_iso = $opt_P if defined $opt_P;
    
    push(@lines, "!! defaults (Don't remove!!\)\n");
    push(@lines, "idraw.PSCompositeFont1: Courier-Bold-Gothic \\\n");
    push(@lines, "	Courier-Bold GothicBBB-Medium-EUC-H\n");
    push(@lines, "idraw.PSCompositeFont2: Courier-Ryumin \\\n");
    push(@lines, "	Courier Ryumin-Light-EUC-H\n");
    push(@lines, "idraw.PSCompositeFont3: Times-Ryumin \\\n");
    push(@lines, "	Times-Roman Ryumin-Light-EUC-H\n");
    push(@lines, "idraw.PSCompositeFont4: Times-Gothic \\\n");
    push(@lines, "	Times-Roman GothicBBB-Medium-EUC-H\n");
    push(@lines, "idraw.PSCompositeFont5: Helvetica-Gothic \\\n");
    push(@lines, "	Helvetica GothicBBB-Medium-EUC-H\n");
    push(@lines, "idraw.PSCompositeFont6: Times-Ryumin-Italic \\\n");
    push(@lines, "	Times-Italic Ryumin-Light-EUC-H-Slant\n");
    push(@lines, "idraw.PSCompositeFont7: Times-Bold-Gothic-Italic \\\n");
    push(@lines, "	Times-BoldItalic GothicBBB-Medium-EUC-H-Slant\n");
    push(@lines, "!! END defaults\n");
    push(@lines, "\n");
  }
  elsif ($opt_f eq "xfig"){
    $size = "64";
    $size = $opt_Z if defined $opt_Z;
    $ps_iso = "Times-Roman";	# iso8859-1
    $ps_iso = $opt_P if defined $opt_P;
    $x_iso = "-adobe-times-medium-r-normal--%d-*-*-*-*-*-iso8859-1";
    # iso8859-1
    $x_iso = $opt_X if defined $opt_X;
    $x_iso =~ s/%d/$size/g;
    
    push(@lines, "! WARNING!! WARNING!! WARNING!! WARNING!! WARNING!! WARNING!! \n");
    push(@lines, "! xfig cannot use more than three Japanese fonts.\n");
    push(@lines, "! So you should choose properly two entris for normal and bold fonts \n");
    push(@lines, "! from output X resources. \n");
    push(@lines, "!-- [Example]--------------------------------------------------\n");
    push(@lines, "!  !! font size\n");
    push(@lines, "!  Fig.fontSetSize: 64\n");
    push(@lines, "!  !! normal font\n");
    push(@lines, "!  Fig.normalFontSet: -adobe-times-medium-r-normal--64-*-*-*-*-*-*-*, \\\n");
    push(@lines, "!  \t-DynaLab-DFHSMincho-W3-r-normal--64-*-*-*-*-*--jisx0208.1983-0\n");
    push(@lines, "!  !! bold font\n");
    push(@lines, "!  Fig.boldFontSet: -adobe-times-bold-r-normal--64-*-*-*-*-*-*-*, \\\n");
    push(@lines, "!  \t-DynaLab-DFHSMincho-W9-r-normal--64-*-*-*-*-*--jisx0208.1983-0\n");
    push(@lines, "!--------------------------------------------------------------\n");
    push(@lines, "!\n");
    push(@lines, "! To print a figure created by xfig, you should edit from \n");
    push(@lines, "! ISO8859:1, ISO8859:2, JAPANESE:1 and JAPANESE:2 in the below description to \n");
    push(@lines, "! names of proper Postscript font, and copy it(deleting first \"!\")\n");
    push(@lines, "! to a proper directory.\n");
    push(@lines, "!--------------------------------------------------------------\n");
    push(@lines, "!% japanese.ps (ja_JP.EUC.ps on FreeBSD) for fig2dev 3.2\n");
    push(@lines, "!16 dict begin\n");
    push(@lines, "!  /FontName /CompositeRoman def  /FontType 0 def\n");
    push(@lines, "!  /WMode 0 def    /FMapType 3 def  /FontMatrix matrix def\n");
    push(@lines, "!  /Encoding [0 1] def\n");
    push(@lines, "!  /FDepVector [ /ISO8859:1 findfont\n");
    push(@lines, "!      /JAPANESE:1-EUC-H findfont ] def\n");
    push(@lines, "!  FontName currentdict\n");
    push(@lines, "!  end\n");
    push(@lines, "!definefont pop\n");
    push(@lines, "!16 dict begin\n");
    push(@lines, "!  /FontName /CompositeBold def  /FontType 0 def\n");
    push(@lines, "!  /WMode 0 def    /FMapType 3 def  /FontMatrix matrix def\n");
    push(@lines, "!  /Encoding [0 1] def\n");
    push(@lines, "!  /FDepVector [ /ISO8859:2 findfont\n");
    push(@lines, "!      /JAPANESE:2-EUC-H findfont ] def\n");
    push(@lines, "!  FontName currentdict\n");
    push(@lines, "!  end\n");
    push(@lines, "!definefont pop\n");
    push(@lines, "!% end of japanese.ps\n");
    push(@lines, "!--------------------------------------------------------------\n");
    push(@lines, "\n");
    push(@lines, "!!!!! X resources for xfig !!!!\n");
    push(@lines, "! Font size had better be large to look fine.\n");
    push(@lines, "Fig.fontSetSize: $size\n");
    push(@lines, "\n");
  }
  elsif($opt_f eq "vfontcap"){
    $fontdriver = "freetype";
    $fontdriver = "truetype" if defined $opt_b;
  }
  elsif($opt_f eq "kconfig"){
    $operator = "VFlibBMkanji";
    $operator = "VFlibkanji" if defined $opt_b;
    $ps_offset = "4300400";
    $ps_offset = $opt_s if defined $opt_s;
  }
}

sub output{
  if ($opt_f eq "tgif") {
    push(@lines2, "\n");
    foreach $l (@lines) {
      print $l;
    }
    foreach $l (@lines2) {
      print $l;
    }
  }
  elsif ($opt_f eq "tgif3") {
    push(@lines, " \\n\\\n");
    push(@lines2, "\n");
    foreach $l (@lines) {
      print $l;
    }
    foreach $l (@lines2) {
      print $l;
    }
  }
  elsif ($opt_f eq "xv-fonts.dir") {
    print $#lines + 1, "\n";
    foreach $l (@lines) {
      print $l;
    }
  }
  elsif ($opt_f eq "CIDFnmap.jp") {
    foreach $l (@lines) {
      print $l;
    }
  }
  elsif ($opt_f eq "vfontcap"){
    foreach $l (@lines) {
      print $l;
    }
    print STDERR "\nWARNING!! WARNING!! WARNING!! WARNING!! " .
      "WARNING!! WARNING!! \n".
	"Have you done `ttindex file.[ttc|ttf]` " .
	  "for each truetype font file\n" .
	    "in @lines3, where ttindex is a command for VFlib ?\n"
	      if defined $opt_b && defined @lines3;
  }
  elsif ($opt_f eq "jps_font"){
    #  system "cp gs/build.sh.temple gs/build.sh";
    #  open(OUTPUT, ">> gs/build.sh") || die "opendir: $!\n";
    foreach $l (@lines) {
      #    print OUTPUT $l;
      print $l;
    }
  }
  elsif ($opt_f eq "kconfig" ||
	 $opt_f eq "idraw" ||
	 $opt_f eq "xfig" ) {
    foreach $l (@lines) {
      print $l;
    }
  }
}


sub tgif_res {
  local($ttf_id, $x_jisx, $jps_code) = @_;
  my $i;

  # For horizontal fonts
  for ($i=1; $i<=4; $i++){
      push(@lines, " $x_jisx \\n\\
     H \\n\\
     $ttf_id$jps_code-H \\n\\\n");
  }
  push(@lines, " \\n\\\n");
#  if (defined $opt_I) {
#      $x_o_jisx = $x_jisx;
#      $x_o_jisx =~ s/-r-/-o-/;
#      push(@lines, " $x_jisx,H,$ttf_id" . "Shadow$jps_code-H\\n\\\n");
#      push(@lines, " $x_o_jisx,H,$ttf_id" . "Oblique$jps_code-H\\n\\\n");
#      push(@lines, " $x_o_jisx,H,$ttf_id" . "ObliqueShadow$jps_code-H\\n\\\n");
#  }
  # For Vertical fonts
  for ($i=1; $i<=4; $i++){
      push(@lines2, " $x_jisx \\n\\
     V \\n\\
     $ttf_id$jps_code-V \\n\\\n");
  }
  push(@lines2, " \\n\\\n");
#  if (defined $opt_I) {
#      push(@lines2, " $x_jisx,V,$ttf_id" . "Shadow$jps_code-V\\n\\\n");
#      push(@lines2, " $x_o_jisx,V,$ttf_id" . "Oblique$jps_code-V\\n\\\n");
#      push(@lines2, " $x_o_jisx,V,$ttf_id" . "ObliqueShadow$jps_code-V\\n\\\n");
#  }
}


sub tgif3_res {
  local($ttf_id, $x_jisx, $jps_code) = @_;

  # For horizontal fonts
  push(@lines, " \\n\\\n");
  push(@lines, " $x_jisx,, \\\n");
  push(@lines, "	$ttf_id$jps_code-H, $ttf_id, \\\n");
  push(@lines, "	H, false, all");
  # For Vertical fonts
  push(@lines2, " \\n\\\n");
  push(@lines2, " $x_jisx,, \\\n");
  push(@lines2, "	$ttf_id$jps_code-V, $ttf_id-V, \\\n");
  push(@lines2, "	V, false, all");
  
}


sub idraw_res{
  local($ttf_id, $x_jisx, $x_iso) = @_;

  @sizes = split(' ',$idraw_sizes);
  $x_jisx =~ s/\s+/\*/g; # no white space
  $x_iso =~ s/\s+/\*/g;	# no white space
  foreach $s (@sizes){
    $jisx = $x_jisx;
    $jisx =~ s/%d/$s/g;
    $iso = $x_iso;
    $iso =~ s/%d/$s/g;	# size
    &idraw_res_x($ttf_id, $jisx, $iso);
    $idraw_fnum++;
    $idraw_cfnum++;
  }
  &idraw_res_ps($ttf_id);
  $idraw_pscfnum++;
}

sub idraw_res_x{
  local($ttf_id, $x_jisx, $x_iso) = @_;
  
  push(@lines, "idraw.font$idraw_fnum: " .
       "$ps_iso-$ttf_id-$s $ps_iso-$ttf_id $s\n");
  push(@lines, "idraw.compositeFont$idraw_cfnum: ".
       "$ps_iso-$ttf_id-$s \\\n");
  push(@lines, "	$x_iso \\\n");
  push(@lines, "	$x_jisx\n");
}

sub idraw_res_ps{
  local($ttf_id) = @_[0];

  push(@lines, "idraw.PSCompositeFont$idraw_pscfnum: ". 
       "$ps_iso-$ttf_id \\\n");
  push(@lines, "\t$ps_iso $ttf_id-EUC-H\n");
  push(@lines, "\n");
}

sub xfig_res{
  local($ttf_id, $x_jisx, $x_iso, $ps_iso) = @_;

  push(@lines, "!Fig.normalFontSet: $x_iso, \\\n");
  push(@lines, "!\t$x_jisx\n");
  push(@lines, "!Fig.boldFontSet: $x_iso, \\\n");
  push(@lines, "!\t$x_jisx\n");
  push(@lines, "!!!! Entry for PS fonts in japanese.ps " .
       "(ja_JP.EUC.ps on FreeBSD)\n");
  push(@lines, "!!!!  /FDepVector [ /$ps_iso findfont\n");
  push(@lines, "!!!!      /$ttf_id-EUC-H findfont ] def\n");
  push(@lines, "\n");
}

sub vfontcap_res{
  local($ttf_id, $filename, $ai) = @_;

  $ai = int $ai*100;
  $fn = $filename;
  $fn =~ s/(^.+)\.tt[cf]/$1/;
  $filename = $fn if defined $opt_b; # for a truetype driver of VFlib
  if($slant eq "r"){
    push(@lines,"$ttf_id|$fn|");
    push(@lines,"$foundry TrueType Font $ttf_id:\\\n");
    push(@lines,"\t:ft=$fontdriver:ff=$dir/$filename:\n");
  }
  elsif($slant eq "o"){
    push(@lines,"$ttf_id|$fn" . "i:\\\n");
    push(@lines,"\t:sl#$ai:fc=$nb_ttf_id:\n");
  }
  elsif($slant eq "ro"){
    push(@lines,"$ttf_id|$fn" . "l:\\\n");
    push(@lines,"\t:sl#-$ai:fc=$nb_ttf_id:\n");
  }
}

sub CIDFnmap_res{
  local($ttf_id, $filename) = @_;

  $fn = $filename;
  $fn =~ s/(^.+)\.tt[cf]/$1/;
  if($slant eq "r"){
    push(@lines,"$ttf_id ($dir/$filename) 1 ;\n");
  }
  # not supported
  elsif($slant eq "o"){
    push(@lines,"$ttf_id ($dir/$filename) 1 ;\n");
  }
  # not supported
  elsif($slant eq "ro"){
    push(@lines,"$ttf_id ($dir/$filename) 1 ;\n");
  }
}

sub kconfig_res{
  local($ttf_id) = @_[0];

  push(@lines,"/$ttf_id $ps_offset" .
       " ($ttf_id) $operator\n");
  push(@lines,"/$ttf_id-RKSJ-H" .
       " /$ttf_id-Ext-RKSJ-H copyfont\n");
  push(@lines,"/$ttf_id-RKSJ-V" .
       " /$ttf_id-Ext-RKSJ-V copyfont\n");
}

sub oblique_ttf_id{
  local($t) = @_[0];

  $t .= "Oblique";
}

sub lefty_ttf_id{
  local($t) = @_[0];

  $t .= "Lefty";
}
