<?php
  /**************************************************************************\
  * phpGroupWare app (Bookkeeping)                                           *
  * http://www.phpgroupware.org                                              *
  * Written by Rick Bakker <r.bakker@linvision.com>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  // HTTP_GET_VARS
  $order=$HTTP_GET_VARS['order'];
  $selected=$HTTP_GET_VARS['selected'];
  $entry_id=$HTTP_GET_VARS['entry_id'];

  $phpgw_info["flags"] = array("currentapp" => "bookkeeping");
  include("../header.inc.php");
  include("inc/bookkeeping_header.inc.php");

  $phpgw->template->set_file(array( "entry_view" => "entry_view.tpl"));
  $phpgw->template->set_block("entry_view", "entry_fields", "entry_fields_t");

  $phpgw->template->set_var("header",$header);
  $phpgw->template->set_var("lang_app_title",lang("bookkeeping"));
  $phpgw->template->set_var("lang_title",lang("entries"));
  $phpgw->template->set_var("head_color","D3DCE3");

  if($selected=="expenses"){
    $lang_selected=lang("view_expense");
  }else{
    $lang_selected=lang("view_income");
  }

  $phpgw->template->set_var(lang_selected,lang("$lang_selected"));

  $phpgw->db->query("select e.date_entry as date_entry,c.description as category,e.amount as amount,e.description as description ".
                    "from phpgw_bk_entries e, phpgw_bk_categories c WHERE entry_id='$entry_id' AND e.category_id=c.category_id");
  $phpgw->db->next_record();

  $lang_date_entry=lang("date").": ";
  $phpgw->template->set_var("lang_entry_field",$lang_date_entry);
  $date_entry = $phpgw->db->f("date_entry");
  $date_entry=getdate($date_entry);
  $date_entry=$date_entry["year"]."-".$date_entry["mon"]."-".$date_entry["mday"];
  $phpgw->template->set_var("entry_field",$date_entry);
  $color=row_color($color);
  $phpgw->template->set_var(color,$color);
  $phpgw->template->parse("entry_fields_t", "entry_fields", true);

  $lang_category=lang("category").": ";
  $phpgw->template->set_var("lang_entry_field",$lang_category);
  $category=$phpgw->db->f("category");
  $phpgw->template->set_var("entry_field",$category);
  $color=row_color($color);
  $phpgw->template->set_var(color,$color);
  $phpgw->template->parse("entry_fields_t", "entry_fields", true);

  $lang_amount=lang("amount").": ";
  $phpgw->template->set_var("lang_entry_field",$lang_amount);
  $amount=$phpgw->db->f("amount");
  $phpgw->template->set_var("entry_field",$amount);
  $color=row_color($color);
  $phpgw->template->set_var(color,$color);
  $phpgw->template->parse("entry_fields_t", "entry_fields", true);

  $lang_description=lang("description").": ";
  $phpgw->template->set_var("lang_entry_field",$lang_description);
  $description=$phpgw->db->f("description");
  $phpgw->template->set_var("entry_field",$description);
  $color=row_color($color);
  $phpgw->template->set_var(color,$color);
  $phpgw->template->parse("entry_fields_t", "entry_fields", true);

  $phpgw->template->set_var("actionurl",$phpgw->link("/bookkeeping/index.php","selected=$selected&order=$order"));
  $phpgw->template->set_var("lang_go_back",lang("go_back"));
  $phpgw->template->parse("out", "entry_view", true);
  $phpgw->template->p("out");
  $phpgw->common->phpgw_footer();

?>
