<?php
  /**************************************************************************\
  * phpGroupWare app (Bookkeeping)                                           *
  * http://www.phpgroupware.org                                              *
  * Written by Rick Bakker <r.bakker@linvision.com>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  function row_color($currentcolor='')
  {
    if($currentcolor=='DDDDDD')
    {
       $color='EEEEEE';
    }
    else
    {
       $color='DDDDDD';
    }
    return $color;
  }

  function getMaxValue($array,$res)
  {
    reset($array);
    $count=count($array);
    if($res=='month')
    {
      for($i=0;$i<$count;$i++)
      {
        $year=strtok($array[$i],':');
        $month=strtok(':');
        $amount=strtok(':');
        $max = max($max,$amount);
      }
    }
    if($res=='day')
    {
      for($i=0;$i<$count;$i++)
      {
        $year=strtok($array[$i],':');
        $month=strtok(':');
        $day=strtok(':');
        $amount=strtok(':');
        $max = max($max,$amount);
      }
    }
    if($res=='report')
    {
      for($i=0;$i<$count;$i++)
      {
        $description=strtok($array[$i],':');
        $amount=strtok(':');
        $max = max($max,$amount);
      }
    }
    return $max;
  }

  function addMonth($timestamp)
  {
    $temp=getdate($timestamp);
    $month=$temp["mon"];
    $day=$temp["mday"];
    $year=$temp["year"];
    if($month==12)
    {
      $month=1;
      $year++;
    }
    else
    {
      $month++;
    }
    return(mktime(0,0,0,$month,$day,$year));
  }

  function addDay($timestamp)
  {
    $temp=getdate($timestamp);
    $month=$temp["mon"];
    $day=$temp["mday"];
    $year=$temp["year"];
    if(checkdate($month,$day+1,$year))
    {
      $day++;
    }
    else
    {
      if($month=='12')
      {
        $day=1;
        $month=1;
        $year++;
      }
      else
      {
        $day=1;
        $month++;
      }
    }
    return(mktime(0,0,0,$month,$day,$year));
  }

  function addWeek($timestamp)
  {
    $temp=getdate($timestamp);
    $month=$temp["mon"];
    $day=$temp["mday"];
    $year=$temp["year"];
    for($i=0;$i<7;$i++)
    {
      if(checkdate($month,$day+1,$year))
      {
        $day++;
      }
      else
      {
        if($month=='12')
        {
          $day=1;
          $month=1;
          $year++;
        }
        else
        {
          $day=1;
          $month++;
        }
      }
    }
    return(mktime(0,0,0,$month,$day,$year));
  }

  function lastDayOfMonth($year,$month,$day)
  {
    if(checkdate($month,$day+1,$year))
    {
      return(false);
    }
    else
    {
      return(true);
    }
  }
?>
