<?php
  /**************************************************************************\
  * phpGroupWare - Shopping cart                                             *
  * http://www.phpgroupware.org                                              *
  * Written by Bettina Gille [ceb@phpgroupware.org]                          *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/
  /* $Id: view_product.php,v 1.2 2001/05/10 22:06:58 bettina Exp $ */

    if (!$con) {
        $phpgw_info['flags'] = array('noheader' => True,
                                     'nonavbar' => True);
    }
    if (! $con) {
	Header('Location: ' . $HTTP_REFERER);
	$phpgw->common->phpgw_exit();
    }

    $phpgw_info['flags']['currentapp'] = 'cart';
    include('../header.inc.php');

    $t = new Template(PHPGW_APP_TPL);
    $t->set_file(array('view' => 'view_product.tpl'));

    $hidden_vars = "<input type=\"hidden\" name=\"sort\" value=\"$sort\">\n"
                . "<input type=\"hidden\" name=\"order\" value=\"$order\">\n"
                . "<input type=\"hidden\" name=\"query\" value=\"$query\">\n"
                . "<input type=\"hidden\" name=\"start\" value=\"$start\">\n"
                . "<input type=\"hidden\" name=\"filter\" value=\"$filter\">\n"
                . "<input type=\"hidden\" name=\"con\" value=\"$con\">\n";

    $c = CreateObject('phpgwapi.categories');

    if (isset($phpgw_info['user']['preferences']['common']['currency'])) {
        $currency = $phpgw_info['user']['preferences']['common']['currency'];
        $t->set_var('error','');
    }
    else {
        $t->set_var('error',lang('Please select your currency in preferences !'));
    }

    $t->set_var('hidden_vars',$hidden_vars);
    $t->set_var('lang_id',lang('Product ID'));
    $t->set_var('lang_short_name',lang('Short Name'));
    $t->set_var('lang_description',lang('Description'));
    $t->set_var('lang_category',lang('Category'));
    $t->set_var('lang_price',lang('Price'));
    $t->set_var('lang_retail',lang('Retail'));
    $t->set_var('currency',$currency);
    $t->set_var('image',PHPGW_IMAGES . '/logo.jpg');  
  
    $phpgw->db->query("select * from phpgw_inv_products where con='$con'");
    $phpgw->db->next_record();

    $category = $phpgw->db->f('category');
    $t->set_var('cat_name',$c->return_name($category));

    $price = $phpgw->db->f('price');
    $t->set_var('id',$phpgw->db->f('id'));
    $t->set_var('name',$phpgw->strip_html($phpgw->db->f('name')));
    $t->set_var('descr',$phpgw->strip_html($phpgw->db->f('descr')));

    $t->set_var('price',$price);
    $taxpercent = select_tax($category);
    $retail = round($price*(1+$taxpercent),2);
    $t->set_var('retail',sprintf("%01.2f",$retail));

    $t->set_var('done_action',$HTTP_REFERER);
    $t->set_var('lang_done',lang('Done'));
    $t->pparse('out','view');

    $phpgw->common->phpgw_footer();
?>
