<?php
  /**************************************************************************\
  * phpGroupWare - phpgw_dj                                                  *
  * http://www.phpgroupware.org                                              *
  * Written by Miles Lott <milosch@phpgroupware.org>                         *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: functions.inc.php,v 1.3 2001/05/05 03:53:43 jengo Exp $ */

	// Return a select form element with the categories option dialog in it
	function cat_option($cat_id='',$notall=False,$java=True)
	{
		global $phpgw_info;
		if ($java)
		{
			$jselect = ' onChange="this.form.submit();"';
		}
		// Setup all and none first
		$cats_link  = "\n" .'<select name="cat_id"' .$jselect .">\n";
		if (!$notall)
		{
			$cats_link .= '<option value=""';
			if ($cat_id=="all")
			{
				$cats_link .= ' selected';
			}
			$cats_link .= '>'.lang("all").'</option>'."\n";
		}

		// Get global and app-specific category listings
		$cats       = CreateObject('phpgwapi.categories');
		$cats_link .= $cats->formated_list('select','all',$cat_id,False);
		$cats_link .= '</select>'."\n";
		return $cats_link;
	}

	function nicesize($filesize='')
	{
		$revsize = strrev($filesize);
		$checkarr = array(0,3,6,9,12,15,18,21,24);
		
		while (list($null,$start) = each($checkarr))
		{
			if ($start <= strlen($revsize))
			{
				$newsize .= substr($revsize,$start,3) . ',';
			}
			else
			{
				break;
			}
		}
		$newsize = substr(strrev($newsize),1) . ' ' . lang('Bytes');
		return $newsize;
	}

	function get_dirs()
	{
		global $phpgw;
		$dirs = array();

		$phpgw->db->query("SELECT * FROM phpgw_dj_directories WHERE dir_id>0");
		while ($phpgw->db->next_record())
		{
			if ($phpgw->db->f('dir_name'))
			{
				//$servers[$phpgw->db->f('name')] = array(
				$dirs[$phpgw->db->f('dir_id')]= array(
					'dir_id'   => trim(stripslashes($phpgw->db->f('dir_id'))),
					'dir_name' => trim(stripslashes($phpgw->db->f('dir_name'))),
				);
			}
		}
		return $dirs;
	}

	function song_exists($song_name = '')
	{
		global $phpgw;

		if($song_name)
		{
			$song_name = addslashes($song_name);
			$phpgw->db->query("SELECT COUNT(*) FROM phpgw_dj_songlist WHERE song_name='$song_name'");
			$phpgw->db->next_record();
			if ($phpgw->db->f(0))
			{
				return True;
			}
			else
			{
				return False;
			}
		}
		else
		{
			return True;
		}
	}

	function get_files()
	{
		global $phpgw;

		$dirs = get_dirs();
		$filelist = array();
		$i = 0;

		while (list($key,$dir) = each($dirs))
		{
			if (is_dir($dir['dir_name']))
			{
				chdir($dir['dir_name']);
				$current = opendir('.');
				while ($fname = readdir($current))
				{
					if (!is_dir($fname))
					{
						$fname = trim($fname);
						$lname = strtolower(substr($fname,-3));
						if ($lname == 'mp3')
						{
							$filelist[$i] = $dir['dir_name'] . SEP . $fname;
							$i++;
							//echo $dir['dir_name'] . SEP . $fname ."\n";
						}
					}
				}
				closedir($current);
			}
		}
		return $filelist;
	}

	function get_info($filename = '')
	{
		if ($filename)
		{
			$data = ereg_replace("\n","",$filename);
			$mp3info = CreateObject('dj.id3',$data);

			return $mp3info;
		}
	}

	function add_song($mp3info = '')
	{
		global $phpgw, $mark_unavaiable;

		$status = ($mark_unavaiable?'N':'A');

		if ($mp3info)
		{
			$sql = "INSERT INTO phpgw_dj_songlist (song_name,song_title,song_artist,song_year,song_comment,"
				. "song_album,song_genre,song_size, song_length, song_bitsize, song_samplerate,song_frames,"
				. "song_emphasis,song_cmode,song_version, song_layer,song_crc,song_copyright,song_original,"
				. "song_status,song_cycle_status) VALUES ('"
				. addslashes($mp3info->file)
				. "','" . addslashes($mp3info->title)
				. "','" . addslashes($mp3info->artists)
				. "','" . addslashes($mp3info->year)
				. "','" . addslashes($mp3info->comment)
				. "','" . addslashes($mp3info->album)
				. "','" . addslashes($mp3info->genre)
				. "','" . addslashes($mp3info->filesize)
				. "','" . addslashes($mp3info->lengths)
				. "','" . addslashes($mp3info->bitrate)
				. "','" . addslashes($mp3info->sample)
				. "','" . addslashes($mp3info->frames)
				. "','" . addslashes($mp3info->emphasis)
				. "','" . addslashes($mp3info->chmode)
				. "','" . addslashes($mp3info->mpeg_ver)
				. "','" . addslashes($mp3info->layer)
				. "','" . addslashes($mp3info->crc)
				. "','" . addslashes($mp3info->copyright)
				. "','" . addslashes($mp3info->original)
				. "','$status','A')";
			$phpgw->db->query($sql);
		}
		return $mp3info;
	}
?>
