<?php
  /**************************************************************************\
  * phpGroupWare - eldaptir                                                  *
  * http://www.phpgroupware.org                                              *
  * Written by Bettina Gille [ceb@phpgroupware.org]                          *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/
/* $Id: addserver.php,v 1.4 2001/05/11 14:32:50 milosch Exp $ */

	$phpgw_info["flags"]["currentapp"] = 'eldaptir';
	include('../header.inc.php');

	if(!$phpgw->acl->check('run',1,'admin'))
	{
		echo lang('access not permitted');
		$phpgw->common->phpgw_footer();
		$phpgw->common->phpgw_exit();

	}

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array('form' => 'server_form.tpl'));
	$t->set_block('form','add','addhandle');
	$t->set_block('form','edit','edithandle');

	if ($submit) {
		$errorcount = 0;

		$phpgw->db->query("SELECT * FROM phpgw_eldaptir_servers WHERE name='".$server_name."'");
		if ($phpgw->db->next_record())
		{
			$error[$errorcount++] = lang('That server name has been used already !');
		}

		if (!$server_name)
		{
			$error[$errorcount++] = lang('Please enter a name for that server !');
		}

		if (! $error)
		{
			if ($is_default == 'on')
			{
				$default_checked = True;
			}
			else
			{
				$default_checked = 0;
			}

			if($default_checked) $phpgw->db->query("UPDATE phpgw_eldaptir_servers SET is_default=0");

			$server_name     = addslashes($server_name);
			$server_basedn   = addslashes($server_basedn);
			$server_rootdn   = addslashes($server_rootdn);
			$server_rootpw   = addslashes($server_rootpw);

			$phpgw->db->query("INSERT INTO phpgw_eldaptir_servers (name,basedn,rootdn,rootpw,is_default) VALUES ("
				. "'" . $server_name . "','" .$server_basedn . "','"
				. $server_rootdn . "','" . $server_rootpw . "'," . $default_checked .")");
		}
	}

	if ($errorcount) { $t->set_var('message',$phpgw->common->error_list($error)); }
	if (($submit) && (! $error) && (! $errorcount)) { $t->set_var('message',lang('Server x has been added !', $server_name)); }
	if ((! $submit) && (! $error) && (! $errorcount)) { $t->set_var('message',''); }

	$t->set_var('title_servers',lang('Add LDAP Server'));
	$t->set_var('actionurl',$phpgw->link('/eldaptir/addserver.php'));
	$t->set_var('doneurl',$phpgw->link('/eldaptir/servers.php'));
	$t->set_var('hidden_vars','<input type="hidden" name="server_id" value="' . $server_id . '">');

	$t->set_var('lang_name',lang('Server name'));
	$t->set_var('lang_basedn',lang('Server basedn'));
	$t->set_var('lang_rootdn',lang('Server rootdn'));
	$t->set_var('lang_rootpw',lang('Server rootpw'));

	$t->set_var('lang_add',lang('Add'));
	$t->set_var('lang_default',lang('Default'));
	$t->set_var('lang_reset',lang('Clear Form'));
	$t->set_var('lang_done',lang('Done'));

	$t->set_var('server_name',$server_name);
	$t->set_var('server_basedn',$server_basedn);
	$t->set_var('server_rootdn',$phpgw->strip_html($server_rootdn));
	$t->set_var('server_rootpw',$phpgw->strip_html($server_rootpw));

	$t->set_var('edithandle','');
	$t->set_var('addhandle','');
	$t->pparse('out','form');
	$t->pparse('addhandle','add');

	$phpgw->common->phpgw_footer();
?>
