<?php
  /**************************************************************************\
  * phpGroupWare - Inventory                                                 *
  * http://www.phpgroupware.org                                              *
  * Written by Bettina Gille [ceb@phpgroupware.org]                          *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/
  /* $Id: listreceipt.php,v 1.19 2001/05/10 22:08:57 bettina Exp $ */
  
    $phpgw_info["flags"] = array('currentapp' => 'inv',
		    'enable_nextmatchs_class' => True);

    include('../header.inc.php');

    $t = new Template(PHPGW_APP_TPL);
    $t->set_file(array('listreceipt_t' => 'listreceipt.tpl',
                       'listreceipt'   => 'listreceipt.tpl'));

    $t->set_block('listreceipt_t','listreceipt','list');

    $d = CreateObject('phpgwapi.contacts');
    $inventory = CreateObject('inv.inventory');
    $grants = $phpgw->acl->get_grants('inv');
    $c = CreateObject('phpgwapi.categories');

    if($phpgw_info["user"]["preferences"]["common"]["maxmatchs"] && $phpgw_info["user"]["preferences"]["common"]["maxmatchs"] > 0) {
                $limit = $phpgw_info["user"]["preferences"]["common"]["maxmatchs"];
    }
    else { $limit = 15; }

    if (isset($phpgw_info["user"]["preferences"]["common"]["currency"])) {
	$currency = $phpgw_info["user"]["preferences"]["common"]["currency"];
	$t->set_var('error','');
    }
    else { $t->set_var('error',lang('Please select your currency in preferences !')); }

    $archive_id = $inventory->get_status_id('archive');

    if (!$start) { $start = 0; }

    $querymethod = " AND (name like '%$query%' OR descr like '%$query%' OR id like '%$query%') ";

    if (! $filter) {
	$phpgw->db->query("SELECT dist,category from phpgw_inv_products WHERE status != '$archive_id' $querymethod");    
	$phpgw->db->next_record();
        $category = $c->return_single($phpgw->db->f('category'));
    	    if ($category) {
        	if ($inventory->check_perms($grants[$category[0]['owner']],PHPGW_ACL_READ) || $category[0]['owner'] == $phpgw_info['user']['account_id']) {
		    $filter = $phpgw->db->f("dist");
		}
	    }
	    else { $filter = '999'; }
	}
    else {
        $phpgw->db->query("SELECT category from phpgw_inv_products WHERE dist='$filter'");
        $phpgw->db->next_record(); 
        $category = $c->return_single($phpgw->db->f('category'));
    }

    $products = $inventory->read_products($start,$limit,$query,'dist',$filter,$sort,$order,'active');

//--------------------------------- nextmatch --------------------------------------------

    $left = $phpgw->nextmatchs->left('/inv/listreceipt.php',$start,$inventory->total_records);
    $right = $phpgw->nextmatchs->right('/inv/listreceipt.php',$start,$inventory->total_records);
    $t->set_var('left',$left);
    $t->set_var('right',$right);

    if ($query) {
        if ($inventory->total_records == 0) {  $t->set_var('search_message',lang('Your search has returned no matchs !')); }
        else { $t->set_var('search_message',lang("showing x",$inventory->total_records)); }
    }
    else {
        if ($inventory->total_records > $limit) { $t->set_var('search_message',lang("showing x - x of x",($start + 1),($start + $limit),$inventory->total_records)); }
        else { $t->set_var('search_message',lang("showing x",$inventory->total_records)); }
    }

// ------------------------------ end nextmatch ------------------------------------------

//---------------------------- list variable template-declarations -------------------------

    $t->set_var('th_bg',$phpgw_info["theme"][th_bg]);
    $t->set_var('sort_id',$phpgw->nextmatchs->show_sort_order($sort,'id',$order,'/inv/listreceipt.php',lang('Product ID')));
    $t->set_var('sort_serial',$phpgw->nextmatchs->show_sort_order($sort,'serial',$order,'/inv/listreceipt.php',lang('Serial number')));
    $t->set_var('sort_name',$phpgw->nextmatchs->show_sort_order($sort,'name',$order,'/inv/listreceipt.php',lang('Name')));
    $t->set_var('sort_category',$phpgw->nextmatchs->show_sort_order($sort,'category',$order,'/inv/listreceipt.php',lang('Category')));
    $t->set_var('sort_date',$phpgw->nextmatchs->show_sort_order($sort,'pdate',$order,'/inv/listreceipt.php',lang('Purchase date')));
    $t->set_var('sort_cost',$phpgw->nextmatchs->show_sort_order($sort,'cost',$order,'/inv/listreceipt.php',lang('Purchase price')));
    $t->set_var('sort_stock',$phpgw->nextmatchs->show_sort_order($sort,'stock',$order,'/inv/listreceipt.php',lang('Stock')));
    $t->set_var('lang_edit',lang('Edit'));
    $t->set_var('lang_view',lang('View'));
    $t->set_var('currency',$currency);
    $t->set_var('lang_action',lang('Stock receipt list'));
    $t->set_var('filter_action',$phpgw->link('/inv/listreceipt.php'));
    $t->set_var('search_action',$phpgw->link('/inv/listreceipt.php'));
    $t->set_var('lang_select_dist',lang('Select distributor'));
    $t->set_var('lang_search',lang('Search'));

    $t->set_var('dist_list',select_dist_list($filter));

    $t->set_var('lang_submit',lang('Submit'));
    $t->set_var('lang_add',lang('Add'));
    $t->set_var('add_action',$phpgw->link("/inv/addproduct.php","dist=$filter"));

// -------------------------------- end declaration -----------------------------------------

    for ($i=0;$i<count($products);$i++) {

    $phpgw->templater_color = $phpgw->nextmatchs->alternate_row_color($phpgw->templater_color);
    $t->set_var('tr_color',$phpgw->templater_color);

    $serial = $phpgw->strip_html($products[$i]['serial']);
    if (! $serial) $serial = '&nbsp;';
    $name = $phpgw->strip_html($products[$i]['name']);
    if (! $name) $name = '&nbsp;';

    $date = $products[$i]['date'];
    if ($date != 0) {
    $month = $phpgw->common->show_date(time(),'n');
    $day   = $phpgw->common->show_date(time(),'d');
    $year  = $phpgw->common->show_date(time(),'Y');

    $date = $date + (60*60) * $phpgw_info["user"]["preferences"]["common"]["tz_offset"];
    $dateout =  $phpgw->common->show_date($date,$phpgw_info["user"]["preferences"]["common"]["dateformat"]);
    }
    else { $dateout = '&nbsp;'; }

    $cat_name = $c->return_name($products[$i]['category']);

    $id = $phpgw->strip_html($products[$i]['id']);
    $cost = $products[$i]['cost'];

    if ($products[$i]['mstock'] == $products[$i]['stock']) { $stock = '<b>' . $products[$i]['stock'] . '</b>'; }
    if ($products[$i]['mstock'] < $products[$i]['stock']) { $stock = $products[$i]['stock']; }
    if ($products[$i]['mstock'] > $products[$i]['stock']) { $stock = '<font color=FF0000><b>' . $products[$i]['stock'] . '</b></font>'; }

//---------------------------------- list records -------------------------------------

    $t->set_var(array('id' => $id,
            	    'name' => $name,
		'category' => $cat_name,
		    'date' => $dateout,
                    'cost' => $cost,
	           'stock' => $stock,
		  'serial' => $serial));

    if ($inventory->check_perms($grants[$category[0]['owner']],PHPGW_ACL_EDIT) || $category[0]['owner'] == $phpgw_info['user']['account_id']) {
	$t->set_var('edit',$phpgw->link('/inv/editproduct.php','con=' . $products[$i]['con'] . "&filter=$filter"));                                                                                       
        $t->set_var('lang_edit_entry',lang('Edit'));
    }
    else {
        $t->set_var('edit','');
        $t->set_var('lang_edit_entry','&nbsp;');
    }

    $t->set_var('view',$phpgw->link('/inv/viewproduct.php','con=' . $products[$i]['con'] . "&filter=$filter"));

    $t->parse('list','listreceipt',True);
    }

// ---------------------------- end list records -----------------------------------------

    if ($inventory->check_perms($grants[$category[0]['owner']],PHPGW_ACL_ADD) || $category[0]['owner'] == $phpgw_info['user']['account_id']) {
        $t->set_var('add','<form method="POST" action="' . $phpgw->link('/inv/addproduct.php',"dist=$filter") . '"><input type="submit" value="' . lang('Add') .'"></form>');
    }
    else { $t->set_var('add',''); }

    $t->parse('out','listreceipt_t',True);
    $t->p('out');

    $phpgw->common->phpgw_footer();
?>