<?php
  /**************************************************************************\
  * phpGroupWare - MediaDB Artist Functions                                  *
  * http://www.phpgroupware.org                                              *
  * This file written by Sam Wynn <neotexan@wynnsite.com>                    *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: artist.inc.php,v 1.5 2000/11/03 18:59:20 neotexan Exp $ */

function list_artist($order, $sort, $filter, $start, $query, $qfield)
{
   global $phpgw, $phpgw_info;

   $search_obj = array(array("artist_fname","first name"),
                       array("artist_lname","last name"));
   
   if ($order)
   {
      $ordermethod = "order by $order $sort";
   }
   else
   {
      $ordermethod = "order by artist_lname asc";
   }

   if (! $sort)
   {
      $sort = "desc";
   }

   if (! $start)
   {
       $start = 0;
   }

   if (! $qfield)
   {
       $qfield = "artist_fname";
   }
   
   if (! $filter)
   {
       $filter = "none";
   }

   $limit =$phpgw->nextmatchs->sql_limit($start);
   
   if (!$query)
   {
       $phpgw->db->query("select count(*) from media_artist "
                         .$ordermethod);
   }
   else
   {
       $phpgw->db->query("select count(*) from media_artist "
                         ."WHERE $qfield like '%$query%' "
                         .$ordermethod);
   }

   $phpgw->db->next_record(); 
   if ($phpgw->db->f(0) > $phpgw_info["user"]["preferences"]["common"]["maxmatchs"])
   {
       printf("<center>%s</center>\n",
              lang("showing x - x of x",($start + 1),
                   ($start + $phpgw_info["user"]["preferences"]["common"]["maxmatchs"]),
                   $phpgw->db->f(0)));
   }
   else
   {
       printf("<center>%s</center>\n", lang("showing x",$phpgw->db->f(0)));
   }

   printf("<center>\n");
   
   $phpgw->nextmatchs->show("artist.php",$start,$phpgw->db->f(0), "",
                            "75%", $phpgw_info["theme"]["th_bg"],$search_obj,0);
   printf("</center>\n");

   printf("<table border=\"0\" width=\"75%%\" align=\"center\">\n");
   printf("  <tr>\n");
   printf("    <td colspan=4>&nbsp;</td>\n");
   printf("  </tr>\n");
   printf("  <tr bgcolor=\"%s\">\n", $phpgw_info["theme"]["th_bg"]);
   printf("    <td>%s</td>\n",
          $phpgw->nextmatchs->show_sort_order($sort,"artist_lname",$order,"artist.php",
                                              lang("Last Name")));
   printf("    <td>%s</td>\n",
          $phpgw->nextmatchs->show_sort_order($sort,"artist_fname",$order,"artist.php",
                                              lang("First Name")));
   printf("    <td>%s</td>\n", lang("Edit"));
   printf("    <td>%s</td>\n", lang("Delete"));
   printf("  </tr>\n");

   
   if (!$query)
   {
       $phpgw->db->query("select * from media_artist "
                         .$ordermethod
                         ." limit ".$limit);
   }
   else
   {
       $phpgw->db->query("select * from media_artist "
                         ."WHERE $qfield like '%$query%' "
                         .$ordermethod
                         ." limit ".$limit);
   }

   while ($phpgw->db->next_record()) 
   {
      $tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);

      $fname = $phpgw->db->f("artist_fname");
      if (! $fname)
      {
         $fname = "&nbsp;";
      }

      $lname = $phpgw->db->f("artist_lname");
      if (! $lname)
      {
         $lname = "&nbsp;";
      }

      printf("  <tr bgcolor=$tr_color>\n");
      printf("    <td>%s</td>\n", $lname);
      printf("    <td>%s</td>\n", $fname);
      printf("    <td width=5%%><a href=\"%s\">%s</a></td>\n",
             $phpgw->link("artist.php",
                          "con=" . urlencode($phpgw->db->f("artist_id")) 
			  ."&act=edit"
                          ."&start=$start&order=$order&filter=$filter&qfield=$qfield"
                          ."&sort=$sort"
                          ."&query=".urlencode($query)),
             lang("Edit"));
      printf("    <td width=5%%><a href=\"%s\">%s</a></td>\n",
             $phpgw->link("artist.php",
                          "con=" . urlencode($phpgw->db->f("artist_id"))
                          ."&act=delete"
                          ."&start=$start&order=$order&filter=$filter&qfield=$qfield"
                          ."&sort=$sort"
                          ."&query=".urlencode($query)),
             lang("Delete"));

      printf("  </tr>\n");
   }
   printf("</table>\n");
}

function add_artist_entry($order, $sort, $filter, $start, $query, $qfield)
{
    global $phpgw, $phpgw_info;

    $color = $phpgw_info["theme"]["th_bg"];
    
    printf("<form method=POST action=\"%s\">\n",
           $phpgw->link("artist.php",
                        "act=add"
                        ."&start=$start&order=$order&filter=$filter&qfield=$qfield"
                        ."&sort=$sort"
                        ."&query=".urlencode($query)));
    printf("  <table border=\"0\" cellpadding=\"0\""
           . " cellspacing=\"0\" width=75%% align=center>\n");
    printf("    <tr bgcolor=%s>\n", $color);
    printf("      <td align=left width=15%%>\n");
    printf("        <input type=\"submit\" name=\"submit\" value=\"%s\">\n",lang("Add"));
    printf("      </td>\n");
    printf("      <td width=10%%>%s:</td>\n",lang("First"));
    printf("      <td>\n");
    printf("        <input type=\"text\" name=\"artist_fname\""
           ." value=\"%s\" maxlength=30>\n", $afname);
    printf("      </td>\n");
    printf("      <td width=10%%>%s:</td>\n",lang("Last"));
    printf("      <td>\n");
    printf("        <input type=\"text\" name=\"artist_lname\""
           ." value=\"%s\" maxlength=50>\n", $alname);
    printf("      </td>\n");
    printf("    </tr>\n");
    printf("  </table>\n");
    printf("</form>\n");
}

function modify_artist_entry($con, $act, $order, $sort, $filter, $start, $query, $qfield)
{
    global $phpgw, $phpgw_info;

    $phpgw->db->query("select * from media_artist where artist_id=$con");
    $phpgw->db->next_record();
    $afname = $phpgw->db->f("artist_fname");
    $alname = $phpgw->db->f("artist_lname");

    switch($act)
    {
      case "delete":
        {
            $color = $phpgw_info["theme"]["bg07"];
        }
        break;
      default:
        {
            $color = $phpgw_info["theme"]["table_bg"];
        }
        break;
    }
    
    printf("<form method=POST action=\"%s\">\n",
           $phpgw->link("artist.php",
                        "act=$act"
                        ."&start=$start&order=$order&filter=$filter&qfield=$qfield"
                        ."&sort=$sort"
                        ."&query=".urlencode($query)));
    printf("<input type=\"hidden\" name=\"artist_id\" value=\"%s\">\n",$con);
    printf("  <table border=\"0\" cellpadding=\"0\""
           . " cellspacing=\"0\" width=75%% align=center>\n");
    printf("    <tr bgcolor=%s>\n",$color);
    printf("      <td align=left width=15%%>\n");
    printf("        <input type=\"submit\" name=\"submit\" value=\"%s\">\n",lang($act));
    printf("      </td>\n");
    printf("      <td width=10%%>%s:</td>\n",lang("First"));
    printf("      <td>\n");
    printf("        <input type=\"text\" name=\"artist_fname\""
           ." value=\"%s\" maxlength=30>\n", $afname);
    printf("      </td>\n");
    printf("      <td width=10%%>%s:</td>\n",lang("Last"));
    printf("      <td>\n");
    printf("        <input type=\"text\" name=\"artist_lname\""
           ." value=\"%s\" maxlength=50>\n", $alname);
    printf("      </td>\n");
    printf("    </tr>\n");
    printf("  </table>\n");
    printf("</form>\n");
}
?>
