<?php
  /**************************************************************************\
  * phpGroupWare Application (Napster)                                       *
  * http://www.phpgroupware.org                                              *
  * Written by Mark Peters <mpeters@satx.rr.com>                             *
  * Based on WebNap Client copyright 2000                                    *
  * Written by Aakash Kambuj <aakash@idearing.com>                           *
  *            Kalpak Kothari <kalpak@idearing.com>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  * --------------------------------------------                             *
  * Napster is a registered trademark of Napster Inc  http://www.napster.com *
  \**************************************************************************/

  /* $Id: searchmp3.php,v 1.5 2000/11/19 18:04:26 skeeter Exp $ */

  $phpgw_info["flags"]["currentapp"] = "napster";
  $phpgw_info["flags"]["enable_network_class"] = True;
  include("../header.inc.php");
  include($phpgw_info["server"]["app_inc"]."/browserdetect.inc.php");

  function close_routine()
  {
    global $phpgw;
    $phpgw->network->close_port();
  }

  $browser = new BrowserDetector;
  $bd = $browser->isIEorMozilla();
  $bdlynx = $browser->isLynx();
  unset($browser);

  $napster = new napster;

  register_shutdown_function("close_routine");

  if(!isset($napserver))
    $napster->napserver = $napster->servers["imperialfleet.com"];
  else
    $napster->napserver = urldecode($napserver);

  if(!isset($linespeed))
    $napster->linespeed = "AT BEST";
  else
    $napster->linespeed = urldecode($linespeed);

  if(!isset($linktype))
    $napster->linktype = 10;
  else
    $napster->linktype = urldecode($linktype);

  if(!isset($nofirewall))
    $napster->nofirewall = 0;
  else
    $napster->nofirewall = $nofirewall;

  if (isset($keywords)) {
    $t = new Template($phpgw_info["server"]["app_tpl"]);
    $t->set_file(array( "search_result_header"		=> "search_result_header.tpl",
			"search_result_table_header"	=> "search_result_table_header.tpl",
			"search_form"			=> "search.tpl",
			"motd"				=> "motd.tpl",
			"search_result_table_footer"	=> "search_result_table_footer.tpl" ));

    $t->set_block("search_result_header","search_result_table_header","search_form","motd","search_result_table_footer");

    $t->set_var("keywords",$keywords);
    $t->set_var("napserver",$napster->get_key($napster->napserver,$napster->servers));
    $t->parse("out","search_result_header",true);

    $t->parse("out","search_result_table_header",true);

    if(!$napster->init_conn()) {
      $t->p("out");
      $phpgw->common->phpgw_footer();
      exit;
    }

    $t->parse("out","search_result_table_header",true);

    $t->set_var("action_url",$phpgw->link("searchmp3.php"));
    $t->set_var("search_word",lang("Search"));
    $t->set_var("help_url",$phpgw->link("help.php"));
    $t->set_var("help_word",lang("Help"));
    $t->set_var("queue_url",$phpgw->link("queue.php","list=1"));
    $t->set_var("queue_word",lang("Queue"));
    $t->set_var("charts_url",$phpgw->link("mp3chart.php","napserver=".$napster->napserver
			    ."&linespeed=".$napster->linespeed."&linktype=".$napster->linktype
			    ."&nofirewall=".$napster->nofirewall));
    $t->set_var("charts_word",lang("Charts"));
    $t->set_var("keywords",$keywords);
    $t->set_var("napserver_list",$napster->select_options($napster->napserver,$napster->servers,0));
    $t->set_var("linespeed_list",$napster->select_options($napster->linespeed,$napster->comparators,0));
    $t->set_var("linktype_list",$napster->select_options($napster->linktype,$napster->speeds,1));
    $t->set_var("firewall_filter_word",lang("Firewall Filter"));
    $t->set_var("slow_word",lang("Slow"));
    $t->set_var("firewall_checked",($napster->nofirewall ? "checked" : ""));
    $t->set_var("go_word",lang("Go"));
    $t->set_var("server_stat_url",$phpgw->link("servers.php","getstats=1"));
    $t->parse("out","search_form",true);
    
    $t->parse("out","search_result_table_footer",true);

    $t->set_var("bgcolor",$phpgw_info["theme"]["th_bg"]);
    $t->set_var("row_on_color",$phpgw_info["theme"]["row_on"]);
    $t->set_var("motd_text",$napster->motd());
    $t->parse("out","motd",true);
    $napster->in_motd=0;

    $t->parse("out","search_result_table_footer",true);

    $t->p("out");

    $napster->searchmp3($keywords, 0);
  }

  $phpgw->common->phpgw_footer();
?>

